/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.liquidity.service;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.OperateOption;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.BatchTaskStatusSynHelper;

public class LiquidityUpdateService {
    private static final Log logger = LogFactory.getLog(LiquidityUpdateService.class);
    private static final ExecutorService EXECUTOR = ThreadPools.newExecutorService((String)"tda_liquidityschedule_threadpool", (int)4);

    public static void batchUpdateData(String taskNum, Date beginTime, Map<Long, String> liquiditys, HashMap<String, Long> reloanIds) {
        BatchTaskStatusSynHelper.initTaskStatus((String)taskNum, (Date)beginTime, (int)liquiditys.size());
        CountDownLatch latch = new CountDownLatch(liquiditys.size());
        for (Map.Entry<Long, String> liquidity : liquiditys.entrySet()) {
            String key = liquidity.getValue();
            HashMap<String, Object> tempMap = new HashMap<String, Object>(4);
            tempMap.put("liquidity", liquidity.getKey());
            tempMap.put("synthesise", reloanIds.get(key));
            tempMap.put("tasknum", taskNum);
            LiquidityUpdateService.updateLiquidityData(tempMap, latch);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
        logger.info("batchUpdateData finish time" + DateUtils.formatString((Date)DateUtils.getCurrentTime(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public static void updateLiquidityData(Map<String, Object> map, CountDownLatch latch) {
        Long liquidity = (Long)map.get("liquidity");
        Long synthesise = (Long)map.get("synthesise");
        String tasknum = (String)map.get("tasknum");
        EXECUTOR.submit(() -> {
            try {
                LiquidityUpdateService.updateLiquidityData(liquidity, synthesise, tasknum);
            }
            finally {
                latch.countDown();
            }
        });
    }

    public static void updateLiquidityData(Long liquidity, Long synthesise, String tasknum) {
        long begintime = System.currentTimeMillis();
        Timestamp thisBatchBeginTime = DateUtils.getCurrentTime();
        try {
            logger.info("\u6267\u884cgetdate\u7684\u6d41\u52a8\u6027\u6570\u636eid:" + liquidity);
            TmcOperateServiceHelper.execOperate((String)"getdata", (String)"tda_liquiditybill", (Object[])new Object[]{liquidity}, (OperateOption)OperateOption.create());
            logger.error("\u6267\u884cgetData\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begintime) + "  id  :  " + liquidity);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6d41\u52a8\u6027\u6570\u636e\u9519\u8bef\uff1a" + e.getMessage());
        }
        long begintime1 = System.currentTimeMillis();
        if (!EmptyUtil.isEmpty((Long)synthesise)) {
            try {
                logger.info("\u6267\u884creload\u7684\u7efc\u5408\u5206\u6790\u6570\u636eid:" + synthesise);
                TmcOperateServiceHelper.execOperate((String)"reload", (String)"tda_synthesissumdata", (Object[])new Object[]{synthesise}, (OperateOption)OperateOption.create());
                logger.error("\u6267\u884creload\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begintime1) + "  id  :  " + synthesise);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u7efc\u5408\u5206\u6790\u6570\u636e\u9519\u8bef\uff1a" + e.getMessage());
            }
        }
        try {
            BatchTaskStatusSynHelper.singleBatchFinish((String)tasknum, (Date)thisBatchBeginTime);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

