/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.param;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterCache;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BasicParamUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BasicParamUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u7cfb\u7edf\u53c2\u6570\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"SysParamUpgradeService_0", (String)"tmc-tda-mservice", (Object[])new Object[0]));
            QFilter qFilter = new QFilter("fdata", "like", (Object)"%tda_parameter%");
            DynamicObject[] tdaSysParams = BusinessDataServiceHelper.load((String)"bos_svc_sysparameter", (String)"fid,fparamid,fdata", (QFilter[])qFilter.toArray());
            result.setLog(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u5386\u53f2\u6570\u636e\u6709\u3010%s\u3011\u6761\u3002", (String)"SysParamUpgradeService_1", (String)"tmc-tda-mservice", (Object[])new Object[]{tdaSysParams.length}));
            for (DynamicObject sysParam : tdaSysParams) {
                Boolean containconsistentgm;
                String param = sysParam.getString("fdata");
                JSONObject jsonObj = JSON.parseObject((String)param);
                String acctrangeStr = jsonObj.getString("acctrange");
                Boolean issettlementcenter = jsonObj.getBoolean("issettlementcenter");
                if (EmptyUtil.isNoEmpty((String)acctrangeStr) || issettlementcenter != null) {
                    DynamicObject dynamicObjectAcct = BusinessDataServiceHelper.newDynamicObject((String)"tda_acct_queryparamset");
                    dynamicObjectAcct.set("acctrange", (Object)acctrangeStr);
                    dynamicObjectAcct.set("issettlementcenter", (Object)issettlementcenter);
                    this.buildSaveBasicParam("tda_acct_queryparamset", this.saveSrcBill(dynamicObjectAcct));
                }
                String financebizStr = jsonObj.getString("financebiz");
                Boolean enableoffsetshow = jsonObj.getBoolean("enableoffsetshow");
                if (EmptyUtil.isNoEmpty((String)financebizStr) || enableoffsetshow != null) {
                    DynamicObject dynamicObjectFinanc = BusinessDataServiceHelper.newDynamicObject((String)"tda_finance_param");
                    dynamicObjectFinanc.set("financebiz", (Object)financebizStr);
                    dynamicObjectFinanc.set("enableoffsetshow", (Object)enableoffsetshow);
                    this.buildSaveBasicParam("tda_finance_param", this.saveSrcBill(dynamicObjectFinanc));
                }
                if ((containconsistentgm = jsonObj.getBoolean("containconsistentgm")) == null) continue;
                DynamicObject dynamicObjectgm = BusinessDataServiceHelper.newDynamicObject((String)"tda_security_param");
                dynamicObjectgm.set("containconsistentgm", (Object)containconsistentgm);
                this.buildSaveBasicParam("tda_security_param", this.saveSrcBill(dynamicObjectgm));
            }
            ParameterCache.removeParameter((String)TmcAppEnum.TMC.getId(), (String)TmcAppEnum.TDA.getId());
            ParameterCache.removeBatchParameter((String)TmcAppEnum.TMC.getId(), (String)TmcAppEnum.TDA.getId());
            result.setLog(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"SysParamUpgradeService_2", (String)"tmc-tda-mservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.error("\u7cfb\u7edf\u53c2\u6570\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f02\u5e38", (Throwable)e);
            logger.error(result.getErrorInfo());
        }
        return result;
    }

    private void buildSaveBasicParam(String dataEntityName, String jsonString) {
        Date date = new Date();
        QFilter qFilter = new QFilter("name", "=", (Object)dataEntityName);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tda_param_basic", (String)"id,nodeid,params_tag,name,createtime,modifytime", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
            dynamicObject.set("params_tag", (Object)jsonString);
            dynamicObject.set("modifytime", (Object)date);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            String nodeIdStr = this.getNodeIdToString(dataEntityName);
            if (nodeIdStr != null) {
                DynamicObject dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)"tda_param_basic");
                dynamicObjectNew.set("id", (Object)DBServiceHelper.genGlobalLongId());
                dynamicObjectNew.set("params_tag", (Object)jsonString);
                dynamicObjectNew.set("modifytime", (Object)date);
                dynamicObjectNew.set("nodeid", (Object)nodeIdStr);
                dynamicObjectNew.set("name", (Object)dataEntityName);
                dynamicObjectNew.set("createtime", (Object)date);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObjectNew});
            }
        }
    }

    public String saveSrcBill(DynamicObject cacheObject) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(false);
        option.setIncludeComplexProperty(true);
        option.setIncludeCollectionProperty(true);
        option.setIncludeType(false);
        String json = DataEntitySerializer.serializerToString((Object)cacheObject, (DataEntitySerializerOption)option);
        return json;
    }

    private String getNodeIdToString(String dataEntityName) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection categoryCollection = QueryServiceHelper.query((String)"tda_basic_param_tree", (String)"id,number,name,formid,parent", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : categoryCollection) {
            if (!dynamicObject.get("formid").toString().contains(dataEntityName)) continue;
            return dynamicObject.get("id").toString();
        }
        return null;
    }
}

