/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.report.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.SnapDataStateEnum;

public class ReportScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ReportScheduleTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        logger.info("\u8c03\u5ea6\u5feb\u7167\u8bbe\u7f6e");
        this.valid();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (params.containsKey("ishistory")) {
            filter.and("ishistory", "=", (Object)Boolean.TRUE);
        } else {
            filter.and("ishistory", "=", (Object)Boolean.FALSE);
        }
        Map snapSetMap = TmcDataServiceHelper.loadFromCache((String)"tda_decisanlssnapset", (QFilter[])filter.toArray());
        logger.info("\u8c03\u5ea6\u5feb\u7167\u8bbe\u7f6e:" + snapSetMap.size());
        if (snapSetMap.size() > 0) {
            try {
                OperationResult result;
                OperateOption operate = OperateOption.create();
                if (params.containsKey("ishistory")) {
                    operate.getVariables().put("ishistory", params.get("ishistory").toString());
                }
                if ((result = TmcOperateServiceHelper.execOperate((String)"schedule", (String)"tda_decisanlssnapset", (DynamicObject[])snapSetMap.values().toArray(new DynamicObject[0]), (OperateOption)operate, (boolean)true)).isSuccess()) {
                    logger.info("\u6267\u884c\u6210\u529f\u6761\u6570:" + result.getSuccessPkIds().size());
                }
            }
            catch (Exception e) {
                logger.info("\u6267\u884c\u8c03\u5ea6\u62a5\u9519\u4fe1\u606f:" + e.getMessage());
            }
        }
    }

    private void valid() {
        int heartBeat;
        Date heartBeatDate;
        QFilter filter = new QFilter("versionstate", "=", (Object)SnapDataStateEnum.LOADING.getValue());
        Object[] lateests = TmcDataServiceHelper.load((String)"tda_decisanlsversion", (String)"modifytime", (QFilter[])filter.toArray(), (String)"modifytime desc", (int)1);
        if (EmptyUtil.isNoEmpty((Object[])lateests) && EmptyUtil.isNoEmpty((Object)(heartBeatDate = lateests[0].getDate("modifytime"))) && (heartBeat = DateUtils.getDiffMinute((Date)heartBeatDate, (Date)new Date())) < 60) {
            String message = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5feb\u7167\u8c03\u5ea6, \u4e0a\u6b21\u6267\u884c\u65f6\u95f4\u3010%1$s\u3011\u5206\u949f\u524d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u660e\u7ec6\u751f\u6210\u3002", (String)"ReportScheduleTask_1", (String)"tmc-tda-mservice", (Object[])new Object[0]), heartBeat);
            throw new KDBizException(message);
        }
    }
}

