/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.snap;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.snap.SnapScheduleService;

public class SnapScheduleTask
implements Runnable {
    private Long orgId;
    private String batch;
    private DynamicObject schedule;
    private CountDownLatch latch;
    private Long orgViewId;
    private Date queryDate;
    private static final Log logger = LogFactory.getLog(SnapScheduleTask.class);

    public SnapScheduleTask(DynamicObject schedule, Long orgViewId, Long orgId, String batch, Date queryDate, CountDownLatch latch) {
        this.schedule = schedule;
        this.orgViewId = orgViewId;
        this.orgId = orgId;
        this.batch = batch;
        this.latch = latch;
        this.queryDate = queryDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            HashSet<Long> idSet = new HashSet<Long>();
            if (EmptyUtil.isNoEmpty((DynamicObject)this.schedule)) {
                logger.info(this.batch + "\u7ebf\u7a0b\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0c\u62a5\u8868\u7c7b\u578b\uff1a" + this.schedule.getString("reporttype"));
                DynamicObjectCollection scheduleJobs = this.schedule.getDynamicObjectCollection("snapschedule");
                for (DynamicObject scheduleJob : scheduleJobs) {
                    idSet.add(scheduleJob.getLong("fbasedataid_id"));
                }
            }
            logger.info(String.format("\u5feb\u7167\u7248\u672c%s\u62a5\u8868\u8c03\u5ea6\u4efb\u52a1\u6570\u91cf\uff1a%d,\u62a5\u8868\u7c7b\u578b\uff1a%s", this.batch, idSet.size(), this.schedule.getString("reporttype")));
            if (idSet.size() > 0) {
                QFilter fi = new QFilter("id", "in", idSet);
                fi.and(new QFilter("enable", "=", (Object)true));
                Map snapSchedules = TmcDataServiceHelper.loadFromCache((String)"fcs_snapschedule", (String)"reportform,queryitem,queryparam,queryplugin", (QFilter[])fi.toArray());
                logger.info(String.format("\u5feb\u7167\u7248\u672c%s\u62a5\u8868\u8c03\u5ea6\u5b9e\u9645\u4efb\u52a1\u6570\u91cf\uff1a%d,\u62a5\u8868\u7c7b\u578b\uff1a%s", this.batch, snapSchedules.size(), this.schedule.getString("reporttype")));
                if (snapSchedules.size() > 0) {
                    QFilter[] filters = this.getFilter(this.orgId, this.batch, this.queryDate);
                    new SnapScheduleService().schedule(snapSchedules.values().stream().collect(Collectors.toList()), filters, this.batch);
                }
            }
            String sSQL = "Update T_Tda_DecisAnlsVersion Set FModifyTime = ? Where Fnumber = ?";
            TmcDataServiceHelper.execute((DBRoute)DBRouteConst.TMC, (String)sSQL, (Object[])new Object[]{new Date(), this.batch});
        }
        finally {
            this.latch.countDown();
        }
    }

    private QFilter[] getFilter(Long orgId, String batch, Date queryDate) {
        QFilter fi = new QFilter("number", "=", (Object)batch);
        DynamicObject filterSet = TmcDataServiceHelper.loadSingleFromCache((String)"tda_decisanlsversion", (String)"org,orgview,querydate", (QFilter[])fi.toArray());
        DynamicObject orgView = filterSet.getDynamicObject("orgview");
        if (EmptyUtil.isEmpty((Long)orgId)) {
            orgId = filterSet.getDynamicObject("org").getLong("id");
        }
        if (queryDate == null) {
            queryDate = filterSet.getDate("querydate");
        }
        QFilter orgView_Filter = new QFilter("orgview", "=", (Object)orgView);
        DynamicObject org = null;
        if (EmptyUtil.isNoEmpty((Long)orgId)) {
            org = TmcDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        }
        QFilter org_Filter = new QFilter("org", "=", (Object)org);
        QFilter queryDate_Filter = new QFilter("querydate", "=", (Object)queryDate);
        return new QFilter[]{orgView_Filter, org_Filter, queryDate_Filter};
    }
}

