/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.webapi.controller;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.AmountUnitEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.qing.data.AbstractQingAnlsDataPlugin;
import kd.tmc.tda.webapi.model.FormDataSetQueryParam;

@ApiController(value="formdataset", desc="\u8868\u5355\u539f\u59cb\u6570\u636e\u96c6")
@ApiMapping(value="/formdataset")
public class FormDataSetController
implements Serializable {
    private static final Log logger = LogFactory.getLog(FormDataSetController.class);
    private static final String QING_SORT = "qingsort";
    private static final Set<String> AMOUNT_UNIT_Set = new HashSet<String>(Arrays.asList(AmountUnitEnum.ONE.getValue(), AmountUnitEnum.THOUSAND.getValue(), AmountUnitEnum.TTHOUSAND.getValue(), AmountUnitEnum.MILLION.getValue(), AmountUnitEnum.TMILLION.getValue(), AmountUnitEnum.HMILLION.getValue()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiPostMapping(value="/", desc="\u83b7\u53d6\u8868\u5355\u539f\u59cb\u6570\u636e\u96c6")
    public CustomApiResult<QingData> getFormDataSet(@ApiParam(value="\u8868\u5355\u539f\u59cb\u6570\u636e\u96c6\u67e5\u8be2\u53c2\u6570", required=true) @ApiParam(value="\u8868\u5355\u539f\u59cb\u6570\u636e\u96c6\u67e5\u8be2\u53c2\u6570", required=true) FormDataSetQueryParam param) {
        String msg = "";
        boolean isParamValid = true;
        if (param == null) {
            isParamValid = false;
            msg = ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"FormDataSetController_0", (String)"tmc-tda-webapi", (Object[])new Object[0]);
        } else if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{param.getOrgView(), param.getOrg(), param.getQueryDate(), param.getCurrency(), param.getAmountUnit(), param.getFormId()})) {
            isParamValid = false;
            msg = ResManager.loadKDString((String)"'\u7ec4\u7ec7\u89c6\u56fe'\u3001'\u7ec4\u7ec7'\u3001'\u67e5\u8be2\u65e5\u671f'\u3001'\u6298\u7b97\u5e01\u79cd'\u3001'\u8d27\u5e01\u5355\u4f4d'\u548c'\u6307\u5b9a\u6307\u6807\u7684\u62a5\u8868\u8868\u5355\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormDataSetController_1", (String)"tmc-tda-webapi", (Object[])new Object[0]);
        } else if (!AMOUNT_UNIT_Set.contains(param.getAmountUnit())) {
            isParamValid = false;
            msg = ResManager.loadKDString((String)"'\u8d27\u5e01\u5355\u4f4d'\u53ea\u80fd\u4ece\u4ee5\u4e0b\u53d6\u503c\uff1a1\u30011000\u300110000\u30011000000\u300110000000\u3001100000000\u3002", (String)"FormDataSetController_4", (String)"tmc-tda-webapi", (Object[])new Object[0]);
        }
        if (!isParamValid) {
            return this.errorApiResult(msg);
        }
        param.setQueryDate(DateUtils.truncateDate((Date)param.getQueryDate()));
        try (DataSet bizDs = null;){
            QFilter orgViewFilter = new QFilter("orgview", "=", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)param.getOrgView(), (String)"fbd_companysysviewsch"));
            QFilter orgFilter = new QFilter("org", "=", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)param.getOrg(), (String)"bos_org"));
            QFilter currencyFilter = new QFilter("currency", "=", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)param.getCurrency(), (String)"bd_currency"));
            QFilter queryDateFilter = new QFilter("querydate", "=", (Object)param.getQueryDate());
            QFilter unitFilter = new QFilter("amountunit", "=", (Object)param.getAmountUnit());
            QFilter[] qFilters = new QFilter[]{orgViewFilter, orgFilter, queryDateFilter, currencyFilter, unitFilter};
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fcs_snapschedule", (String)"number,queryplugin", (QFilter[])new QFilter("number", "=", (Object)param.getFormId()).toArray());
            if (dynamicObject == null) {
                msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u8868\u5355 %s \u5173\u8054\u7684\u6570\u636e\u6e90\u3002", (String)"FormDataSetController_3", (String)"tmc-tda-webapi", (Object[])new Object[0]);
                CustomApiResult<QingData> customApiResult = this.errorApiResult(String.format(msg, param.getFormId()));
                return customApiResult;
            }
            String queryPluginClassName = dynamicObject.getString("queryplugin");
            IDataSnapExecute pluginInstance = (IDataSnapExecute)Class.forName(queryPluginClassName).newInstance();
            bizDs = this.getBizDs(qFilters, pluginInstance, "" + param.getFormId(), "");
            Set<String> amountFields = this.getAmountFields(pluginInstance);
            if (EmptyUtil.isNoEmpty(amountFields)) {
                ReportQueryParam reportQueryParam = FormDataSetController.tranFilterToParam(new ReportQueryParam(), qFilters);
                Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)reportQueryParam);
                bizDs = AmountTransHelper.dealRowOtherValue((DataSet)bizDs, (Map)paramMap, amountFields);
            }
            QingData qingData = pluginInstance instanceof AbstractQingAnlsDataPlugin ? this.transQingData(bizDs, pluginInstance) : new QingData();
            CustomApiResult customApiResult = CustomApiResult.success((Object)qingData);
            return customApiResult;
        }
    }

    private CustomApiResult<QingData> errorApiResult(String msg) {
        CustomApiResult result = new CustomApiResult();
        result.setStatus(false);
        result.setErrorCode(ApiErrorCode.Data_Invalid.getStatusCode());
        result.setMessage(msg);
        return result;
    }

    private DataSet getBizDs(QFilter[] qFilters, IDataSnapExecute service, String formId, String schemeId) throws Exception {
        return service.data(formId, schemeId, qFilters);
    }

    private QingData transQingData(DataSet ds, IDataSnapExecute pluginInstance) {
        QingData qingData = new QingData();
        if (ds == null) {
            return qingData;
        }
        List<Object[]> columns = this.getColumnItems(pluginInstance);
        qingData.setDataindex(this.createDataIndex(columns));
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        this.addColumnName(data, columns);
        Iterator it = ds.iterator();
        int sort = 0;
        while (it.hasNext()) {
            Row rs = (Row)it.next();
            Object[] row = new Object[columns.size()];
            for (int index = 0; index < columns.size(); ++index) {
                Object[] column = columns.get(index);
                String filed = (String)column[0];
                if (QING_SORT.equals(filed)) {
                    row[index] = sort++;
                    continue;
                }
                Object value = rs.get(filed);
                if (value != null && QingFieldType.Date.toNumber() == ((Integer)column[2]).intValue()) {
                    Date date = (Date)rs.get(filed);
                    value = date.getTime();
                }
                row[index] = value;
            }
            data.add(row);
        }
        qingData.setRows(data);
        return qingData;
    }

    private void addColumnName(List<Object[]> data, List<Object[]> columns) {
        Object[] row = new Object[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            row[i] = columns.get(i)[1];
        }
        data.add(row);
    }

    private Map<String, Integer> createDataIndex(List<Object[]> columnItems) {
        int presize = columnItems.size();
        HashMap<String, Integer> index = new HashMap<String, Integer>(presize);
        for (int k = 0; k < presize; ++k) {
            Object[] column = columnItems.get(k);
            index.put((String)column[0], k);
        }
        return index;
    }

    private static ReportQueryParam tranFilterToParam(ReportQueryParam param, QFilter[] filters) {
        List filterItems = param.getFilter().getFilterItems();
        for (QFilter fi : filters) {
            if (param.getFilter().containProp(fi.getProperty())) {
                for (FilterItemInfo filterItem : filterItems) {
                    if (!fi.getProperty().equals(filterItem.getPropName())) continue;
                    filterItem.setValue(fi.getValue());
                }
                continue;
            }
            param.getFilter().addFilterItem(fi.getProperty(), fi.getValue());
        }
        Long orgViewId = ((DynamicObject)param.getFilter().getFilterItem("orgview").getValue()).getLong("id");
        Long orgId = ((DynamicObject)param.getFilter().getFilterItem("org").getValue()).getLong("id");
        List orgIdList = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        if (param.getFilter().containProp("allorgids")) {
            for (FilterItemInfo filterItem : filterItems) {
                if (!"allorgids".equals(filterItem.getPropName())) continue;
                filterItem.setValue((Object)orgIdList);
            }
        } else {
            param.getFilter().addFilterItem("allorgids", (Object)orgIdList);
        }
        logger.info("------\u83b7\u53d6\u7ec4\u7ec7\u7684\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u8d70\u67e5\u8be2\uff1a" + orgViewId + "-" + orgId);
        List subOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        if (param.getFilter().containProp("suborgids")) {
            for (FilterItemInfo filterItem : filterItems) {
                if (!"suborgids".equals(filterItem.getPropName())) continue;
                filterItem.setValue((Object)subOrgIds);
            }
        } else {
            param.getFilter().addFilterItem("suborgids", (Object)subOrgIds);
        }
        if (param.getFilter().containProp("basecurrency")) {
            for (FilterItemInfo filterItem : filterItems) {
                if (!"basecurrency".equals(filterItem.getPropName())) continue;
                filterItem.setValue((Object)AmountTransHelper.getBaseCurrency((Long)orgViewId));
            }
        } else {
            param.getFilter().addFilterItem("basecurrency", (Object)AmountTransHelper.getBaseCurrency((Long)orgViewId));
        }
        return param;
    }

    private static String throwableToString(Exception exception) {
        Exception cause = exception;
        return FormDataSetController.throwableToString((Throwable)cause);
    }

    private static String throwableToString(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(FormDataSetController.throwableToString(t.getCause())).append("\n");
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            pw.flush();
            sw.flush();
            upper.append(sw);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.toString();
    }

    private Set<String> getAmountFields(IDataSnapExecute pluginInstance) {
        String methodName = "getAmountFields";
        Method method = null;
        Set amountFields = null;
        try {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = pluginInstance.getClass().getDeclaredMethods()) {
                if (!methodName.equals(declaredMethod.getName())) continue;
                method = declaredMethod;
            }
            if (method == null) {
                for (Method declaredMethod : declaredMethods = pluginInstance.getClass().getSuperclass().getDeclaredMethods()) {
                    if (!methodName.equals(declaredMethod.getName())) continue;
                    method = declaredMethod;
                }
            }
            if (method == null) {
                for (Method declaredMethod : declaredMethods = pluginInstance.getClass().getSuperclass().getSuperclass().getDeclaredMethods()) {
                    if (!methodName.equals(declaredMethod.getName())) continue;
                    method = declaredMethod;
                }
            }
            if (method != null) {
                ReflectionUtils.makeAccessible(method);
                amountFields = (Set)method.invoke((Object)pluginInstance, new Object[0]);
            }
            return amountFields;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    private List<Object[]> getColumnItems(IDataSnapExecute pluginInstance) {
        String methodName = "getColumnItems";
        Method method = null;
        List columnItems = null;
        try {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = pluginInstance.getClass().getDeclaredMethods()) {
                if (!methodName.equals(declaredMethod.getName())) continue;
                method = declaredMethod;
            }
            if (method == null) {
                for (Method declaredMethod : declaredMethods = pluginInstance.getClass().getSuperclass().getDeclaredMethods()) {
                    if (!methodName.equals(declaredMethod.getName())) continue;
                    method = declaredMethod;
                }
            }
            if (method == null) {
                for (Method declaredMethod : declaredMethods = pluginInstance.getClass().getSuperclass().getSuperclass().getDeclaredMethods()) {
                    if (!methodName.equals(declaredMethod.getName())) continue;
                    method = declaredMethod;
                }
            }
            if (method != null) {
                ReflectionUtils.makeAccessible(method);
                columnItems = (List)method.invoke((Object)pluginInstance, new Object[0]);
            }
            return columnItems;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

