/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.arap;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.mservice.arap.task.ArapSummaryScheduleTask;

public class AccrualAgingEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(AccrualAgingEditPlugin.class);
    private static final String TDA_ACCRUALAGING = "tda_accrualaging";
    private static final String TYPE = "type";
    private static final ExecutorService EXECUTOR = ThreadPools.newExecutorService((String)"tda_arapaging_threadpool", (int)2);

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int currentIndex = changeData[0].getRowIndex();
        if (currentIndex != -1) {
            boolean isdaymore = (Boolean)this.getModel().getValue("e_isdaymore", currentIndex);
            int startday = (Integer)this.getModel().getValue("e_startday", currentIndex);
            int endday = (Integer)this.getModel().getValue("e_endday", currentIndex);
            switch (key) {
                case "e_isdaymore": {
                    if (!isdaymore) break;
                    int entryCount = this.getModel().getEntryRowCount("entry");
                    if (entryCount != currentIndex + 1) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u5929\u4ee5\u4e0a\u5f00\u5173\u7684\u884c\u5fc5\u987b\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"AccrualAgingEditPlugin_4", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getModel().setValue("e_endday", (Object)0, currentIndex);
                    break;
                }
                case "e_startday": {
                    int entryCount = currentIndex - 1;
                    int currentRowSeq = currentIndex + 1;
                    if (entryCount < 0) break;
                    int lastRowEndday = (Integer)this.getModel().getValue("e_endday", entryCount);
                    if (lastRowEndday == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e0a\u4e00\u884c\u622a\u6b62\u5929\u6570\u3002", (String)"AccrualAgingEditPlugin_1", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("e_startday", (Object)0, currentIndex);
                        return;
                    }
                    int currentInputStartDay = lastRowEndday + 1;
                    if (startday == currentInputStartDay) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u672c\u884c\u8bbe\u7f6e\u7684\u8d77\u59cb\u5929\u6570\u5e94\u4e0e\u4e0a\u4e00\u884c\u622a\u6b62\u5929\u6570\u8854\u63a5\u3002", (String)"AccrualAgingEditPlugin_2", (String)"tmc-tda-formplugin", (Object[])new Object[]{currentRowSeq}));
                    this.getModel().setValue("e_startday", (Object)currentInputStartDay, currentIndex);
                    break;
                }
                case "e_endday": {
                    int entryCount;
                    if (endday <= startday && !isdaymore) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u622a\u6b62\u5929\u6570\u5e94\u5927\u4e8e\u8d77\u59cb\u5929\u6570\u3002", (String)"AccrualAgingEditPlugin_5", (String)"tmc-tda-formplugin", (Object[])new Object[]{currentIndex + 1}));
                    }
                    if ((entryCount = this.getModel().getEntryRowCount("entry")) == 1) {
                        return;
                    }
                    if (currentIndex >= entryCount - 1) break;
                    this.getModel().setValue("e_startday", (Object)(endday + 1), currentIndex + 1);
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key)) {
            this.sectionValidator();
        } else if ("newentry".equals(key)) {
            int entryCount = this.getModel().getEntryRowCount("entry");
            if (entryCount == 0) {
                return;
            }
            int currencyIndex = entryCount - 1;
            boolean isDaymore = (Boolean)this.getModel().getValue("e_isdaymore", currencyIndex);
            if (isDaymore) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u5929\u4ee5\u4e0a\u5f00\u5173\u7684\u884c\u5fc5\u987b\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"AccrualAgingEditPlugin_4", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("newentry".equals(key)) {
            int entryCount = this.getModel().getEntryRowCount("entry");
            if (entryCount == 1) {
                return;
            }
            int lastRowEndday = (Integer)this.getModel().getValue("e_endday", entryCount - 2);
            if (lastRowEndday != 0) {
                this.getModel().setValue("e_startday", (Object)(lastRowEndday + 1), entryCount - 1);
            }
        }
        if ("save".equals(key)) {
            EXECUTOR.submit(() -> {
                ArapSummaryScheduleTask task = new ArapSummaryScheduleTask();
                Date date = new Date();
                for (int i = 1; i < 25; ++i) {
                    Date firstDayOfMonth = DateUtils.getFirstDateOfAnyMonth((Date)date, (int)(-i));
                    String dateStr = DateUtils.formatString((Date)firstDayOfMonth, (String)"yyyy-MM-dd");
                    HashMap<String, String> paramMap = new HashMap<String, String>(4);
                    paramMap.put("date", dateStr);
                    try {
                        task.execute(null, paramMap);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("\u5e94\u6536\u5e94\u4ed8\u8d26\u9f84\u8bbe\u7f6e-\u91cd\u5237\u5386\u53f2", (Throwable)e);
                    }
                }
            });
        }
    }

    private void sectionValidator() {
        String type = (String)this.getModel().getValue(TYPE);
        if (EmptyUtil.isNoEmpty((String)type)) {
            boolean exists;
            QFilter filter = new QFilter(TYPE, "=", (Object)type);
            Long id = (Long)this.getModel().getValue("id");
            if (EmptyUtil.isNoEmpty((Long)id)) {
                filter.and("id", "!=", (Object)id);
            }
            if (exists = QueryServiceHelper.exists((String)TDA_ACCRUALAGING, (QFilter[])filter.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6b64\u8d26\u9f84\u5206\u7ec4\u7c7b\u578b\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u5f55\u5165\u3002", (String)"AccrualAgingEditPlugin_6", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            }
        }
        int entryCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryCount; ++i) {
            int nextRowStartDay;
            boolean isdaymore = (Boolean)this.getModel().getValue("e_isdaymore", i);
            if (isdaymore) {
                Object section;
                if (entryCount - 1 <= 0 || (section = this.getModel().getValue("e_section", i + 1)) == null) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u5929\u4ee5\u4e0a\u5f00\u5173\u7684\u884c\u5fc5\u987b\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"AccrualAgingEditPlugin_4", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            }
            int startday = (Integer)this.getModel().getValue("e_startday", i);
            int endtday = (Integer)this.getModel().getValue("e_endday", i);
            if (endtday <= startday) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u622a\u6b62\u5929\u6570\u5e94\u5927\u4e8e\u8d77\u59cb\u5929\u6570\u3002", (String)"AccrualAgingEditPlugin_5", (String)"tmc-tda-formplugin", (Object[])new Object[]{i + 1}));
            }
            if (i == entryCount - 1 || (nextRowStartDay = ((Integer)this.getModel().getValue("e_startday", i + 1)).intValue()) == endtday + 1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u672c\u884c\u8bbe\u7f6e\u7684\u8d77\u59cb\u5929\u6570\u5e94\u4e0e\u4e0a\u4e00\u884c\u622a\u6b62\u5929\u6570\u8854\u63a5\u3002", (String)"AccrualAgingEditPlugin_2", (String)"tmc-tda-formplugin", (Object[])new Object[]{i + 2}));
        }
    }
}

