/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.basicparam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.BasicParamSetFormDataHelper;
import kd.tmc.tda.common.helper.CtrlConditionHelper;

public class BasicParamApplicationPlugin
extends AbstractBillPlugIn {
    public static final String POSITION_APPLYCONDITION = "positionapplycondition";
    public static final String BE_APPLYCONDITION = "bankapplycondition";
    public static final String ABROAD_APPLYCONDITION = "abroadapplycondition";
    public static final String POSITION_VIEW_BTN = "positionbtn";
    public static final String BE_VIEW_BTN = "bebtn";
    public static final String ABROAD_VIEW_BTN = "abroadbtn";
    public static final String PAPPLYCONDITION_TAG = "positionapplyconditiontag";
    public static final String BAPPLYCONDITION_TAG = "bankapplyconditiontag";
    public static final String AAPPLYCONDITION_TAG = "abroadapplyconditiontag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{POSITION_APPLYCONDITION, BE_APPLYCONDITION, ABROAD_APPLYCONDITION, POSITION_VIEW_BTN, BE_VIEW_BTN, ABROAD_VIEW_BTN});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String jsonStr = null;
        String jsonBtnView = null;
        String chooseJson = null;
        switch (key) {
            case "positionapplycondition": {
                jsonStr = (String)this.getModel().getValue(PAPPLYCONDITION_TAG);
                chooseJson = POSITION_APPLYCONDITION;
                break;
            }
            case "bankapplycondition": {
                jsonStr = (String)this.getModel().getValue(BAPPLYCONDITION_TAG);
                chooseJson = BE_APPLYCONDITION;
                break;
            }
            case "abroadapplycondition": {
                jsonStr = (String)this.getModel().getValue(AAPPLYCONDITION_TAG);
                chooseJson = ABROAD_APPLYCONDITION;
                break;
            }
            case "positionbtn": {
                jsonBtnView = (String)this.getModel().getValue(PAPPLYCONDITION_TAG);
                break;
            }
            case "bebtn": {
                jsonBtnView = (String)this.getModel().getValue(BAPPLYCONDITION_TAG);
                break;
            }
            case "abroadbtn": {
                jsonBtnView = (String)this.getModel().getValue(AAPPLYCONDITION_TAG);
                break;
            }
        }
        if (jsonStr != null) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setCurrentEntity("bd_accountbanks");
            TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            this.showConditionForm(jsonStr, mainType.getName(), fldNodes, chooseJson);
        }
        if (jsonBtnView != null) {
            this.getViewBtnContent(jsonBtnView);
        }
    }

    private void getViewBtnContent(String jsonBtnView) {
        QFilter qFilter = CtrlConditionHelper.getFilterFromTag((String)"bd_accountbanks", (String)jsonBtnView);
        if (qFilter == null) {
            qFilter = new QFilter("id", "=", null);
        }
        ListShowParameter listShow = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)false);
        listShow.getOpenStyle().setShowType(ShowType.Modal);
        listShow.setFormId("bos_list");
        listShow.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u6761\u4ef6\u94f6\u884c\u8d26\u6237\u5217\u8868", (String)"FundCcrSetAcctViewPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
        listShow.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)listShow);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dynamicObject = BasicParamSetFormDataHelper.buildBasicParamSetForm((String)"tda_application_scenarios", (Integer)1);
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty dataEntityProperty : properties) {
                this.getModel().setValue(dataEntityProperty.getName(), (Object)dynamicObject.getString(dataEntityProperty.getName()));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (this.applycondtionContainsList(sourceFldKey)) {
            this.setApplyConditionInfo((String)returnData, sourceFldKey);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        String keyTag = this.chooseContainsList(e.getProperty().getName());
        if (changeSet[0].getNewValue() != null && !changeSet[0].getNewValue().equals(changeSet[0].getOldValue())) {
            this.getView().getPageCache().put("dataChange", "true");
            if (EmptyUtil.isNoEmpty((String)keyTag) && EmptyUtil.isEmpty((Object)this.getModel().getValue(e.getProperty().getName()))) {
                this.getModel().setValue(keyTag, null);
            }
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String chooseJson) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", "true");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("hiddenexpression", "true");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, chooseJson));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setApplyConditionInfo(String returnData, String sourceFldKey) {
        if (StringUtils.isNotBlank((CharSequence)returnData)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            this.getModel().setValue(this.chooseContainsList(sourceFldKey), (Object)returnData);
            String desc = condition.getExprDesc();
            if (desc.length() > 50) {
                desc = desc.substring(0, 40) + "......";
            }
            this.getModel().setValue(sourceFldKey, (Object)desc);
        }
    }

    private boolean applycondtionContainsList(String key) {
        ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(POSITION_APPLYCONDITION, BE_APPLYCONDITION, ABROAD_APPLYCONDITION));
        return stringList.contains(key);
    }

    private String chooseContainsList(String key) {
        switch (key) {
            case "positionapplycondition": {
                return PAPPLYCONDITION_TAG;
            }
            case "bankapplycondition": {
                return BAPPLYCONDITION_TAG;
            }
            case "abroadapplycondition": {
                return AAPPLYCONDITION_TAG;
            }
        }
        return null;
    }
}

