/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.basicparam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BasicParamSettingPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    private static final String TEMP_PAGE_CACHE = "tempPageCache";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String TREEVIEWAP = "treeviewap";
    private static final String SETTINGPAGECACHE = "settingPageCache";
    private static final String CLOSE_PAGE_CACHE = "closePageCache";
    private static final String TABLE_TDA_PARAM_BASIC = "tda_param_basic";
    private static final String TABAP = "tabap";
    private static final String TREENODECACHE = "treenodecache";
    private static final String FOCUSEDNODEID = "focusedNodeId";
    private static final String PAGE_VIEWS = "page_views_cache";
    private static final String CURRENTNODEID = "currentNodeId";
    private static final String DATACHANGE = "dataChange";
    private static final String ISCLOSED = "isClosed";
    private static final String TABLECLICK_CONFIRM = "tableClick_confirm";
    private static final String TREECLICK_CONFIRM = "treeClick_confirm";
    private static final String DATACHANGE_COMFIRM = "dataChange_comfirm";
    private static final String TOOLBARAP = "toolbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeNode root = this.buildRootNode();
        IPageCache pageCache = this.getPageCache();
        pageCache.put(TREENODECACHE, SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addNode(root);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_REFRESH});
        pageCache.put(PAGE_VIEWS, SerializationUtils.serializeToBase64(new HashMap(4)));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String lastNodeId;
        String nodeId = (String)evt.getNodeId();
        if (!StringUtils.equals((CharSequence)nodeId, (CharSequence)(lastNodeId = this.getPageCache().get(FOCUSEDNODEID)))) {
            IPageCache pageCache = this.getPageCache();
            IFormView parameterView = this.getView().getViewNoPlugin(pageCache.get(SETTINGPAGECACHE));
            if (parameterView != null && Boolean.parseBoolean(parameterView.getPageCache().get(DATACHANGE))) {
                this.getView().showConfirm(this.showConfirmMsg(), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener(TREECLICK_CONFIRM, (IFormPlugin)this));
                this.getPageCache().put(CURRENTNODEID, nodeId);
                evt.setCancel(true);
            } else {
                this.batchCloseParamForm(this.getPageView().values());
                this.doTreeNodeClick(nodeId);
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREENODECACHE), TreeNode.class);
                TreeNode checkedNode = root.getTreeNode(nodeId, 10);
                List children = checkedNode.getChildren();
                if (CollectionUtils.isNotEmpty((Collection)children)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_REFRESH});
                }
            }
        }
    }

    private void doTreeNodeClick(String nodeId) {
        this.closeParameterForm();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREENODECACHE), TreeNode.class);
        TreeNode checkedNode = root.getTreeNode(nodeId, 10);
        TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
        tree.focusNode(checkedNode);
        if (checkedNode == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_REFRESH});
        } else {
            this.getPageCache().put(FOCUSEDNODEID, nodeId);
            String formIdStr = (String)checkedNode.getData();
            if (formIdStr != null) {
                Map<String, String> pageView = this.getPageView();
                List<String> formIdStrList = Arrays.asList(formIdStr.split(","));
                for (String formId : formIdStrList) {
                    if (pageView.containsKey(formId)) continue;
                    FormShowParameter showParameter = this.getFormShowParameter(nodeId, formId);
                    if (this.isContainPrintValue(formId)) {
                        showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u503c\u53c2\u6570\u8bbe\u7f6e", (String)"BasicParamSettingPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().showForm(showParameter);
                    this.putPageView(formId, showParameter.getPageId());
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_SAVE, BTN_REFRESH});
                    this.getPageCache().put(SETTINGPAGECACHE, showParameter.getPageId());
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_SAVE.equals(key)) {
            this.saveData();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!Boolean.parseBoolean(this.getPageCache().get(ISCLOSED))) {
            IPageCache pageCache = this.getPageCache();
            IFormView parameterView = this.getView().getViewNoPlugin(pageCache.get(CLOSE_PAGE_CACHE));
            if (parameterView != null && Boolean.parseBoolean(parameterView.getPageCache().get(DATACHANGE))) {
                this.getView().showConfirm(this.showConfirmMsg(), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener(DATACHANGE_COMFIRM, (IFormPlugin)this));
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if (DATACHANGE_COMFIRM.equals(confirmId)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                this.getPageCache().put(ISCLOSED, "true");
                this.getView().close();
            } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.saveData();
                this.getDataChangeTip();
                this.getPageCache().put(ISCLOSED, "true");
                this.getView().close();
            }
        } else if (TREECLICK_CONFIRM.equals(confirmId)) {
            String currentNodeId = this.getPageCache().get(CURRENTNODEID);
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.saveData();
                this.getDataChangeTip();
                this.batchCloseParamForm(this.getPageView().values());
                this.doTreeNodeClick(currentNodeId);
            } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                this.batchCloseParamForm(this.getPageView().values());
                this.doTreeNodeClick(currentNodeId);
            } else {
                String lastNodeId = this.getPageCache().get(FOCUSEDNODEID);
                TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREENODECACHE), TreeNode.class);
                TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
                TreeNode treeNode = leftRoot.getTreeNode(lastNodeId);
                tree.focusNode(treeNode);
            }
        } else if (TABLECLICK_CONFIRM.equals(confirmId)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.saveData();
                this.getDataChangeTip();
                this.getView().getPageCache().remove(CLOSE_PAGE_CACHE);
                this.getView().getPageCache().remove(TEMP_PAGE_CACHE);
            } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                String settingPageCache = this.getView().getPageCache().get(SETTINGPAGECACHE);
                String tempPageCache = this.getView().getPageCache().get(TEMP_PAGE_CACHE);
                if (EmptyUtil.isNoEmpty((String)settingPageCache)) {
                    IFormView viewNoPlugin = this.getView().getView(settingPageCache);
                    viewNoPlugin.getPageCache().put(DATACHANGE, "false");
                    viewNoPlugin.updateView();
                    if (EmptyUtil.isNoEmpty((String)tempPageCache)) {
                        this.getView().getPageCache().put(SETTINGPAGECACHE, tempPageCache);
                        this.getView().getPageCache().remove(CLOSE_PAGE_CACHE);
                    }
                }
            } else {
                String settingPageCache = this.getView().getPageCache().get(SETTINGPAGECACHE);
                if (EmptyUtil.isNoEmpty((String)settingPageCache)) {
                    Tab tab = (Tab)this.getView().getControl(TABAP);
                    tab.activeTab(settingPageCache);
                    this.getView().getPageCache().remove(CLOSE_PAGE_CACHE);
                    this.getView().getPageCache().remove(TEMP_PAGE_CACHE);
                }
            }
        }
    }

    private void saveData() {
        IPageCache pageCache = this.getPageCache();
        String settingPageCache = pageCache.get(SETTINGPAGECACHE);
        pageCache.put(CLOSE_PAGE_CACHE, settingPageCache);
        IFormView parameterView = this.getView().getViewNoPlugin(settingPageCache);
        String tempPageCache = pageCache.get(TEMP_PAGE_CACHE);
        if (EmptyUtil.isNoEmpty((String)tempPageCache)) {
            pageCache.put(SETTINGPAGECACHE, tempPageCache);
            pageCache.remove(TEMP_PAGE_CACHE);
        }
        if (parameterView != null) {
            parameterView.getPageCache().put(DATACHANGE, "false");
            IDataModel parameterModel = (IDataModel)parameterView.getService(IDataModel.class);
            DynamicObject dataEntity = parameterModel.getDataEntity();
            String dataEntityName = parameterModel.getDataEntityType().getName();
            String nodeId = (String)parameterView.getFormShowParameter().getCustomParam("nodeid");
            QFilter qFilter = new QFilter("nodeid", "=", (Object)nodeId).and("name", "=", (Object)dataEntityName);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)TABLE_TDA_PARAM_BASIC, (String)"id,nodeid,params_tag,name,createtime,modifytime", (QFilter[])qFilter.toArray());
            String jsonString = this.saveSrcBill(dataEntity);
            Date date = new Date();
            if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
                dynamicObject.set("params_tag", (Object)jsonString);
                dynamicObject.set("modifytime", (Object)date);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            } else {
                DynamicObject dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)TABLE_TDA_PARAM_BASIC);
                dynamicObjectNew.set("id", (Object)DBServiceHelper.genGlobalLongId());
                dynamicObjectNew.set("params_tag", (Object)jsonString);
                dynamicObjectNew.set("modifytime", (Object)date);
                dynamicObjectNew.set("nodeid", (Object)nodeId);
                dynamicObjectNew.set("name", (Object)dataEntityName);
                dynamicObjectNew.set("createtime", (Object)date);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObjectNew});
            }
        }
    }

    private FormShowParameter getFormShowParameter(String nodeId, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(TABAP);
        showParameter.setFormId(formId);
        showParameter.setCustomParam("nodeid", (Object)nodeId);
        String pageId = showParameter.getPageId();
        this.getPageCache().put(formId, pageId);
        return showParameter;
    }

    private void closeParameterForm() {
        String pageId = this.getPageCache().get(CLOSE_PAGE_CACHE);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>(16);
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(CLOSE_PAGE_CACHE);
            this.removePageViewByPageViewId(pageId);
            String tempPageCache = this.getPageCache().get(TEMP_PAGE_CACHE);
            if (EmptyUtil.isNoEmpty((String)tempPageCache)) {
                this.getPageCache().put(SETTINGPAGECACHE, tempPageCache);
                this.getPageCache().remove(TEMP_PAGE_CACHE);
            }
        }
    }

    private TreeNode buildRootNode() {
        TreeNode treeNode = new TreeNode();
        treeNode.setParentid("");
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(16);
        String headId = "";
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection categoryCollection = QueryServiceHelper.query((String)"tda_basic_param_tree", (String)"id,number,name,formid,parent", (QFilter[])new QFilter[]{qFilter}, (String)"number");
        for (DynamicObject dynamicObject : categoryCollection) {
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            memberMap.put("id", dynamicObject.getString("id"));
            memberMap.put("number", dynamicObject.getString("number"));
            memberMap.put("name", ResManager.loadKDString((String)dynamicObject.getString("name"), (String)("TdaParamSettingPlugin_" + dynamicObject.getString("id")), (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            memberMap.put("formid", dynamicObject.getString("formid"));
            memberMap.put("parent", dynamicObject.getString("parent"));
            treeList.add(memberMap);
            if (!"0".equals(dynamicObject.getString("parent"))) continue;
            headId = dynamicObject.getString("id");
            treeNode.setId(headId);
            treeNode.setText(ResManager.loadKDString((String)dynamicObject.getString("name"), (String)"TdaParamSettingPlugin_1", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            treeNode.setIsOpened(true);
        }
        this.setEntryNode(treeNode, treeList, headId);
        return treeNode;
    }

    private TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parent");
            ArrayList<Map<String, String>> nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<Map<String, String>>();
                nodeMap.put(parentId, (List<Map<String, String>>)nodeList);
            }
            nodeList.add(node);
        }
        return this.createNode(root, nodeMap, headId);
    }

    private TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                entry.setData((Object)map.get("formid"));
                String entryHeadId = map.get("id");
                this.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }

    public String saveSrcBill(DynamicObject cacheObject) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(false);
        option.setIncludeComplexProperty(true);
        option.setIncludeCollectionProperty(true);
        option.setIncludeType(false);
        String json = DataEntitySerializer.serializerToString((Object)cacheObject, (DataEntitySerializerOption)option);
        return json;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String currentTab = ((Tab)tabSelectEvent.getSource()).getCurrentTab();
        String oldTab = this.getView().getPageCache().get(SETTINGPAGECACHE);
        if (EmptyUtil.isNoEmpty((String)oldTab) && !oldTab.equals(currentTab) && EmptyUtil.isNoEmpty((Object)this.getView().getViewNoPlugin(oldTab)) && Boolean.parseBoolean(this.getView().getViewNoPlugin(oldTab).getPageCache().get(DATACHANGE))) {
            this.getView().getPageCache().put(TEMP_PAGE_CACHE, currentTab);
            this.getView().getPageCache().put(CLOSE_PAGE_CACHE, oldTab);
            this.getView().showConfirm(this.showConfirmMsg(), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener(TABLECLICK_CONFIRM, (IFormPlugin)this));
        } else {
            this.getView().getPageCache().put(SETTINGPAGECACHE, currentTab);
        }
    }

    private void batchCloseParamForm(Collection<String> tabKeys) {
        if (EmptyUtil.isEmpty(tabKeys)) {
            return;
        }
        ArrayList<Map<String, String>> needCloseTabs = new ArrayList<Map<String, String>>(tabKeys.size());
        for (String tabKey : tabKeys) {
            IFormView formView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
            if (formView != null) {
                formView.close();
            }
            needCloseTabs.add(Collections.singletonMap("pageId", tabKey));
        }
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", needCloseTabs);
        this.removeAllPageView();
        this.getPageCache().remove(SETTINGPAGECACHE);
        this.getPageCache().remove(TEMP_PAGE_CACHE);
        this.getPageCache().remove(CLOSE_PAGE_CACHE);
    }

    private Map<String, String> getPageView() {
        String pageViewCacheStr = this.getPageCache().get(PAGE_VIEWS);
        return (Map)SerializationUtils.deSerializeFromBase64((String)pageViewCacheStr);
    }

    private void putPageView(String key, String pageViewId) {
        this.refreshPageViewCache(key, pageViewId, "put");
    }

    private void removeAllPageView() {
        this.refreshPageViewCache(null, null, "removeAll");
    }

    private void removePageViewByPageViewId(String pageViewId) {
        this.refreshPageViewCache(null, pageViewId, "removeByPageViewId");
    }

    private void refreshPageViewCache(String key, String pageViewId, String refreshType) {
        Map<String, String> pageViewMap = this.getPageView();
        switch (refreshType) {
            case "put": {
                pageViewMap.put(key, pageViewId);
                break;
            }
            case "remove": {
                pageViewMap.remove(key);
                break;
            }
            case "removeByPageViewId": {
                pageViewMap.values().removeIf(value -> value.equals(pageViewId));
                break;
            }
            case "removeAll": {
                pageViewMap.clear();
                break;
            }
        }
        this.getPageCache().put(PAGE_VIEWS, SerializationUtils.serializeToBase64(pageViewMap));
    }

    private boolean isContainPrintValue(String str) {
        HashSet<String> stringSet = new HashSet<String>(Arrays.asList("tda_acct_queryparamset", "tda_finance_param", "tda_security_param"));
        return stringSet.contains(str);
    }

    private void getDataChangeTip() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TdaParamSettingPlugin_11", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
    }

    private String showConfirmMsg() {
        return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4fdd\u5b58\u4fee\u6539\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TdaParamSettingPlugin_12", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
    }
}

