/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.bigamount;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.SucessFailStateEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SysParamHelper;

public class BigAmountBatchPlugin
implements IEventServicePlugin {
    private static final String BEI_BANK_PAY_BILL = "bei_bankpaybill";
    private static final String BEI_PAY_UPDATE_STATUS_BILL = "bei_paybillupdatestatus";
    private static final String BANK_PAY_BILL_SYNC = "bei_bankpaybill_syncstatus";
    private static final String BANK_PAY_UPDATE_STATUS_BILL_AUDIT = "bei_paybillupdatestatus_audit";
    private static final String PAY_BILL_PAY = "cas_paybill_pay";
    private static final String PAY_BILL_SYNC_STATUS = "cas_paybill_syncbankbillstatus";
    private static final String PAY_BILL_CANCEL_PAY = "cas_paybill_cancelpay";
    private static final String REC_BILL_REC = "cas_recbill_receivingrec";
    private static final String REC_BILL_CANCEL_REC = "cas_recbill_cancelrec";
    private static final String TRANS_DETAIL_SAVE = "bei_transdetail_save";
    public static final String SOURCEBILLID = "sourcebillid";
    public static final String SRCBILLNO = "srcbillno";

    public Object handleEvent(KDBizEvent evt) {
        boolean isOpenSettle = SysParamHelper.isOpenSettle();
        if (!isOpenSettle) {
            return super.handleEvent(evt);
        }
        EntityEvent entityEvent = (EntityEvent)evt;
        String entityNumber = entityEvent.getEntityNumber();
        String operation = entityEvent.getOperation();
        String key = entityNumber + "_" + operation;
        List businesskeys = entityEvent.getBusinesskeys();
        if (EmptyUtil.isEmpty((Collection)businesskeys)) {
            return super.handleEvent(evt);
        }
        switch (key) {
            case "bei_transdetail_save": {
                this.invokeBatchBigAmount(businesskeys);
                break;
            }
            case "cas_paybill_pay": 
            case "cas_paybill_syncbankbillstatus": 
            case "cas_recbill_receivingrec": {
                this.invokeBatchPayOrRecBigAmount(entityNumber, businesskeys);
                break;
            }
            case "cas_paybill_cancelpay": 
            case "cas_recbill_cancelrec": {
                List<String> delNumbers = this.getRecOrPayCancelNumbers(entityNumber, businesskeys);
                this.invokeDelTransDetailData(delNumbers);
                break;
            }
            case "bei_bankpaybill_syncstatus": {
                List<String> payIds = this.getPayIdsByBankPayBillIds(businesskeys);
                this.invokeBatchPayOrRecBigAmount("cas_paybill", payIds);
                break;
            }
            case "bei_paybillupdatestatus_audit": {
                this.dealBankPayUpdateStatusBills(businesskeys);
                break;
            }
        }
        return super.handleEvent(evt);
    }

    private void dealBankPayUpdateStatusBills(List<String> businesskeys) {
        QFilter filter = new QFilter("id", "in", businesskeys.stream().map(Long::valueOf).collect(Collectors.toList())).and("sourcetype", "=", (Object)BEI_BANK_PAY_BILL);
        DynamicObjectCollection querys = QueryServiceHelper.query((String)BEI_PAY_UPDATE_STATUS_BILL, (String)"id,auditdate,sourcebillid,entrys.statusnew,entrys.opstatus", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)querys)) {
            return;
        }
        List auditdates = querys.stream().filter(dynamicObject -> SucessFailStateEnum.SUCCESS.getValue().equals(dynamicObject.getString("entrys.opstatus"))).sorted(Comparator.comparing(o1 -> ((DynamicObject)o1).getString("auditdate")).thenComparing(o2 -> ((DynamicObject)o2).getLong("id"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(auditdates)) {
            return;
        }
        DynamicObject updateStatusBill = (DynamicObject)auditdates.get(auditdates.size() - 1);
        QFilter payFilter = new QFilter("id", "=", (Object)updateStatusBill.getLong(SOURCEBILLID));
        DynamicObject bankPayBill = QueryServiceHelper.queryOne((String)BEI_BANK_PAY_BILL, (String)"sourcebillid, srcbillno", (QFilter[])payFilter.toArray());
        if (BeBillStatusEnum.TS.getValue().equals(updateStatusBill.getString("entrys.statusnew"))) {
            this.invokeBatchPayOrRecBigAmount("cas_paybill", Collections.singletonList(bankPayBill.getString(SOURCEBILLID)));
            return;
        }
        if (BeBillStatusEnum.TF.getValue().equals(updateStatusBill.getString("entrys.statusnew"))) {
            this.invokeDelTransDetailData(Collections.singletonList(bankPayBill.getString(SRCBILLNO)));
        }
    }

    private List<String> getPayIdsByBankPayBillIds(List<String> businesskeys) {
        QFilter filter = new QFilter("id", "in", businesskeys.stream().map(Long::valueOf).collect(Collectors.toList()));
        DynamicObjectCollection querys = QueryServiceHelper.query((String)BEI_BANK_PAY_BILL, (String)SOURCEBILLID, (QFilter[])filter.toArray());
        List<String> sourcebillid = querys.stream().map(dynamicObject -> dynamicObject.getString(SOURCEBILLID)).collect(Collectors.toList());
        return sourcebillid;
    }

    private List<String> getRecOrPayCancelNumbers(String entityNumber, List<String> businesskeys) {
        QFilter filter = new QFilter("id", "in", businesskeys.stream().map(Long::valueOf).collect(Collectors.toList()));
        DynamicObjectCollection querys = QueryServiceHelper.query((String)entityNumber, (String)"billno", (QFilter[])filter.toArray());
        List<String> billNumbers = querys.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        return billNumbers;
    }

    private void invokeDelTransDetailData(List<String> delNumbers) {
        if (EmptyUtil.isNoEmpty(delNumbers)) {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"bigAmountSummaryService", (String)"delTransDetailData", (Object[])new Object[]{delNumbers});
        }
    }

    private void invokeBatchBigAmount(List<String> businesskeys) {
        if (EmptyUtil.isNoEmpty(businesskeys)) {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"bigAmountSummaryService", (String)"batchBigAmount", (Object[])new Object[]{businesskeys});
        }
    }

    private void invokeBatchPayOrRecBigAmount(String entityNumber, List<String> businesskeys) {
        if (EmptyUtil.isNoEmpty(businesskeys)) {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"bigAmountSummaryService", (String)"batchPayOrRecBigAmount", (Object[])new Object[]{entityNumber, businesskeys});
        }
    }
}

