/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.bigamount;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class BigAmountSetEditPlugin
extends AbstractTmcBillEdit {
    private static final String TRADETEXTFIELDDES = "tradetextfielddes";
    private static final String RECTEXTFIELDDES = "rectextfielddes";
    private static final String PAYTEXTFIELDDES = "paytextfielddes";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TRADETEXTFIELDDES, RECTEXTFIELDDES, PAYTEXTFIELDDES});
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.bindData(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindData(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("bigamountgetterway".equals(propName)) {
            String value = (String)this.getModel().getValue("bigamountgetterway");
            this.setTextVisible(value);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String clickType = source.getKey();
        this.clickApplyCondition(clickType);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        switch (event.getActionId()) {
            case "bei_transdetail": {
                this.setApplyConditionInfo((String)returnData, TRADETEXTFIELDDES, "tradetextfield_tag");
                break;
            }
            case "cas_recbill": {
                this.setApplyConditionInfo((String)returnData, RECTEXTFIELDDES, "rectextfield_tag");
                break;
            }
            case "cas_paybill": {
                this.setApplyConditionInfo((String)returnData, PAYTEXTFIELDDES, "paytextfield_tag");
                break;
            }
        }
    }

    private void setApplyConditionInfo(String returnData, String textField, String longTextField) {
        if (StringUtils.isNotBlank((CharSequence)returnData)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            this.getModel().setValue(longTextField, (Object)returnData);
            String desc = condition.getExprDesc();
            if (desc.length() > 50) {
                desc = desc.substring(0, 40) + "......";
            }
            this.getModel().setValue(textField, (Object)desc);
        }
    }

    private void clickApplyCondition(String clickType) {
        String entityNumber = "";
        String jsonTag = "";
        switch (clickType) {
            case "tradetextfielddes": {
                entityNumber = "bei_transdetail";
                jsonTag = "tradetextfield_tag";
                break;
            }
            case "rectextfielddes": {
                entityNumber = "cas_recbill";
                jsonTag = "rectextfield_tag";
                break;
            }
            case "paytextfielddes": {
                entityNumber = "cas_paybill";
                jsonTag = "paytextfield_tag";
                break;
            }
        }
        String json = (String)this.getModel().getValue(jsonTag);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(entityNumber);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(json, mainType.getName(), fldNodes);
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", "true");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("hiddenexpression", "true");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityNumber));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void bindData(boolean isBindData) {
        Map defaults = TmcDataServiceHelper.loadFromCache((String)this.getModel().getDataEntityType().getName(), (String)"id, bigamountgetterway", null);
        if (!defaults.isEmpty()) {
            for (DynamicObject defaultValue : defaults.values()) {
                if (!isBindData) {
                    IBillModel model = (IBillModel)this.getModel();
                    model.load(defaultValue.getPkValue());
                }
                String bigamountgetterway = defaultValue.getString("bigamountgetterway");
                this.setTextVisible(bigamountgetterway);
            }
        }
    }

    private void setTextVisible(String bigamountgetterway) {
        if ("1".equals(bigamountgetterway)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TRADETEXTFIELDDES});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RECTEXTFIELDDES, PAYTEXTFIELDDES});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TRADETEXTFIELDDES});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{RECTEXTFIELDDES, PAYTEXTFIELDDES});
        }
    }
}

