/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.ccr;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.formplugin.anls.home.AbstractDecisionAnlsHomePlugin;

public class FundConcentrateSetEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final Long DEFAULT_FUN_ORG_VIEW_ID = 8L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"applyconditiondesc"});
        BasedataEdit orgview = (BasedataEdit)this.getView().getControl("orgview");
        orgview.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("applyconditiondesc".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            String json = (String)this.getModel().getValue("applycondition_tag", rowIndex);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setCurrentEntity("bd_accountbanks");
            TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            this.showConditionForm(json, mainType.getName(), fldNodes);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("orgview".equals(property)) {
            DataSet ds = TmcOrgDataHelper.getAuthorizedBankOrgViewDataSet((Long)RequestContext.get().getCurrUserId());
            if (!AbstractDecisionAnlsHomePlugin.isEnableDefaultOrgView()) {
                ds = ds.filter("id != " + DEFAULT_FUN_ORG_VIEW_ID);
            }
            HashSet<Long> ids = new HashSet<Long>(16);
            while (ds.hasNext()) {
                ids.add(ds.next().getLong("id"));
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("applyconditiondesc".equals(sourceFldKey)) {
            this.setApplyConditionInfo((String)returnData);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        if ("applyconditiondesc".equals(propName) && EmptyUtil.isEmpty((Object)(value = this.getModel().getValue(propName, rowIndex)))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applycondition_tag", null, (int)rowIndex);
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", "true");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("hiddenexpression", "true");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "applyconditiondesc"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setApplyConditionInfo(String returnData) {
        if (StringUtils.isNotBlank((CharSequence)returnData)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            this.getModel().setValue("applycondition_tag", (Object)returnData, row);
            String desc = condition.getExprDesc();
            if (desc.length() > 50) {
                desc = desc.substring(0, 40) + "......";
            }
            this.getModel().setValue("applyconditiondesc", (Object)desc, row);
        }
    }
}

