/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.designer;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LargeBoardListPlugin
extends AbstractFormPlugin {
    private static final String BTN_VIEW = "viewbtn";
    private static final String BTN_CONFIG = "configbtn";
    private static final String BTN_DESIGN = "designbtn";
    private static final String KEY_TBLREFRESH = "tblrefresh";
    public static final String BTN_ADDNEW = "tblnew";
    public static final String BTN_SAVA = " bar_save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_VIEW, BTN_CONFIG, BTN_DESIGN});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        String proKey;
        Control source = (Control)evt.getSource();
        switch (proKey = source.getKey()) {
            case "viewbtn": {
                boolean viewPermResult = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"tda").getId(), (String)"tda_largeboard", (String)"47150e89000000ac");
                if (!viewPermResult) break;
                this.openSelectedLargeBoardPage("tda_rp_design_show");
                break;
            }
            case "configbtn": {
                boolean configPermResult = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"tda").getId(), (String)"tda_largeboard", (String)"4BAQ9C33V=R+");
                if (!configPermResult) break;
                this.openSelectedLargeBoardPage("tda_largeboard");
                break;
            }
            case "designbtn": {
                boolean designPermResult = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"tda").getId(), (String)"tda_largeboard", (String)"4BAQ9C33V=R+");
                if (!designPermResult) break;
                this.openSelectedLargeBoardPage("tda_report_design");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        boolean addPermResult;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_ADDNEW.equals(key) && (addPermResult = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"tda").getId(), (String)"tda_largeboard", (String)"47156aff000000ac"))) {
            this.openNewDesignPage();
        }
    }

    private void openSelectedLargeBoardPage(String formId) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        if (EmptyUtil.isEmpty((Object)selectedRow)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", selectedRow.getPrimaryKeyValue());
        DynamicObject largeBoard = QueryServiceHelper.queryOne((String)"tda_largeboard", (String)"name,themename,billno,versionidentifier", (QFilter[])new QFilter[]{qFilter});
        FormShowParameter param = new FormShowParameter();
        param.getCustomParams().put("configtag", selectedRow.getBillNo());
        param.setFormId(formId);
        if (formId.equals("tda_largeboard")) {
            StyleCss css = new StyleCss();
            css.setWidth("700");
            css.setHeight("250");
            param.getOpenStyle().setInlineStyleCss(css);
            param.setCustomParam("name", largeBoard.get("name"));
            param.setCustomParam("themename", largeBoard.get("themename"));
            param.setCustomParam("parentbillno", largeBoard.get("billno"));
            param.setCustomParam("versionidentifier", largeBoard.get("versionidentifier"));
            param.setCaption(ResManager.loadKDString((String)"\u5927\u5c4f\u770b\u677f\u6269\u5c55", (String)"TdaParamSettingPlugin_18", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            param.getOpenStyle().setShowType(ShowType.Modal);
        } else {
            if (largeBoard != null) {
                param.setCaption(largeBoard.getString("name"));
            }
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        this.getView().showForm(param);
    }

    private void openNewDesignPage() {
        FormShowParameter param = new FormShowParameter();
        StyleCss css = new StyleCss();
        css.setWidth("700");
        css.setHeight("250");
        param.setFormId("tda_largeboard");
        param.getOpenStyle().setInlineStyleCss(css);
        param.setCaption(ResManager.loadKDString((String)"\u5927\u5c4f\u770b\u677f", (String)"TdaParamSettingPlugin_17", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }
}

