/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.home;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.SnapDataStateEnum;
import kd.tmc.tda.common.helper.TdaParameterHelper;

public class DecisionAnlsFiltersEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnset"});
        this.addItemClickListeners(new String[]{"btnset"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        AbstractOperate op = (AbstractOperate)source;
        if ("save".equalsIgnoreCase(op.getOperateKey())) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("id"))) {
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                String version = SnapDataHelper.createDecisAnlsVersion((DynamicObject)orgView);
                this.getModel().setValue("number", (Object)version);
                this.getModel().setValue("name", (Object)version);
                this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
                this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
                this.getModel().setValue("modifytime", (Object)DateUtils.getCurrentTime());
                this.setReturnVal(SnapDataStateEnum.LOADING.getValue(), version);
            } else {
                this.checkIsGenNewVersion();
                args.setCancel(true);
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("close");
            }
        }
    }

    private void setReturnVal(String state, String version) {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("state", state);
        returnData.put("version", version);
        returnData.put("id", this.getModel().getValue("id"));
        returnData.put("orgview", this.getModel().getValue("orgview"));
        returnData.put("querydate", this.getModel().getValue("querydate"));
        this.getView().returnDataToParent(returnData);
    }

    private void checkIsGenNewVersion() {
        Boolean isUpdate = (Boolean)this.getModel().getValue("isupdate");
        if (isUpdate.booleanValue()) {
            this.generateNewSet();
        } else {
            String[] propertys;
            boolean isModify = false;
            Object id = this.getModel().getValue("id");
            DynamicObject set = TmcDataServiceHelper.loadSingleFromCache((Object)id, (String)"tda_decisanlsversion", (String)SnapDataHelper.getCheckChangeProperty());
            for (String property : propertys = SnapDataHelper.getCheckChangeProperty().split(",")) {
                Object bdVal = set.get(property);
                Object newVal = this.getModel().getValue(property);
                if (SerializationUtils.toJsonString((Object)bdVal).equals(SerializationUtils.toJsonString((Object)newVal))) continue;
                isModify = true;
                break;
            }
            if (isModify) {
                String bdVersion = this.getDBExistSet();
                if (EmptyUtil.isEmpty((String)bdVersion)) {
                    this.generateNewSet();
                }
            } else {
                String version = (String)this.getModel().getValue("number");
                String state = (String)this.getModel().getValue("versionstate");
                this.setReturnVal(state, version);
            }
        }
    }

    private String getDBExistSet() {
        String[] propertys;
        Object id = this.getModel().getValue("id");
        QFilter filter = new QFilter("id", "!=", id);
        for (String property : propertys = SnapDataHelper.getCheckChangeProperty().split(",")) {
            Object val = this.getModel().getValue(property);
            if (val instanceof DynamicObject) {
                filter.and(new QFilter(property, "=", ((DynamicObject)val).getPkValue()));
                continue;
            }
            filter.and(new QFilter(property, "=", val));
        }
        DynamicObject set = TmcDataServiceHelper.loadSingle((String)"tda_decisanlsversion", (String)"number,versionstate,createtime,modifier,modifytime,enable,status", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)set)) {
            return null;
        }
        Long orgId = RequestContext.get().getOrgId();
        int updateTime = TdaParameterHelper.getAppIntParameter((long)orgId, (String)"updatetime");
        int diffTime = DateUtils.getDiffMinute((Date)set.getDate("createtime"), (Date)DateUtils.getCurrentTime());
        if (updateTime > 0 && diffTime > updateTime) {
            set.set("modifier", (Object)RequestContext.get().getCurrUserId());
            set.set("modifytime", (Object)DateUtils.getCurrentTime());
            set.set("versionstate", (Object)SnapDataStateEnum.LOADING.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)"tda_decisanlsversion", (DynamicObject[])new DynamicObject[]{set}, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)set)) {
            String version = set.getString("number");
            String state = set.getString("versionstate");
            this.setReturnVal(state, version);
            return version;
        }
        return null;
    }

    private void generateNewSet() {
        DynamicObject newSet = TmcDataServiceHelper.clone((DynamicObject)this.getModel().getDataEntity());
        newSet.set("versionstate", (Object)"loading");
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        String version = SnapDataHelper.createDecisAnlsVersion((DynamicObject)orgView);
        newSet.set("id", (Object)DBServiceHelper.genGlobalLongId());
        newSet.set("number", (Object)version);
        newSet.set("name", (Object)version);
        newSet.set("creator", (Object)RequestContext.get().getCurrUserId());
        newSet.set("createtime", (Object)DateUtils.getCurrentTime());
        newSet.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newSet.set("modifytime", (Object)DateUtils.getCurrentTime());
        newSet.set("org", (Object)RequestContext.get().getOrgId());
        newSet.set("orgview", orgView.getPkValue());
        TmcOperateServiceHelper.execOperate((String)"save", (String)"tda_decisanlsversion", (DynamicObject[])new DynamicObject[]{newSet}, (OperateOption)OperateOption.create());
        this.setReturnVal(SnapDataStateEnum.LOADING.getValue(), version);
    }
}

