/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.home;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.AccountReceiveAndPayableHelper;
import kd.tmc.tda.common.helper.DraftBillCostDateHelper;
import kd.tmc.tda.common.helper.InvestCostDateHelper;
import kd.tmc.tda.formplugin.anls.home.AbstractDecisionAnlsHomePlugin;

public class DecisionAnlsVisualResHomePlugin
extends AbstractDecisionAnlsHomePlugin {
    private static final int PERIOD_ONEYEAR = 12;
    private static final Log logger = LogFactory.getLog(DecisionAnlsVisualResHomePlugin.class);

    @Override
    protected void initThemesComboItem(Long orgView) {
        Date queryDate = (Date)this.getModel().getValue("querydate");
        this.initReceiveAndPayablebComItem(queryDate, 12, orgView);
        this.initInvestDateItem(true);
        this.initDraftBillDateItem(true);
    }

    protected void initReceiveAndPayablebComItem(Date queryDate, int period, Long orgView) {
        List paymentdays = AccountReceiveAndPayableHelper.getPaymentDays((Date)queryDate, (int)period, (Long)orgView);
        if (EmptyUtil.isEmpty((Collection)paymentdays)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("paymentday");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(paymentdays.size());
        for (String str : paymentdays) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(str));
            comboItem.setValue(str);
            comboItemList.add(comboItem);
        }
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue("paymentday", paymentdays.get(0));
        this.getModel().setValue("custsupptype", (Object)"allside");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        super.propertyChanged(e);
        switch (property = e.getProperty().getName()) {
            case "custsupptype": 
            case "paymentday": 
            case "ensuretype": {
                this.reFresh(false);
                break;
            }
            case "comloanrange": {
                this.reFresh(false);
                break;
            }
            case "customtype": {
                this.typeLinkEvent(property, "customtype", "date", "initInvestDateItem");
                break;
            }
            case "date": {
                this.typeLinkEvent(property, "customtype", "date", "initInvestDateItem");
                break;
            }
            case "termtype": {
                this.typeLinkEvent(property, "termtype", "term", "initDraftBillDateItem");
                break;
            }
            case "term": {
                this.typeLinkEvent(property, "termtype", "term", "initDraftBillDateItem");
                break;
            }
            case "type": {
                Tab mianTab = (Tab)this.getView().getControl("tabap");
                mianTab.activeTab((String)this.getModel().getValue("type"));
                if (!"tda_decisanlsresvisual_bl".equals(this.getView().getFormShowParameter().getFormId())) break;
                this.setLabelTopName();
                break;
            }
        }
    }

    @Override
    protected String getBlueEntityName() {
        return "tda_decisanlsresvisual_bl";
    }

    protected void initInvestDateItem(boolean init) {
        Date queryDate = (Date)this.getModel().getValue("querydate");
        String customType = (String)this.getModel().getValue("customtype");
        if (init && EmptyUtil.isEmpty((String)customType)) {
            customType = "month";
        }
        List dateList = InvestCostDateHelper.getDateFormatByType((Date)queryDate, (String)customType);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("date");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(dateList.size());
        for (String str : dateList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(str));
            comboItem.setValue(str);
            comboItemList.add(comboItem);
        }
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue("customtype", (Object)customType);
        if (init) {
            this.getModel().setValue("date", dateList.get(0));
        }
    }

    protected void initDraftBillDateItem(boolean init) {
        Date queryDate = (Date)this.getModel().getValue("querydate");
        String termType = (String)this.getModel().getValue("termtype");
        if (init && EmptyUtil.isEmpty((String)termType)) {
            termType = "month";
        }
        List dateList = DraftBillCostDateHelper.parseDateIncludeCur((Date)queryDate, (String)termType);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("term");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(dateList.size());
        for (String str : dateList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(str));
            comboItem.setValue(str);
            comboItemList.add(comboItem);
        }
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue("termtype", (Object)termType);
        if (init || "day".equals(termType)) {
            this.getModel().setValue("term", dateList.get(0));
        }
    }
}

