/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.cache;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.CashFundsCommonHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.FinanceCostCommonHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.cash.CashFundsRequest;
import kd.tmc.fbp.common.model.tda.finance.FinCostRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.detail.DataSetFileStorageHelper;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.common.helper.TdaParameterHelper;

public class CacheManager {
    private static final int cacheSize = 2;
    private static final ExecutorService executor = ThreadPools.newExecutorService((String)"tda_cache_preheating_threadpool", (int)2);
    private static final Log logger = LogFactory.getLog(CacheManager.class);
    private static final Set<String> cachesDataSetKey = new ConcurrentHashSet(16);
    private static final Set<String> cachesSnapDataSetKey = new ConcurrentHashSet(16);
    private static final Set<String> cachesOrgViewKey = new ConcurrentHashSet(16);

    public static void putCacheDataSetKey(String key, boolean isSnapExcute) {
        if (isSnapExcute) {
            cachesSnapDataSetKey.add(key);
        } else {
            cachesDataSetKey.add(key);
        }
    }

    public static void putCacheOrgViewKey(String key) {
        cachesOrgViewKey.add(key);
    }

    public static void clearDataSetCache() {
        DataSetCacheManagerHelper.remove((String[])cachesDataSetKey.toArray(new String[0]));
        cachesDataSetKey.clear();
        CacheManager.clearSnapDataSetCache(null);
    }

    public static void clearSnapDataSetCache(String batch) {
        DataSetCacheManagerHelper.remove((String[])cachesSnapDataSetKey.toArray(new String[0]));
        cachesSnapDataSetKey.clear();
    }

    public static void clearOrgViewCache() {
        IAppCache cache = AppCache.get((String)TmcAppEnum.TMC.getValue());
        for (String tempKey : cachesOrgViewKey) {
            cache.remove(tempKey);
            logger.info("\u7ec4\u7ec7\u7f13\u5b58\u6e05\u7406\u6210\u529f\uff1a" + tempKey);
        }
        cachesOrgViewKey.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet getCacheOrElseGet(Long orgViewId, String algoKey, String cacheKey, Supplier<? extends DataSet> helper) {
        boolean isUseCache = SysParamHelper.getQueryCacheFlag();
        boolean isSnapExcute = ThreadCache.exists((Object)"isSnapExcute") && Boolean.parseBoolean((String)ThreadCache.get((Object)"isSnapExcute"));
        logger.info("\u53d6\u6570\u7f13\u5b58\u67e5\u8be2:algokey:" + algoKey + "cachekey:" + cacheKey + "issnapexcute" + isSnapExcute + DateUtils.formatString((Date)DateUtils.getCurrentDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (!isUseCache) {
            CacheManager.tmcLogInfo(1, isSnapExcute, new String[0]);
            logger.info("\u53d6\u6570\u7f13\u5b58\u53c2\u6570\u672a\u5f00\u542f\uff0c\u6267\u884c\u5b9e\u65f6\u67e5\u8be2:" + RequestContext.get().getOrgId());
            DataSet ds = helper.get();
            if (isSnapExcute) {
                new DataSetFileStorageHelper().dataSetToFile(ds, cacheKey, DateUtils.truncateDate((Date)new Date()), algoKey);
                CacheManager.tmcLogInfo(1, isSnapExcute, cacheKey, String.format(ResManager.loadKDString((String)"; \u5b58\u50a8\u660e\u7ec6\u5feb\u7167; %s", (String)"CacheManager_11", (String)"tmc-tda-common", (Object[])new Object[0]), cacheKey));
            } else {
                CacheManager.tmcLogInfo(1, isSnapExcute, cacheKey);
            }
            return ds;
        }
        int cachetimeout = SysParamHelper.getSysParamValue("querydatacachetime", Integer.class);
        int cacheTimeOutResult = cachetimeout * 60;
        Pair<Boolean, DataSet> firstCacheResult = CacheManager.getFromCacheData(algoKey, cacheKey);
        if (((Boolean)firstCacheResult.getValue0()).booleanValue()) {
            CacheManager.putCacheDataSetKey(cacheKey, isSnapExcute);
            CacheManager.tmcLogInfo(4, isSnapExcute, cacheKey);
            logger.info("\u76f4\u63a5\u4ece\u7f13\u5b58\u83b7\u53d6DataSet\u6210\u529f cache key :" + cacheKey + "  algoKey:" + algoKey);
            return (DataSet)firstCacheResult.getValue1();
        }
        logger.info("\u76f4\u63a5\u4ece\u7f13\u5b58\u83b7\u53d6DataSet\u5931\u8d25 cache key :" + cacheKey + "  algoKey:" + algoKey);
        DLock dLock = DLock.create((String)cacheKey);
        if (dLock.tryLock(10000L)) {
            try {
                logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f cache key :" + cacheKey + "  algoKey:" + algoKey);
                Pair<Boolean, DataSet> secondCacheResult = CacheManager.getFromCacheData(algoKey, cacheKey);
                if (((Boolean)secondCacheResult.getValue0()).booleanValue()) {
                    CacheManager.putCacheDataSetKey(cacheKey, isSnapExcute);
                    CacheManager.tmcLogInfo(4, isSnapExcute, cacheKey);
                    logger.info("\u4e8c\u6b21\u4ece\u7f13\u5b58\u83b7\u53d6DataSet\u6210\u529f cache key :" + cacheKey + "  algoKey:" + algoKey);
                    DataSet dataSet = (DataSet)secondCacheResult.getValue1();
                    return dataSet;
                }
                logger.info("\u4e8c\u6b21\u4ece\u7f13\u5b58\u83b7\u53d6DataSet\u5931\u8d25 cache key :" + cacheKey + "  algoKey:" + algoKey);
                CacheManager.tmcLogInfo(2, isSnapExcute, cacheKey);
                DataSet dataSet = CacheManager.getRealResultAndCache(orgViewId, algoKey, cacheKey, new Date(), helper, isSnapExcute, cacheTimeOutResult);
                return dataSet;
            }
            finally {
                dLock.unlock();
            }
        }
        logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 cache key :" + cacheKey + "  algoKey:" + algoKey);
        Pair<Boolean, DataSet> thirdCacheResult = CacheManager.getFromCacheData(algoKey, cacheKey);
        if (((Boolean)thirdCacheResult.getValue0()).booleanValue()) {
            CacheManager.putCacheDataSetKey(cacheKey, isSnapExcute);
            logger.info("\u4e09\u6b21\u4ece\u7f13\u5b58\u83b7\u53d6DataSet\u6210\u529f cache key :" + cacheKey + "  algoKey:" + algoKey);
            CacheManager.tmcLogInfo(4, isSnapExcute, cacheKey);
            return (DataSet)thirdCacheResult.getValue1();
        }
        logger.info("\u4e09\u6b21\u4ece\u7f13\u5b58\u83b7\u53d6DataSet\u5931\u8d25 cache key :" + cacheKey + "  algoKey:" + algoKey);
        CacheManager.tmcLogInfo(3, isSnapExcute, cacheKey);
        return CacheManager.getRealResultAndCache(orgViewId, algoKey, cacheKey, new Date(), helper, isSnapExcute, cacheTimeOutResult);
    }

    private static DataSet getRealResultAndCache(Long orgViewId, String algoKey, String cacheKey, Date queryDate, Supplier<? extends DataSet> helper, boolean isSnapExcute, int cacheTimeOutResult) {
        logger.info("getRealResultAndCache\uff1a cache key :" + cacheKey + "  queryDate:" + queryDate + "algoKey:" + algoKey + "time :" + DateUtils.formatString((Date)DateUtils.getCurrentDate(), (String)"yyyy-MM-dd HH:mm:ss") + System.currentTimeMillis());
        DataSet ds = null;
        DataSetFileStorageHelper storageService = new DataSetFileStorageHelper();
        if (!isSnapExcute && (ds = storageService.dataSetFromFile(orgViewId, cacheKey, DateUtils.truncateDate((Date)queryDate))) != null) {
            CacheManager.tmcLogInfo(5, isSnapExcute, cacheKey);
        }
        if (ds == null) {
            logger.info("\u6587\u4ef6\u5b58\u50a8\u53d6\u6570\u7ed3\u679c\u4e3anull\uff1a cache key :" + cacheKey + "  queryDate:" + queryDate + "algoKey:" + algoKey);
            ds = helper.get();
            if (isSnapExcute) {
                logger.info("\u5feb\u7167\u8c03\u5ea6\u6267\u884c\u660e\u7ec6\u5b58\u50a8\uff1a cache key :" + cacheKey + "  queryDate:" + queryDate + "algoKey:" + algoKey);
                storageService.dataSetToFile(ds, cacheKey, DateUtils.truncateDate((Date)queryDate), algoKey);
                CacheManager.tmcLogInfo(1, isSnapExcute, cacheKey, String.format(ResManager.loadKDString((String)"; \u5b58\u50a8\u660e\u7ec6\u5feb\u7167; %s", (String)"CacheManager_11", (String)"tmc-tda-common", (Object[])new Object[0]), cacheKey));
            } else {
                CacheManager.tmcLogInfo(1, isSnapExcute, cacheKey);
            }
            logger.info("\u5feb\u7167\u8c03\u5ea6\u6267\u884c\u660e\u7ec6\u5b58\u50a8\u7ed3\u675f\uff1a cache key :" + cacheKey + "  queryDate:" + queryDate);
        }
        if (ds == null) {
            logger.info("\u5b9e\u65f6\u53d6\u6570\u7ed3\u679c\u4e3anull\uff1a cache key :" + cacheKey + "  algoKey:" + algoKey);
            return null;
        }
        try {
            DataSetCacheManagerHelper.putDataSetToCache((String)cacheKey, (DataSet)ds.copy(), (int)cacheTimeOutResult);
            CacheManager.putCacheDataSetKey(cacheKey, isSnapExcute);
        }
        catch (IOException e) {
            logger.info("\u5b9e\u65f6\u53d6\u6570\u7ed3\u679c\u4e0d\u4e3anull\uff0c\u8c03\u7528\u7f13\u5b58\u65f6\u62a5\u9519\uff1a cache key :" + cacheKey + "  algoKey:" + algoKey + e.getMessage(), (Object)e);
        }
        return ds;
    }

    public static Pair<Boolean, DataSet> getFromCacheData(String algoKey, String cacheKey) {
        try {
            DataSet cacheDs = DataSetCacheManagerHelper.getDataSetFromCache((String)algoKey, (String)cacheKey);
            if (cacheDs == null) {
                return new Pair((Object)Boolean.FALSE, null);
            }
            return new Pair((Object)Boolean.TRUE, (Object)cacheDs);
        }
        catch (Exception e) {
            logger.info("\u7f13\u5b58\u53d6\u6570\u5931\u8d25\uff1acache key:" + cacheKey + "algo key:" + algoKey + ":" + e.getMessage(), (Object)e);
            return new Pair((Object)Boolean.FALSE, null);
        }
    }

    private static void tmcLogInfo(int i, boolean isSnapExcute, String ... param) {
        switch (i) {
            case 1: {
                if (!isSnapExcute) break;
                ThreadCache.put((Object)"tdalogdesc", (Object)String.format(ResManager.loadKDString((String)"\u5feb\u7167\u8c03\u5ea6\uff1a\u7edf\u4e00\u63a5\u53e3\u53d6\u6570\u5b9e\u65f6\u53d6\u6570\uff08\u53c2\u6570\u672a\u5f00\u542f\uff09\uff1a%s", (String)"CacheManager_1", (String)"tmc-tda-common", (Object[])new Object[0]), RequestContext.get().getOrgId()));
                break;
            }
            case 2: {
                if (isSnapExcute) {
                    ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u5feb\u7167\u8c03\u5ea6\uff1a\u7edf\u4e00\u63a5\u53e3\u53d6\u6570\u5b9e\u65f6\u53d6\u6570", (String)"CacheManager_3", (String)"tmc-tda-common", (Object[])new Object[0]));
                    break;
                }
                ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u7edf\u4e00\u63a5\u53e3\u53d6\u6570\u5b9e\u65f6\u53d6\u6570", (String)"CacheManager_4", (String)"tmc-tda-common", (Object[])new Object[0]));
                break;
            }
            case 3: {
                if (isSnapExcute) {
                    ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u5feb\u7167\u8c03\u5ea6\uff1a\u7edf\u4e00\u63a5\u53e3\u53d6\u6570\u5b9e\u65f6\u53d6\u6570\uff08\u672a\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff09", (String)"CacheManager_5", (String)"tmc-tda-common", (Object[])new Object[0]));
                    break;
                }
                ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u7edf\u4e00\u63a5\u53e3\u53d6\u6570\u5b9e\u65f6\u53d6\u6570\uff08\u672a\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff09", (String)"CacheManager_6", (String)"tmc-tda-common", (Object[])new Object[0]));
                break;
            }
            case 4: {
                if (isSnapExcute) {
                    ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u5feb\u7167\u8c03\u5ea6\uff1a\u7edf\u4e00\u63a5\u53e3\u53d6\u6570\u7f13\u5b58\u53d6\u6570", (String)"CacheManager_7", (String)"tmc-tda-common", (Object[])new Object[0]));
                    break;
                }
                ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u7edf\u4e00\u63a5\u53e3\u53d6\u6570\u7f13\u5b58\u53d6\u6570", (String)"CacheManager_8", (String)"tmc-tda-common", (Object[])new Object[0]));
                break;
            }
            case 5: {
                if (isSnapExcute) {
                    ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u5feb\u7167\u8c03\u5ea6\uff1a\u7edf\u4e00\u63a5\u53e3\u660e\u7ec6\u5feb\u7167\u53d6\u6570", (String)"CacheManager_10", (String)"tmc-tda-common", (Object[])new Object[0]));
                    break;
                }
                ThreadCache.put((Object)"tdalogdesc", (Object)ResManager.loadKDString((String)"\u7edf\u4e00\u63a5\u53e3\u660e\u7ec6\u5feb\u7167\u53d6\u6570", (String)"CacheManager_9", (String)"tmc-tda-common", (Object[])new Object[0]));
                break;
            }
        }
        if (param.length > 0) {
            ThreadCache.put((Object)"tdalogdesc", (Object)(ThreadCache.get((Object)"tdalogdesc") + "; " + param[0]));
        }
    }

    public static void cachePreHeating(Long orgViewId, Date queryDate) {
        List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
        Long baseCurrency = AmountTransHelper.getBaseCurrency((Long)orgViewId);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
        boolean containSettle = TdaParameterHelper.getFinSettleFinFlag();
        if (!isQueryDataCache) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(2);
        try {
            executor.submit(() -> {
                ThreadCache.put((Object)"orgViewId", (Object)orgViewId);
                ThreadCache.put((Object)"isSnapExcute", (Object)"true");
                try {
                    List<Object[]> queryDateList = FinanceCostDateHelper.getAllQueryDateList(FinanceCostDateHelper.getNewDate(queryDate));
                    CacheManager.getCacheOrElseGet(orgViewId, "FinanceCostDataHelper_cachepreheating", FinanceCostDataHelper.getCacheKey(orgViewId, queryDate), () -> FinanceCostCommonHelper.getAllViewData((FinCostRequest)new FinCostRequest("FinanceCostDataHelper_cachepreheating", queryDate, baseCurrency, orgViewId, queryDateList, FinanceCostCommonHelper.getQFilter((List)allViewOrgs, (Date)((Date)((Object[])queryDateList.get(0))[0]), (Date)((Date)((Object[])queryDateList.get(queryDateList.size() - 1))[1]), (boolean)containCompany, (boolean)containSettle))));
                    CacheManager.getCacheOrElseGet(orgViewId, "FinanceDataHelper_cachepreheating", FinanceDataHelper.getCacheKey(orgViewId, queryDate), () -> FinanceDataHelper.getAllViewData("FinanceDataHelper_cachepreheating", queryDate, baseCurrency, orgViewId, allViewOrgs));
                    for (int i = 1; i < 12; ++i) {
                        Date tempDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)(-i));
                        CacheManager.getCacheOrElseGet(orgViewId, "FinanceDataHelper_cachepreheating", FinanceDataHelper.getCacheKey(orgViewId, tempDate), () -> FinanceDataHelper.getAllViewData("FinanceDataHelper_cachepreheating", tempDate, baseCurrency, orgViewId, allViewOrgs));
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage(), (Object)e);
                }
                finally {
                    latch.countDown();
                }
            });
            executor.submit(() -> {
                ThreadCache.put((Object)"orgViewId", (Object)orgViewId);
                ThreadCache.put((Object)"isSnapExcute", (Object)"true");
                try {
                    CacheManager.getCacheOrElseGet(orgViewId, "CashFundsDataHelper_cachepreheating", CashFundsDataHelper.getCacheKey(orgViewId, queryDate, false), () -> CashFundsCommonHelper.getFundDatas((CashFundsRequest)new CashFundsRequest("CashFundsDataHelper_cachepreheating", allViewOrgs, Boolean.valueOf(false), queryDate, baseCurrency, orgViewId)));
                }
                catch (Exception e) {
                    logger.info(e.getMessage(), (Object)e);
                }
                finally {
                    latch.countDown();
                }
            });
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("\u7f13\u5b58\u9884\u70ed\u6267\u884c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }
}

