/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum DateRangeEnum {
    YEAR(0, 5, "year", new MultiLangEnumBridge("\u5e74", "DateRangeEnum_0", "tmc-tda-common"), "Y", 0),
    HALF_YEAR(6, 17, "half", new MultiLangEnumBridge("\u534a\u5e74", "DateRangeEnum_1", "tmc-tda-common"), "H", 1),
    SEASON(18, 29, "season", new MultiLangEnumBridge("\u5b63", "DateRangeEnum_2", "tmc-tda-common"), "Q", 2),
    MONTH(30, 41, "month", new MultiLangEnumBridge("\u6708", "DateRangeEnum_3", "tmc-tda-common"), "M", 3),
    UNKNOWN(-1, -1, "unknown", new MultiLangEnumBridge("\u672a\u77e5", "DateRangeEnum_4", "tmc-tda-common"), "U", -1),
    ALL(0, 41, "all", new MultiLangEnumBridge("\u5168\u90e8", "DateRangeEnum_5", "tmc-tda-common"), "A", 4);

    private Integer start;
    private Integer end;
    private String value;
    private MultiLangEnumBridge text;
    private String shortName;
    private Integer index;

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public String getValue() {
        return this.value;
    }

    public String getText() {
        return this.text.loadKDString();
    }

    public String getShortName() {
        return this.shortName;
    }

    public Integer getIndex() {
        return this.index;
    }

    private DateRangeEnum(Integer start, Integer end, String value, MultiLangEnumBridge text, String shortName, Integer index) {
        this.start = start;
        this.end = end;
        this.value = value;
        this.text = text;
        this.shortName = shortName;
        this.index = index;
    }

    public static DateRangeEnum getEnumByValue(String value) {
        return Arrays.stream(DateRangeEnum.values()).filter(dateRangeEnum -> dateRangeEnum.getValue().equals(value)).findFirst().orElse(UNKNOWN);
    }

    public static DateRangeEnum getEnumByIndex(Integer index) {
        return Arrays.stream(DateRangeEnum.values()).filter(dateRangeEnum -> dateRangeEnum.getIndex().equals(index)).findFirst().orElse(UNKNOWN);
    }

    public static String[] valueMapItemList() {
        DateRangeEnum[] dateRangeEnums = DateRangeEnum.values();
        String[] array = new String[dateRangeEnums.length * 2];
        int i = 0;
        for (DateRangeEnum dateRangeEnum : dateRangeEnums) {
            array[i] = dateRangeEnum.getValue();
            array[i + 1] = dateRangeEnum.getText();
            i += 2;
        }
        return array;
    }

    public static List<DateRangeEnum> getCommonEnums() {
        return Arrays.stream(DateRangeEnum.values()).filter(dateRangeEnum -> dateRangeEnum != UNKNOWN && dateRangeEnum != ALL).collect(Collectors.toList());
    }
}

