/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.enums;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum FinanceCostTermEnum {
    WITHIN_SIX_MONTHS(1, Pattern.compile("(^([1-5]m)?([0-9]{1,2}d))|(^[1-6]m$)"), new MultiLangEnumBridge("6\u4e2a\u6708\u4ee5\u5185", "FinanceCostTermEnum_1", "tmc-tda-common")),
    SIX_MONTH_TO_ONEYERA(2, Pattern.compile("(^(1[0-1]|[6-9])m[0-9]{1,2}d)|^(1[0-2]|[7-9])m$|1y$"), new MultiLangEnumBridge("6\u4e2a\u6708-1\u5e74", "FinanceCostTermEnum_2", "tmc-tda-common")),
    ONEYEAR_TO_THREE(3, Pattern.compile("(^([1-2]y)((1[0-2]|[1-9])m)?([0-9]{1,2}d)?)|3y$"), new MultiLangEnumBridge("1-3\u5e74", "FinanceCostTermEnum_7", "tmc-tda-common")),
    THREE_TO_FIVEYEAR(4, Pattern.compile("(^([3-4]y)((1[0-2]|[1-9])m)?([0-9]{1,2}d)?)|5y$"), new MultiLangEnumBridge("3-5\u5e74", "FinanceCostTermEnum_8", "tmc-tda-common")),
    FIVEYEAR_TO_TENYEAR(5, Pattern.compile("(^([5-9]y)((1[0-2]|[1-9])m)?([0-9]{1,2}d)?)|10y$"), new MultiLangEnumBridge("5-10\u5e74", "FinanceCostTermEnum_4", "tmc-tda-common")),
    MORE_THEN_TENYEARS(6, Pattern.compile("^(1[0-9]|[2-9][0-9]+)y((1[0-2]|[1-9])m)?([0-9]{1,2}d)?"), new MultiLangEnumBridge("10\u5e74\u4ee5\u4e0a", "FinanceCostTermEnum_5", "tmc-tda-common")),
    UNKNOWN(0, Pattern.compile("^"), new MultiLangEnumBridge("\u672a\u77e5", "FinanceCostTermEnum_0", "tmc-tda-common"));

    private Integer index;
    private Pattern rangeExp;
    private MultiLangEnumBridge text;

    public Integer getIndex() {
        return this.index;
    }

    public Pattern getRangeExp() {
        return this.rangeExp;
    }

    public MultiLangEnumBridge getText() {
        return this.text;
    }

    private FinanceCostTermEnum(Integer index, Pattern rangeExp, MultiLangEnumBridge text) {
        this.index = index;
        this.rangeExp = rangeExp;
        this.text = text;
    }

    public static FinanceCostTermEnum getEnumByIndex(Integer index) {
        return Arrays.stream(FinanceCostTermEnum.values()).filter(financeCostTermEnum -> financeCostTermEnum.getIndex().equals(index)).findFirst().orElse(UNKNOWN);
    }

    public static boolean isMatch(String termStr) {
        return UNKNOWN != FinanceCostTermEnum.matchExp(termStr);
    }

    public static FinanceCostTermEnum matchExp(String termStr) {
        return Arrays.stream(FinanceCostTermEnum.values()).filter(financeCostTermEnum -> {
            Pattern compile = financeCostTermEnum.rangeExp;
            Matcher matcher = compile.matcher(termStr);
            return matcher.matches();
        }).findFirst().orElse(UNKNOWN);
    }
}

