/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.enums;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum GuaranteeTermEnum {
    IN_ONEYEAR(1, "inoneyear", Pattern.compile("(^((1[0-1]|[1-9])m)?([0-9]{1,2}d))|(^(1[0-1]|[1-9])m$|1y$)"), new MultiLangEnumBridge("1\u5e74\u4ee5\u5185", "GuaranteeTermEnum_1", "tmc-tda-common")),
    ONEYEAR_TO_THREEEYEAR(2, "onetothreeyear", Pattern.compile("(^([1-2]y)((1[0-2]|[1-9])m)?([0-9]{1,2}d)?)|3y$"), new MultiLangEnumBridge("1\u5e74-3\u5e74", "GuaranteeTermEnum_2", "tmc-tda-common")),
    THREEEYEAR_TO_FIVEYEAR(3, "threetofiveyear", Pattern.compile("(^([3-4]y)((1[0-2]|[1-9])m)?([0-9]{1,2}d)?)|5y$"), new MultiLangEnumBridge("3\u5e74-5\u5e74", "GuaranteeTermEnum_3", "tmc-tda-common")),
    MORE_THEN_FIVEYEAR(4, "overfiveyear", Pattern.compile("^([5-9]|[1-9][0-9]+)y((1[0-2]|[1-9])m)?([0-9]{1,2}d)?"), new MultiLangEnumBridge("5\u5e74\u4ee5\u4e0a", "GuaranteeTermEnum_4", "tmc-tda-common")),
    UNKNOWN(0, "unknow", Pattern.compile("^"), new MultiLangEnumBridge("\u672a\u77e5", "GuaranteeTermEnum_0", "tmc-tda-common"));

    private Integer index;
    private String number;
    private Pattern rangeExp;
    private MultiLangEnumBridge text;

    public Integer getIndex() {
        return this.index;
    }

    public MultiLangEnumBridge getText() {
        return this.text;
    }

    public String getNumber() {
        return this.number;
    }

    private GuaranteeTermEnum(Integer index, String number, Pattern rangeExp, MultiLangEnumBridge text) {
        this.index = index;
        this.number = number;
        this.rangeExp = rangeExp;
        this.text = text;
    }

    public static GuaranteeTermEnum getEnumByIndex(Integer index) {
        return Arrays.stream(GuaranteeTermEnum.values()).filter(financeCostTermEnum -> financeCostTermEnum.getIndex().equals(index)).findFirst().orElse(UNKNOWN);
    }

    public static boolean isMatch(String termStr) {
        return UNKNOWN != GuaranteeTermEnum.matchExp(termStr);
    }

    public static GuaranteeTermEnum matchExp(String termStr) {
        return Arrays.stream(GuaranteeTermEnum.values()).filter(guaranteeTermEnum -> {
            Pattern compile = guaranteeTermEnum.rangeExp;
            Matcher matcher = compile.matcher(termStr);
            return matcher.matches();
        }).findFirst().orElse(UNKNOWN);
    }
}

