/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.enums;

import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import kd.tmc.fbp.common.util.EmptyUtil;

public enum InvestTermEnum {
    WITHIN_ONE_MONTH(new MultiLangEnumBridge("1\u4e2a\u6708\u4ee5\u5185", "InvestTermEnum_0", "tmc-tda-common"), "1"),
    ONE_TWO_MONTH(new MultiLangEnumBridge("1\u4e2a\u6708-2\u4e2a\u6708", "InvestTermEnum_1", "tmc-tda-common"), "2"),
    TWO_THREE_MONTH(new MultiLangEnumBridge("2\u4e2a\u6708-3\u4e2a\u6708", "InvestTermEnum_2", "tmc-tda-common"), "3"),
    THREE_SIX_MONTH(new MultiLangEnumBridge("3\u4e2a\u6708-6\u4e2a\u6708", "InvestTermEnum_3", "tmc-tda-common"), "4"),
    SIX_MONTH_ONE_YEAR(new MultiLangEnumBridge("6\u4e2a\u6708-1\u5e74", "InvestTermEnum_4", "tmc-tda-common"), "5"),
    MORE_THEN_ONE_YEAR(new MultiLangEnumBridge("1\u5e74\u4ee5\u4e0a", "InvestTermEnum_5", "tmc-tda-common"), "6"),
    DATELESS(new MultiLangEnumBridge("\u65e0\u56fa\u5b9a\u671f\u9650", "InvestTermEnum_6", "tmc-tda-common"), "7");

    private final MultiLangEnumBridge text;
    private final String number;

    private InvestTermEnum(MultiLangEnumBridge text, String number) {
        this.text = text;
        this.number = number;
    }

    public static InvestTermEnum getInvestTermEnum(String term) {
        InvestTermEnum termEnum;
        if (EmptyUtil.isEmpty((String)term)) {
            return DATELESS;
        }
        if ("-1d".equals(term)) {
            return null;
        }
        int yearIndex = term.indexOf("y");
        if (yearIndex > 0) {
            if ("1y".equals(term)) {
                return SIX_MONTH_ONE_YEAR;
            }
            return MORE_THEN_ONE_YEAR;
        }
        int monthIndex = term.indexOf("m");
        if (monthIndex <= 0) {
            return WITHIN_ONE_MONTH;
        }
        int month = Integer.parseInt(term.substring(0, monthIndex));
        boolean isContainDay = term.contains("d");
        if (month == 1) {
            termEnum = WITHIN_ONE_MONTH;
            if (isContainDay) {
                termEnum = ONE_TWO_MONTH;
            }
        } else if (month == 2) {
            termEnum = ONE_TWO_MONTH;
            if (isContainDay) {
                termEnum = TWO_THREE_MONTH;
            }
        } else if (month == 3) {
            termEnum = TWO_THREE_MONTH;
            if (isContainDay) {
                termEnum = THREE_SIX_MONTH;
            }
        } else if (month > 3 && month <= 6) {
            termEnum = THREE_SIX_MONTH;
            if (month == 6 && isContainDay) {
                termEnum = SIX_MONTH_ONE_YEAR;
            }
        } else {
            termEnum = SIX_MONTH_ONE_YEAR;
        }
        return termEnum;
    }

    public String getText() {
        return this.text.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }
}

