/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class AccountReceiveAndPayableHelper {
    private static final List<String> BILL_TYPE_LIST = Arrays.asList("ar_finarbill", "cas_paybill", "ap_finapbill", "cas_recbill");

    public static List<String> getPaymentDays(Date queryDate, int period, Long orgView) {
        ArrayList<String> paymentDays = new ArrayList<String>(12);
        for (int i = period; i > 0; --i) {
            Date lastMonth = DateUtils.getLastMonth((Date)queryDate, (int)i);
            String yearMonth = DateUtils.formatString((Date)lastMonth, (String)"yyyy-MM");
            paymentDays.add(yearMonth);
        }
        QFilter qFilter = new QFilter("paymentday", "in", paymentDays);
        qFilter.and("billtype", "in", BILL_TYPE_LIST);
        List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgView);
        qFilter.and("org.id", "in", (Object)allViewOrgs);
        DataSet allDs = QueryServiceHelper.queryDataSet((String)("tda-decisanls-algo-" + AccountReceiveAndPayableHelper.class + ".queryArapSummaryData"), (String)"tda_arap_sumbill", (String)"paymentday", (QFilter[])qFilter.toArray(), null);
        allDs = allDs.groupBy(new String[]{"paymentday"}).finish().orderBy(new String[]{"paymentday desc"});
        ArrayList<String> resultList = new ArrayList<String>(12);
        while (allDs.hasNext()) {
            Row row = allDs.next();
            String paymentDay = row.getString("paymentday");
            resultList.add(paymentDay);
        }
        return resultList;
    }

    public static DataSet getAfterFilterDataSet(DataSet dataSet, String custsupptype, String paymentday, int period, Map<String, Object> paramMap) {
        if (dataSet.isEmpty()) {
            RowMeta rowMeta = new RowMeta(dataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getDataTypes());
            return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        }
        if (StringUtil.isEmpty((String)custsupptype)) {
            custsupptype = "allside";
        }
        Date queryDate = AmountTransHelper.getQueryDate(paramMap);
        if (StringUtil.isEmpty((String)paymentday)) {
            Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
            List<String> paymentdayList = AccountReceiveAndPayableHelper.getPaymentDays(queryDate, period, orgViewId);
            if (CollectionUtils.isEmpty(paymentdayList)) {
                return dataSet;
            }
            paymentday = paymentdayList.get(0);
        }
        String params = custsupptype + "_" + paymentday;
        paramMap.put("params", params);
        dataSet = dataSet.filter("param = params", paramMap);
        return dataSet;
    }
}

