/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.sql.Timestamp;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BatchTaskStatusSynHelper {
    private static final Log logger = LogFactory.getLog(BatchTaskStatusSynHelper.class);

    public static void initTaskStatus(String taskNum, Date beginTime, int batchSize) {
        try {
            DynamicObject taskStatus = BusinessDataServiceHelper.newDynamicObject((String)"tda_batchtaskstatus");
            taskStatus.set("number", (Object)taskNum);
            taskStatus.set("name", (Object)taskNum);
            taskStatus.set("status", (Object)"A");
            taskStatus.set("type", (Object)"fincost");
            taskStatus.set("begintime", (Object)beginTime);
            taskStatus.set("totalnum", (Object)batchSize);
            taskStatus.set("finishnum", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskStatus});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void singleBatchFinish(String taskNum, Date thisBatchBeginTime) {
        try {
            DLock lock = DLock.create((String)taskNum);
            lock.lock();
            try {
                DynamicObject taskStatus = BusinessDataServiceHelper.loadSingle((String)"tda_batchtaskstatus", (String)"id,status,totalnum,finishnum,endtime,entryentity.ebegintime,entryentity.eendtime", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taskNum)});
                if (EmptyUtil.isNoEmpty((DynamicObject)taskStatus)) {
                    int totalNum = taskStatus.getInt("totalnum");
                    int finishNum = taskStatus.getInt("finishnum");
                    taskStatus.set("finishnum", (Object)(finishNum + 1));
                    Timestamp thisBatchEndTime = DateUtils.getCurrentTime();
                    if (totalNum == finishNum + 1) {
                        taskStatus.set("endtime", (Object)DateUtils.getCurrentTime());
                        taskStatus.set("status", (Object)"C");
                    }
                    if (totalNum < finishNum + 1) {
                        return;
                    }
                    DynamicObjectCollection entity = taskStatus.getDynamicObjectCollection("entryentity");
                    DynamicObject newEntityRow = (DynamicObject)entity.getDynamicObjectType().createInstance();
                    newEntityRow.set("ebegintime", (Object)thisBatchBeginTime);
                    newEntityRow.set("eendtime", (Object)thisBatchEndTime);
                    entity.add((Object)newEntityRow);
                    taskStatus.set("entryentity", (Object)entity);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskStatus});
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

