/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.CashFundsCommonHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.cash.CashFundsRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import org.apache.commons.lang.StringUtils;

public class CashFundsDataHelper {
    private static final Log logger = LogFactory.getLog(CashFundsDataHelper.class);

    public static DataSet getFundDataSet(String algoKey, List<Long> orgIds, Date queryDate, Map<String, Object> paramMap, boolean includeLastYear, boolean usePositionAccSet) {
        boolean isSettlementCenter;
        long start = System.currentTimeMillis();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        String orgRootId = TmcOrgDataHelper.getOrgRootId((Long)orgViewId);
        Long rootId = orgRootId == null ? 0L : Long.parseLong(orgRootId);
        List allOrgIds = TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgViewId, Collections.singletonList(rootId), (boolean)true, (boolean)true);
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        String cachekey = CashFundsDataHelper.getCacheKey(orgViewId, queryDate, includeLastYear);
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cachekey);
        List allIds = isQueryCache && !isNoCache ? allOrgIds : orgIds;
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        ThreadCache.put((Object)"orgViewId", (Object)orgViewId.toString());
        DataSet allDs = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cachekey, () -> CashFundsCommonHelper.getFundDatas((CashFundsRequest)new CashFundsRequest(algoKey, allIds, Boolean.valueOf(includeLastYear), queryDate, baseCurrency, orgViewId)));
        if (isQueryCache && !isNoCache) {
            allDs = allDs.filter("company in ids", Collections.singletonMap("ids", orgIds));
        }
        if (usePositionAccSet) {
            allDs = BasicParamHelper.excludePositionFilter(allDs, orgIds);
        }
        if (!(isSettlementCenter = BasicParamHelper.getAppBooleamParameter("tda_acct_queryparamset", "issettlementcenter"))) {
            allDs = allDs.filter("finorgtype != '1'");
        }
        allDs = BasicParamHelper.includeOverseasFunds(allDs, orgIds);
        if (usePositionAccSet && CollectionUtils.isNotEmpty((Collection)orgIds)) {
            StringBuilder offSetSb = new StringBuilder("case when finorgtype = '3' and businessunit in (");
            if (isSettlementCenter) {
                offSetSb = new StringBuilder("case when (finorgtype = '3' or finorgtype = '1')  and businessunit in (");
            }
            offSetSb.append(StringUtils.join((Collection)orgIds, (String)",")).append(") then '1' else '0' end ");
            allDs = allDs.updateField("isoffset", offSetSb.toString());
        }
        logger.info("CashFundsDataHelper.getFundDataSet\u53d6\u6570\u8017\u65f6" + algoKey + "cost : " + (System.currentTimeMillis() - start));
        return allDs;
    }

    public static DataSet getTrendFundDataSet(String algoKey, List<Long> orgIds, Date queryDate, Map<String, Object> paramMap, boolean includeLastYear, boolean usePositionAccSet) {
        boolean isSettlementCenter;
        long start = System.currentTimeMillis();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet allDs = CashFundsCommonHelper.getTrendFundDatas((CashFundsRequest)new CashFundsRequest(algoKey, orgIds, Boolean.valueOf(includeLastYear), queryDate, baseCurrency, orgViewId));
        if (usePositionAccSet) {
            allDs = BasicParamHelper.excludePositionFilter(allDs, orgIds);
        }
        if (!(isSettlementCenter = BasicParamHelper.getAppBooleamParameter("tda_acct_queryparamset", "issettlementcenter"))) {
            allDs = allDs.filter("finorgtype != '1'");
        }
        if (usePositionAccSet && CollectionUtils.isNotEmpty(orgIds)) {
            StringBuilder offSetSb = new StringBuilder("case when finorgtype = '3' and businessunit in (");
            if (isSettlementCenter) {
                offSetSb = new StringBuilder("case when (finorgtype = '3' or finorgtype = '1')  and businessunit in (");
            }
            offSetSb.append(StringUtils.join(orgIds, (String)",")).append(") then '1' else '0' end ");
            allDs = allDs.updateField("isoffset", offSetSb.toString());
        }
        logger.info("CashFundsDataHelper.getFundDataSet\u53d6\u6570\u8017\u65f6" + algoKey + "cost : " + (System.currentTimeMillis() - start));
        return allDs;
    }

    public static DataSet getFundConcentrateDs(DataSet allDs, List<Long> orgIds) {
        allDs = BasicParamHelper.excludePositionFilter(allDs, orgIds);
        boolean isSettlementCenter = BasicParamHelper.getAppBooleamParameter("tda_acct_queryparamset", "issettlementcenter");
        if (CollectionUtils.isNotEmpty(orgIds)) {
            StringBuilder offSetSb = new StringBuilder("case when finorgtype = '3' and businessunit in (");
            if (isSettlementCenter) {
                offSetSb = new StringBuilder("case when (finorgtype = '3' or finorgtype = '1')  and businessunit in (");
            }
            offSetSb.append(StringUtils.join(orgIds, (String)",")).append(") then '1' else '0' end ");
            allDs = allDs.updateField("isoffset", offSetSb.toString());
        }
        return allDs;
    }

    public static String getCacheKey(Long orgviewId, Date queryDate, boolean includeLastYear) {
        return "CashFundsDataHelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + "-" + includeLastYear;
    }
}

