/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;

public class CcrTermDateHelper {
    public static final String YEAR = "year";
    public static final Integer YEAR_RANGE = 2;
    public static final String SEASON = "season";
    public static final Integer SEASON_RANGE = 4;
    public static final String MONTH = "month";
    public static final Integer MONTH_RANGE = 12;

    public static List<String> parseDate(Date queryDate, String termType) {
        int offset;
        int end = 12;
        ArrayList<String> termList = new ArrayList<String>(10);
        switch (termType) {
            case "year": {
                end = YEAR_RANGE;
                break;
            }
            case "season": {
                end = CcrTermDateHelper.getSeasonEndOffset(queryDate);
                break;
            }
            case "month": {
                end = CcrTermDateHelper.getMonthEndOffset(queryDate);
                break;
            }
        }
        DateRangeEnum rangeEnum = DateRangeEnum.getEnumByValue(termType);
        for (int i = offset = 0; i < end; ++i) {
            String term = FinanceCostDateHelper.getDateCaption(queryDate, rangeEnum.getValue(), rangeEnum.getShortName(), i);
            termList.add(term);
        }
        return termList;
    }

    public static int getSeasonEndOffset(Date queryDate) {
        int season = DateUtils.getSeason((Date)queryDate);
        return season + SEASON_RANGE;
    }

    public static int getMonthEndOffset(Date queryDate) {
        int month = DateUtils.getMonth((Date)queryDate);
        return month + MONTH_RANGE;
    }
}

