/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DecisionCommonHelper {
    public static final String DATE_RANGE = "dateRange";
    public static final String ONE_MONTH = "one_month";
    public static final String THREE_MONTH = "three_month";
    public static final String SIX_MONTH = "six_month";
    public static final String YEAR = "year";

    public static Date fixQueryDate(Date queryDate) {
        Date currentDate = DateUtils.getCurrentDate();
        if (queryDate.getTime() < currentDate.getTime() && DateUtils.getMonth((Date)queryDate) < DateUtils.getMonth((Date)currentDate) || DateUtils.getYear((Date)queryDate) < DateUtils.getYear((Date)currentDate)) {
            queryDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)1);
        }
        return queryDate;
    }

    public static String toPlainString(String numberStr) {
        if (EmptyUtil.isEmpty((String)numberStr)) {
            return "0";
        }
        if (numberStr.endsWith("E") || numberStr.endsWith("e")) {
            return numberStr.substring(0, numberStr.length() - 1);
        }
        BigDecimal b = new BigDecimal(numberStr);
        return b.toPlainString();
    }

    public static String stringFormat(String s) {
        String format = "'%s'";
        return String.format(format, s);
    }

    public static String[] getDifferenceArraysOrdered(String[] arr1, String ... arr2) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{arr1, arr2})) {
            return arr1;
        }
        ArrayList<String> resultList = new ArrayList<String>(16);
        for (String i : arr1) {
            boolean found = false;
            for (String j : arr2) {
                if (j == null || !j.equals(i)) continue;
                found = true;
                break;
            }
            if (found) continue;
            resultList.add(i);
        }
        return resultList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<T> getFieldValues(DataSet ds, String fieldName, Class<T> clazz) {
        HashSet<Object> set = new HashSet<Object>(1024);
        try {
            for (Row row : ds) {
                Object value;
                if (Long.class.equals(clazz)) {
                    value = row.getLong(fieldName);
                    if (value == null) continue;
                    set.add(value);
                    continue;
                }
                value = row.getString(fieldName);
                if (value == null) continue;
                set.add(value);
            }
            HashSet<Object> hashSet = set;
            return hashSet;
        }
        finally {
            ds.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, Object[]> getFieldValues(DataSet ds, String fieldKey, String[] valueNames) {
        HashMap<Object, Object[]> map = new HashMap<Object, Object[]>(1024);
        try {
            for (Row row : ds) {
                Object key = row.get(fieldKey);
                Object[] values = new Object[valueNames.length];
                for (int i = 0; i < valueNames.length; ++i) {
                    values[i] = row.get(valueNames[i]);
                }
                map.put(key, values);
            }
            HashMap<Object, Object[]> hashMap = map;
            return hashMap;
        }
        finally {
            ds.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet getUniqueBankCate(Set<String> allBankNums) {
        DataSet allBankCateDs = DecisionCommonHelper.loadAllBankCates(allBankNums);
        DataSet copy = null;
        DataSet bankCateCountDs = null;
        try {
            copy = allBankCateDs.copy();
            bankCateCountDs = copy.groupBy(new String[]{"type_code"}).count("count").finish().filter("count == 1");
            HashSet<String> typeCodes = new HashSet<String>(128);
            Iterator iterator = bankCateCountDs.iterator();
            while (iterator.hasNext()) {
                typeCodes.add(((Row)iterator.next()).getString("type_code"));
            }
            DataSet dataSet = allBankCateDs = allBankCateDs.filter("type_code in codeParam", Collections.singletonMap("codeParam", typeCodes));
            return dataSet;
        }
        finally {
            if (copy != null) {
                copy.close();
            }
            if (bankCateCountDs != null) {
                bankCateCountDs.close();
            }
        }
    }

    private static DataSet loadAllBankCates(Set<String> allBankNums) {
        QFilter filter = new QFilter("type_code", "in", allBankNums).and("enable", "=", (Object)"1");
        return QueryServiceHelper.queryDataSet((String)"loadAllBankCates", (String)"bd_bankcgsetting", (String)"id,type_code,name", (QFilter[])filter.toArray(), null);
    }

    public static Map<String, Object> getDateRangeMap(Date queryDate) {
        LinkedHashMap<String, Object> dateMap = new LinkedHashMap<String, Object>(8);
        dateMap.put(ONE_MONTH, DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)0));
        dateMap.put(THREE_MONTH, DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-2));
        dateMap.put(SIX_MONTH, DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-5));
        dateMap.put(YEAR, DateUtils.getFirstYearDate((Date)queryDate));
        return dateMap;
    }

    public static DataSet getDateRangeDataSets(DataSet dataSet, Map<String, Object> dateRangeMap, String dateFieldName) {
        dataSet = dataSet.addField("TO_CHAR(" + dateFieldName + ",'yyyyMMdd')", "dateSub");
        String[] dateRageFilter = new String[dateRangeMap.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : dateRangeMap.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("dateSub").append(" >= ").append(DateUtils.formatString((Date)((Date)entry.getValue()), (String)"yyyyMMdd"));
            dateRageFilter[i++] = stringBuilder.toString();
        }
        DataSet[] dataSets = dataSet.splitByFilter(dateRageFilter, false);
        DataSet resultSet = null;
        int j = 0;
        for (Map.Entry<String, Object> entry : dateRangeMap.entrySet()) {
            DataSet splitSet = dataSets[j++];
            splitSet = splitSet.addField("'" + entry.getKey() + "'", DATE_RANGE);
            if (resultSet == null) {
                resultSet = splitSet;
                continue;
            }
            resultSet = resultSet.union(splitSet);
        }
        return resultSet;
    }

    public static String idListToString(Collection<Object> idList) {
        ArrayList<String> list = new ArrayList<String>(idList.size());
        for (Object id : idList) {
            list.add(String.valueOf(id));
        }
        return DecisionCommonHelper.listToString(list);
    }

    public static String listToString(Collection<String> idList) {
        return String.join((CharSequence)",", idList);
    }

    public static List<String> getZeroColNames(DataSet totalRow, List<String> countFields) {
        ArrayList<String> zeroColNames = new ArrayList<String>(countFields.size());
        Iterator iterator = totalRow.copy().iterator();
        RowMeta rowMeta = totalRow.getRowMeta();
        if (iterator.hasNext()) {
            Row total = (Row)iterator.next();
            for (String fieldName : countFields) {
                if (total.get(fieldName) == null) {
                    zeroColNames.add(fieldName);
                    continue;
                }
                int fieldIndex = rowMeta.getFieldIndex(fieldName);
                DataType dataType = rowMeta.getDataType(fieldIndex);
                if (dataType instanceof BigDecimalType) {
                    if (total.getBigDecimal(fieldName).compareTo(BigDecimal.ZERO) != 0) continue;
                    zeroColNames.add(fieldName);
                    continue;
                }
                if (dataType instanceof LongType) {
                    if (total.getLong(fieldName).compareTo(0L) != 0) continue;
                    zeroColNames.add(fieldName);
                    continue;
                }
                if (!(dataType instanceof IntegerType) || total.getInteger(fieldName).compareTo(0) != 0) continue;
                zeroColNames.add(fieldName);
            }
        }
        return zeroColNames;
    }
}

