/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.tda.extpoint.note.IDraftBillDecisionRptInterface;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.DraftBillCostDateHelper;
import kd.tmc.tda.common.helper.DraftBillUpdateFieldFunction;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.common.helper.SysParamHelper;

public class DraftBillDataHelper {
    private static final Log logger = LogFactory.getLog(DraftBillDataHelper.class);
    private static final String RECEIVABLE_FIELDS = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccountname, drawerbank.name drawerbank,receivername,0L as receiver, receiveraccount, receiverbank.name receiverbankname,acceptername,accepteraccount, accepterbebank.union_number as accepterbankcatename, 0L as accepterbankcate,delivername,deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,'receivebill' rptype";
    private static final String RECEIVABLE_BUSINESS_FIELDS = "supperbillid, equaltradebillid,isfromequalspilt,1 as draftbillcount";
    private static final String PAYABLE_FIELDS = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccount.bankaccountnumber draweraccountname, drawerbankname drawerbank,receivername,receiver, receiveraccount, receiverbank.name receiverbankname,acceptername, accepteraccount, accepterfinorg.bank_cate.name accepterbankcatename, accepterfinorg.bank_cate accepterbankcate,'' delivername,0L as deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,'paybill' rptype,draweraccount.bank.bank_cate.name drawerbank_bankcatename,draweraccount.bank.bank_cate drawerbank_bankcate";
    private static final String DISCOUNT_FIELDS = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccountname, drawerbank.name drawerbank,receivername,0L as receiver, receiveraccount, receiverbank.name receiverbankname,acceptername,accepteraccount, accepterbebank.union_number as accepterbankcatename, 0L as accepterbankcate,delivername,deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,0.0 discountinterest,'discount' rptype";
    private static final String DISCOUNT_INTEREST_FIELDS = "rate discountrate,recbody.name recbodyname,recbody.bank_cate.id recbodybankcateid,recbody.bank_cate.name recbodybankcatename,discount_interest,discount_days,billno";
    private static final String DISCOUNT_DAYS = "discountdays";
    private static final String BUSINESS_PROCESS_FIELDS = "id,bizdate,entrys.draftbill.id draftbillid,entrys.draftbill.draftbillno draftbillno,entrys.draftbill.company draftbillcompany,tradetype,auditdate";
    private static final String RECEIVABLE_PAY_FIELDS = "id,orgid,billtype,registereddate,draftbillno,subbillrange,currency,issuedate,expiredate,originalamount, amount,drawername,draweraccountname,  drawerbank,receivername, receiveraccount, receiverbankname,acceptername, accepteraccount, accepterbankcatename, accepterbankcate,delivername,deliver,receiver, description,billstatus,draftbillstatus,rptype,bizdate,rate,originalsubbillrang,originalsubbillamount,eledraftstatusnew,eledraftstatus,elccirculatestatus,supperbillid,draftbillcount";
    public static final String BALANCE = "balance";
    public static final String ACCRUED = "accrued";
    public static final String DISCOUNT = "discount";
    public static final String RECEIVEBILL = "receivebill";
    public static final String PAYBILL = "paybill";
    public static final String DATE_SUB = "dateSub";
    public static final String CUSTOMTYPE = "customtype";
    public static final String DATETYPE = "datetype";

    public static DataSet getBillBalanceDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, String rptype) {
        if (EmptyUtil.isEmpty((String)rptype)) {
            DataSet recBillBalanceDataSet = DraftBillDataHelper.getRecBillBalanceDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
            DataSet payBillBalanceDataSet = DraftBillDataHelper.getPayBillBalanceDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
            return recBillBalanceDataSet.union(payBillBalanceDataSet);
        }
        if (RECEIVEBILL.equals(rptype)) {
            return DraftBillDataHelper.getRecBillBalanceDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
        }
        return DraftBillDataHelper.getPayBillBalanceDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
    }

    public static DataSet getBillAccruedDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, String rptype) {
        if (EmptyUtil.isEmpty((String)rptype)) {
            DataSet recBillAccruedDataSet = DraftBillDataHelper.getRecBillAccruedDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
            DataSet payBillAccruedDataSet = DraftBillDataHelper.getPayBillAccruedDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
            return recBillAccruedDataSet.union(payBillAccruedDataSet);
        }
        if (RECEIVEBILL.equals(rptype)) {
            return DraftBillDataHelper.getRecBillAccruedDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
        }
        return DraftBillDataHelper.getPayBillAccruedDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId);
    }

    public static DataSet getRecBillDiscountDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        long start = System.currentTimeMillis();
        DataSet recBillDiscountDataSet = DraftBillDataHelper.queryBillDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, "cdm_drafttradebill", DISCOUNT);
        Set<String> allBankNums = DecisionCommonHelper.getFieldValues(recBillDiscountDataSet.copy(), "accepterbankcatename", String.class);
        DataSet bankCateDs = DecisionCommonHelper.getUniqueBankCate(allBankNums);
        Map<Object, Object[]> bankCateNumbers = DecisionCommonHelper.getFieldValues(bankCateDs, "type_code", new String[]{"id", "name"});
        recBillDiscountDataSet = DraftBillUpdateFieldFunction.updateFields(recBillDiscountDataSet, DraftBillUpdateFieldFunction.setAccepterFunction(), DraftBillUpdateFieldFunction.setAccepterBankFunction(bankCateNumbers));
        logger.info("\u5e94\u6536\u7968\u636e\u8d34\u73b0\u53d6\u6570\u8017\u65f6" + algoKey + orgViewId + "cost : " + (System.currentTimeMillis() - start));
        return recBillDiscountDataSet;
    }

    private static DataSet getRecBillBalanceDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        long start = System.currentTimeMillis();
        DataSet recBillBalanceDataSet = DraftBillDataHelper.queryBillDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, "cdm_receivablebill", BALANCE);
        recBillBalanceDataSet = DraftBillDataHelper.validateRecBillStatus(queryDate, recBillBalanceDataSet);
        Set<String> allBankNums = DecisionCommonHelper.getFieldValues(recBillBalanceDataSet.copy(), "accepterbankcatename", String.class);
        DataSet bankCateDs = DecisionCommonHelper.getUniqueBankCate(allBankNums);
        Map<Object, Object[]> bankCateNumbers = DecisionCommonHelper.getFieldValues(bankCateDs, "type_code", new String[]{"id", "name"});
        recBillBalanceDataSet = DraftBillUpdateFieldFunction.updateFields(recBillBalanceDataSet, DraftBillUpdateFieldFunction.setAccepterFunction(), DraftBillUpdateFieldFunction.setAccepterBankFunction(bankCateNumbers));
        recBillBalanceDataSet = recBillBalanceDataSet.updateField("draftbillcount", "case when supperbillid is null or supperbillid = 0L or tradetype = 'rlspledge' then 1 else 0 end");
        logger.info("\u5e94\u6536\u7968\u636e\u4f59\u989d\u53d6\u6570\u8017\u65f6" + algoKey + orgViewId + "cost : " + (System.currentTimeMillis() - start));
        return recBillBalanceDataSet.select(RECEIVABLE_PAY_FIELDS);
    }

    private static DataSet getPayBillBalanceDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        long start = System.currentTimeMillis();
        DataSet payBillBalanceDataSet = DraftBillDataHelper.queryBillDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, "cdm_payablebill", BALANCE);
        payBillBalanceDataSet = DraftBillDataHelper.validatePayBillStatus(queryDate, payBillBalanceDataSet);
        payBillBalanceDataSet = DraftBillUpdateFieldFunction.updateFields(payBillBalanceDataSet, DraftBillUpdateFieldFunction.setAccepterFunction(), DraftBillUpdateFieldFunction.setAccepterBankFunction(null));
        logger.info("\u5e94\u4ed8\u7968\u636e\u4f59\u989d\u53d6\u6570\u8017\u65f6" + algoKey + orgViewId + "cost : " + (System.currentTimeMillis() - start));
        return payBillBalanceDataSet.select(RECEIVABLE_PAY_FIELDS);
    }

    private static DataSet getRecBillAccruedDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        long start = System.currentTimeMillis();
        DataSet recBillAccruedDataSet = DraftBillDataHelper.queryBillDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, "cdm_receivablebill", ACCRUED);
        Set<String> allBankNums = DecisionCommonHelper.getFieldValues(recBillAccruedDataSet.copy(), "accepterbankcatename", String.class);
        DataSet bankCateDs = DecisionCommonHelper.getUniqueBankCate(allBankNums);
        Map<Object, Object[]> bankCateNumbers = DecisionCommonHelper.getFieldValues(bankCateDs, "type_code", new String[]{"id", "name"});
        recBillAccruedDataSet = DraftBillUpdateFieldFunction.updateFields(recBillAccruedDataSet, DraftBillUpdateFieldFunction.setAccepterFunction(), DraftBillUpdateFieldFunction.setAccepterBankFunction(bankCateNumbers));
        recBillAccruedDataSet = recBillAccruedDataSet.updateField("draftbillcount", "case when supperbillid is null or supperbillid = 0L then 1 else 0 end");
        logger.info("\u5e94\u6536\u7968\u636e\u53d1\u751f\u989d\u53d6\u6570\u8017\u65f6" + algoKey + orgViewId + "cost : " + (System.currentTimeMillis() - start));
        return recBillAccruedDataSet.select(RECEIVABLE_PAY_FIELDS);
    }

    private static DataSet getPayBillAccruedDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        long start = System.currentTimeMillis();
        DataSet payBillAccruedDataSet = DraftBillDataHelper.queryBillDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, "cdm_payablebill", ACCRUED);
        payBillAccruedDataSet = DraftBillUpdateFieldFunction.updateFields(payBillAccruedDataSet, DraftBillUpdateFieldFunction.setAccepterFunction(), DraftBillUpdateFieldFunction.setAccepterBankFunction(null));
        logger.info("\u5e94\u4ed8\u7968\u636e\u53d1\u751f\u989d\u53d6\u6570\u8017\u65f6" + algoKey + orgViewId + "cost : " + (System.currentTimeMillis() - start));
        return payBillAccruedDataSet.select(RECEIVABLE_PAY_FIELDS);
    }

    private static DataSet queryBillDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, String entity, String amountType) {
        DataSet result;
        Date nextTruncateDate = DateUtils.truncateDate((Date)DateUtils.getNextDay((Date)queryDate, (int)1));
        String cacheKey = DraftBillDataHelper.getCacheKey(orgViewId, queryDate, entity, amountType);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> BALANCE.equals(amountType) ? DraftBillDataHelper.getAllBalanceViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, allOrgIds, entity) : (ACCRUED.equals(amountType) ? DraftBillDataHelper.getAllAccruedViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, allOrgIds, entity) : DraftBillDataHelper.getDiscountViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, allOrgIds, entity)));
            result = result.filter("orgid in orgIds", Collections.singletonMap("orgIds", orgIds));
        } else {
            result = BALANCE.equals(amountType) ? DraftBillDataHelper.getAllBalanceViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, orgIds, entity) : (ACCRUED.equals(amountType) ? DraftBillDataHelper.getAllAccruedViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, orgIds, entity) : DraftBillDataHelper.getDiscountViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, orgIds, entity));
        }
        return result;
    }

    private static DataSet getAllBalanceViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> orgIds, String entity) {
        QFilter qFilter = new QFilter("company", "in", orgIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("draftbilltype.settlementtype", "in", Arrays.asList("5", "6")).and("draftbillexpiredate", ">=", (Object)queryDate).and("draftbilltranstatus", "=", (Object)"success");
        String selectFields = "";
        String realEntity = DraftBillDataHelper.getDraftBillEntityName(entity);
        if ("cdm_receivablebill".equals(entity)) {
            selectFields = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccountname, drawerbank.name drawerbank,receivername,0L as receiver, receiveraccount, receiverbank.name receiverbankname,acceptername,accepteraccount, accepterbebank.union_number as accepterbankcatename, 0L as accepterbankcate,delivername,deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,'receivebill' rptype, supperbillid, equaltradebillid,isfromequalspilt,1 as draftbillcount";
            qFilter.and("bizdate", "<", (Object)queryDate).and("rptype", "=", (Object)RECEIVEBILL);
        } else {
            selectFields = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccount.bankaccountnumber draweraccountname, drawerbankname drawerbank,receivername,receiver, receiveraccount, receiverbank.name receiverbankname,acceptername, accepteraccount, accepterfinorg.bank_cate.name accepterbankcatename, accepterfinorg.bank_cate accepterbankcate,'' delivername,0L as deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,'paybill' rptype,draweraccount.bank.bank_cate.name drawerbank_bankcatename,draweraccount.bank.bank_cate drawerbank_bankcate, supperbillid, equaltradebillid,isfromequalspilt,1 as draftbillcount";
            qFilter.and("issuedate", "<", (Object)queryDate).and("rptype", "=", (Object)PAYBILL);
        }
        DataSet allViewData = QueryServiceHelper.queryDataSet((String)algoKey, (String)realEntity, (String)selectFields, (QFilter[])qFilter.toArray(), null);
        QFilter businessQfilter = new QFilter("draftbilltranstatus", "=", (Object)"success").and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        String realDrafttradebillEntity = DraftBillDataHelper.getDraftBillEntityName("cdm_drafttradebill");
        DataSet businessProcessData = QueryServiceHelper.queryDataSet((String)algoKey, (String)realDrafttradebillEntity, (String)BUSINESS_PROCESS_FIELDS, (QFilter[])businessQfilter.toArray(), null);
        businessProcessData = businessProcessData.filter("draftbillid != 0L");
        if ("cdm_receivablebill".equals(entity)) {
            allViewData = allViewData.updateField("accepterbankcatename", "case when accepterbankcatename is null then 'isnull' else Left(accepterbankcatename, 3) end");
            DataSet[] splitDataSets = allViewData.splitByFilter(new String[]{"equaltradebillid != 0L and isfromequalspilt = true", "equaltradebillid != 0L and isfromequalspilt = true"}, true);
            DataSet splitDrafitSet = splitDataSets[0];
            businessProcessData = DraftBillDataHelper.updateBusinessProcessData(queryDate, businessProcessData, splitDrafitSet);
            allViewData = splitDataSets[1].union(splitDataSets[2]);
            allViewData = allViewData.addFields(new String[]{"0L", "0L"}, new String[]{"startrange", "endrange"});
            allViewData = DraftBillUpdateFieldFunction.updateFields(allViewData, DraftBillUpdateFieldFunction.billRangeUpdateFunction());
            allViewData = allViewData.orderBy(new String[]{"draftbillno", "startrange asc", "endrange dec"});
        }
        allViewData = allViewData.leftJoin(businessProcessData).on("id", "draftbillid").on("orgid", "draftbillcompany").select(allViewData.getRowMeta().getFieldNames(), new String[]{"bizdate", "tradetype"}).finish();
        allViewData = allViewData.updateField("amount", "originalamount");
        allViewData = AmountTransHelper.tranDataSetRate((DataSet)allViewData, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("amount"), (Date)queryDate);
        return allViewData;
    }

    private static DataSet updateBusinessProcessData(Date queryDate, DataSet businessProcessData, DataSet splitDrafitSet) {
        RowMeta businessRowMeta = businessProcessData.getRowMeta();
        businessProcessData = businessProcessData.leftJoin(splitDrafitSet).on("id", "equaltradebillid").on("draftbillid", "supperbillid").select(businessRowMeta.getFieldNames(), new String[]{"id realdraftbillid"}).finish();
        businessProcessData = businessProcessData.updateField("draftbillid", "case when realdraftbillid is not null then realdraftbillid else draftbillid end").select(businessRowMeta.getFieldNames());
        DataSet[] recbusinessProcessDatas = businessProcessData.splitByFilter(new String[]{"tradetype in ('pledge','rlspledge')", "tradetype in ('trusteeship','retrieve')"}, true);
        DataSet pledgeSet = recbusinessProcessDatas[0].filter("bizdate < querydate", Collections.singletonMap("querydate", queryDate));
        DataSet pledgeSetCopy = pledgeSet.copy().groupBy(new String[]{"draftbillid"}).max("auditdate").finish();
        pledgeSet = pledgeSetCopy.leftJoin(pledgeSet).on("draftbillid", "draftbillid").on("auditdate", "auditdate").select(pledgeSet.getRowMeta().getFieldNames()).finish();
        DataSet trusteeshipSet = recbusinessProcessDatas[1].copy().groupBy(new String[]{"draftbillid"}).max("auditdate").finish();
        trusteeshipSet = trusteeshipSet.leftJoin(recbusinessProcessDatas[1]).on("draftbillid", "draftbillid").on("auditdate", "auditdate").select(recbusinessProcessDatas[1].getRowMeta().getFieldNames()).finish();
        businessProcessData = recbusinessProcessDatas[2].union(new DataSet[]{pledgeSet, trusteeshipSet});
        return businessProcessData;
    }

    private static DataSet getAllAccruedViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> orgIds, String entity) {
        QFilter qFilter = new QFilter("company", "in", orgIds).and("draftbilltype.settlementtype", "in", Arrays.asList("5", "6")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("draftbilltranstatus", "=", (Object)"success");
        String selectFields = "";
        Date firstDateOfAnyMonth = FinanceCostDateHelper.getFirstOrEndDateByHalfYearOffset(queryDate, -11, true, true);
        String realEntity = DraftBillDataHelper.getDraftBillEntityName(entity);
        Date maxQueryDate = DraftBillDataHelper.getAccruedTypeMaxDate(queryDate);
        if ("cdm_receivablebill".equals(entity)) {
            selectFields = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccountname, drawerbank.name drawerbank,receivername,0L as receiver, receiveraccount, receiverbank.name receiverbankname,acceptername,accepteraccount, accepterbebank.union_number as accepterbankcatename, 0L as accepterbankcate,delivername,deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,'receivebill' rptype, supperbillid, equaltradebillid,isfromequalspilt,1 as draftbillcount";
            qFilter.and("bizdate", ">=", (Object)firstDateOfAnyMonth).and("bizdate", "<", (Object)maxQueryDate).and("rptype", "=", (Object)RECEIVEBILL);
        } else {
            selectFields = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccount.bankaccountnumber draweraccountname, drawerbankname drawerbank,receivername,receiver, receiveraccount, receiverbank.name receiverbankname,acceptername, accepteraccount, accepterfinorg.bank_cate.name accepterbankcatename, accepterfinorg.bank_cate accepterbankcate,'' delivername,0L as deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,'paybill' rptype,draweraccount.bank.bank_cate.name drawerbank_bankcatename,draweraccount.bank.bank_cate drawerbank_bankcate, supperbillid, equaltradebillid,isfromequalspilt,1 as draftbillcount";
            qFilter.and("issuedate", ">=", (Object)firstDateOfAnyMonth).and("issuedate", "<", (Object)maxQueryDate).and("rptype", "=", (Object)PAYBILL);
        }
        DataSet allViewData = QueryServiceHelper.queryDataSet((String)algoKey, (String)realEntity, (String)selectFields, (QFilter[])qFilter.toArray(), null);
        if ("cdm_receivablebill".equals(entity)) {
            allViewData = allViewData.updateField("accepterbankcatename", "case when accepterbankcatename is null then 'isnull' else Left(accepterbankcatename, 3) end");
        }
        if ("cdm_payablebill".equals(entity)) {
            QFilter businessQfilter = new QFilter("draftbilltranstatus", "=", (Object)"success").and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            String realDrafttradebillEntity = DraftBillDataHelper.getDraftBillEntityName("cdm_drafttradebill");
            DataSet businessProcessData = QueryServiceHelper.queryDataSet((String)algoKey, (String)realDrafttradebillEntity, (String)BUSINESS_PROCESS_FIELDS, (QFilter[])businessQfilter.toArray(), null);
            businessProcessData = businessProcessData.filter("draftbillid != 0L and tradetype = 'refund'");
            String[] allViewDataFieldNames = allViewData.getRowMeta().getFieldNames();
            allViewData = allViewData.leftJoin(businessProcessData).on("id", "draftbillid").on("orgid", "draftbillcompany").select(allViewDataFieldNames, new String[]{"bizdate", "tradetype"}).finish();
            allViewData = allViewData.filter("tradetype != 'refund'").select(allViewDataFieldNames);
        }
        allViewData = allViewData.updateField("amount", "originalamount");
        allViewData = AmountTransHelper.tranDataSetRate((DataSet)allViewData, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("amount"), (Date)queryDate);
        return allViewData.addField("null", "bizdate");
    }

    private static DataSet getDiscountViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> orgIds, String entity) {
        Date maxQueryDate = DraftBillDataHelper.getAccruedTypeMaxDate(queryDate);
        Date firstDateOfAnyMonth = FinanceCostDateHelper.getFirstOrEndDateByHalfYearOffset(queryDate, -11, true, true);
        QFilter[] qFilters = new QFilter("company", "in", orgIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("draftbilltranstatus", "=", (Object)"success").and("tradetype", "=", (Object)DISCOUNT).and("bizdate", "<", (Object)maxQueryDate).and("bizdate", ">=", (Object)firstDateOfAnyMonth).toArray();
        String realDrafttradebillEntity = DraftBillDataHelper.getDraftBillEntityName("cdm_drafttradebill");
        DataSet businessProcessData = QueryServiceHelper.queryDataSet((String)algoKey, (String)realDrafttradebillEntity, (String)"id,bizdate,entrys.draftbill.id draftbillid,entrys.draftbill.draftbillno draftbillno,entrys.draftbill.company draftbillcompany,tradetype,auditdate,rate discountrate,recbody.name recbodyname,recbody.bank_cate.id recbodybankcateid,recbody.bank_cate.name recbodybankcatename,discount_interest,discount_days,billno", (QFilter[])qFilters, null);
        businessProcessData = businessProcessData.filter("draftbillid != 0L");
        QFilter recQFilter = new QFilter("company", "in", orgIds).and("draftbilltype.settlementtype", "in", Arrays.asList("5", "6")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("draftbillstatus", "=", (Object)"discounted").and("draftbilltranstatus", "=", (Object)"success").and("bizdate", ">=", (Object)firstDateOfAnyMonth).and("bizdate", "<", (Object)maxQueryDate).and("rptype", "=", (Object)RECEIVEBILL);
        String selectFields = "id,company as orgid,draftbilltype.settlementtype billtype,bizdate registereddate,draftbillno,subbillrange,originalsubbillrang,currency,issuedate,draftbillexpiredate expiredate,amount originalamount, 0.0 as amount,originalsubbillamount,drawername, draweraccountname, drawerbank.name drawerbank,receivername,0L as receiver, receiveraccount, receiverbank.name receiverbankname,acceptername,accepteraccount, accepterbebank.union_number as accepterbankcatename, 0L as accepterbankcate,delivername,deliver,description,billstatus,draftbillstatus,eledraftstatusnew,eledraftstatus,elccirculatestatus,0.0 discountinterest,'discount' rptype, supperbillid, equaltradebillid,isfromequalspilt,1 as draftbillcount";
        String realRecEntity = DraftBillDataHelper.getDraftBillEntityName("cdm_receivablebill");
        DataSet allViewData = QueryServiceHelper.queryDataSet((String)algoKey, (String)realRecEntity, (String)selectFields, (QFilter[])recQFilter.toArray(), null);
        allViewData = allViewData.updateField("accepterbankcatename", "case when accepterbankcatename is null then 'isnull' else Left(accepterbankcatename, 3) end");
        DataSet[] splitDataSets = allViewData.splitByFilter(new String[]{"equaltradebillid != 0L and isfromequalspilt = true", "equaltradebillid != 0L and isfromequalspilt = true"}, true);
        DataSet splitDrafitSet = splitDataSets[0];
        RowMeta businessRowMeta = businessProcessData.getRowMeta();
        businessProcessData = businessProcessData.leftJoin(splitDrafitSet).on("id", "equaltradebillid").on("draftbillid", "supperbillid").select(businessRowMeta.getFieldNames(), new String[]{"id realdraftbillid"}).finish();
        businessProcessData = businessProcessData.updateField("draftbillid", "case when realdraftbillid is not null then realdraftbillid else draftbillid end").select(businessRowMeta.getFieldNames());
        allViewData = splitDataSets[1].union(splitDataSets[2]);
        allViewData = allViewData.leftJoin(businessProcessData).on("id", "draftbillid").on("orgid", "draftbillcompany").select(allViewData.getRowMeta().getFieldNames(), new String[]{"bizdate", "tradetype", "billno", "discount_days", "discountrate", "discount_interest", "recbodyname", "recbodybankcateid", "recbodybankcatename"}).finish();
        allViewData = allViewData.filter("billno != null");
        DataSet[] allViewDatas = allViewData.splitByFilter(new String[]{"true", "true"}, false);
        allViewData = allViewDatas[0];
        DataSet allInterestData = allViewDatas[1];
        Object[] fieldNames = allViewData.getRowMeta().getFieldNames();
        allInterestData = allInterestData.addField("DATEDIF(bizdate, expiredate, D) + discount_days", DISCOUNT_DAYS);
        allInterestData = allInterestData.addField("originalamount * discountdays", "tempamount");
        allViewData = allViewData.addField("DATEDIF(bizdate, expiredate, D) + discount_days", DISCOUNT_DAYS);
        allViewData = allViewData.addField("originalamount * discountdays", "tempamount");
        allInterestData = allInterestData.groupBy(new String[]{"billno"}).sum("tempamount", "tempamounttotal").finish();
        allViewData = allViewData.leftJoin(allInterestData).on("billno", "billno").select(allViewData.getRowMeta().getFieldNames(), new String[]{"tempamounttotal"}).finish();
        allViewData = allViewData.updateField("discountinterest", "case when tempamounttotal = 0.0 then 0.0 else discount_interest * (tempamount /  tempamounttotal) end");
        allViewData = allViewData.updateField("amount", "originalamount").select((String[])ArrayUtils.addAll((Object[])fieldNames, (Object[])new String[]{DISCOUNT_DAYS}));
        allViewData = AmountTransHelper.tranDataSetRate((DataSet)allViewData, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("amount"), (Date)queryDate);
        return allViewData;
    }

    private static DataSet validateRecBillStatus(Date queryDate, DataSet recBillBalanceDataSet) {
        DataSet[] recBillBalanceDataSets = recBillBalanceDataSet.splitByFilter(new String[]{"tradetype = 'pledge'"}, true);
        final Map<String, Map<String, Date>> pledgeMap = DraftBillDataHelper.getPledgeMap(recBillBalanceDataSets);
        recBillBalanceDataSet = recBillBalanceDataSets[1];
        final Date truncateQueryDate = DateUtils.truncateDate((Date)queryDate);
        recBillBalanceDataSet = recBillBalanceDataSet.filter(new FilterFunction(){

            /*
             * WARNING - void declaration
             */
            public boolean test(Row row) {
                void var12_18;
                String draftbillstatus = row.getString("draftbillstatus");
                String tradetype = row.getString("tradetype");
                Date bizdate = row.getDate("bizdate");
                String draftbillno = row.getString("draftbillno");
                long startrange = row.getLong("startrange");
                long endrange = row.getLong("endrange");
                Map pledgeBillInfoMap = (Map)pledgeMap.get(draftbillno);
                if (pledgeBillInfoMap != null) {
                    for (Map.Entry entry : pledgeBillInfoMap.entrySet()) {
                        String pledgeRange = (String)entry.getKey();
                        Date opBizdate = (Date)entry.getValue();
                        String[] pledgeRanges = pledgeRange.split("-");
                        if (startrange < Long.parseLong(pledgeRanges[0]) || endrange > Long.parseLong(pledgeRanges[1]) || bizdate != null && DateUtils.truncateDate((Date)bizdate).getTime() <= DateUtils.truncateDate((Date)opBizdate).getTime()) continue;
                        return Boolean.FALSE;
                    }
                }
                String string = draftbillstatus;
                int n = -1;
                switch (string.hashCode()) {
                    case -1869930878: {
                        if (!string.equals("registered")) break;
                        boolean bl = false;
                        break;
                    }
                    case -1455576622: {
                        if (!string.equals("collocated")) break;
                        boolean bl = true;
                        break;
                    }
                    case 1740277652: {
                        if (!string.equals("endorsed")) break;
                        int n2 = 2;
                        break;
                    }
                    case -490497589: {
                        if (!string.equals("pledged")) break;
                        int n3 = 3;
                        break;
                    }
                    case 536884640: {
                        if (!string.equals("discounted")) break;
                        int n4 = 4;
                        break;
                    }
                    case 1883491145: {
                        if (!string.equals("collected")) break;
                        int n5 = 5;
                    }
                }
                switch (var12_18) {
                    case 0: 
                    case 1: {
                        return Boolean.TRUE;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (bizdate != null && DateUtils.truncateDate((Date)bizdate).getTime() <= truncateQueryDate.getTime()) {
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                }
                return Boolean.FALSE;
            }
        });
        return recBillBalanceDataSet;
    }

    private static Map<String, Map<String, Date>> getPledgeMap(DataSet[] recBillBalanceDataSets) {
        HashMap<String, Map<String, Date>> pledgeMap = new HashMap<String, Map<String, Date>>(64);
        for (Row row : recBillBalanceDataSets[0]) {
            String[] range;
            String draftbillno = row.getString("draftbillno");
            String originalsubbillrang = row.getString("originalsubbillrang");
            if (!originalsubbillrang.contains("-") || EmptyUtil.isEmpty((String)(range = originalsubbillrang.split("-"))[0]) || EmptyUtil.isEmpty((String)range[1])) continue;
            Date bizdate = row.getDate("bizdate");
            HashMap<String, Date> pledgeBillInfoMap = (HashMap<String, Date>)pledgeMap.get(draftbillno);
            if (pledgeBillInfoMap == null) {
                pledgeBillInfoMap = new HashMap<String, Date>(16);
                pledgeBillInfoMap.put(originalsubbillrang, bizdate);
                pledgeMap.put(draftbillno, pledgeBillInfoMap);
                continue;
            }
            pledgeBillInfoMap.put(originalsubbillrang, bizdate);
        }
        return pledgeMap;
    }

    private static DataSet validatePayBillStatus(final Date queryDate, DataSet payBillBalanceDataSet) {
        payBillBalanceDataSet = payBillBalanceDataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                String draftbillstatus = row.getString("draftbillstatus");
                Date bizdate = row.getDate("bizdate");
                String tradetype = row.getString("tradetype");
                switch (draftbillstatus) {
                    case "registered": {
                        return !"refund".equals(tradetype) || bizdate == null || DateUtils.truncateDate((Date)bizdate).getTime() > DateUtils.truncateDate((Date)queryDate).getTime();
                    }
                    case "payoffed": {
                        if (bizdate == null || DateUtils.truncateDate((Date)bizdate).getTime() <= DateUtils.truncateDate((Date)queryDate).getTime()) break;
                        return true;
                    }
                }
                return false;
            }
        });
        return payBillBalanceDataSet;
    }

    public static DataSet[] getDateRangeDataSet(DataSet dataSet, Date queryDate, List<Object[]> queryDateList, boolean isUnion) {
        if (EmptyUtil.isEmpty(queryDateList)) {
            queryDateList = new ArrayList<Object[]>(64);
            queryDateList.addAll(DraftBillCostDateHelper.getTermDateList(queryDate, "year"));
            queryDateList.addAll(DraftBillCostDateHelper.getTermDateList(queryDate, "half"));
            queryDateList.addAll(DraftBillCostDateHelper.getTermDateList(queryDate, "season"));
            queryDateList.addAll(DraftBillCostDateHelper.getTermDateList(queryDate, "month"));
            Date currentDate = DateUtils.truncateDate((Date)queryDate);
            queryDateList.add(new Object[]{DateUtils.truncateDate((Date)currentDate), DateUtils.getNextDay((Date)currentDate, (int)1), "day"});
        }
        dataSet = DraftBillDataHelper.getDataSetByBusinessDate(dataSet);
        String[] dateSplits = new String[queryDateList.size()];
        for (int i = 0; i < queryDateList.size(); ++i) {
            Object[] objects = queryDateList.get(i);
            Date startDate = (Date)objects[0];
            Date endDate = (Date)objects[1];
            StringBuilder splitDateStr = new StringBuilder("dateSub >= ").append(DateUtils.formatString((Date)startDate, (String)"yyyyMMdd")).append(" and ").append("dateSub <= ").append(DateUtils.formatString((Date)endDate, (String)"yyyyMMdd"));
            dateSplits[i] = splitDateStr.toString();
        }
        DataSet[] resultSet = isUnion ? new DataSet[1] : new DataSet[queryDateList.size()];
        DataSet[] dataSets = dataSet.splitByFilter(dateSplits, false);
        for (int i = 0; i < queryDateList.size(); ++i) {
            DataSet dataSetTemp = dataSets[i];
            Object[] objects = queryDateList.get(i);
            String customtype = (String)objects[2];
            dataSetTemp = dataSetTemp.addFields(new String[]{"'" + customtype + "'", i + ""}, new String[]{CUSTOMTYPE, DATETYPE});
            if (isUnion) {
                if (i == 0) {
                    resultSet[0] = dataSetTemp;
                    continue;
                }
                resultSet[0] = resultSet[0].union(dataSetTemp);
                continue;
            }
            resultSet[i] = dataSetTemp;
        }
        return resultSet;
    }

    private static DataSet getDataSetByBusinessDate(DataSet dataSet) {
        List fieldNames = Arrays.stream(dataSet.getRowMeta().getFieldNames()).collect(Collectors.toList());
        ArrayList dateFields = new ArrayList();
        Collections.addAll(dateFields, "registereddate", "issuedate", "bizdate");
        dateFields.removeAll(fieldNames);
        if (EmptyUtil.isNoEmpty(dateFields)) {
            String[] absentDateFields = new String[dateFields.size()];
            for (int i = 0; i < dateFields.size(); ++i) {
                absentDateFields[i] = (String)dateFields.get(i);
            }
            dataSet = dataSet.addNullField(absentDateFields);
        }
        dataSet = dataSet.addField("case when rptype = 'receivebill' then TO_CHAR(registereddate,'yyyyMMdd') when rptype = 'paybill' then TO_CHAR(issuedate,'yyyyMMdd') when rptype = 'discount' then TO_CHAR(bizdate,'yyyyMMdd') end", DATE_SUB);
        return dataSet;
    }

    public static String getDraftBillEntityName(String rptype) {
        PluginProxy pluginProxy = PluginProxy.create(IDraftBillDecisionRptInterface.class, (String)"kd.sdk.tmc.tda.extpoint.note.IDraftBillDecisionRptInterface");
        List resultList = pluginProxy.callReplace(p -> p.getDraftBillEntityName(rptype));
        if (EmptyUtil.isNoEmpty((Object)resultList)) {
            return (String)resultList.get(0);
        }
        return rptype;
    }

    private static Date getAccruedTypeMaxDate(Date queryDate) {
        Date currentLastDate = DateUtils.getLastYearDate((Date)new Date());
        Date queryLastDate = DateUtils.getLastYearDate((Date)queryDate);
        return queryLastDate.getTime() > currentLastDate.getTime() ? currentLastDate : queryLastDate;
    }

    private static String getCacheKey(Long orgViewId, Date queryDate, String queryEntity, String amountType) {
        return "DraftBillDataHelper-" + queryEntity + "-" + amountType + "-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyyMMdd");
    }
}

