/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import org.apache.commons.lang3.StringUtils;

@FunctionalInterface
public interface DraftBillUpdateFieldFunction<E, K, T, R> {
    public R apply(E var1, K var2, T var3);

    public static DraftBillUpdateFieldFunction<Object[], Row, RowMeta, Object[]> setAccepterFunction() {
        String fincomname = ResManager.loadKDString((String)"\u8d22\u52a1\u6709\u9650\u516c\u53f8", (String)"DraftBillUpdateFieldFunction_0", (String)"tmc-tda-common", (Object[])new Object[0]);
        String fincomname2 = ResManager.loadKDString((String)"\u8d22\u52a1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (String)"DraftBillUpdateFieldFunction_1", (String)"tmc-tda-common", (Object[])new Object[0]);
        return (data, row, rowMeta) -> {
            String acceptername;
            String billType = row.getString("billtype");
            if ("6".equals(billType) && EmptyUtil.isNoEmpty((String)(acceptername = row.getString("acceptername"))) && (acceptername.contains(fincomname) || acceptername.contains(fincomname2))) {
                int billTypeIndex = rowMeta.getFieldIndex("billtype");
                data[billTypeIndex] = "20";
            }
            return data;
        };
    }

    public static DraftBillUpdateFieldFunction<Object[], Row, RowMeta, Object[]> setAccepterBankFunction(Map<Object, Object[]> bankCateNumbers) {
        String otherBank = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"DraftBillUpdateFieldFunction_2", (String)"tmc-tda-common", (Object[])new Object[0]);
        String finance = ResManager.loadKDString((String)"\u8d22\u53f8\u627f\u5151", (String)"RecPayBillTypeEnum_2", (String)"tmc-tda-common", (Object[])new Object[0]);
        String business = ResManager.loadKDString((String)"\u5546\u4e1a\u627f\u5151", (String)"RecPayBillTypeEnum_0", (String)"tmc-tda-common", (Object[])new Object[0]);
        return (data, row, rowMeta) -> {
            String billType = row.getString("billtype");
            String rptype = row.getString("rptype");
            String accepterbankcatename = row.getString("accepterbankcatename");
            int accepterbankcatenameIndex = rowMeta.getFieldIndex("accepterbankcatename");
            int accepterbankcateIndex = rowMeta.getFieldIndex("accepterbankcate");
            if (("receivebill".equals(rptype) || "discount".equals(rptype)) && "isnull".equals(accepterbankcatename)) {
                data[accepterbankcatenameIndex] = "";
            }
            if ("6".equals(billType)) {
                if ("receivebill".equals(rptype) || "discount".equals(rptype)) {
                    if (EmptyUtil.isNoEmpty((String)accepterbankcatename) && bankCateNumbers.containsKey(accepterbankcatename)) {
                        data[accepterbankcatenameIndex] = ((Object[])bankCateNumbers.get(accepterbankcatename))[1];
                        data[accepterbankcateIndex] = ((Object[])bankCateNumbers.get(accepterbankcatename))[0];
                    } else {
                        data[accepterbankcatenameIndex] = otherBank;
                        data[accepterbankcateIndex] = 0L;
                    }
                } else {
                    String drawerbank_bankcatename = row.getString("drawerbank_bankcatename");
                    Long drawerbank_bankcate = row.getLong("drawerbank_bankcate");
                    data[accepterbankcatenameIndex] = drawerbank_bankcatename;
                    data[accepterbankcateIndex] = drawerbank_bankcate;
                }
                accepterbankcatename = (String)data[accepterbankcatenameIndex];
                if (EmptyUtil.isEmpty((String)accepterbankcatename)) {
                    data[accepterbankcatenameIndex] = otherBank;
                    data[accepterbankcateIndex] = 0L;
                }
            } else if ("20".equals(billType)) {
                data[accepterbankcatenameIndex] = finance;
                data[accepterbankcateIndex] = 0L;
            } else {
                data[accepterbankcatenameIndex] = business;
                data[accepterbankcateIndex] = 0L;
            }
            return data;
        };
    }

    public static DraftBillUpdateFieldFunction<Object[], Row, RowMeta, Object[]> orgLongNumberUpdateFunction(Integer level) {
        return (data, row, rowMeta) -> {
            String longNumber = row.getString("longnumber");
            int leftIndex = StringUtils.ordinalIndexOf((CharSequence)(longNumber + "!"), (CharSequence)"!", (int)level);
            String targetLongNumber = StringUtils.substring((String)longNumber, (int)0, (int)leftIndex);
            int longNumberIndex = rowMeta.getFieldIndex("longnumber");
            data[longNumberIndex] = targetLongNumber;
            return data;
        };
    }

    public static DraftBillUpdateFieldFunction<Object[], Row, RowMeta, Object[]> dateTypeUpdateFunction(Date queryDate, String periodFieldName) {
        return (data, row, rowMeta) -> {
            Integer dateType = row.getInteger("datetype");
            String dateRange = row.getString("customtype");
            DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue(dateRange);
            int diff = dateRangeEnum.getEnd() - dateType;
            String dateCaption = FinanceCostDateHelper.getDateCaption(queryDate, dateRange, dateRangeEnum.getShortName(), diff);
            int periodNameIndex = rowMeta.getFieldIndex(periodFieldName);
            data[periodNameIndex] = dateCaption;
            return data;
        };
    }

    public static DraftBillUpdateFieldFunction<Object[], Row, RowMeta, Object[]> billRangeUpdateFunction() {
        return (data, row, rowMeta) -> {
            String originalsubbillrang = row.getString("originalsubbillrang");
            if (!originalsubbillrang.contains("-")) {
                return data;
            }
            int startrangeIdex = rowMeta.getFieldIndex("startrange");
            int endrangeIndex = rowMeta.getFieldIndex("endrange");
            if (EmptyUtil.isNoEmpty((String)originalsubbillrang)) {
                String[] range = originalsubbillrang.split("-");
                if (EmptyUtil.isEmpty((String)range[0]) || EmptyUtil.isEmpty((String)range[1])) {
                    return data;
                }
                data[startrangeIdex] = Long.parseLong(range[0]);
                data[endrangeIndex] = Long.parseLong(range[1]);
            }
            return data;
        };
    }

    public static DataSet updateFields(DataSet billDataSet, final DraftBillUpdateFieldFunction<Object[], Row, RowMeta, Object[]> ... updateFieldFunction) {
        final RowMeta rowMeta = billDataSet.getRowMeta();
        return billDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                for (DraftBillUpdateFieldFunction rowRowMetaDraftBillUpdateFieldFunction : updateFieldFunction) {
                    data = (Object[])rowRowMetaDraftBillUpdateFieldFunction.apply(data, row, rowMeta);
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }
}

