/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.tda.extpoint.finance.IFinanceLeaseSourceInterface;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.enums.FinanceCostTermEnum;
import kd.tmc.tda.common.extpoint.FinanceLeaseSourceDefaultExt;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.common.helper.TdaParameterHelper;

public class FinanceBatchDataHelper {
    private static final Log logger = LogFactory.getLog(FinanceBatchDataHelper.class);
    public static final String SEARCH_PARAM_ALL = "ALL";
    public static final String SEARCH_PARAM_CURRENTYEAR = "CurrentYear";
    public static final String SEARCH_PARAM_CURRENTMONTH = "CurrentMonth";
    private static final String selectfields = "org,case when loantype = 'entrust' or loantype = 'ec' then 2 else case when loantype = 'bond' then 1 else case when ( loantype = 'loan' or loantype = 'sl' ) and creditortype = 'bank' then 0 else 3 end end end as financetype,currency.id as currency,currency.number as currencynumber,drawamount,startintdate,expiredate,term,'' as termname,loanrate,0 as repayedamount,0 as repayamount,creditortype,creditor,0 as creditorinnerorg,loantype,cleardate,id";
    private static final String leaseselectfields = "3 as sourcetype,3 as financetype,assetunit as org,assetunit as company,'' as billno,number as contractno,name as contractname,0 as finproduct,'" + FinanceBatchDataHelper.getSelectfieldsLanguage() + "' as finproductname,'' as creditortype,leaser.name as textcreditor,0 as bankcate,'' as bankcatename,1 as region,'R1' as realregion,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,leaseliab as drawamount,leasestartdate as startintdate,leaseenddate as expiredate,contrsigndate as bizdate,null as firstredeemdate,'' as term,'fixed' as interesttype,'' as basis,discountrate as loanrate,0 as financemode,0 as repayedamount,'' as residueterm,0 as repayamount,leaser.id as creditor,0 as creditorinnerorg,'lease' as loantype,null as cleardate,0 as ratefloatpoint,'' as rateadjustcycletype,0 as rateadjustcycle,discountrate as startloanrate,'' as repaymentway,'' as settleintmode,'' as guarantee,'' as drawway,null as renewalexpiredate,null as rateadjustdate,0L as referencerate,0.0 as referenceratevalue,0 as isrenewal,id";

    protected static String getSelectfieldsLanguage() {
        return ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41", (String)"FinanceFormByDirectDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    public static DataSet getFinanceDataSet(String algoKey, List<Long> allorgids, Date queryDate, Long baseCurrency, Long orgViewId) {
        DataSet result;
        long start = System.currentTimeMillis();
        String cacheKey = FinanceBatchDataHelper.getCacheKey(orgViewId, queryDate);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> FinanceBatchDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs));
            result = result.filter("org in allorgids", Collections.singletonMap("allorgids", allorgids));
        } else {
            result = FinanceBatchDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allorgids);
        }
        result = result.filter("creditorinnerorg not in allorgids", Collections.singletonMap("allorgids", allorgids));
        logger.info("\u878d\u8d44\u53d6\u6570\u8017\u65f6" + algoKey + "cost : " + (System.currentTimeMillis() - start));
        return result;
    }

    public static DataSet getAllViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> allViewOrgs) {
        int yearIndex;
        int monthIndex;
        int allIndex;
        int i;
        boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
        boolean containSettleData = TdaParameterHelper.getFinSettleFinFlag();
        QFilter filter = FinanceBatchDataHelper.getQFilter(allViewOrgs, queryDate, containCompany, containSettleData);
        DataSet idSet = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSetId"), (String)"cfm_loanbill", (String)"id,creditor", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> loanIds = new HashSet<Long>(16);
        HashSet<Long> creditors = new HashSet<Long>(16);
        for (Row row : idSet) {
            loanIds.add(row.getLong("id"));
            creditors.add(row.getLong("creditor"));
        }
        ArrayList<Date> dealDate = new ArrayList<Date>(12);
        dealDate.add(queryDate);
        for (int i2 = 1; i2 < 12; ++i2) {
            Date lastMonthDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)(-i2));
            dealDate.add(lastMonthDate);
        }
        QFilter qFilter = new QFilter("id", "in", creditors);
        DataSet finorginfos = QueryServiceHelper.queryDataSet((String)"FinanceBatchDataHelper.getfinorginfos", (String)"bd_finorginfo", (String)"id,org.id as finorgid", (QFilter[])qFilter.toArray(), null);
        QFilter bizPartnerFilter = new QFilter("id", "in", creditors);
        DataSet bizPartner = QueryServiceHelper.queryDataSet((String)"FinanceBatchDataHelper.getBizPartner", (String)"bd_bizpartner", (String)"id,internal_company.id as finorgid", (QFilter[])bizPartnerFilter.toArray(), null);
        DataSet result = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)"cfm_loanbill", (String)selectfields, (QFilter[])new QFilter[]{filter}, null);
        final RowMeta rowMeta = result.getRowMeta();
        result = result.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String term = row.getString("term");
                int termIndex = rowMeta.getFieldIndex("term", false);
                int termNameIndex = rowMeta.getFieldIndex("termname", false);
                FinanceCostTermEnum financeCostTermEnum = FinanceCostTermEnum.matchExp(term);
                data[termIndex] = String.valueOf(financeCostTermEnum.getIndex());
                data[termNameIndex] = String.valueOf(financeCostTermEnum.getText().getDescription());
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        String expr = "case when currencynumber = '" + CurrencyTypeEnum.CNY.getNumber() + "' then %1$s when currencynumber = '" + CurrencyTypeEnum.USD.getNumber() + "' then %2$s when currencynumber = '" + CurrencyTypeEnum.HKD.getNumber() + "' then %3$s when (currencynumber != '" + CurrencyTypeEnum.CNY.getNumber() + "' and currencynumber != '" + CurrencyTypeEnum.USD.getNumber() + "' and currencynumber != '" + CurrencyTypeEnum.HKD.getNumber() + "') then %4$s end";
        result = result.addFields(new String[]{String.format(expr, "0", "1", "2", "3"), String.format(expr, ResManager.loadKDString((String)"'\u4eba\u6c11\u5e01'", (String)"FinanceBatchDataHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"'\u7f8e\u5143'", (String)"FinanceBatchDataHelper_1", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"'\u6e2f\u5e01'", (String)"FinanceBatchDataHelper_2", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"'\u5176\u4ed6'", (String)"FinanceBatchDataHelper_3", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{"currencysort", "currencytypename"});
        String expr1 = "case when financetype = 0 then '%1$s' when financetype = 1 then '%2$s' when financetype = 2 then '%3$s' when financetype = 3 then '%4$s' end";
        result = result.addField(String.format(expr1, ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceingCostAnalsDataHelper_29", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceingCostAnalsDataHelper_30", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceingCostAnalsDataHelper_31", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceingCostAnalsDataHelper_32", (String)"tmc-tda-report", (Object[])new Object[0])), "financetypename");
        result = result.updateField("creditorinnerorg", "case when creditortype = 'innerunit' then creditor else creditorinnerorg end");
        String[] fieldNames = result.getRowMeta().getFieldNames();
        result = result.leftJoin(finorginfos).on("creditor", "id").select(fieldNames, new String[]{"finorgid"}).finish().updateField("finorgid", "case when finorgid is null then 0 else finorgid end");
        result = result.updateField("creditorinnerorg", "case when  finorgid = 0 then creditorinnerorg else finorgid end");
        result = result.removeFields(new String[]{"finorgid"});
        result = result.leftJoin(bizPartner).on("creditor", "id").select(fieldNames, new String[]{"finorgid"}).finish().updateField("finorgid", "case when finorgid is null then 0 else finorgid end");
        result = result.updateField("creditorinnerorg", "case when  finorgid = 0 then creditorinnerorg else finorgid end");
        result = result.removeFields(new String[]{"finorgid"});
        DataSet[] rateDataSet = FinanceBatchDataHelper.getRateDataSet(loanIds, dealDate);
        DataSet[] repayedDataSet = FinanceBatchDataHelper.getRepayedDataSet(loanIds, dealDate);
        DataSetBuilder[] builders = new DataSetBuilder[36];
        Algo algo = Algo.create((String)"FinanceBatchDataHelper.buildDataSet");
        for (int i3 = 0; i3 < 36; ++i3) {
            builders[i3] = algo.createDataSetBuilder(result.getRowMeta());
        }
        while (result.hasNext()) {
            Row row = result.next();
            for (i = 0; i < dealDate.size(); ++i) {
                Date date = (Date)dealDate.get(i);
                allIndex = i * 3;
                monthIndex = allIndex + 1;
                yearIndex = allIndex + 2;
                Date currentYearFirst = DateUtils.getFirstYearDate((Date)date);
                Date currentYearLast = date;
                Date currentMonthFirst = DateUtils.getFirstDayOfMonth((Date)date);
                Date currentMonthLast = DateUtils.getLastDayOfMonth((Date)date);
                Date startIntDate = row.getDate("startintdate");
                if (DateUtils.getDataFormat((Date)date, (boolean)false).compareTo(startIntDate) < 0 || row.getDate("cleardate") != null && row.getDate("cleardate").compareTo(DateUtils.getDataFormat((Date)date, (boolean)false)) <= 0) continue;
                builders[allIndex].append(row);
                if (startIntDate.compareTo(currentMonthFirst) >= 0 && startIntDate.compareTo(currentMonthLast) <= 0) {
                    builders[monthIndex].append(row);
                }
                if (startIntDate.compareTo(currentYearFirst) < 0 || startIntDate.compareTo(currentYearLast) > 0) continue;
                builders[yearIndex].append(row);
            }
        }
        DataSet[] results = new DataSet[builders.length];
        for (i = 0; i < builders.length; ++i) {
            String[] dateAndParam = FinanceBatchDataHelper.getDateAndParam(i, dealDate);
            results[i] = builders[i].build().addFields(dateAndParam, new String[]{"date", "datestr", "param", "paramname"});
        }
        DataSet[] unionDataSet = new DataSet[dealDate.size()];
        for (int i4 = 0; i4 < dealDate.size(); ++i4) {
            allIndex = i4 * 3;
            monthIndex = allIndex + 1;
            yearIndex = allIndex + 2;
            DataSet leftDataSet = results[allIndex].union(new DataSet[]{results[monthIndex], results[yearIndex]});
            String[] tempFieldName = leftDataSet.getRowMeta().getFieldNames();
            leftDataSet = leftDataSet.leftJoin(rateDataSet[i4]).on("id", "id").select(tempFieldName, new String[]{"yearrate"}).finish().updateField("loanrate", "case when yearrate is null then 0 else yearrate end");
            String[] tempFieldName1 = leftDataSet.getRowMeta().getFieldNames();
            leftDataSet = leftDataSet.leftJoin(repayedDataSet[i4]).on("id", "loanbillid").select(tempFieldName1, new String[]{"erepayamount"}).finish().updateField("repayedamount", "case when erepayamount is null then 0 else erepayamount end");
            boolean contailZeroRate = TdaParameterHelper.getFinZeroRateFlag();
            if (!contailZeroRate) {
                leftDataSet = leftDataSet.filter("loanrate > 0");
            }
            unionDataSet[i4] = leftDataSet = AmountTransHelper.tranDataSetRate((DataSet)leftDataSet, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Arrays.asList("repayamount", "drawamount", "repayedamount").stream().collect(Collectors.toSet()), (Date)((Date)dealDate.get(i4)));
        }
        DataSet costResult = unionDataSet[0].union(new DataSet[]{unionDataSet[1], unionDataSet[2], unionDataSet[3], unionDataSet[4], unionDataSet[5], unionDataSet[6], unionDataSet[7], unionDataSet[8], unionDataSet[9], unionDataSet[10], unionDataSet[11]});
        costResult = costResult.updateField("repayamount", "drawamount - repayedamount");
        return costResult;
    }

    private static String[] getDateAndParam(int i, List<Date> dealDate) {
        String[] dateAndParam = new String[4];
        dateAndParam[0] = "'" + DateUtils.formatString((Date)dealDate.get(i / 3), (String)"yyyy-MM-dd") + "'";
        dateAndParam[1] = "'" + DateUtils.formatString((Date)dealDate.get(i / 3), (String)"yyyyMM") + "'";
        String param = "";
        String paramname = "";
        if (i % 3 == 0) {
            param = "'ALL'";
            paramname = ResManager.loadKDString((String)"'\u5b58\u91cf\u6570\u636e'", (String)"FinanceingCostAnalsDataHelper_21", (String)"tmc-tda-report", (Object[])new Object[0]);
        } else if (i % 3 == 1) {
            param = "'CurrentMonth'";
            paramname = ResManager.loadKDString((String)"'\u672c\u6708\u65b0\u589e'", (String)"FinanceingCostAnalsDataHelper_23", (String)"tmc-tda-report", (Object[])new Object[0]);
        } else if (i % 3 == 2) {
            param = "'CurrentYear'";
            paramname = ResManager.loadKDString((String)"'\u672c\u5e74\u65b0\u589e'", (String)"FinanceingCostAnalsDataHelper_22", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        dateAndParam[2] = param;
        dateAndParam[3] = paramname;
        return dateAndParam;
    }

    private static DataSet[] getRateDataSet(Set<Long> loanIds, List<Date> dealDate) {
        QFilter qFilter = new QFilter("id", "in", loanIds);
        qFilter.and("rateadjust_entry.ra_effectdate", "<=", (Object)dealDate.get(0));
        DataSet resetRateBillSet = QueryServiceHelper.queryDataSet((String)"FinanceBatchDataHelpercovertLoanRate", (String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_yearrate as yearrate,rateadjust_entry.ra_effectdate as effectdate", (QFilter[])qFilter.toArray(), null);
        resetRateBillSet = resetRateBillSet.addField("TO_CHAR(effectdate,'yyyyMMdd')", "effectdatestr");
        DataSet[] result = new DataSet[dealDate.size()];
        String[] splitStrings = FinanceBatchDataHelper.getRateSplitString(dealDate);
        DataSet[] splitRate = resetRateBillSet.splitByFilter(splitStrings, false);
        for (int i = 0; i < splitRate.length; ++i) {
            DataSet[] tempRateDate = splitRate[i].splitByFilter(new String[]{"true", "true"}, false);
            DataSet lastRateDate = tempRateDate[0].select("id,effectdate").groupBy(new String[]{"id"}).max("effectdate").finish();
            result[i] = lastRateDate.leftJoin(tempRateDate[1]).on("id", "id").on("effectdate", "effectdate").select(new String[]{"id", "effectdate"}, new String[]{"yearrate"}).finish();
        }
        return result;
    }

    private static String[] getRateSplitString(List<Date> dealDate) {
        String[] result = new String[dealDate.size()];
        for (int i = 0; i < dealDate.size(); ++i) {
            result[i] = "effectdatestr <= " + DateUtils.formatString((Date)dealDate.get(i), (String)"yyyyMMdd");
        }
        return result;
    }

    private static DataSet[] getRepayedDataSet(Set<Long> loanIds, List<Date> dealDate) {
        QFilter qFilter = new QFilter("loans.e_loanbill", "in", loanIds);
        qFilter.and("bizdate", "<=", (Object)dealDate.get(0));
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repaymentBills = QueryServiceHelper.queryDataSet((String)"FinanceBatchDataHelpercovertRepayedAmount", (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill as loanbillid,loans.e_repayamount as erepayamount,bizdate", (QFilter[])qFilter.toArray(), null);
        repaymentBills = repaymentBills.addField("TO_CHAR(bizdate,'yyyyMMdd')", "bizdatestr");
        DataSet[] result = new DataSet[dealDate.size()];
        String[] splitStrings = FinanceBatchDataHelper.getRepayedSplitString(dealDate);
        DataSet[] splitRepayed = repaymentBills.splitByFilter(splitStrings, false);
        for (int i = 0; i < splitRepayed.length; ++i) {
            result[i] = splitRepayed[i].select("loanbillid,erepayamount").groupBy(new String[]{"loanbillid"}).sum("erepayamount").finish();
        }
        return result;
    }

    private static String[] getRepayedSplitString(List<Date> dealDate) {
        String[] result = new String[dealDate.size()];
        for (int i = 0; i < dealDate.size(); ++i) {
            result[i] = "bizdatestr <= " + DateUtils.formatString((Date)dealDate.get(i), (String)"yyyyMMdd");
        }
        return result;
    }

    public static String getLeaseFormId() {
        FinanceLeaseSourceDefaultExt leaseFormId = new FinanceLeaseSourceDefaultExt();
        PluginProxy pluginProxy = PluginProxy.create((Object)leaseFormId, IFinanceLeaseSourceInterface.class, (String)"kd.sdk.tmc.tda.extpoint.finance.leasecontract", null);
        List result = pluginProxy.callReplaceIfPresent(p -> p.getFormId());
        return (String)result.get(0);
    }

    public static QFilter getQFilter(List<Long> allorgids, Date queryDate, boolean containCompany, boolean containSettleData) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("finproduct.equitytool", "=", (Object)Boolean.FALSE);
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat((Date)DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-11), (boolean)false)).or(new QFilter("cleardate", "is null", null)));
        QFilter bankFilter = new QFilter("loantype", "in", Arrays.asList("loan", "sl"));
        if (!containSettleData) {
            bankFilter.and("creditortype", "!=", (Object)"settlecenter");
        }
        QFilter companyFilter = new QFilter("loantype", "in", Arrays.asList("entrust", "ec"));
        QFilter bonfFilter = new QFilter("loantype", "=", (Object)"bond");
        QFilter loadTypeFilter = containCompany ? bankFilter.or(companyFilter).or(bonfFilter) : bankFilter.or(bonfFilter);
        return qFilter.and(loadTypeFilter);
    }

    public static QFilter getLeaseQfilter(List<Long> allorgids, Date queryDate) {
        QFilter qFilter = new QFilter("assetunit", "in", allorgids);
        qFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("leasestartdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and("leaseliab", ">", (Object)BigDecimal.ZERO);
        QFilter endDateFilter = new QFilter("leaseterminationdate", ">", (Object)queryDate).or("leaseterminationdate", "is null", null);
        qFilter.and(endDateFilter);
        return qFilter;
    }

    public static String getCacheKey(Long orgviewId, Date queryDate) {
        return "financeBatchDataHelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }
}

