/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.FinanceCostCommonHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.tda.finance.FinCostRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.common.helper.TdaParameterHelper;

public class FinanceCostDataHelper {
    private static final Log logger = LogFactory.getLog(FinanceCostDataHelper.class);

    public static DataSet getFinanceDataSet(String algoKey, List<Long> allorgids, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId, List<Object[]> dateList) {
        return FinanceCostDataHelper.getFinanceDataSet(algoKey, allorgids, queryDate, baseCurrency, orgViewId, orgId, dateList, false);
    }

    public static DataSet getFinanceDataSet(String algoKey, List<Long> allorgids, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId, List<Object[]> dateList, boolean splitBankCate) {
        DataSet result;
        long start = System.currentTimeMillis();
        String cacheKey = FinanceCostDataHelper.getCacheKey(orgViewId, queryDate);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
        boolean containSettle = TdaParameterHelper.getFinSettleFinFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> FinanceCostCommonHelper.getAllViewData((FinCostRequest)new FinCostRequest(algoKey, queryDate, baseCurrency, orgViewId, dateList, FinanceCostCommonHelper.getQFilter((List)allViewOrgs, (Date)((Date)((Object[])dateList.get(0))[0]), (Date)((Date)((Object[])dateList.get(dateList.size() - 1))[1]), (boolean)containCompany, (boolean)containSettle), FinanceCostCommonHelper.getLeaseQFilter((List)allViewOrgs, (Date)((Date)((Object[])dateList.get(0))[0]), (Date)((Date)((Object[])dateList.get(dateList.size() - 1))[1])))));
            result = result.filter("orgid in allorgids", Collections.singletonMap("allorgids", allorgids));
            if (!containCompany) {
                result = result.filter("financetype != 2");
            }
        } else {
            result = FinanceCostCommonHelper.getAllViewData((FinCostRequest)new FinCostRequest(algoKey, queryDate, baseCurrency, orgViewId, dateList, FinanceCostCommonHelper.getQFilter(allorgids, (Date)((Date)dateList.get(0)[0]), (Date)((Date)dateList.get(dateList.size() - 1)[1]), (boolean)containCompany, (boolean)containSettle), FinanceCostCommonHelper.getLeaseQFilter(allorgids, (Date)((Date)dateList.get(0)[0]), (Date)((Date)dateList.get(dateList.size() - 1)[1]))));
        }
        if (splitBankCate) {
            long splitBankStartTime = System.currentTimeMillis();
            result = FinanceCostCommonHelper.splitBankcateData((QFilter)FinanceCostCommonHelper.getSlQFilter(allorgids, (Date)((Date)dateList.get(0)[0]), (Date)((Date)dateList.get(dateList.size() - 1)[1])), (DataSet)result);
            logger.info("\u94f6\u56e2\u53d6\u6570\u8017\u65f6\uff1a" + (System.currentTimeMillis() - splitBankStartTime));
        }
        logger.info("\u878d\u8d44\u6210\u672c\u53d6\u6570\u8017\u65f6" + algoKey + orgViewId + "cost : " + (System.currentTimeMillis() - start));
        return result;
    }

    public static DataSet getFinanceMergeDataSet(DataSet result, DataSet orgDateSet, Long orgId) {
        result = result.addField("company", "org");
        result = result.addFields(new String[]{"0.0", "0.0"}, new String[]{MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
        DataSet[] splitMergeDataSet = result.splitByFilter(new String[]{"creditorinnerorg = 0"}, true);
        result = splitMergeDataSet[0];
        DataSet mergeDataSet = MergeOffsetHandler.addMergeOffsetField(splitMergeDataSet[1], orgDateSet, "avgbalance", orgId);
        result = result.union(mergeDataSet.select(result.getRowMeta().getFieldNames()));
        return result;
    }

    public static String getCacheKey(Long orgviewId, Date queryDate) {
        return "financeCostDataHelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }
}

