/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.common.helper.TdaParameterHelper;

public class FinanceEquityDataHelper {
    private static final Log logger = LogFactory.getLog(FinanceEquityDataHelper.class);
    private static final String selectfields = "org,currency,drawamount,loanrate,bizdate,startintdate,cleardate,firstredeemdate,0 as repayedamount,0 as repayamount,id";

    public static DataSet getFinanceDataSet(String algoKey, List<Long> allorgids, Date queryDate, Long baseCurrency, Long orgViewId) {
        DataSet result;
        long start = System.currentTimeMillis();
        String cacheKey = FinanceEquityDataHelper.getCacheKey(orgViewId, queryDate);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> FinanceEquityDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs));
            result = result.filter("org in allorgids", Collections.singletonMap("allorgids", allorgids));
        } else {
            result = FinanceEquityDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allorgids);
        }
        logger.info("\u878d\u8d44\u53d6\u6570\u8017\u65f6" + algoKey + "cost : " + (System.currentTimeMillis() - start));
        return result;
    }

    public static DataSet getAllViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> allViewOrgs) {
        int i;
        boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
        boolean containSettleData = TdaParameterHelper.getFinSettleFinFlag();
        QFilter filter = FinanceEquityDataHelper.getQFilter(allViewOrgs, queryDate, containCompany, containSettleData);
        DataSet idSet = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSetId"), (String)"cfm_loanbill", (String)"id,currency", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> loanIds = new HashSet<Long>(16);
        HashSet<Long> currencys = new HashSet<Long>(16);
        ArrayList<Object[]> currencyRow = new ArrayList<Object[]>(10);
        for (Row row : idSet) {
            loanIds.add(row.getLong("id"));
            Long currency = row.getLong("currency");
            if (!currencys.add(currency)) continue;
            currencyRow.add(new Object[]{currency});
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"currency"}, (DataType[])new DataType[]{DataType.LongType});
        CollectionInput inputs = new CollectionInput(rowMeta, currencyRow);
        ArrayList<Date> dealDate = new ArrayList<Date>(12);
        dealDate.add(queryDate);
        Date lastMonthDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-1);
        dealDate.add(lastMonthDate);
        String lastMonthDateString = DateUtils.formatString((Date)lastMonthDate, (String)"yyyyMMdd");
        Date lastYearSameDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-12);
        String lastYearSameDateString = DateUtils.formatString((Date)lastYearSameDate, (String)"yyyyMMdd");
        Date lastYearDate = DateUtils.getLastYearDate((Date)lastYearSameDate);
        String lastYearDateString = DateUtils.formatString((Date)lastYearDate, (String)"yyyyMMdd");
        if (!lastYearSameDateString.equals(lastYearDateString) && !lastMonthDateString.equals(lastYearDateString)) {
            dealDate.add(lastYearDate);
        }
        dealDate.add(lastYearSameDate);
        DataSet result = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)"cfm_loanbill", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("id", "in", loanIds)}, null);
        DataSet[] rateDataSet = FinanceEquityDataHelper.getRateDataSet(loanIds, dealDate);
        DataSet[] repayedDataSet = FinanceEquityDataHelper.getRepayedDataSet(loanIds, dealDate);
        DataSetBuilder[] builders = new DataSetBuilder[dealDate.size()];
        Algo algo = Algo.create((String)"FinanceEquityDataHelper.buildDataSet");
        for (int i2 = 0; i2 < dealDate.size(); ++i2) {
            builders[i2] = algo.createDataSetBuilder(result.getRowMeta());
        }
        while (result.hasNext()) {
            Row row = result.next();
            for (i = 0; i < dealDate.size(); ++i) {
                Date date = (Date)dealDate.get(i);
                Date startIntDate = row.getDate("startintdate");
                if (DateUtils.getDataFormat((Date)date, (boolean)false).compareTo(startIntDate) < 0 || row.getDate("cleardate") != null && row.getDate("cleardate").compareTo(DateUtils.getDataFormat((Date)date, (boolean)false)) <= 0) continue;
                builders[i].append(row);
            }
        }
        DataSet[] results = new DataSet[builders.length];
        for (i = 0; i < builders.length; ++i) {
            results[i] = builders[i].build().addField("'" + DateUtils.formatString((Date)((Date)dealDate.get(i)), (String)"yyyyMMdd") + "'", "datestring");
        }
        DataSet[] unionDataSet = new DataSet[dealDate.size()];
        for (int i3 = 0; i3 < dealDate.size(); ++i3) {
            DataSet leftDataSet = results[i3];
            String[] tempFieldName = leftDataSet.getRowMeta().getFieldNames();
            leftDataSet = leftDataSet.leftJoin(rateDataSet[i3]).on("id", "id").select(tempFieldName, new String[]{"yearrate"}).finish().updateField("loanrate", "case when yearrate is null then 0 else yearrate end");
            String[] tempFieldName1 = leftDataSet.getRowMeta().getFieldNames();
            leftDataSet = leftDataSet.leftJoin(repayedDataSet[i3]).on("id", "loanbillid").select(tempFieldName1, new String[]{"erepayamount"}).finish().updateField("repayedamount", "case when erepayamount is null then 0 else erepayamount end");
            boolean contailZeroRate = TdaParameterHelper.getFinZeroRateFlag();
            if (!contailZeroRate) {
                leftDataSet = leftDataSet.filter("loanrate > 0");
            }
            DataSet currencyDs = Algo.create((String)"financequityhelper.new").createDataSet(new Input[]{inputs});
            unionDataSet[i3] = leftDataSet = AmountTransHelper.tranDataSetRate((DataSet)leftDataSet, (DataSet)currencyDs, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Arrays.asList("repayamount", "drawamount", "repayedamount").stream().collect(Collectors.toSet()), (Date)((Date)dealDate.get(i3)));
        }
        DataSet costResult = dealDate.size() == 4 ? unionDataSet[0].union(new DataSet[]{unionDataSet[1], unionDataSet[2], unionDataSet[3]}) : unionDataSet[0].union(new DataSet[]{unionDataSet[1], unionDataSet[2]});
        costResult = costResult.updateField("repayamount", "drawamount - repayedamount");
        return costResult;
    }

    private static DataSet[] getRateDataSet(Set<Long> loanIds, List<Date> dealDate) {
        QFilter qFilter = new QFilter("id", "in", loanIds);
        qFilter.and("rateadjust_entry.ra_effectdate", "<=", (Object)dealDate.get(0));
        DataSet resetRateBillSet = QueryServiceHelper.queryDataSet((String)"FinanceBatchDataHelpercovertLoanRate", (String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_yearrate as yearrate,rateadjust_entry.ra_effectdate as effectdate", (QFilter[])qFilter.toArray(), null);
        resetRateBillSet = resetRateBillSet.addField("TO_CHAR(effectdate,'yyyyMMdd')", "effectdatestr");
        DataSet[] result = new DataSet[dealDate.size()];
        String[] splitStrings = FinanceEquityDataHelper.getRateSplitString(dealDate);
        DataSet[] splitRate = resetRateBillSet.splitByFilter(splitStrings, false);
        for (int i = 0; i < splitRate.length; ++i) {
            DataSet[] tempRateDate = splitRate[i].splitByFilter(new String[]{"true", "true"}, false);
            DataSet lastRateDate = tempRateDate[0].select("id,effectdate").groupBy(new String[]{"id"}).max("effectdate").finish();
            result[i] = lastRateDate.leftJoin(tempRateDate[1]).on("id", "id").on("effectdate", "effectdate").select(new String[]{"id", "effectdate"}, new String[]{"yearrate"}).finish();
        }
        return result;
    }

    private static String[] getRateSplitString(List<Date> dealDate) {
        String[] result = new String[dealDate.size()];
        for (int i = 0; i < dealDate.size(); ++i) {
            result[i] = "effectdatestr <= " + DateUtils.formatString((Date)dealDate.get(i), (String)"yyyyMMdd");
        }
        return result;
    }

    private static DataSet[] getRepayedDataSet(Set<Long> loanIds, List<Date> dealDate) {
        QFilter qFilter = new QFilter("loans.e_loanbill", "in", loanIds);
        qFilter.and("bizdate", "<=", (Object)dealDate.get(0));
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repaymentBills = QueryServiceHelper.queryDataSet((String)"FinanceBatchDataHelpercovertRepayedAmount", (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill as loanbillid,loans.e_repayamount as erepayamount,bizdate", (QFilter[])qFilter.toArray(), null);
        repaymentBills = repaymentBills.addField("TO_CHAR(bizdate,'yyyyMMdd')", "bizdatestr");
        DataSet[] result = new DataSet[dealDate.size()];
        String[] splitStrings = FinanceEquityDataHelper.getRepayedSplitString(dealDate);
        DataSet[] splitRepayed = repaymentBills.splitByFilter(splitStrings, false);
        for (int i = 0; i < splitRepayed.length; ++i) {
            result[i] = splitRepayed[i].select("loanbillid,erepayamount").groupBy(new String[]{"loanbillid"}).sum("erepayamount").finish();
        }
        return result;
    }

    private static String[] getRepayedSplitString(List<Date> dealDate) {
        String[] result = new String[dealDate.size()];
        for (int i = 0; i < dealDate.size(); ++i) {
            result[i] = "bizdatestr <= " + DateUtils.formatString((Date)dealDate.get(i), (String)"yyyyMMdd");
        }
        return result;
    }

    public static QFilter getQFilter(List<Long> allorgids, Date queryDate, boolean containCompany, boolean containSettleData) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("finproduct.equitytool", "=", (Object)Boolean.TRUE);
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat((Date)DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-12), (boolean)false)).or(new QFilter("cleardate", "is null", null)));
        QFilter bankFilter = new QFilter("loantype", "in", Arrays.asList("loan", "sl"));
        if (!containSettleData) {
            bankFilter.and("creditortype", "!=", (Object)"settlecenter");
        }
        QFilter companyFilter = new QFilter("loantype", "in", Arrays.asList("entrust", "ec"));
        QFilter bonfFilter = new QFilter("loantype", "=", (Object)"bond");
        QFilter loadTypeFilter = containCompany ? bankFilter.or(companyFilter).or(bonfFilter) : bankFilter.or(bonfFilter);
        return qFilter.and(loadTypeFilter);
    }

    public static String getCacheKey(Long orgviewId, Date queryDate) {
        return "financeEquityDataHelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }
}

