/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.tda.common.helper.AbstractFinanceFieldConvert;

public class FinanceFieldCompanyConvert
extends AbstractFinanceFieldConvert {
    public FinanceFieldCompanyConvert(DataSet source, Date queryDate) {
        super(source, queryDate);
    }

    @Override
    protected DataSet covertSourceType(DataSet source) {
        return source.updateField("sourcetype", "2");
    }

    @Override
    protected DataSet covertFinanceType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertOutGroup(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        HashSet<Long> ids = new HashSet<Long>(16);
        Iterator iterator = source.copy().select("creditor").groupBy(new String[]{"creditor"}).finish().iterator();
        while (iterator.hasNext()) {
            ids.add(((Row)iterator.next()).getLong("creditor"));
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DataSet finorginfos = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertOutGroup"), (String)"bd_bizpartner", (String)"id,internal_company.id as finorgid", (QFilter[])qFilter.toArray(), null);
        source = source.leftJoin(finorginfos).on("creditor", "id").select(fieldNames, new String[]{"finorgid"}).finish().updateField("finorgid", "case when finorgid is null then 0 else finorgid end");
        source = source.addField("case when creditortype = 'other' or (creditortype = 'custom' and finorgid = 0) then 1 else 0 end", "isoutgroup");
        source = source.updateField("creditorinnerorg", "finorgid");
        source = source.updateField("creditorinnerorg", "case when creditortype = 'innerunit' then creditor else creditorinnerorg end");
        source = source.removeFields(new String[]{"finorgid"});
        return source;
    }

    @Override
    protected DataSet covertBankCate(DataSet source) {
        source = source.addField("0", "bankcate");
        source = source.addField("''", "bankcatename");
        return source;
    }

    @Override
    protected DataSet covertRegion(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertDrawAmount(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertStartIntDate(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertInterestType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertBasis(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertFinanceMode(DataSet source) {
        source = source.addField("1", "financemode");
        return source;
    }

    @Override
    protected DataSet covertResidueTerm(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertCreditortype(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertTextCreditor(DataSet source) {
        return source;
    }

    @Override
    protected DataSet afterConvert(DataSet source) {
        if (this.containZeroRate) {
            return source;
        }
        return source.filter("loanrate > 0");
    }
}

