/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.tda.common.helper.AbstractFinanceFieldConvert;

public class FinanceFieldLeaseConvert
extends AbstractFinanceFieldConvert {
    public FinanceFieldLeaseConvert(DataSet source, Date queryDate) {
        super(source, queryDate);
    }

    @Override
    protected DataSet covertSourceType(DataSet source) {
        return source.updateField("sourcetype", "3");
    }

    @Override
    protected DataSet covertFinanceType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertOutGroup(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        HashSet<Long> ids = new HashSet<Long>(16);
        Iterator iterator = source.copy().select("creditor").groupBy(new String[]{"creditor"}).finish().iterator();
        while (iterator.hasNext()) {
            ids.add(((Row)iterator.next()).getLong("creditor"));
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DataSet finorginfos = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertOutGroup"), (String)"bd_finorginfo", (String)"id,org.id as finorgid,bank_cate.id as bankcate,bank_cate.name as bankcatename,finorgtype.type as banktype", (QFilter[])qFilter.toArray(), null);
        source = source.leftJoin(finorginfos).on("creditor", "id").select(fieldNames, new String[]{"finorgid", "bankcate", "bankcatename"}).finish().updateFields(new String[]{"finorgid", "bankcate"}, new String[]{"case when finorgid is null then 0 else finorgid end", "case when bankcate is null then 0 else bankcate end"});
        source = source.addField("case when  finorgid > 0 then 0 else 1 end", "isoutgroup");
        source = source.updateField("creditorinnerorg", "finorgid");
        source = source.updateField("bankcate", "case when creditortype = 'bank'  then bankcate else 0 end");
        source = source.removeFields(new String[]{"finorgid"});
        return source;
    }

    @Override
    protected DataSet covertCreditortype(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertBankCate(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertLoanRate(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        QFilter qFilter = new QFilter("loancontractbill", "in", (Object)this.ids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet receiptBillSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertLoanRate"), (String)"fl_receiptbill", (String)"id,loancontractbill", (QFilter[])qFilter.toArray(), null);
        receiptBillSet = receiptBillSet.groupBy(new String[]{"loancontractbill"}).max("id").finish();
        HashSet<Long> loanBillId = new HashSet<Long>(16);
        for (Row row : receiptBillSet) {
            loanBillId.add(row.getLong("id"));
        }
        QFilter loanFilter = new QFilter("id", "in", loanBillId);
        loanFilter.and("rateadjust_entry.ra_effectdate", "<=", (Object)this.queryDate);
        DataSet resetRateBillSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertLoanRate"), (String)"fl_receiptbill", (String)"loancontractbill,rateadjust_entry.ra_yearrate as yearrate,rateadjust_entry.ra_effectdate as effectdate", (QFilter[])loanFilter.toArray(), null);
        DataSet lastRateDate = resetRateBillSet.copy().select("loancontractbill,effectdate").groupBy(new String[]{"loancontractbill"}).max("effectdate").finish();
        resetRateBillSet = lastRateDate.leftJoin(resetRateBillSet).on("loancontractbill", "loancontractbill").on("effectdate", "effectdate").select(new String[]{"loancontractbill", "effectdate"}, new String[]{"yearrate"}).finish();
        source = source.leftJoin(resetRateBillSet).on("id", "loancontractbill").select(fieldNames, new String[]{"yearrate"}).finish().updateField("loanrate", "case when yearrate is null then 0 else yearrate end");
        source = source.removeFields(new String[]{"yearrate"});
        return source;
    }

    @Override
    protected DataSet covertRepayedAmount(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        QFilter qFilter = new QFilter("loancontractbill", "in", (Object)this.ids);
        qFilter.and("bizdate", "<=", (Object)this.queryDate);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repaymentBills = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertRepayedAmount"), (String)"fl_rentpaybill", (String)"loancontractbill,amount", (QFilter[])qFilter.toArray(), null);
        repaymentBills = repaymentBills.select("loancontractbill,amount").groupBy(new String[]{"loancontractbill"}).sum("amount").finish();
        source = source.leftJoin(repaymentBills).on("id", "loancontractbill").select(fieldNames, new String[]{"amount"}).finish().updateField("repayedamount", "case when amount is null then 0 else amount end");
        source = source.removeFields(new String[]{"amount"});
        return source;
    }

    @Override
    protected DataSet covertRegion(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertDrawAmount(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertStartIntDate(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertExpireDate(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertInterestType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertBasis(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertFinanceMode(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertResidueTerm(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertTextCreditor(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertIsEquity(DataSet source) {
        return source.addField("false", "isequity");
    }

    @Override
    protected DataSet covertPerpetualbond(DataSet source) {
        return source.addField("false", "perpetualbond");
    }

    @Override
    protected DataSet afterConvert(DataSet source) {
        return source;
    }
}

