/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.helper.RepayPlanHelper;
import kd.tmc.tda.common.helper.SysParamHelper;

public class FinanceInterestBearLiaDisDatahelper {
    public static DataSet getInterstBearLiaDisDataSet(String algoKey, List<Long> allorgids, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId, DataSet orgDateSet) {
        DataSet result;
        String cacheKey = FinanceInterestBearLiaDisDatahelper.getCacheKey(orgViewId, queryDate);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> FinanceInterestBearLiaDisDatahelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs));
            result = result.filter("org in allorgids", Collections.singletonMap("allorgids", allorgids));
        } else {
            result = FinanceInterestBearLiaDisDatahelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allorgids);
        }
        if (orgDateSet == null) {
            orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        }
        DataSet[] splitMergeDataSet = result.splitByFilter(new String[]{"creditorinnerorg = 0"}, true);
        result = splitMergeDataSet[0];
        DataSet mergeDataSet = MergeOffsetHandler.addMergeOffsetField(splitMergeDataSet[1], orgDateSet, "repayamount", orgId);
        result = result.union(mergeDataSet.select(result.getRowMeta().getFieldNames()));
        return result;
    }

    private static DataSet getAllViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> allViewOrgs) {
        DataSet ds = FinanceDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs);
        DataSet[] dataSets = ds.splitByFilter(new String[]{"sourcetype=3"}, true);
        DataSet leaseDs = RepayPlanHelper.handleRepayPlan(algoKey, queryDate, baseCurrency, orgViewId, dataSets[0], FinanceDataHelper.getLeaseFormId());
        DataSet loanDs = RepayPlanHelper.handleRepayPlan(algoKey, queryDate, baseCurrency, orgViewId, dataSets[1]);
        return leaseDs.union(loanDs);
    }

    public static String getCacheKey(Long orgviewId, Date queryDate) {
        return "financeInterestBearLiaDisDatahelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }
}

