/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.helper.SysParamHelper;

public class InterCompanyLoansDataHelper {
    private static final Log logger = LogFactory.getLog(InterCompanyLoansDataHelper.class);
    private static final String DEBT_FIELDS = "case when loantype = 'entrust' or loantype = 'ec' then 1 else 0 end as sourcetype,org,org as company,billno,contractno,contractname,finproduct.id as finproduct,finproduct.name as finproductname,finproduct.equitytool as isequity,creditortype,textcreditor,0 as isoutgroup,case when region = 'R1' then 1 else 0 end as region,region as realregion,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,drawamount,startintdate,expiredate,bizdate,firstredeemdate,firstredeemterm,term,interesttype,basis,loanrate,0 as repayedamount,'' as residueterm,0 as repayamount,finproduct.perpetualbond as perpetualbond,creditor,0L as creditorinnerorg,loantype,cleardate,ratefloatpoint,rateadjustcycletype,rateadjustcycle,startloanrate,repaymentway,settleintmode,loancontractbill.guarantee as guarantee,drawway,renewalexpiredate,rateadjustdate,referencerate,0.0 as referenceratevalue,case when renewalexpiredate is null then 0 else 1 end as isrenewal,id";
    private static final String IFM_CREDIT_FIELDS = "3 as sourcetype,org,creditorg as company,billno,contractno,contractname,finproduct.id as finproduct,finproduct.name as finproductname,finproduct.equitytool as isequity,debtortype,debtor,textdebtor,creditortype,textcreditor,0 as isoutgroup,case when region = 'R1' then 1 else 0 end as region,region as realregion,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,drawamount,startintdate,expiredate,bizdate,firstredeemdate,firstredeemterm,term,interesttype,basis,loanrate,0 as repayedamount,'' as residueterm,0 as repayamount,finproduct.perpetualbond as perpetualbond,creditorg as creditor,org as creditorinnerorg,loantype,cleardate,ratefloatpoint,rateadjustcycletype,rateadjustcycle,startloanrate,repaymentway,settleintmode,loancontractbill.guarantee as guarantee,drawway,renewalexpiredate,rateadjustdate,referencerate,0.0 as referenceratevalue,case when renewalexpiredate is null then 0 else 1 end as isrenewal,id";
    private static final String INVEST_CREDIT_FIELDS = "2 as sourcetype,org,creditorg as company,billno,contractno,contractname,finproduct.id as finproduct,finproduct.name as finproductname,finproduct.equitytool as isequity,debtortype,debtor,textdebtor,creditortype,textcreditor,0 as isoutgroup,case when region = 'R1' then 1 else 0 end as region,region as realregion,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,drawamount,startintdate,expiredate,bizdate,firstredeemdate,firstredeemterm,term,interesttype,basis,loanrate,0 as repayedamount,'' as residueterm,0 as repayamount,finproduct.perpetualbond as perpetualbond,creditorg as creditor,org as creditorinnerorg,loantype,cleardate,ratefloatpoint,rateadjustcycletype,rateadjustcycle,startloanrate,repaymentway,settleintmode,loancontractbill.guarantee as guarantee,drawway,renewalexpiredate,rateadjustdate,referencerate,0.0 as referenceratevalue,case when renewalexpiredate is null then 0 else 1 end as isrenewal,id";

    public static DataSet getInterCompanyLoanData(String algoKey, List<Long> allOrgIds, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId, DataSet orgDateSet, boolean isDebit) {
        return InterCompanyLoansDataHelper.getInterCompanyLoanData(algoKey, allOrgIds, queryDate, baseCurrency, orgViewId, orgId, orgDateSet, isDebit, "outgroup");
    }

    public static DataSet getInterCompanyLoanData(String algoKey, List<Long> allOrgIds, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId, DataSet orgDateSet, boolean isDebit, String comLoanRange) {
        DataSet result;
        String cacheKey = InterCompanyLoansDataHelper.getCacheKey(orgViewId, queryDate, isDebit);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> InterCompanyLoansDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs, isDebit));
            result = isDebit ? result.filter("org in allorgids", Collections.singletonMap("allorgids", allOrgIds)) : result.filter("creditor in allorgids", Collections.singletonMap("allorgids", allOrgIds));
        } else {
            result = InterCompanyLoansDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allOrgIds, isDebit);
        }
        if ("outgroup".equals(comLoanRange)) {
            DataSet[] splitMergeDataSet = result.splitByFilter(new String[]{"creditorinnerorg = 0"}, true);
            result = splitMergeDataSet[0];
            DataSet mergeDataSet = isDebit ? MergeOffsetHandler.addMergeOffsetField(splitMergeDataSet[1], orgDateSet, "repayamount", orgId) : MergeOffsetHandler.addMergeOffsetField(splitMergeDataSet[1], orgDateSet, "repayamount", orgId, "creditor");
            result = result.union(mergeDataSet.select(result.getRowMeta().getFieldNames()));
        } else if ("ingroup".equals(comLoanRange)) {
            result = result.filter("isoutgroup = 0");
        }
        return result;
    }

    public static DataSet getAllViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> allViewOrgs, boolean isDebit) {
        if (isDebit) {
            return InterCompanyLoansDataHelper.getDebitAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs);
        }
        return InterCompanyLoansDataHelper.getCreditAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs);
    }

    public static DataSet getCreditAllViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> allViewOrgs) {
        QFilter ifmQFilter = InterCompanyLoansDataHelper.getIfmQFilter(allViewOrgs, queryDate);
        DataSet ifmDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)"ifm_loanbill", (String)IFM_CREDIT_FIELDS, (QFilter[])new QFilter[]{ifmQFilter}, null);
        QFilter investFilter = InterCompanyLoansDataHelper.getInvestQFilter(allViewOrgs, queryDate);
        DataSet investDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)"ifm_loanbill", (String)INVEST_CREDIT_FIELDS, (QFilter[])new QFilter[]{investFilter}, null);
        HashSet<Long> loanIds = new HashSet<Long>(16);
        HashSet<Long> companyCreditor = new HashSet<Long>(16);
        for (Row row : ifmDataSet.copy().select("id").groupBy(new String[]{"id"}).finish()) {
            loanIds.add(row.getLong("id"));
        }
        for (Row row : investDataSet.copy().select("id,debtor").groupBy(new String[]{"id", "debtor"}).finish()) {
            loanIds.add(row.getLong("id"));
            companyCreditor.add(row.getLong("debtor"));
        }
        QFilter companyFilter = new QFilter("id", "in", companyCreditor);
        DataSet partnerDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "getBizpartner"), (String)"bd_bizpartner", (String)"id,internal_company.id as finorgid", (QFilter[])companyFilter.toArray(), null);
        String[] settleFieldNames = investDataSet.getRowMeta().getFieldNames();
        investDataSet = investDataSet.leftJoin(partnerDataSet).on("debtor", "id").select(settleFieldNames, new String[]{"finorgid"}).finish();
        investDataSet = investDataSet.updateField("finorgid", "case when finorgid is null then 0 else finorgid end");
        investDataSet = investDataSet.updateField("creditorinnerorg", "case when debtortype = 'innerunit' then creditorinnerorg else finorgid end");
        investDataSet = investDataSet.removeFields(new String[]{"finorgid"});
        DataSet result = ifmDataSet.union(investDataSet);
        return InterCompanyLoansDataHelper.handleFiled(algoKey, queryDate, baseCurrency, orgViewId, loanIds, result);
    }

    private static DataSet handleFiled(String algoKey, final Date queryDate, Long baseCurrency, Long orgViewId, Set<Long> loanIds, DataSet result) {
        String[] resultFieldNames = result.getRowMeta().getFieldNames();
        QFilter extendFilter = new QFilter("loanbilllist.drawbillid", "in", loanIds);
        extendFilter.and("bizdate", "<=", (Object)queryDate);
        DataSet extendBillSet = QueryServiceHelper.queryDataSet((String)(algoKey + "covertExpireDate"), (String)"cfm_contractextendbill", (String)"contractbillno,loanbilllist.drawbillid as loanbillid,loanbilllist.lrenewalexpiredate as lrenewalexpiredate", (QFilter[])extendFilter.toArray(), null);
        extendBillSet = extendBillSet.select("loanbillid,lrenewalexpiredate").groupBy(new String[]{"loanbillid"}).max("lrenewalexpiredate").finish();
        result = result.leftJoin(extendBillSet).on("id", "loanbillid").select(resultFieldNames, new String[]{"lrenewalexpiredate"}).finish().updateField("expiredate", "case when lrenewalexpiredate is null then expiredate else lrenewalexpiredate end");
        result = result.removeFields(new String[]{"lrenewalexpiredate"});
        final RowMeta rowMeta = result.getRowMeta();
        result = result.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(20);
                for (String fieldName : rowMeta.getFieldNames()) {
                    if ("term".equals(fieldName) && EmptyUtil.isNoEmpty((Object)row.getDate("startintdate")) && EmptyUtil.isNoEmpty((Object)row.getDate("expiredate"))) {
                        String term = DateUtils.getDiff_ymd((Date)row.getDate("startintdate"), (Date)row.getDate("expiredate"));
                        rowInfo.add(term);
                        continue;
                    }
                    if ("residueterm".equals(fieldName) && EmptyUtil.isNoEmpty((Object)row.getDate("expiredate"))) {
                        String residueterm = DateUtils.getDiff_ymd((Date)queryDate, (Date)row.getDate("expiredate"));
                        rowInfo.add(residueterm);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        QFilter loanRateFilter = new QFilter("id", "in", loanIds);
        loanRateFilter.and("rateadjust_entry.ra_effectdate", "<=", (Object)queryDate);
        DataSet resetRateBillSet = QueryServiceHelper.queryDataSet((String)(algoKey + "covertLoanRate"), (String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_yearrate as yearrate,rateadjust_entry.ra_effectdate as effectdate", (QFilter[])loanRateFilter.toArray(), null);
        DataSet lastRateDate = resetRateBillSet.copy().select("id,effectdate").groupBy(new String[]{"id"}).max("effectdate").finish();
        resetRateBillSet = lastRateDate.leftJoin(resetRateBillSet).on("id", "id").on("effectdate", "effectdate").select(new String[]{"id", "effectdate"}, new String[]{"yearrate"}).finish();
        result = result.leftJoin(resetRateBillSet).on("id", "id").select(resultFieldNames, new String[]{"yearrate"}).finish().updateField("loanrate", "case when yearrate is null then 0 else yearrate end");
        result = result.removeFields(new String[]{"yearrate"});
        QFilter repayFilter = new QFilter("loans.e_loanbill", "in", loanIds);
        repayFilter.and("bizdate", "<=", (Object)queryDate);
        repayFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repaymentBills = QueryServiceHelper.queryDataSet((String)(algoKey + "covertRepayedAmount"), (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill as loanbillid,loans.e_repayamount as erepayamount", (QFilter[])repayFilter.toArray(), null);
        repaymentBills = repaymentBills.select("loanbillid,erepayamount").groupBy(new String[]{"loanbillid"}).sum("erepayamount").finish();
        result = result.leftJoin(repaymentBills).on("id", "loanbillid").select(resultFieldNames, new String[]{"erepayamount"}).finish().updateField("repayedamount", "case when erepayamount is null then 0 else erepayamount end");
        result = result.removeFields(new String[]{"erepayamount"});
        result = result.updateField("repayamount", "drawamount - repayedamount");
        result = result.addFields(new String[]{"repayamount", "drawamount", "repayedamount"}, new String[]{"srcrepayamount", "srcdrawamount", "srcrepayedamount"});
        result = AmountTransHelper.tranDataSetRate((DataSet)result, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Arrays.asList("repayamount", "drawamount", "repayedamount").stream().collect(Collectors.toSet()), (Date)queryDate);
        result = result.addFields(new String[]{"0.0", "0.0"}, new String[]{MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
        List allViewOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
        return InterCompanyLoansDataHelper.handleGroup(result, allViewOrgIds);
    }

    public static DataSet getDebitAllViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> allViewOrgs) {
        QFilter filter = InterCompanyLoansDataHelper.getDebitQFilter(allViewOrgs, queryDate);
        DataSet result = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)"cfm_loanbill", (String)DEBT_FIELDS, (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> loanIds = new HashSet<Long>(16);
        HashSet<Long> settleCenterCreditor = new HashSet<Long>(16);
        HashSet<Long> companyCreditor = new HashSet<Long>(16);
        for (Row row : result.copy().select("id,loantype,creditor").groupBy(new String[]{"id", "loantype", "creditor"}).finish()) {
            loanIds.add(row.getLong("id"));
            if ("loan".equals(row.getString("loantype"))) {
                settleCenterCreditor.add(row.getLong("creditor"));
                continue;
            }
            companyCreditor.add(row.getLong("creditor"));
        }
        DataSet[] splitDataSet = result.splitByFilter(new String[]{"loantype = 'loan'"}, true);
        DataSet settleDataSet = splitDataSet[0];
        DataSet companyDataSet = splitDataSet[1];
        QFilter settleFilter = new QFilter("id", "in", settleCenterCreditor);
        DataSet finOrgInfos = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinOrgInfos"), (String)"bd_finorginfo", (String)"id,org.id as finorgid", (QFilter[])settleFilter.toArray(), null);
        String[] settleFieldNames = settleDataSet.getRowMeta().getFieldNames();
        settleDataSet = settleDataSet.leftJoin(finOrgInfos).on("creditor", "id").select(settleFieldNames, new String[]{"finorgid"}).finish();
        settleDataSet = settleDataSet.updateField("creditorinnerorg", "case when finorgid is null then 0 else finorgid end");
        settleDataSet = settleDataSet.removeFields(new String[]{"finorgid"});
        QFilter companyFilter = new QFilter("id", "in", companyCreditor);
        DataSet partnerDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "getBizpartner"), (String)"bd_bizpartner", (String)"id,internal_company.id as finorgid", (QFilter[])companyFilter.toArray(), null);
        companyDataSet = companyDataSet.leftJoin(partnerDataSet).on("creditor", "id").select(settleFieldNames, new String[]{"finorgid"}).finish();
        companyDataSet = companyDataSet.updateField("creditorinnerorg", "case when finorgid is null then 0 else finorgid end");
        companyDataSet = companyDataSet.updateField("creditorinnerorg", "case when creditortype = 'innerunit' then creditor else creditorinnerorg end");
        companyDataSet = companyDataSet.removeFields(new String[]{"finorgid"});
        result = companyDataSet.union(settleDataSet);
        return InterCompanyLoansDataHelper.handleFiled(algoKey, queryDate, baseCurrency, orgViewId, loanIds, result);
    }

    private static DataSet handleGroup(DataSet result, List<Long> allViewOrgs) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>(4);
        paramMap.put("innerorg", allViewOrgs);
        QFilter isOutGroupFilter = new QFilter("creditorinnerorg", "in", (Object)"innerorg");
        String[] exprArr = new String[]{isOutGroupFilter.toString().replace("'", "")};
        DataSet[] dataSets = DataSetHelper.splitByFilter((DataSet)result, (String[])exprArr, paramMap, (boolean)true);
        dataSets[0] = dataSets[0].updateField("isoutgroup", "0");
        dataSets[1] = dataSets[1].updateField("isoutgroup", "1");
        return dataSets[0].union(dataSets[1]);
    }

    public static QFilter getInvestQFilter(List<Long> allorgids, Date queryDate) {
        QFilter qFilter = new QFilter("creditorg", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("finproduct.equitytool", "=", (Object)Boolean.FALSE);
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false)).or(new QFilter("cleardate", "is null", null)));
        QFilter companyFilter = new QFilter("loantype", "in", Arrays.asList("entrust", "ec"));
        return qFilter.and(companyFilter);
    }

    public static QFilter getIfmQFilter(List<Long> allorgids, Date queryDate) {
        QFilter qFilter = new QFilter("creditorg", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("finproduct.equitytool", "=", (Object)Boolean.FALSE);
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false)).or(new QFilter("cleardate", "is null", null)));
        QFilter bankFilter = new QFilter("loantype", "=", (Object)"loan");
        bankFilter.and("creditortype", "=", (Object)"settlecenter");
        return qFilter.and(bankFilter);
    }

    public static QFilter getDebitQFilter(List<Long> allorgids, Date queryDate) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("finproduct.equitytool", "=", (Object)Boolean.FALSE);
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false)).or(new QFilter("cleardate", "is null", null)));
        QFilter bankFilter = new QFilter("loantype", "=", (Object)"loan");
        bankFilter.and("creditortype", "=", (Object)"settlecenter");
        QFilter companyFilter = new QFilter("loantype", "in", Arrays.asList("entrust", "ec"));
        QFilter loanTypeFilter = bankFilter.or(companyFilter);
        return qFilter.and(loanTypeFilter);
    }

    public static String getCacheKey(Long orgviewId, Date queryDate, boolean loan) {
        return "InterCompanyLoansDataHelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + "-" + loan;
    }
}

