/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.InterCompanyLoansDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.helper.RepayPlanHelper;
import kd.tmc.tda.common.helper.SysParamHelper;

public class InterCompanyLoansTermHelper {
    public static DataSet getInterLoanTermData(String algoKey, List<Long> allOrgIds, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId, DataSet orgDateSet, boolean isDebit) {
        return InterCompanyLoansTermHelper.getInterLoanTermData(algoKey, allOrgIds, queryDate, baseCurrency, orgViewId, orgId, orgDateSet, isDebit, "outgroup");
    }

    public static DataSet getInterLoanTermData(String algoKey, List<Long> allOrgIds, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId, DataSet orgDateSet, boolean isDebit, String comLoanRange) {
        DataSet result;
        String cacheKey = InterCompanyLoansTermHelper.getCacheKey(orgViewId, queryDate, isDebit);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> InterCompanyLoansTermHelper.getAllViewData(algoKey, allViewOrgs, queryDate, baseCurrency, orgViewId, isDebit));
            result = isDebit ? result.filter("org in allorgids", Collections.singletonMap("allorgids", allOrgIds)) : result.filter("creditor in allorgids", Collections.singletonMap("allorgids", allOrgIds));
        } else {
            result = InterCompanyLoansTermHelper.getAllViewData(algoKey, allOrgIds, queryDate, baseCurrency, orgViewId, isDebit);
        }
        if (orgDateSet == null) {
            orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        }
        if ("outgroup".equals(comLoanRange)) {
            DataSet[] splitMergeDataSet = result.splitByFilter(new String[]{"creditorinnerorg = 0"}, true);
            result = splitMergeDataSet[0];
            DataSet mergeDataSet = isDebit ? MergeOffsetHandler.addMergeOffsetField(splitMergeDataSet[1], orgDateSet, "repayamount", orgId) : MergeOffsetHandler.addMergeOffsetField(splitMergeDataSet[1], orgDateSet, "repayamount", orgId, "creditor");
            result = result.union(mergeDataSet.select(result.getRowMeta().getFieldNames()));
        } else if ("ingroup".equals(comLoanRange)) {
            result = result.filter("isoutgroup = 0");
        }
        return result;
    }

    private static DataSet getAllViewData(String algoKey, List<Long> allOrgIds, Date queryDate, Long baseCurrency, Long orgViewId, boolean isDebit) {
        DataSet ds = isDebit ? InterCompanyLoansDataHelper.getDebitAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allOrgIds) : InterCompanyLoansDataHelper.getCreditAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allOrgIds);
        ds = ds.addField("repayamount", "repayamountsum");
        return RepayPlanHelper.handleRepayPlan(algoKey, queryDate, baseCurrency, orgViewId, ds);
    }

    private static String getCacheKey(Long orgviewId, Date queryDate, boolean loan) {
        return InterCompanyLoansTermHelper.class.getSimpleName() + "-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + "-" + loan;
    }
}

