/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;

public class InvestCostDateHelper {
    public static List<String> getDateFormatByType(Date queryDate, String customType) {
        String[] dateArray = FinanceCostDateHelper.parseNewDateType(queryDate);
        List<String> dateList = Arrays.asList(dateArray);
        Collections.reverse(dateList);
        switch (customType) {
            case "month": {
                return dateList.subList(0, 12);
            }
            case "season": {
                return dateList.subList(12, 24);
            }
            case "half": {
                return dateList.subList(24, 36);
            }
            case "year": {
                return dateList.subList(36, 42);
            }
        }
        return new ArrayList<String>();
    }

    public static DataSet getAfterFilterDataSet(DataSet dataSet, String customType, Boolean needDate, String date, Map<String, Object> paramMap) {
        if (dataSet.isEmpty()) {
            RowMeta rowMeta = new RowMeta(dataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getDataTypes());
            return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        }
        if (StringUtil.isEmpty((String)customType)) {
            customType = "month";
        }
        StringBuilder condition = new StringBuilder("customtype").append(" = '").append(customType).append("'");
        if (needDate.booleanValue()) {
            if (StringUtil.isEmpty((String)date)) {
                Date queryDate = AmountTransHelper.getQueryDate(paramMap);
                List<String> dateFormatList = InvestCostDateHelper.getDateFormatByType(queryDate, customType);
                if (CollectionUtils.isEmpty(dateFormatList)) {
                    return dataSet;
                }
                date = dateFormatList.get(0);
            }
            condition.append(" and ").append("date").append(" = '").append(date).append("'");
        }
        String filterParam = condition.toString();
        dataSet = dataSet.filter(filterParam);
        return dataSet;
    }
}

