/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.InvestCommonHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.tda.invest.InvestRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import org.apache.commons.lang.StringUtils;

public class InvestDataHelper {
    private static final List<String> INVEST_TYPE_LIST = Arrays.asList(InvestTypeEnum.notice.getValue(), InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue());

    public static DataSet getInvestBalanceDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        return InvestDataHelper.getInvestDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, null);
    }

    public static DataSet getInvestDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, DateRangeEnum dateRange) {
        boolean isBalanceOnly = dateRange == null;
        String cacheKey = InvestDataHelper.getCacheKey(orgViewId, queryDate, isBalanceOnly ? "amount" : dateRange.getValue() + "principle");
        List<Object[]> dateList = isBalanceOnly ? null : InvestDataHelper.getDateList(dateRange, queryDate);
        DataSet result = InvestDataHelper.doGetInvestDataSet(algoKey, cacheKey, orgIds, queryDate, baseCurrency, orgViewId, dateList);
        if (isBalanceOnly) {
            return result;
        }
        return result.filter("isoffset='0'");
    }

    public static DataSet getInvestDetailDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, DateRangeEnum dateRange) {
        String cacheKey = InvestDataHelper.getCacheKey(orgViewId, queryDate, dateRange.getValue() + "principle");
        List<Object[]> dateList = InvestDataHelper.getDateList(dateRange, queryDate);
        return InvestDataHelper.doGetInvestDataSet(algoKey, cacheKey, orgIds, queryDate, baseCurrency, orgViewId, dateList);
    }

    private static DataSet doGetInvestDataSet(String algoKey, String cacheKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, List<Object[]> dateList) {
        DataSet result;
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            boolean isBalanceOnly = dateList == null;
            Date queryStartDate = isBalanceOnly ? queryDate : (Date)dateList.get(0)[0];
            Date queryEndDate = isBalanceOnly ? queryDate : (Date)dateList.get(dateList.size() - 1)[1];
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> InvestCommonHelper.getAllViewData((InvestRequest)new InvestRequest(algoKey, queryDate, baseCurrency, orgViewId, dateList, InvestDataHelper.getFinsubScribeFilter(allOrgIds, queryStartDate, queryEndDate), InvestDataHelper.getDepositFilter(allOrgIds, queryStartDate, queryEndDate))));
            result = result.filter("company in orgIds", Collections.singletonMap("orgIds", orgIds));
        } else {
            boolean isBalanceOnly = dateList == null;
            Date queryStartDate = isBalanceOnly ? queryDate : (Date)dateList.get(0)[0];
            Date queryEndDate = isBalanceOnly ? queryDate : (Date)dateList.get(dateList.size() - 1)[1];
            QFilter filter = InvestDataHelper.getFinsubScribeFilter(orgIds, queryStartDate, queryEndDate);
            QFilter depositFilter = InvestDataHelper.getDepositFilter(orgIds, queryStartDate, queryEndDate);
            InvestRequest request = new InvestRequest(algoKey, queryDate, baseCurrency, orgViewId, dateList, filter, depositFilter);
            result = InvestCommonHelper.getAllViewData((InvestRequest)request);
        }
        boolean isSettlementCenter = BasicParamHelper.getAppBooleamParameter("tda_acct_queryparamset", "issettlementcenter");
        if (!isSettlementCenter) {
            result = result.filter("finorgtype != '1'");
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            StringBuilder offSetSb = new StringBuilder("case when finorgtype = '3' and businessunit in (");
            if (isSettlementCenter) {
                offSetSb = new StringBuilder("case when (finorgtype = '3' or finorgtype = '1')  and businessunit in (");
            }
            offSetSb.append(StringUtils.join(orgIds, (String)",")).append(") then '1' else '0' end ");
            result = result.updateField("isoffset", offSetSb.toString());
        }
        return result;
    }

    private static QFilter getFinsubScribeFilter(List<Long> orgIds, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("finservicestatus", "!=", (Object)"subscribe_ing");
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isrenewal='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and(InvestDataHelper.getDateFilter(beginDate, endDate, "valuedate", "cleardate"));
        filter.and("org.id", "in", orgIds);
        return filter;
    }

    private static QFilter getDepositFilter(List<Long> orgIds, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("investvarieties.investtype", "in", INVEST_TYPE_LIST);
        filter.and("bizstatus", "!=", (Object)"subscribe_ing");
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isredepositgenerate='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and(InvestDataHelper.getDateFilter(beginDate, endDate, "intdate", "cleardate"));
        filter.and("org", "in", orgIds);
        return filter;
    }

    private static QFilter getDateFilter(Date queryStartDate, Date queryEndDate, String intdateName, String cleardateName) {
        QFilter dateFilter = new QFilter(intdateName, "<=", (Object)queryEndDate);
        QFilter clearDateFilter = QFilter.isNull((String)cleardateName).or(new QFilter(cleardateName, ">", (Object)queryStartDate));
        return dateFilter.and(clearDateFilter);
    }

    private static List<Object[]> getDateList(DateRangeEnum dateRange, Date queryDate) {
        List<Object[]> dateList;
        if (EmptyUtil.isEmpty((Object)((Object)dateRange))) {
            return Collections.emptyList();
        }
        switch (dateRange) {
            case YEAR: {
                dateList = FinanceCostDateHelper.getInvestQueryDateList(queryDate, DateRangeEnum.YEAR.getValue());
                break;
            }
            case HALF_YEAR: {
                dateList = FinanceCostDateHelper.getInvestQueryDateList(queryDate, DateRangeEnum.HALF_YEAR.getValue());
                break;
            }
            case SEASON: {
                dateList = FinanceCostDateHelper.getInvestQueryDateList(queryDate, DateRangeEnum.SEASON.getValue());
                break;
            }
            case MONTH: {
                dateList = FinanceCostDateHelper.getInvestQueryDateList(queryDate, DateRangeEnum.MONTH.getValue());
                break;
            }
            default: {
                dateList = FinanceCostDateHelper.getAllInvestQueryDateList(queryDate);
            }
        }
        return dateList;
    }

    private static String getCacheKey(Long orgViewId, Date queryDate, String amountOrPrinciple) {
        return InvestDataHelper.class.getSimpleName() + "-cachekey-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + amountOrPrinciple;
    }
}

