/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import org.apache.commons.lang3.StringUtils;

public class MergeOffsetHandler {
    private static String debtOrg = "creditorinnerorg";
    private static String debtLongNumber = "debt_longnumber";
    public static String ROW_OFFSETFILENAME = "rowoffset";
    public static String COL_OFFSETFILENAME = "coloffset";

    public static DataSet addMergeOffsetField(DataSet dataSet, DataSet orgDataSet, String originalAmountFieldName, Long orgid, String orgColName) {
        int orgLevel = orgDataSet.copy().filter("org = " + orgid).next().getInteger("level");
        dataSet = MergeOffsetHandler.addCustomLongNumber(dataSet, orgDataSet, orgColName, debtOrg);
        return MergeOffsetHandler.dealOffsetCol(dataSet, originalAmountFieldName, orgLevel);
    }

    private static DataSet addCustomLongNumber(DataSet dataSet, DataSet orgDataSet, String orgColName, String debtOrg) {
        dataSet = dataSet.leftJoin(orgDataSet.copy()).on(orgColName, "org").select(dataSet.getRowMeta().getFieldNames(), new String[]{"longnumber"}).finish();
        dataSet = dataSet.leftJoin(orgDataSet).on(debtOrg, "org").select(dataSet.getRowMeta().getFieldNames(), new String[]{"longnumber as debt_longnumber"}).finish();
        return dataSet;
    }

    public static DataSet addMergeOffsetField(DataSet dataSet, DataSet orgDataSet, String originalAmountFieldName, Long orgid) {
        int orgLevel = orgDataSet.copy().filter("org = " + orgid).next().getInteger("level");
        dataSet = MergeOffsetHandler.addLongNumber(dataSet, orgDataSet);
        return MergeOffsetHandler.dealOffsetCol(dataSet, originalAmountFieldName, orgLevel);
    }

    private static DataSet dealOffsetCol(DataSet dataSet, final String originalAmountFieldName, final int orgLevel) {
        final RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String loanOrg = row.getString("longnumber");
                String debtOrg = row.getString(debtLongNumber);
                if (StringUtils.isEmpty((CharSequence)loanOrg) || StringUtils.isEmpty((CharSequence)debtOrg)) {
                    return data;
                }
                int loanIndex = StringUtils.ordinalIndexOf((CharSequence)(loanOrg + "!"), (CharSequence)"!", (int)(orgLevel + 1));
                int debtIndex = StringUtils.ordinalIndexOf((CharSequence)(debtOrg + "!"), (CharSequence)"!", (int)(orgLevel + 1));
                if (loanIndex < 0 || debtIndex < 0) {
                    return data;
                }
                loanOrg = StringUtils.substring((String)loanOrg, (int)0, (int)loanIndex);
                debtOrg = StringUtils.substring((String)debtOrg, (int)0, (int)debtIndex);
                if (StringUtils.isEmpty((CharSequence)loanOrg) || StringUtils.isEmpty((CharSequence)debtOrg)) {
                    return data;
                }
                String loanOrgLast = StringUtils.substring((String)loanOrg, (int)0, (int)loanOrg.lastIndexOf("!"));
                String debtOrgLast = StringUtils.substring((String)debtOrg, (int)0, (int)loanOrg.lastIndexOf("!"));
                if (loanOrg.equals(debtOrg)) {
                    int index = rowMeta.getFieldIndex(ROW_OFFSETFILENAME, false);
                    BigDecimal bigDecimal = row.getBigDecimal(originalAmountFieldName);
                    data[index] = bigDecimal.negate();
                } else if (loanOrgLast.equals(debtOrgLast)) {
                    int index = rowMeta.getFieldIndex(COL_OFFSETFILENAME, false);
                    BigDecimal bigDecimal = row.getBigDecimal(originalAmountFieldName);
                    data[index] = bigDecimal.negate();
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    private static DataSet addLongNumber(DataSet dataSet, DataSet orgDataSet) {
        dataSet = dataSet.leftJoin(orgDataSet.copy()).on("org", "org").select(dataSet.getRowMeta().getFieldNames(), new String[]{"longnumber"}).finish();
        dataSet = dataSet.leftJoin(orgDataSet).on(debtOrg, "org").select(dataSet.getRowMeta().getFieldNames(), new String[]{"longnumber as debt_longnumber"}).finish();
        return dataSet;
    }
}

