/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class QingRptFilterParamHelper {
    private static String filter_company = "filter_company";
    private static String filter_openorg = "filter_openorg";
    private static String filter_bankcare = "filter_bankcare";
    private static String filter_isincludefinorg = "filter_isincludefinorg";
    private static String filter_acctpurpose = "filter_acctpurpose";
    private static String filter_status = "filter_status";
    private static String filter_bank = "filter_bank";
    private static String filter_isbeiinterface = "filter_isbeiinterface";
    private static String filter_currency = "filter_currency";

    public static QFilter initOrgFilter(Map<String, Object> paramMap) {
        ArrayList<Long> comIist = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filter_company))) {
            DynamicObjectCollection companys = (DynamicObjectCollection)paramMap.get(filter_company);
            for (DynamicObject company : companys) {
                comIist.add(company.getLong("id"));
            }
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filter_openorg))) {
            DynamicObjectCollection openorgs = (DynamicObjectCollection)paramMap.get(filter_openorg);
            for (DynamicObject openorg : openorgs) {
                orgIds.add(openorg.getLong("id"));
            }
        }
        QFilter ofilter = null;
        if (comIist.size() > 0) {
            ofilter = new QFilter("company.id", "in", comIist);
        }
        if (orgIds.size() > 0) {
            if (ofilter != null) {
                ofilter.and(new QFilter("openorg.id", "in", orgIds));
            } else {
                ofilter = new QFilter("openorg.id", "in", orgIds);
            }
        }
        return ofilter;
    }

    public static QFilter initFinOrgFilter(Map<String, Object> paramMap) {
        boolean isincludefinorg = (Boolean)paramMap.get(filter_isincludefinorg);
        QFilter filter = null;
        if (!isincludefinorg) {
            filter = new QFilter("bank.finorgtype.type", "=", (Object)"0");
        }
        ArrayList<Long> bankIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filter_bankcare))) {
            for (DynamicObject bank : (DynamicObjectCollection)paramMap.get(filter_bankcare)) {
                bankIds.add(bank.getLong("id"));
            }
        }
        if (bankIds.size() > 0) {
            QFilter qf = new QFilter("bank.bank_cate.id", "in", bankIds);
            if (isincludefinorg) {
                qf = qf.or(new QFilter("bank.finorgtype.type", "!=", (Object)"0"));
            }
            if (null == filter) {
                filter = qf;
            } else {
                filter.and(qf);
            }
        }
        ArrayList<Long> finorgIds = new ArrayList<Long>();
        if (!isincludefinorg && !EmptyUtil.isEmpty((Object)paramMap.get(filter_bank))) {
            for (DynamicObject finorginfo : (DynamicObjectCollection)paramMap.get(filter_bank)) {
                finorgIds.add(finorginfo.getLong("id"));
            }
        }
        if (finorgIds.size() > 0) {
            if (null == filter) {
                filter = new QFilter("bank.id", "in", finorgIds);
            } else {
                filter.and(new QFilter("bank.id", "in", finorgIds));
            }
        }
        return filter;
    }

    public static QFilter[] initBankAcctFilter(Map<String, Object> paramMap) {
        String isMulCurrency;
        String isbeiinterface;
        QFilter filter = QingRptFilterParamHelper.initOrgFilter(paramMap);
        QFilter finorgFilter = QingRptFilterParamHelper.initFinOrgFilter(paramMap);
        if (finorgFilter != null) {
            filter = filter.and(finorgFilter);
        }
        if (!EmptyUtil.isEmpty((String)(isbeiinterface = (String)paramMap.get(filter_isbeiinterface)))) {
            String[] split = isbeiinterface.split(",");
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
            for (int i = 0; i < split.length; ++i) {
                String item = split[i];
                if (!EmptyUtil.isNotEmpty((CharSequence)item)) continue;
                if ("NA".equals(item)) {
                    qfilters.add(new QFilter("finorgtype", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue()));
                    continue;
                }
                qfilters.add(new QFilter("issetbankinterface", "=", (Object)Boolean.valueOf(item)).and(new QFilter("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue())));
            }
            if (qfilters.size() > 0) {
                QFilter qf = (QFilter)qfilters.get(0);
                int len = qfilters.size();
                for (int i = 1; i < len; ++i) {
                    qf.or((QFilter)qfilters.get(i));
                }
                filter.and(qf);
            }
        }
        ArrayList<Long> filter_acctpurposeIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filter_acctpurpose))) {
            DynamicObjectCollection filter_acctpurposes = (DynamicObjectCollection)paramMap.get(filter_acctpurpose);
            for (DynamicObject acctpurpose : filter_acctpurposes) {
                filter_acctpurposeIds.add(acctpurpose.getLong("id"));
            }
        }
        if (filter_acctpurposeIds.size() > 0) {
            filter.and(new QFilter("acctproperty.id", "in", filter_acctpurposeIds));
        }
        ArrayList<String> statusList = new ArrayList<String>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filter_status))) {
            String[] statuss;
            for (String status : statuss = ((String)paramMap.get(filter_status)).split(",")) {
                if (EmptyUtil.isEmpty((Object)status)) continue;
                statusList.add(status);
            }
        }
        if (statusList != null && statusList.size() > 0) {
            filter.and(new QFilter("acctstatus", "in", statusList));
        }
        if (!EmptyUtil.isEmpty((String)(isMulCurrency = (String)paramMap.get(filter_currency)))) {
            filter.and(new QFilter("ismulcurrency", "=", (Object)Boolean.valueOf(isMulCurrency)));
        }
        Timestamp currentTime = DateUtils.getCurrentTime();
        if (!EmptyUtil.isEmpty((Object)paramMap.get("opendateranges"))) {
            String openDate;
            switch (openDate = (String)paramMap.get("opendateranges")) {
                case "thismonth": {
                    filter.and(new QFilter("opendate", ">=", (Object)DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate())).and(new QFilter("opendate", "<=", (Object)DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate()))));
                    break;
                }
                case "thisquarter": {
                    filter.and(new QFilter("opendate", ">=", (Object)DateUtils.getFirstSeasonDate((Date)DateUtils.getCurrentDate())).and(new QFilter("opendate", "<=", (Object)DateUtils.getLastSeasonDate((Date)DateUtils.getCurrentDate()))));
                    break;
                }
                case "sixmonth": {
                    filter.and(new QFilter("opendate", ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)6)).and(new QFilter("opendate", "<=", (Object)currentTime)));
                    break;
                }
                case "oneyear": {
                    filter.and(new QFilter("opendate", ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)1)).and(new QFilter("opendate", "<=", (Object)currentTime)));
                    break;
                }
                case "twoyear": {
                    filter.and(new QFilter("opendate", ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)2)).and(new QFilter("opendate", "<=", (Object)currentTime)));
                    break;
                }
            }
        }
        if (!EmptyUtil.isEmpty((Object)paramMap.get("opendateranges_startdate")) && !EmptyUtil.isEmpty((Object)paramMap.get("opendateranges_enddate"))) {
            Date openStartDate = (Date)paramMap.get("opendateranges_startdate");
            Date openEndDate = (Date)paramMap.get("opendateranges_enddate");
            filter.and(new QFilter("opendate", ">=", (Object)openStartDate).and(new QFilter("opendate", "<=", (Object)openEndDate)));
        }
        if (!EmptyUtil.isEmpty((Object)paramMap.get("closedateranges"))) {
            String openDate;
            switch (openDate = (String)paramMap.get("closedateranges")) {
                case "thismonth": {
                    filter.and(new QFilter("closedate", ">=", (Object)DateUtils.getMinMonthDate((Date)new Date())).and(new QFilter("closedate", "<=", (Object)DateUtils.getMaxMonthDate((Date)new Date()))));
                    break;
                }
                case "thisquarter": {
                    filter.and(new QFilter("closedate", ">=", (Object)DateUtils.getFirstSeasonDate((Date)DateUtils.getCurrentDate())).and(new QFilter("closedate", "<=", (Object)DateUtils.getLastSeasonDate((Date)DateUtils.getCurrentDate()))));
                    break;
                }
                case "sixmonth": {
                    filter.and(new QFilter("closedate", ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)6)).and(new QFilter("closedate", "<=", (Object)currentTime)));
                    break;
                }
                case "oneyear": {
                    filter.and(new QFilter("closedate", ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)1)).and(new QFilter("closedate", "<=", (Object)currentTime)));
                    break;
                }
                case "twoyear": {
                    filter.and(new QFilter("closedate", ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)2)).and(new QFilter("closedate", "<=", (Object)currentTime)));
                    break;
                }
            }
        }
        if (!EmptyUtil.isEmpty((Object)paramMap.get("closedateranges_startdate")) && !EmptyUtil.isEmpty((Object)paramMap.get("closedateranges_enddate"))) {
            Date closeStartDate = (Date)paramMap.get("closedateranges_startdate");
            Date closeEndDate = (Date)paramMap.get("closedateranges_enddate");
            filter.and(new QFilter("closedate", ">=", (Object)closeStartDate).and(new QFilter("closedate", "<=", (Object)closeEndDate)));
        }
        return new QFilter[]{filter};
    }
}

