/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.SynthesisProjectEnum;

public class SynthsisSumDataHelper {
    private static final Log logger = LogFactory.getLog(SynthsisSumDataHelper.class);
    private static final String SYNTHESIS_QING_DATA_CLASS = "kd.tmc.tda.report.synthesis.qing.data.SynthesisQingRptDataPlugin";
    private DynamicObject orgView;
    private DynamicObject org;
    private DynamicObject currency;
    private Date queryDate;
    private static final Integer DEFAULT_SCALE = 10;

    public SynthsisSumDataHelper(DynamicObject orgView, DynamicObject org, DynamicObject currency, Date queryDate) {
        this.orgView = orgView;
        this.org = org;
        this.queryDate = queryDate;
    }

    public void refreshSumData() {
        QFilter orgViewFilter = new QFilter("orgview", "=", (Object)this.orgView);
        QFilter orgFilter = new QFilter("org", "=", (Object)this.org);
        Long baseCurrencyId = AmountTransHelper.getBaseCurrency((Long)this.orgView.getLong("id"));
        if (baseCurrencyId == null) {
            return;
        }
        this.currency = TmcDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)"bd_currency");
        QFilter currency_Filter = new QFilter("currency", "=", (Object)this.currency);
        QFilter queryDate_Filter = new QFilter("querydate", "=", (Object)this.queryDate);
        QFilter[] qFilters = new QFilter[]{orgViewFilter, orgFilter, queryDate_Filter, currency_Filter};
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
        try {
            IDataSnapExecute service = (IDataSnapExecute)Class.forName(SYNTHESIS_QING_DATA_CLASS).newInstance();
            DataSet ds = service.data("tda_synthesissumdata", "", qFilters);
            for (Row row : ds) {
                DynamicObject tempObject = this.createDynamicSynthesis(row);
                if (tempObject.getLong("id") != 0L) {
                    updateList.add(tempObject);
                    continue;
                }
                newList.add(tempObject);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7efc\u5408\u5206\u6790\u6c47\u603b\u6570\u636e\u9519\u8bef\uff0c", (Throwable)e);
        }
        SaveServiceHelper.save((DynamicObject[])newList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    private DynamicObject createDynamicSynthesis(Row row) {
        Date bizeDate = DateUtils.getFirstDayOfMonth((Date)row.getDate("bizdate"));
        QFilter orgViewFilter = new QFilter("orgview.id", "=", this.orgView.getPkValue());
        QFilter orgFilter = new QFilter("org.id", "=", this.org.getPkValue());
        QFilter currency_Filter = new QFilter("currency.id", "=", this.currency.getPkValue());
        QFilter queryDate_Filter = new QFilter("bizdate", "=", (Object)bizeDate);
        String project = row.getString("project");
        SynthesisProjectEnum projectEnum = SynthesisProjectEnum.getEnumByValue(project);
        QFilter projectFilter = new QFilter("project", "=", (Object)projectEnum.getValue());
        Object[] systhesisDOs = TmcDataServiceHelper.load((String)"tda_synthesissumdata", (String)"orgview,org,bizdate,bizterm,currency,project,currmonthtotal,lastmonthtotal,currmonthdomestic,lastmonthdomestic,currmonthforeign,lastmonthforeign,budget,relbudget,changeamt,changerate,sort,modifier,modifytime", (QFilter[])new QFilter[]{orgViewFilter, orgFilter, currency_Filter, queryDate_Filter, projectFilter});
        Object synthesisDO = EmptyUtil.isNoEmpty((Object[])systhesisDOs) ? systhesisDOs[0] : TmcDataServiceHelper.newDynamicObject((String)"tda_synthesissumdata");
        synthesisDO.set("orgview", (Object)this.orgView);
        synthesisDO.set("org", (Object)this.org);
        synthesisDO.set("bizdate", (Object)bizeDate);
        synthesisDO.set("bizterm", (Object)DateUtils.formatString((Date)DateUtils.getLastMonth((Date)bizeDate, (int)1), (String)"yyyy-MM"));
        synthesisDO.set("currency", (Object)this.currency);
        synthesisDO.set("project", (Object)projectEnum.getValue());
        synthesisDO.set("currmonthtotal", (Object)this.formatDecimal(row.getBigDecimal("currmonthtotal")));
        synthesisDO.set("lastmonthtotal", (Object)this.formatDecimal(row.getBigDecimal("lastmonthtotal")));
        synthesisDO.set("currmonthdomestic", (Object)this.formatDecimal(row.getBigDecimal("currmonthdomestic")));
        synthesisDO.set("lastmonthdomestic", (Object)this.formatDecimal(row.getBigDecimal("lastmonthdomestic")));
        synthesisDO.set("currmonthforeign", (Object)this.formatDecimal(row.getBigDecimal("currmonthforeign")));
        synthesisDO.set("lastmonthforeign", (Object)this.formatDecimal(row.getBigDecimal("lastmonthforeign")));
        synthesisDO.set("budget", (Object)this.formatDecimal(row.getBigDecimal("budget")));
        synthesisDO.set("relbudget", (Object)this.formatDecimal(row.getBigDecimal("relbudget")));
        synthesisDO.set("changeamt", (Object)this.formatDecimal(row.getBigDecimal("changeamt")));
        synthesisDO.set("changerate", (Object)this.formatDecimal(row.getBigDecimal("changerate")));
        synthesisDO.set("sort", (Object)projectEnum.getSort());
        synthesisDO.set("modifier", (Object)RequestContext.get().getCurrUserId());
        synthesisDO.set("modifytime", (Object)new Date());
        return synthesisDO;
    }

    private BigDecimal formatDecimal(BigDecimal value) {
        if (value != null) {
            value = value.setScale((int)DEFAULT_SCALE, RoundingMode.HALF_UP);
        }
        return value;
    }
}

