/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.olap.util.Pair;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TdaCommonHelper {
    public static final String DEFAULT_AMOUNT_UNIT = "100000000";
    public static final Long DEFAULT_FUN_ORG_VIEW_ID = 8L;
    public static final String BTN_REFRESH = "btnrefresh";

    public static DynamicObject getCurrentUserDefaultSet() {
        long userId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("user.id", "=", (Object)userId);
        return TmcDataServiceHelper.loadSingleFromCache((String)"tda_userdefaultset", (QFilter[])filter.toArray());
    }

    public static Long getRootPermOrgIdByOrgView(Long orgViewId) {
        if (EmptyUtil.isNoEmpty((Long)orgViewId)) {
            return TmcOrgDataHelper.getPermRootOrgId((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.TDA.getValue(), (String)"tda_decisanlsresvisual", (String)"47150e89000000ac", (Long)orgViewId);
        }
        return null;
    }

    public static Long getDefaultCurrencyByOrg(Long orgId) {
        DynamicObject standardCurrency;
        DynamicObject baseCurrency;
        Long currency = 0L;
        if (orgId != null && (baseCurrency = (standardCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)orgId)) == null ? TmcBusinessBaseHelper.getBaseCurrency((long)orgId) : standardCurrency) != null) {
            currency = baseCurrency.getLong("id");
        }
        return currency;
    }

    public static Set<String> getAmountFields(IDataSnapExecute pluginInstance) {
        return (Set)TdaCommonHelper.invokeMethod(pluginInstance, "getAmountFields", new Object[0]);
    }

    public static <T> T invokeMethod(IDataSnapExecute pluginInstance, String methodName, Object ... args) {
        Object result = null;
        try {
            Class<?> pluginClass = pluginInstance.getClass();
            Method method = TdaCommonHelper.getMethod(pluginClass, methodName);
            if (method != null) {
                ReflectionUtils.makeAccessible((Method)method);
                result = method.invoke((Object)pluginInstance, args);
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new KDException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method method = null;
        if (null != clazz && EmptyUtil.isNoEmpty((String)methodName)) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
                if (!methodName.equals(declaredMethod.getName())) continue;
                method = declaredMethod;
                break;
            }
            if (method == null) {
                method = TdaCommonHelper.getMethod(clazz.getSuperclass(), methodName);
            }
        }
        return method;
    }

    public static void putSelectValue(IFormView parentView, Map<String, Object> paramMap, String selectTag) {
        if (null == parentView.getControl(selectTag)) {
            return;
        }
        String type = (String)parentView.getModel().getValue(selectTag);
        if (StringUtil.isNotEmpty((String)type)) {
            paramMap.put(selectTag, type);
        }
    }

    public static void putTypeLinkValue(IFormView view, Map<String, Object> paramMap, String typeTag, String linkTag) {
        if (null == view.getControl(typeTag)) {
            return;
        }
        String type = (String)view.getModel().getValue(typeTag);
        String typeLinkValue = (String)view.getModel().getValue(linkTag);
        if (paramMap != null && StringUtil.isNotEmpty((String)type) && StringUtil.isNotEmpty((String)typeLinkValue)) {
            paramMap.put(typeTag, type);
            paramMap.put(linkTag, typeLinkValue);
        }
    }

    public static String getSelectValue(IPageCache pageCache, Map<String, Object> paramMap, String selectTag) {
        String selectValue = null;
        if (pageCache != null) {
            selectValue = pageCache.get(selectTag);
        }
        if (EmptyUtil.isEmpty(selectValue) && paramMap != null) {
            selectValue = (String)paramMap.get(selectTag);
        }
        return selectValue;
    }

    public static Pair<String, String> getTypeLinkValue(IPageCache pageCache, Map<String, Object> paramMap, String typeTag, String linkTag) {
        String typeValue = null;
        String linkValue = null;
        if (pageCache != null) {
            typeValue = pageCache.get(typeTag);
            linkValue = pageCache.get(linkTag);
        }
        if (EmptyUtil.isEmpty(typeValue) && paramMap != null) {
            typeValue = (String)paramMap.get(typeTag);
            linkValue = (String)paramMap.get(linkTag);
        }
        return new Pair((Object)typeValue, (Object)linkValue);
    }

    public static void cacheSelectValue(IFormView parentView, IPageCache pageCache, String selectTag) {
        if (null == parentView.getControl(selectTag)) {
            return;
        }
        String type = (String)parentView.getModel().getValue(selectTag);
        if (StringUtil.isNotEmpty((String)type)) {
            pageCache.put(selectTag, type);
        }
    }

    public static void cacheTypeLinkValue(IFormView parentView, IPageCache pageCache, String typeTag, String linkTag) {
        if (null == parentView.getControl(typeTag)) {
            return;
        }
        String type = (String)parentView.getModel().getValue(typeTag);
        String typeLinkValue = (String)parentView.getModel().getValue(linkTag);
        if (StringUtil.isNotEmpty((String)type) && StringUtil.isNotEmpty((String)typeLinkValue)) {
            pageCache.put(typeTag, type);
            pageCache.put(linkTag, typeLinkValue);
        }
    }
}

