/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.ExRateDirEnum;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.enums.UseExRateEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PlInfoCalculateHelper {
    private static final Log logger = LogFactory.getLog(PlInfoCalculateHelper.class);

    public static BigDecimal calAmountForwardDirection(BigDecimal subtractor, BigDecimal minuend, BigDecimal principal, String dir) {
        return subtractor.subtract(minuend).max(BigDecimal.ZERO).multiply(principal).multiply(BigDecimal.valueOf(PlInfoCalculateHelper.getFLagByTradeDirect(dir)));
    }

    public static BigDecimal calAmountReverseDirection(BigDecimal subtractor, BigDecimal minuend, BigDecimal principal, String dir) {
        BigDecimal calSubtractor = BigDecimal.ZERO;
        if (subtractor.compareTo(BigDecimal.ZERO) > 0) {
            calSubtractor = BigDecimal.ONE.divide(subtractor, 10, 4);
        }
        BigDecimal calMinuend = BigDecimal.ZERO;
        if (minuend.compareTo(BigDecimal.ZERO) > 0) {
            calMinuend = BigDecimal.ONE.divide(minuend, 10, 4);
        }
        return calSubtractor.subtract(calMinuend).max(BigDecimal.ZERO).multiply(principal).multiply(BigDecimal.valueOf(PlInfoCalculateHelper.getFLagByTradeDirect(dir)));
    }

    public static double getFLagByTradeDirect(String tradedirect) {
        return TradeDirectionEnum.sell.getValue().equals(tradedirect) ? -1.0 : 1.0;
    }

    public static boolean callAndBuyORPutAndsell(String dir, String tradeType) {
        boolean result = OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir);
        return result;
    }

    public static boolean callAndSellORPutAndBuy(String dir, String tradeType) {
        boolean result = OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir);
        return result;
    }

    public static DynamicObject getBizBillBizRecord(DynamicObject plInfo) {
        Long srcBizBillId = plInfo.getLong("srcbizbill");
        if (EmptyUtil.isEmpty((Long)srcBizBillId)) {
            Long recordId = plInfo.getLong("bizrecord");
            return TmcDataServiceHelper.loadSingle((Object)recordId, (String)"tm_bizrecord");
        }
        QFilter filter = new QFilter("srcbizbill", "=", (Object)srcBizBillId);
        return TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"bizdate,enddate,exrate,restamt", (QFilter[])new QFilter[]{filter});
    }

    public static Date getDeyDateForReferExRate(DynamicObject plInfo) {
        DynamicObject tradeType = plInfo.getDynamicObject("tradetype");
        String number = tradeType.getString("number");
        Date Dm = null;
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number)) {
            DynamicObject bizRecord = PlInfoCalculateHelper.getBizBillBizRecord(plInfo);
            Dm = bizRecord.getDate("enddate");
            if (EmptyUtil.isEmpty((Object)Dm)) {
                Dm = bizRecord.getDate("bizdate");
            }
        } else if (ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
            DynamicObject bizRecord = PlInfoCalculateHelper.getBizBillBizRecord(plInfo);
            Dm = bizRecord.getDate("bizdate");
        }
        return Dm;
    }

    public static Map<String, Object> calFloatPlAmt_Forex(DynamicObject plInfo, DynamicObject tradeBill, boolean usePlAmt, BigDecimal spotExRate) {
        DynamicObject bizRecord = PlInfoCalculateHelper.getBizBillBizRecord(plInfo);
        String dir = tradeBill.getString("tradedirect");
        String pair = tradeBill.getString("pair");
        String fxQuote = tradeBill.getString("fxquote");
        BigDecimal exrate = bizRecord.getBigDecimal("exrate");
        BigDecimal amt1 = usePlAmt ? plInfo.getBigDecimal("bizrestamt") : bizRecord.getBigDecimal("restamt");
        BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
        BigDecimal floatPlAmt = pair.equals(fxQuote) ? referExrate.subtract(exrate).multiply(amt1) : (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referExrate, exrate}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(referExrate, 10, 4).subtract(BigDecimal.ONE.divide(exrate, 10, 4)).multiply(amt1));
        String swapDir = plInfo.getString("swapdir");
        if (EmptyUtil.isEmpty((String)swapDir) && TradeDirectionEnum.sell.getValue().equals(dir) || "isnear".equals(swapDir) && TradeDirectionEnum.sell.getValue().equals(dir) || "isfar".equals(swapDir) && TradeDirectionEnum.buy.getValue().equals(dir)) {
            floatPlAmt = floatPlAmt.negate();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (EmptyUtil.isNoEmpty((DynamicObject)plInfo.getDynamicObject("plcurrency"))) {
            Long plcurrencyId = plInfo.getDynamicObject("plcurrency").getLong("id");
            Long plcurrencyIdS = plInfo.getDynamicObject("plcurrency_s").getLong("id");
            if (plcurrencyId.longValue() != plcurrencyIdS.longValue()) {
                if (EmptyUtil.isEmpty((BigDecimal)spotExRate)) {
                    ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)plInfo.getDynamicObject("forexquote").getLong("id"), (String)pair, (Date)plInfo.getDate("updatedate"), null);
                    String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
                    spotExRate = plInfo.getDynamicObject("plcurrency_s").getString("number").equals(forexQuoteInfo.getFxquote().split("/")[0]) ? (ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? forexQuoteInfo.getBuyPrice() : forexQuoteInfo.getMiddleprice()) : (ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? forexQuoteInfo.getSellPrice() : forexQuoteInfo.getMiddleprice());
                }
                result.put("spotexrate", spotExRate);
                floatPlAmt = plInfo.getDynamicObject("plcurrency_s").getString("number").equals(fxQuote.split("/")[0]) ? floatPlAmt.multiply(spotExRate) : floatPlAmt.divide(spotExRate, 10, 4);
            }
            int amtPrecision = plInfo.getDynamicObject("plcurrency").getInt("amtPrecision");
            floatPlAmt = floatPlAmt.setScale(amtPrecision, RoundingMode.HALF_UP);
        }
        result.put("floatplamt", floatPlAmt);
        return result;
    }

    public static BigDecimal getReferExRate(ForexQuoteInfo fqInfo, DynamicObject tradeBill, DynamicObject plInfo) {
        String dir = tradeBill.getString("tradedirect");
        String pair = tradeBill.getString("pair");
        String swapDir = plInfo.getString("swapdir");
        BigDecimal rate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(fqInfo.getFxquote()) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(fqInfo.getFxquote()) ? (!"isfar".equals(swapDir) ? fqInfo.getSellPrice() : fqInfo.getBuyPrice()) : (!"isfar".equals(swapDir) ? fqInfo.getBuyPrice() : fqInfo.getSellPrice());
        return rate;
    }

    public static BigDecimal getReferExRate_ForexOptions(ForexQuoteInfo fqInfo, DynamicObject tradeBill) {
        BigDecimal rate;
        String dir = tradeBill.getString("tradedirect");
        String pair = tradeBill.getString("pair");
        String tradeType = tradeBill.getString("tradetype");
        if (pair.equals(fqInfo.getFxquote())) {
            rate = fqInfo.getBuyPrice();
            if (PlInfoCalculateHelper.callAndBuyORPutAndsell(dir, tradeType)) {
                rate = fqInfo.getSellPrice();
            }
        } else {
            rate = fqInfo.getBuyPrice();
            if (PlInfoCalculateHelper.callAndSellORPutAndBuy(dir, tradeType)) {
                rate = fqInfo.getSellPrice();
            }
        }
        return rate;
    }

    public static BigDecimal calFloatPl_ForexOption_byReferPremium(DynamicObject plInfo, DynamicObject tradeBill, boolean usePlAmt) {
        BigDecimal bizrestAmt;
        if (EmptyUtil.isEmpty((DynamicObject)plInfo.getDynamicObject("forexquote"))) {
            return BigDecimal.ZERO;
        }
        BigDecimal floatPlAmt = BigDecimal.ZERO;
        Long fqId = plInfo.getDynamicObject("forexquote").getLong("id");
        String dir = tradeBill.getString("tradedirect");
        DynamicObject bizRecord = PlInfoCalculateHelper.getBizBillBizRecord(plInfo);
        BigDecimal bigDecimal = bizrestAmt = usePlAmt ? plInfo.getBigDecimal("bizrestamt") : bizRecord.getBigDecimal("restamt");
        if (EmptyUtil.isNoEmpty((DynamicObject)plInfo.getDynamicObject("plcurrency"))) {
            DynamicObject plcurrency = plInfo.getDynamicObject("plcurrency");
            Long curId = plcurrency.getLong("id");
            DynamicObject premiumCur = tradeBill.getDynamicObject("premiumcurrency");
            BigDecimal premium = tradeBill.getBigDecimal("premium");
            if (!curId.equals(premiumCur.getLong("id"))) {
                String fxQuote3 = plcurrency.getString("number").trim() + "/" + premiumCur.getString("number").trim();
                ForexQuoteInfo sportFqInfo3 = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote3, null, null);
                premium = plcurrency.getString("number").equals(sportFqInfo3.getFxquote().split("/")[0]) ? premium.divide(sportFqInfo3.getSellPrice(), 10, RoundingMode.HALF_UP) : premium.multiply(sportFqInfo3.getBuyPrice());
            }
            BigDecimal buyAmt = tradeBill.getBigDecimal("amount");
            BigDecimal referPremium = plInfo.getBigDecimal("referpremium");
            floatPlAmt = referPremium.subtract(premium.multiply(bizrestAmt).divide(buyAmt, 10, RoundingMode.HALF_UP));
            if (TradeDirectionEnum.sell.getValue().equals(dir)) {
                floatPlAmt = floatPlAmt.multiply(Constants._ONE);
            }
            int amtPrecision = plInfo.getDynamicObject("plcurrency").getInt("amtPrecision");
            floatPlAmt = floatPlAmt.setScale(amtPrecision, RoundingMode.HALF_UP);
        }
        return floatPlAmt;
    }

    public static Map<String, Object> calFloatPl_ForexOption_byExRate(DynamicObject plInfo, DynamicObject tradeBill, boolean usePlAmt, BigDecimal spotExRate) {
        BigDecimal bizrestAmt;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (EmptyUtil.isEmpty((DynamicObject)plInfo.getDynamicObject("forexquote"))) {
            return result;
        }
        Long fqId = plInfo.getDynamicObject("forexquote").getLong("id");
        BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
        String pair = tradeBill.getString("pair");
        String fxQuote = tradeBill.getString("fxquote");
        String dir = tradeBill.getString("tradedirect");
        String tradeType = tradeBill.getString("tradetype");
        BigDecimal exchangeRate = tradeBill.getBigDecimal("exchangerate");
        DynamicObject bizRecord = PlInfoCalculateHelper.getBizBillBizRecord(plInfo);
        BigDecimal bigDecimal = bizrestAmt = usePlAmt ? plInfo.getBigDecimal("bizrestamt") : bizRecord.getBigDecimal("restamt");
        BigDecimal floatPlAmt = pair.equals(fxQuote) ? (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? PlInfoCalculateHelper.calAmountForwardDirection(referExrate, exchangeRate, bizrestAmt, dir) : PlInfoCalculateHelper.calAmountForwardDirection(exchangeRate, referExrate, bizrestAmt, dir)) : (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? PlInfoCalculateHelper.calAmountReverseDirection(referExrate, exchangeRate, bizrestAmt, dir) : PlInfoCalculateHelper.calAmountReverseDirection(exchangeRate, referExrate, bizrestAmt, dir));
        if (EmptyUtil.isNoEmpty((DynamicObject)plInfo.getDynamicObject("plcurrency"))) {
            DynamicObject plcurrencyS = plInfo.getDynamicObject("plcurrency_s");
            DynamicObject plcurrency = plInfo.getDynamicObject("plcurrency");
            Long curId = plcurrency.getLong("id");
            if (!curId.equals(plcurrencyS.getLong("id"))) {
                if (EmptyUtil.isEmpty((BigDecimal)spotExRate)) {
                    ForexQuoteInfo sportFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)plInfo.getDate("updatedate"), null);
                    String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
                    spotExRate = plcurrency.getString("number").equals(sportFqInfo.getFxquote().split("/")[0]) ? (ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? sportFqInfo.getSellPrice() : sportFqInfo.getMiddleprice()) : (ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? sportFqInfo.getBuyPrice() : sportFqInfo.getMiddleprice());
                }
                result.put("spotexrate", spotExRate);
                floatPlAmt = plcurrency.getString("number").equals(fxQuote.split("/")[0]) ? floatPlAmt.divide(spotExRate, 10, RoundingMode.HALF_UP) : floatPlAmt.multiply(spotExRate);
            }
            DynamicObject premiumCur = tradeBill.getDynamicObject("premiumcurrency");
            BigDecimal premium = tradeBill.getBigDecimal("premium");
            if (!curId.equals(premiumCur.getLong("id"))) {
                String fxQuote3 = plcurrency.getString("number").trim() + "/" + premiumCur.getString("number").trim();
                ForexQuoteInfo sportFqInfo3 = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote3, null, null);
                premium = plcurrency.getString("number").equals(sportFqInfo3.getFxquote().split("/")[0]) ? premium.divide(sportFqInfo3.getSellPrice(), 10, RoundingMode.HALF_UP) : premium.multiply(sportFqInfo3.getBuyPrice());
            }
            BigDecimal buyAmt = tradeBill.getBigDecimal("amount");
            BigDecimal calAmt = premium.multiply(bizrestAmt).divide(buyAmt, 10, RoundingMode.HALF_UP);
            floatPlAmt = TradeDirectionEnum.buy.getValue().equals(dir) ? floatPlAmt.subtract(calAmt) : floatPlAmt.add(calAmt);
            int amtPrecision = plInfo.getDynamicObject("plcurrency").getInt("amtPrecision");
            floatPlAmt = floatPlAmt.setScale(amtPrecision, RoundingMode.HALF_UP);
        }
        result.put("floatplamt", floatPlAmt);
        return result;
    }

    public static void updatePlInfo_Forex(DynamicObject info, DynamicObject tradeBill) {
        if (EmptyUtil.isNoEmpty((DynamicObject)info.getDynamicObject("forexquote"))) {
            ForexQuoteInfo fqInfo;
            Long fqId = info.getDynamicObject("forexquote").getLong("id");
            String useExRate = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"useexrate");
            String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
            Date Dm = UseExRateEnum.FORWARD.getValue().equals(useExRate) ? PlInfoCalculateHelper.getDeyDateForReferExRate(info) : null;
            String pair = tradeBill.getString("pair");
            String fxQuote = tradeBill.getString("fxquote");
            if (!fxQuote.equals((fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)info.getDate("updatedate"), (Date)Dm)).getFxquote())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u4ef7\u6765\u6e90\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0e\u4ea4\u6613\u5355\u636e\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u62a5\u4ef7\u6765\u6e90\u3002", (String)"PlInfoCalculateHelper_0", (String)"tmc-tm-common", (Object[])new Object[0]));
            }
            BigDecimal referExrate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? PlInfoCalculateHelper.getReferExRate(fqInfo, tradeBill, info) : fqInfo.getMiddleprice();
            info.set("referexrate", (Object)referExrate);
            info.set("issuedate", (Object)fqInfo.getIssuetime());
            Map<String, Object> result = PlInfoCalculateHelper.calFloatPlAmt_Forex(info, tradeBill, false, null);
            info.set("floatplamt", result.get("floatplamt"));
            info.set("spotexrate", result.get("spotexrate"));
            DynamicObject localCurrency = info.getDynamicObject("localcurrency");
            if (localCurrency != null && PlInfoCalculateHelper.isShowVoucherPlPanel(tradeBill, localCurrency.getLong("id"))) {
                PlInfoCalculateHelper.setVoucherPl_plInfo(info, fqId, Dm);
            }
        }
        PlInfoCalculateHelper.updatePlInfo_Local(info);
    }

    public static void setVoucherPl_plInfo(DynamicObject plInfo, Long fqId, Date Dm) {
        BigDecimal sellExAmt;
        BigDecimal sellExRate;
        BigDecimal buyExAmt;
        BigDecimal buyExRate;
        Long orgId = plInfo.get("org") instanceof DynamicObject ? Long.valueOf(plInfo.getDynamicObject("org").getLong("id")) : Long.valueOf(plInfo.getLong("org"));
        String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)orgId, (String)"exratedir");
        DynamicObject localCurrency = plInfo.getDynamicObject("localcurrency");
        DynamicObject buyCurrency = plInfo.getDynamicObject("buycurrency");
        DynamicObject sellCurrency = plInfo.getDynamicObject("sellcurrency");
        BigDecimal buyAmt = plInfo.getBigDecimal("buyamount");
        BigDecimal sellAmt = plInfo.getBigDecimal("sellamount");
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        ForexQuoteInfo buyCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)(buyCurrencyNumber + "/" + localCurrency.getString("number")), (Date)plInfo.getDate("updatedate"), (Date)Dm);
        String buyCurFxQuote = buyCurFqInfo.getFxquote();
        boolean isUseBuyOrSellPrice = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir);
        if (buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0])) {
            buyExRate = isUseBuyOrSellPrice ? buyCurFqInfo.getBuyPrice() : buyCurFqInfo.getMiddleprice();
            buyExAmt = buyAmt.multiply(buyExRate);
        } else {
            buyExRate = isUseBuyOrSellPrice ? buyCurFqInfo.getSellPrice() : buyCurFqInfo.getMiddleprice();
            buyExAmt = buyAmt.divide(buyExRate, 10, 4);
        }
        ForexQuoteInfo sellCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)(sellCurrencyNumber + "/" + localCurrency.getString("number")), (Date)plInfo.getDate("updatedate"), (Date)Dm);
        String sellCurFxQuote = sellCurFqInfo.getFxquote();
        if (sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0])) {
            sellExRate = isUseBuyOrSellPrice ? sellCurFqInfo.getBuyPrice() : sellCurFqInfo.getMiddleprice();
            sellExAmt = sellAmt.multiply(sellExRate);
        } else {
            sellExRate = isUseBuyOrSellPrice ? sellCurFqInfo.getSellPrice() : sellCurFqInfo.getMiddleprice();
            sellExAmt = sellAmt.divide(sellExRate, 10, 4);
        }
        plInfo.set("buy_local_fq", (Object)buyCurFxQuote);
        plInfo.set("buy_local_exrate", (Object)buyExRate);
        plInfo.set("sell_local_fq", (Object)sellCurFxQuote);
        plInfo.set("sell_local_exrate", (Object)sellExRate);
        plInfo.set("voucher_pl", (Object)buyExAmt.subtract(sellExAmt));
    }

    public static boolean isShowVoucherPlPanel(DynamicObject tradeBill, Long localCurrencyId) {
        DynamicObject sellCurrency;
        DynamicObject buyCurrency = tradeBill.getDynamicObject("CURRENCY");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency = tradeBill.getDynamicObject("SELLCURRENCY")})) {
            return false;
        }
        long buyCurrencyId = buyCurrency.getLong("id");
        long sellCurrencyId = sellCurrency.getLong("id");
        return buyCurrencyId != localCurrencyId && sellCurrencyId != localCurrencyId && "deliverable".equals(tradeBill.getString("deliveryway"));
    }

    public static void updatePlInfo_Local(DynamicObject plInfo) {
        Long localCurrencyId = plInfo.getDynamicObject("localcurrency").getLong("id");
        DynamicObject fq_local = plInfo.getDynamicObject("forexquote");
        DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)plCurrency) && !localCurrencyId.equals(plCurrency.getLong("id"))) {
            DynamicObject localCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
            int amtprecision = localCurrency.getInt("amtprecision");
            String fxquote_local = plCurrency.getString("number").trim() + "/" + localCurrency.getString("number").trim();
            if (fq_local != null) {
                BigDecimal floatPlAmt_local;
                BigDecimal exrate_local;
                ForexQuoteInfo fqInfo_local = MarketDataServiceHelper.getForexQuoteInfo((Long)fq_local.getLong("id"), (String)fxquote_local, (Date)plInfo.getDate("updatedate"), null);
                plInfo.set("fxquote_local", (Object)fqInfo_local.getFxquote());
                BigDecimal floatPlAmt = plInfo.getBigDecimal("floatplamt");
                DynamicObject tradeBill = plInfo.getDynamicObject("tradebill");
                String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
                if (plInfo.getDynamicObject("plcurrency").getString("number").equals(fqInfo_local.getFxquote().split("/")[0])) {
                    exrate_local = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? fqInfo_local.getBuyPrice() : fqInfo_local.getMiddleprice();
                    floatPlAmt_local = floatPlAmt.multiply(exrate_local).setScale(amtprecision, 4);
                } else {
                    exrate_local = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? fqInfo_local.getSellPrice() : fqInfo_local.getMiddleprice();
                    floatPlAmt_local = floatPlAmt.divide(exrate_local, amtprecision, 4);
                }
                plInfo.set("exrate_local", (Object)exrate_local);
                plInfo.set("floatpllocalamt", (Object)floatPlAmt_local);
            }
        } else {
            plInfo.set("fxquote_local", null);
            plInfo.set("exrate_local", null);
            plInfo.set("floatpllocalamt", null);
        }
    }

    public static BigDecimal calFloatPlAmt_ForwRateAgree(DynamicObject plInfo, Long BillId) {
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)BillId, (String)"tm_forwrateagree");
        QFilter filterCashFlow = new QFilter("billid", "=", (Object)BillId);
        DynamicObject cashFlow = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"billno,cfpayamount,entrys.cfuserate,entrys.cfratefixdate,entrys.cfratefixindex,entrys.cfperioddays", (QFilter[])new QFilter[]{filterCashFlow});
        DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
        DynamicObject cashFlowEntry = (DynamicObject)entrys.get(0);
        BigDecimal referexrate = plInfo.getBigDecimal("referexrate");
        BigDecimal contractrate = bill.getBigDecimal("contractrate");
        BigDecimal amount = bill.getBigDecimal("amount");
        String tradeDirect = bill.getString("tradedirect");
        int cfperioddays = cashFlowEntry.getInt("cfperioddays");
        int basis = TradeBusinessHelper.getBasis_YearDay((int)0, (BasisEnum)BasisEnum.getEnum((String)bill.getString("basis")));
        BigDecimal periodDaysDivYrbasis = BigDecimal.valueOf(cfperioddays).divide(BigDecimal.valueOf(basis), 10, RoundingMode.HALF_UP);
        BigDecimal floatPlAmt = referexrate.subtract(contractrate).multiply(amount).divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis);
        if ("advance".equals(bill.getString("payrule"))) {
            floatPlAmt = floatPlAmt.divide(referexrate.divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis).add(BigDecimal.ONE), 10, RoundingMode.HALF_UP);
        }
        logger.info("\u8ba1\u7b97\u6d6e\u52a8\u635f\u76ca(\u8fdc\u671f\u5229\u7387\u534f\u8bae)\uff1a\u6d6e\u52a8\u635f\u76ca\uff1a{}\uff1b\u9884\u4f30\u5229\u7387\uff1a{}\uff1b\u5468\u671f\u5929\u6570\uff1a{}", new Object[]{floatPlAmt.toPlainString(), referexrate.toPlainString(), periodDaysDivYrbasis.toPlainString()});
        if ("buy".equals(tradeDirect)) {
            return floatPlAmt;
        }
        return floatPlAmt.negate();
    }

    public static DynamicObject buildPlHistory(DynamicObject info) {
        DynamicObject plHistoryInfo = TmcDataServiceHelper.newDynamicObject((String)"tbo_plinfo_history");
        plHistoryInfo.set("plbill", info.get("id"));
        plHistoryInfo.set("billstatus", (Object)TcBillStatusEnum.SAVE.getValue());
        DataEntityPropertyCollection properties = plHistoryInfo.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if ("id".equals(name) || property instanceof LongProp || "plbill".equals(name) || "plprovisioncurrency".equals(name) || "plprovisionamt".equals(name) || "provision".equals(name) || "plprovisioninfo".equals(name) || "billstatus".equals(name) || info.get(name) instanceof DynamicObjectCollection) continue;
            plHistoryInfo.set(name, info.get(name));
        }
        return plHistoryInfo;
    }

    public static BigDecimal getRateByParam(DynamicObject org, DynamicObject sellCurrency, DynamicObject buyCurrency, ForexQuoteInfo fqInfo) {
        String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)org.getLong("id"), (String)"exratedir");
        BigDecimal referExrate = BigDecimal.ZERO;
        if (buyCurrency.getLong("id") != sellCurrency.getLong("id")) {
            referExrate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? (sellCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0]) ? fqInfo.getBuyPrice() : fqInfo.getSellPrice()) : fqInfo.getMiddleprice();
        }
        return referExrate;
    }
}

