/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum CombReqNoteEnum {
    SPOT("spotinfolist", "spotinfo", "spotorg", "01FOREXSPOT", "937486862912605184", "pushandsavespot", "spisbizbill", "spottransactionno", "spotbill", "spotstatus", "tm_forex", "spotcurrencytypein", "spotcurrencytypeout", "spotamountin", "spotamountout", Arrays.asList("spbizdate", "spotapplydeliverydate", "spotbusinesstype", "spotcurrencytypein", "spotcurrencytypeout", "spotamountout", "spcounpty", "spotexchangequotation", "spotexpectratebottom", "spotexpectratetop")),
    FORWARD("forwardinfolist", "forwardinfo", "fwdorg", "02FOREXFORWARD", "937487193708953600", "pushandsavefwd", "foisbizbill", "transactionno", "fwdbill", "forwardstatus", "tm_forex_forward", "currencytypein", "currencytypeout", "amountin", "amountout", Arrays.asList("fobizdate", "isoptionaltraction", "deliverydate", "deliverystartdate", "deliveryenddate", "businesstype", "currencytypein", "currencytypeout", "amountin", "amountout", "focounterpartyid", "deliveryway", "exchangequotation", "expectratebottom", "expectratetop")),
    SWAPS("swapsinfolist", "swapsinfo", "swapsorg", "03FOREXSWAPS", "937487388609891328", "pushandsaveswaps", "swisbizbill", "bizbillno", "swapsbill", "swstatus", "tm_forex_swaps", "currin", "currout", "amtin", "amtout", Arrays.asList("swbizdate", "swsettledate", "bustype", "currin", "currout", "amtin", "amtout", "swcounterparty", "quote", "exratebottom", "exratetop")),
    OPTIONS("optionsinfolist", "optionsinfo", "optionsorg", "04FOREXOPTION", "941773368233832448", "pushandsaveoptions", "opisbizbill", "opbizbillno", "optionsbill", "opstatus", "tm_forex_options", "opcurrin", "opcurrout", "opamtin", "opamtout", Arrays.asList("opbizdate", "opdeliverydate", "opbustype", "opcurrin", "opcurrout", "opamtin", "opamtout", "optiontype", "opdirect", "tradedirect", "opcounpty", "delmode", "opquote", "exerate", "opcurrency", "opfeebottom", "opfeetop"));

    private final String entryName;
    private final String entryOrgName;
    private final String entryControlName;
    private final String productType;
    private final String productTypeId;
    private final String pushType;
    private final String genbizbillField;
    private final String billNo;
    private final String billIdName;
    private final String billstatus;
    private final String billType;
    private final String entryBuyCurrName;
    private final String entrySellCurrName;
    private final String entryBuyAmtName;
    private final String entrySellAmtName;
    private final List<String> needClearFileds;

    private CombReqNoteEnum(String entryControlName, String entryName, String entryOrgName, String productType, String productTypeId, String pushType, String isgenbizbillField, String billNo, String billIdName, String billstatus, String billType, String entryBuyCurrName, String entrySellCurrName, String entryBuyAmtName, String entrySellAmtName, List<String> needClearFileds) {
        this.entryName = entryName;
        this.entryOrgName = entryOrgName;
        this.entryControlName = entryControlName;
        this.productType = productType;
        this.productTypeId = productTypeId;
        this.pushType = pushType;
        this.genbizbillField = isgenbizbillField;
        this.billNo = billNo;
        this.billstatus = billstatus;
        this.billType = billType;
        this.billIdName = billIdName;
        this.entryBuyCurrName = entryBuyCurrName;
        this.entrySellCurrName = entrySellCurrName;
        this.entryBuyAmtName = entryBuyAmtName;
        this.entrySellAmtName = entrySellAmtName;
        this.needClearFileds = needClearFileds;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getEntryOrgName() {
        return this.entryOrgName;
    }

    public String getEntryControlName() {
        return this.entryControlName;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getPushType() {
        return this.pushType;
    }

    public String getGenbizbillField() {
        return this.genbizbillField;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public String getBillstatus() {
        return this.billstatus;
    }

    public String getBillType() {
        return this.billType;
    }

    public String getBillIdName() {
        return this.billIdName;
    }

    public String getEntryBuyCurrName() {
        return this.entryBuyCurrName;
    }

    public String getEntrySellCurrName() {
        return this.entrySellCurrName;
    }

    public String getEntryBuyAmtName() {
        return this.entryBuyAmtName;
    }

    public String getEntrySellAmtName() {
        return this.entrySellAmtName;
    }

    public List<String> getNeedClearFileds() {
        return this.needClearFileds;
    }

    public String getProductTypeId() {
        return this.productTypeId;
    }

    public static boolean isContainProductType(String productType) {
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        return Arrays.stream(values).anyMatch(e -> e.getProductType().equals(productType));
    }

    public static List<String> getAllEntryName() {
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        return Arrays.stream(values).map(CombReqNoteEnum::getEntryName).collect(Collectors.toList());
    }

    public static List<String> getAllEntryOrgName() {
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        return Arrays.stream(values).map(CombReqNoteEnum::getEntryOrgName).collect(Collectors.toList());
    }

    public static CombReqNoteEnum getByProductType(String number) {
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        Optional<CombReqNoteEnum> first = Arrays.stream(values).filter(e -> e.getProductType().equals(number)).findFirst();
        return first.orElse(null);
    }

    public static CombReqNoteEnum getByProductTypeId(String productTypeId) {
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        Optional<CombReqNoteEnum> first = Arrays.stream(values).filter(e -> e.getProductTypeId().equals(productTypeId)).findFirst();
        return first.orElse(null);
    }

    public static CombReqNoteEnum getByEntryName(String entryName) {
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        Optional<CombReqNoteEnum> first = Arrays.stream(values).filter(e -> e.getEntryName().equals(entryName)).findFirst();
        return first.orElse(null);
    }

    public static CombReqNoteEnum getByBillType(String billType) {
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        Optional<CombReqNoteEnum> first = Arrays.stream(values).filter(e -> e.getBillType().equals(billType)).findFirst();
        return first.orElse(null);
    }

    public String getReqnoteEntityName() {
        switch (this) {
            case SPOT: {
                return "tm_reqnote_spot";
            }
            case FORWARD: {
                return "tm_reqnote_forward";
            }
            case SWAPS: {
                return "tm_reqnote_swaps";
            }
            case OPTIONS: {
                return "tm_reqnote_options";
            }
        }
        return "";
    }
}

