/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.ReturnValTypeEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.AccrualExDivMethodEnum;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.helper.BondIssueBizHelper;
import kd.tmc.tm.common.helper.CashFlowHelper;

public class BondBizHelper {
    private static final Log logger = LogFactory.getLog(BondBizHelper.class);

    public static boolean isAfter(DynamicObject bondIssue, Date basedate, Date nextPaydateAfterBasedate) {
        if (!CashFlowHelper.isCouponPaydate(bondIssue, basedate)) {
            return BondBizHelper.isEqualsOrAfterExdivdate(bondIssue, basedate, nextPaydateAfterBasedate);
        }
        return false;
    }

    private static DynamicObject[] getWorkCalendar(DynamicObject bondIssue) {
        DynamicObjectCollection calendars = bondIssue.getDynamicObjectCollection("calendars");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)calendars)) {
            return null;
        }
        Object[] workCalendar = new DynamicObject[]{};
        workCalendar = (DynamicObject[])calendars.toArray(workCalendar);
        return workCalendar;
    }

    public static boolean isEqualsOrAfterExdivdate(DynamicObject bondIssue, Date comparedate, Date coupondate) {
        Date exdivdate;
        boolean isAfterExdiv = false;
        String exdiv = (String)bondIssue.get("accrualexdivmethod");
        AccrualExDivMethodEnum exdivEnum = AccrualExDivMethodEnum.valueOf(exdiv);
        isAfterExdiv = exdivEnum == AccrualExDivMethodEnum.None ? false : !comparedate.before(exdivdate = BondIssueBizHelper.getAccrualExDivDate(bondIssue, coupondate));
        return isAfterExdiv;
    }

    public static BigDecimal getAccrual_FixAndFloat(DynamicObject bondIssue, String tradedirect, Date date, Date lastPaydate, Date nextPaydate, BigDecimal nextPayAmount) {
        if (EmptyUtil.isEmpty((Object)date)) {
            return BigDecimal.ZERO;
        }
        BigDecimal accrual = BigDecimal.ZERO;
        if (!CashFlowHelper.isCouponPaydate(bondIssue, date)) {
            BigDecimal basis;
            if (EmptyUtil.isEmpty((String)tradedirect)) {
                return BigDecimal.ZERO;
            }
            BasisEnum accrualBasisEnum = BasisEnum.valueOf((String)bondIssue.getString("accrualbasis"));
            DynamicObject[] calendars = BondBizHelper.getWorkCalendar(bondIssue);
            BigDecimal dir = BigDecimal.ONE;
            boolean isAfterExdiv = BondBizHelper.isEqualsOrAfterExdivdate(bondIssue, date, nextPaydate);
            if (isAfterExdiv) {
                basis = TradeBusinessHelper.getBaseBasis((Date)date, (Date)nextPaydate, (BasisEnum)accrualBasisEnum, (DynamicObject[])calendars, CashFlowHelper.getPaydateList(bondIssue), (PayFrequeEnum)PayFrequeEnum.valueOf((String)bondIssue.getString("payfreq")));
                if (!tradedirect.equals("buy")) {
                    dir = dir.negate();
                }
            } else {
                if (lastPaydate.compareTo(date) == 0) {
                    List<Date> paydateList = CashFlowHelper.getPaydateList(bondIssue);
                    int nextIndex = paydateList.indexOf(TcDateUtils.truncateDate((Date)nextPaydate));
                    lastPaydate = paydateList.get(nextIndex - 1);
                }
                basis = TradeBusinessHelper.getBaseBasis((Date)lastPaydate, (Date)date, (BasisEnum)accrualBasisEnum, (DynamicObject[])calendars, CashFlowHelper.getPaydateList(bondIssue), (PayFrequeEnum)PayFrequeEnum.valueOf((String)bondIssue.getString("payfreq")));
                if (tradedirect.equals("buy")) {
                    dir = dir.negate();
                }
            }
            accrual = nextPayAmount.multiply(basis).multiply(dir);
        } else {
            accrual = BigDecimal.ZERO;
        }
        String payFreq = bondIssue.getString("payfreq");
        BigDecimal freque = BigDecimal.valueOf(PayFrequeEnum.valueOf((String)payFreq).getFreque());
        accrual = accrual.multiply(freque);
        return accrual;
    }

    public static BigDecimal getAccrual_Theory_FixAndFloat(DynamicObject bondIssue, String tradedirect, Date date, Date lastPaydate, Date nextPaydate, BigDecimal nextPayAmount) {
        return BondBizHelper.getAccrual_FixAndFloat(bondIssue, tradedirect, date, lastPaydate, nextPaydate, nextPayAmount);
    }

    public static BigDecimal getAccrual_Zero() {
        return BigDecimal.ZERO;
    }

    public static BigDecimal getAccrual_Theory_Zero() {
        return BigDecimal.ZERO;
    }

    public static BigDecimal getDP_Theory_FixAndFloat(DynamicObject bondIssue, String tradedirect, boolean isAfter, Date referdate, BigDecimal amount, DynamicObjectCollection biCashFlowData) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referdate, amount})) {
            return BigDecimal.ZERO;
        }
        BigDecimal dir = tradedirect.equals("buy") ? BigDecimal.ONE : Constants._ONE;
        BigDecimal pv = !isAfter ? BondBizHelper.sumPV(biCashFlowData, referdate, false) : BondBizHelper.sumPV(biCashFlowData, referdate, true);
        return pv.multiply(Constants.ONE_HUNDRED).divide(amount, 6, 4).multiply(dir);
    }

    public static BigDecimal getDP_Theory_Zero(BigDecimal maturityDF) {
        if (EmptyUtil.isEmpty((BigDecimal)maturityDF)) {
            return BigDecimal.ZERO;
        }
        BigDecimal DP = maturityDF.multiply(Constants.ONE_HUNDRED);
        return DP;
    }

    public static BigDecimal getCP_FixAndFloat(String tradedirect, BigDecimal amount, BigDecimal DP, BigDecimal accrual) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount})) {
            return BigDecimal.ZERO;
        }
        BigDecimal dir = tradedirect.equals("buy") ? Constants._ONE : BigDecimal.ONE;
        BigDecimal CP = DP.subtract(accrual.divide(amount, 6, 4).multiply(Constants.ONE_HUNDRED).multiply(dir));
        return CP;
    }

    public static BigDecimal getCP_Theory_FixAndFloat(String tradedirect, BigDecimal amount, BigDecimal DP_Theory, BigDecimal accrual_Theory) {
        return BondBizHelper.getCP_FixAndFloat(tradedirect, amount, DP_Theory, accrual_Theory);
    }

    public static BigDecimal getDPByCP_Theory_FixAndFloat(String tradedirect, BigDecimal amount, BigDecimal CP_Theory, BigDecimal accrual_Theory) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount})) {
            return BigDecimal.ZERO;
        }
        BigDecimal dir = tradedirect.equals("buy") ? Constants._ONE : BigDecimal.ONE;
        BigDecimal DP = CP_Theory.add(accrual_Theory.divide(amount, 6, 4).multiply(Constants.ONE_HUNDRED).multiply(dir));
        return DP;
    }

    public static BigDecimal getCP_Theory_Zero(BigDecimal maturityDF) {
        if (EmptyUtil.isEmpty((BigDecimal)maturityDF)) {
            return BigDecimal.ZERO;
        }
        BigDecimal CP = maturityDF.multiply(Constants.ONE_HUNDRED);
        return CP;
    }

    private static BigDecimal sumPV(DynamicObjectCollection biCashFlowData, Date basedate, boolean startFromSecond) {
        BigDecimal pv = BigDecimal.ZERO;
        boolean isJumpFirst = false;
        for (int i = 0; i < biCashFlowData.size(); ++i) {
            Date curPaydate;
            DynamicObject curRow = (DynamicObject)biCashFlowData.get(i);
            if (EmptyUtil.isEmpty((Object)curRow.getDynamicObjectType().getProperty("cfpaydate")) || EmptyUtil.isEmpty((Object)(curPaydate = curRow.getDate("cfpaydate"))) || !curPaydate.after(basedate)) continue;
            if (startFromSecond && !isJumpFirst) {
                isJumpFirst = true;
                continue;
            }
            BigDecimal curPV = curRow.getBigDecimal("cfpv");
            pv = pv.add(curPV);
        }
        return pv;
    }

    public static BigDecimal getFundRate(DynamicObject bondIssue, Date settleDate, Long priceRuleId, Date nextPaydate) {
        PriceRuleInfo param = new PriceRuleInfo();
        YieldCurveInfo yieldCurveInfo = new YieldCurveInfo();
        yieldCurveInfo.setMarketId(Long.valueOf(bondIssue.getDynamicObject("market").getLong("id")));
        yieldCurveInfo.setReferDate(settleDate);
        yieldCurveInfo.setYieldType(YieldTypeEnum.disc);
        yieldCurveInfo.setValType(ReturnValTypeEnum.rate);
        HashMap<Date, Object> dfMap = new HashMap<Date, Object>(16);
        dfMap.put(nextPaydate, null);
        yieldCurveInfo.setDfMap(dfMap);
        param.setYieldCurve(new YieldCurveInfo[]{yieldCurveInfo});
        PriceRuleInfo priceRule = MarketDataServiceHelper.getPriceRule((Long)priceRuleId, (PriceRuleInfo)param);
        return (BigDecimal)priceRule.getYieldCurve()[0].getDfMap().get(nextPaydate);
    }

    public static BigDecimal calFDP(DynamicObject bondIssue, Date referDate, Date settleDate, DynamicObjectCollection biCashFlowData, BigDecimal accrualTheory, BigDecimal CPTheory, BigDecimal fundRate) {
        double T = (double)TcDateUtils.getDiffDays((Date)referDate, (Date)settleDate) / 365.25;
        BigDecimal FVC = BondBizHelper.calculateFVC(biCashFlowData, referDate, settleDate, fundRate, bondIssue);
        return CPTheory.add(accrualTheory).multiply(Constants.ONE.add(fundRate.multiply(BigDecimal.valueOf(T)))).subtract(FVC);
    }

    public static BigDecimal calFCP(BigDecimal FDP, BigDecimal accrual) {
        return FDP.subtract(accrual);
    }

    private static BigDecimal calculateFVC(DynamicObjectCollection biCashFlowData, Date refDate, Date settleDate, BigDecimal fundRate, DynamicObject bondIssue) {
        BigDecimal FVC = Constants.ZERO;
        ArrayList<Date> datelist = new ArrayList<Date>(10);
        for (int i = 0; i < biCashFlowData.size(); ++i) {
            DynamicObject map = (DynamicObject)biCashFlowData.get(i);
            if (!map.getDataEntityType().getProperties().contains((Object)"cfpaydate")) continue;
            Date payDate = (Date)map.get("cfpaydate");
            datelist.add(payDate);
        }
        PayFrequeEnum payfreqEnum = PayFrequeEnum.valueOf((String)bondIssue.getString("payfreq"));
        for (int i = 0; i < biCashFlowData.size(); ++i) {
            DynamicObject map = (DynamicObject)biCashFlowData.get(i);
            if (!map.getDataEntityType().getProperties().contains((Object)"cfpaydate")) continue;
            Date payDate = (Date)map.get("cfpaydate");
            String cftype = (String)map.get("cftype");
            if (!EmptyUtil.isNoEmpty((Object)payDate) || !payDate.after(refDate) || !payDate.before(settleDate) || !CashFlowTypeEnum.accrued.getValue().equals(cftype)) continue;
            DynamicObject[] calendar = BondBizHelper.getWorkCalendar(bondIssue);
            BigDecimal cfpayamount = map.getBigDecimal("cfpayamount");
            BigDecimal basis = TradeBusinessHelper.getBaseBasis((Date)payDate, (Date)settleDate, (BasisEnum)BasisEnum.valueOf((String)bondIssue.getString("accrualbasis")), (DynamicObject[])calendar, datelist, (PayFrequeEnum)payfreqEnum);
            FVC = FVC.add(cfpayamount.multiply(BigDecimal.valueOf(Math.pow(fundRate.add(Constants.ONE).doubleValue(), basis.doubleValue()))));
        }
        return FVC;
    }
}

