/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import kd.tmc.tm.common.helper.PlHelper;

public class BusinessBillHelper {
    private static final Log logger = LogFactory.getLog(BusinessBillHelper.class);

    public static void buildOtherForPush(DynamicObject bill) {
        String entityType = BusinessBillHelper.getProductType(bill).getEntity();
        String op = bill.getString("operate");
        BizOperateEnum operateEnum = BizOperateEnum.valueOf(op);
        long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        switch (operateEnum) {
            case flat: 
            case flat_n: 
            case flat_f: {
                if ("tm_forex".equals(entityType)) {
                    BusinessBillHelper.buildOther_Flat_Forex(bill, bizRecord);
                    break;
                }
                if ("tm_forex_options".equals(entityType)) {
                    BusinessBillHelper.buildOther_flat_forex_options(bill);
                    break;
                }
                BusinessBillHelper.buildOther_Flat_ForexFwd(bill, bizRecord);
                break;
            }
            case expiredey: 
            case expiredey_n: 
            case expiredey_f: {
                BusinessBillHelper.buildOther_ExpiredDey_ForexFwd(bill, bizRecord);
                DynamicObject tradeBill = bill.getDynamicObject("tradebill");
                if ("tm_forex_swaps".equals(entityType) && ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradeBill.getString("swaptype")) || "tm_forex_swaps".equals(entityType) && ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(tradeBill.getString("swaptype")) && BizOperateEnum.expiredey_n.getValue().equals(op) || "tm_forex".equals(entityType)) break;
                BigDecimal exRate = bizRecord.getBigDecimal("exrate");
                BigDecimal plAmt = BusinessBillHelper.calPlAmtWithPlCurrency(bill.getBigDecimal("execexrate"), exRate, bill);
                bill.set("plamt", (Object)plAmt);
                BusinessBillHelper.setBaseInfo_PL(bill);
                break;
            }
            case defer: 
            case defer_n: 
            case defer_f: {
                BusinessBillHelper.buildOther_defer(bill, bizRecord);
                break;
            }
            case maudate: 
            case maudate_n: 
            case maudate_f: {
                BusinessBillHelper.buildOther_before(bill, bizRecord);
                break;
            }
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                BusinessBillHelper.buildOther_bdelivery(bill, bizRecord);
                break;
            }
            case exercise: {
                BusinessBillHelper.buildOther_exercise(bill);
                break;
            }
            case giveup: {
                BusinessBillHelper.buildOther_giveup(bill);
            }
        }
    }

    public static Date getDeyDate_ForexFwd(DynamicObject bill) {
        Date dm = bill.getBoolean("isdaterange") ? bill.getDate("deydate_end") : bill.getDate("deliverydate");
        return dm;
    }

    private static void buildOther_giveup(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        DynamicObject premCurrency = tradeBill.getDynamicObject("premiumcurrency");
        bill.set("premcurrency_src", (Object)premCurrency);
        BigDecimal premium = tradeBill.getBigDecimal("premium");
        bill.set("premium_src", (Object)premium);
        DynamicObject settleCurrency = tradeBill.getDynamicObject("settlecurrency");
        bill.set("settlecurrency", (Object)settleCurrency);
        Date expireDate = tradeBill.getDate("adjexpiredate");
        bill.set("expireddate", (Object)expireDate);
        Date curDate = TcDateUtils.getCurrentDate();
        Date bizDate = tradeBill.getDate("bizdate");
        if (!curDate.before(bizDate) && !curDate.after(expireDate)) {
            bill.set("bizdate", (Object)curDate);
        }
        Date optDate = bill.getDate("bizdate");
        Date adjustSettleDate = tradeBill.getDate("adjustsettledate");
        bill.set("execexrate", (Object)BusinessBillHelper.getExRateOption(tradeBill, optDate, adjustSettleDate));
        DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"plcurrency", (QFilter[])new QFilter[]{new QFilter("tradebill", "=", (Object)tradeBill.getLong("id"))});
        if (DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.getString("deliveryway"))) {
            bill.set("plcurrency", (Object)tradeBill.getDynamicObject("settlecurrency"));
        } else {
            bill.set("plcurrency", tradeBill.get("sellcurrency"));
        }
        bill.set("reccurrency", (Object)plInfo.getDynamicObject("plcurrency"));
        bill.set("paycurrency", (Object)plInfo.getDynamicObject("plcurrency"));
        Map<String, Object> result = PlHelper.calPlAmt_GiveUp_ForexOptionForBusinessBill(tradeBill, bill);
        for (Map.Entry<String, Object> e : result.entrySet()) {
            bill.set(e.getKey(), e.getValue());
        }
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    private static void buildOther_exercise(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        DynamicObject settleCurrency = tradeBill.getDynamicObject("settlecurrency");
        DynamicObject premCurrency = tradeBill.getDynamicObject("premiumcurrency");
        bill.set("premcurrency_src", (Object)premCurrency);
        BigDecimal premium = tradeBill.getBigDecimal("premium");
        bill.set("premium_src", (Object)premium);
        Date expireDate = tradeBill.getDate("adjexpiredate");
        bill.set("expireddate", (Object)expireDate);
        Date optDate = bill.getDate("bizdate");
        Date deliveryDate = bill.getDate("deliverydate");
        bill.set("execexrate", (Object)BusinessBillHelper.getExRateOption(tradeBill, optDate, deliveryDate));
        String deliveryWay = tradeBill.getString("deliveryway");
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
            String tradeType = tradeBill.getString("tradetype");
            String tradeDir = tradeBill.getString("tradedirect");
            if (OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(tradeDir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(tradeDir)) {
                bill.set("reccurrency", tradeBill.get("currency"));
                bill.set("paycurrency", tradeBill.get("sellcurrency"));
            } else {
                bill.set("paycurrency", tradeBill.get("currency"));
                bill.set("reccurrency", tradeBill.get("sellcurrency"));
            }
            bill.set("plcurrency", tradeBill.get("sellcurrency"));
        } else {
            bill.set("reccurrency", (Object)settleCurrency);
            bill.set("paycurrency", (Object)settleCurrency);
            bill.set("plcurrency", (Object)settleCurrency);
        }
        bill.set("settlecurrency", bill.get("plcurrency"));
        BigDecimal amt = BusinessBillHelper.calSettleAmount_ForexOptionForBusinessBill(tradeBill, bill);
        bill.set("settleamount", (Object)amt);
        Map<String, Object> result = PlHelper.calPlAmt_Ex_ForexOptionForBusinessBill(tradeBill, bill);
        for (Map.Entry<String, Object> e : result.entrySet()) {
            bill.set(e.getKey(), e.getValue());
        }
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    private static void buildOther_bdelivery(DynamicObject bill, DynamicObject bizRecord) {
        BusinessBillHelper.setExecExRateByDeliveryDate(bill);
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        bill.set("exratecalmtd", (Object)ExRateCalMethodEnum.SrcMinusFwdPips);
        BigDecimal exRate = bizRecord.getBigDecimal("exrate");
        Date bizDate = bizRecord.getDate("bizdate");
        Date deliveryDate = bill.getDate("deliverydate");
        Date opDate = bill.getDate("bizdate");
        BigDecimal spotExrate = BusinessBillHelper.getExRate(tradebill, opDate, deliveryDate, false);
        BigDecimal fwdExrate = BusinessBillHelper.getExRate(tradebill, opDate, bizDate, true);
        BigDecimal pips = fwdExrate.subtract(spotExrate).multiply(Constants.TEN_THOUSAND);
        bill.set("pips", (Object)pips);
        bill.set("spotrate_dey", (Object)exRate.subtract(pips.divide(Constants.TEN_THOUSAND, 10, 4)));
        BusinessBillHelper.setAmt_PL_bdelivery(bill, bizRecord);
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    private static void buildOther_defer(DynamicObject bill, DynamicObject bizRecord) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        BusinessBillHelper.setAdjDate(bill, tradebill, "expireddate", "deliverydate");
        BusinessBillHelper.setAdjDate(bill, tradebill, "expired_start", "deydate_start");
        BusinessBillHelper.setAdjDate(bill, tradebill, "expired_end", "deydate_end");
        BusinessBillHelper.setExecExRate(bill);
        bill.set("exratecalmtd", (Object)ExRateCalMethodEnum.SrcPlusSwapPips.getValue());
        Date bizDate = bill.getDate("bizdate");
        Date dm1 = BusinessBillHelper.getDeyDateSrc_ForexFwd(bizRecord);
        Date dm2 = BusinessBillHelper.getDeyDate_ForexFwd(bill);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dm1, dm2})) {
            BigDecimal rate1 = BusinessBillHelper.getExRate(tradebill, bizDate, dm1, true);
            BigDecimal rate2 = BusinessBillHelper.getExRate(tradebill, bizDate, dm2, false);
            bill.set("pips", (Object)rate2.subtract(rate1).multiply(Constants.TEN_THOUSAND));
        }
        BigDecimal exrate = bizRecord.getBigDecimal("exrate");
        BigDecimal pips = bill.getBigDecimal("pips");
        bill.set("spotrate_dey", (Object)exrate.add(pips.divide(Constants.TEN_THOUSAND, 10, 4)));
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    private static DynamicObject setAdjDate(DynamicObject bill, DynamicObject tradebill, String dateProp, String adjDateProp) {
        DynamicObjectCollection wc = tradebill.getDynamicObjectCollection("workcalendar");
        String adjMethod = tradebill.getString("dateadjustmethod");
        Date date = bill.getDate(dateProp);
        if (date != null) {
            Date adjDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)date, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)adjMethod));
            bill.set(adjDateProp, (Object)adjDate);
        }
        return tradebill;
    }

    private static void buildOther_before(DynamicObject bill, DynamicObject bizRecord) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        BusinessBillHelper.setAdjDate(bill, tradebill, "expireddate", "deliverydate");
        BusinessBillHelper.setAdjDate(bill, tradebill, "expired_start", "deydate_start");
        BusinessBillHelper.setAdjDate(bill, tradebill, "expired_end", "deydate_end");
        BusinessBillHelper.setExecExRate(bill);
        bill.set("exratecalmtd", (Object)ExRateCalMethodEnum.SrcMinusSwapPips.getValue());
        Date bizDate = bill.getDate("bizdate");
        Date dm1 = BusinessBillHelper.getDeyDateSrc_ForexFwd(bizRecord);
        Date dm2 = BusinessBillHelper.getDeyDate_ForexFwd(bill);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dm1, dm2})) {
            BigDecimal rate1 = BusinessBillHelper.getExRate(tradebill, bizDate, dm1, true);
            BigDecimal rate2 = BusinessBillHelper.getExRate(tradebill, bizDate, dm2, false);
            bill.set("pips", (Object)rate1.subtract(rate2).multiply(Constants.TEN_THOUSAND));
        }
        BigDecimal exrate = bizRecord.getBigDecimal("exrate");
        BigDecimal pips = bill.getBigDecimal("pips");
        bill.set("spotrate_dey", (Object)exrate.subtract(pips.divide(Constants.TEN_THOUSAND, 10, 4)));
        BusinessBillHelper.setAmt_PL(bill, bizRecord);
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    private static void buildOther_ExpiredDey_ForexFwd(DynamicObject bill, DynamicObject bizRecord) {
        BusinessBillHelper.setExecExRate(bill);
    }

    private static void buildOther_Flat_ForexFwd(DynamicObject bill, DynamicObject bizRecord) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        BigDecimal exRate = bizRecord.getBigDecimal("exrate");
        Date dm = bizRecord.getDate("enddate");
        if (EmptyUtil.isEmpty((Object)dm)) {
            dm = bizRecord.getDate("bizdate");
        }
        Date opdate = bill.getDate("bizdate");
        BigDecimal execExrate = BusinessBillHelper.getExRate(tradebill, opdate, dm, true);
        bill.set("execexrate", (Object)execExrate);
        bill.set("plsettledate", (Object)opdate);
        BigDecimal plAmt = BusinessBillHelper.calAmt_PL(execExrate, exRate, bill);
        plAmt = BusinessBillHelper.dealPlAmt_PlCurrencyNotSrc(plAmt, bill);
        bill.set("plamt", (Object)plAmt);
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    private static void buildOther_Flat_Forex(DynamicObject bill, DynamicObject bizRecord) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        BigDecimal exRate = bizRecord.getBigDecimal("exrate");
        bill.set("plsettledate", bill.get("bizdate"));
        Date opDate = bill.getDate("bizdate");
        BigDecimal execExrate = BusinessBillHelper.getExRate(tradebill, opDate, opDate, true);
        bill.set("execexrate", (Object)execExrate);
        BigDecimal plAmt = BusinessBillHelper.calPlAmtWithPlCurrency(execExrate, exRate, bill);
        bill.set("plamt", (Object)plAmt);
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    private static void calSettleAmountValue(DynamicObject bill, DynamicObject tradebill) {
        DynamicObject buyCurrency = tradebill.getDynamicObject("currency");
        DynamicObject firstCurrency = tradebill.getString("pair").startsWith(buyCurrency.getString("number")) ? buyCurrency : tradebill.getDynamicObject("sellcurrency");
        BigDecimal firstAmount = bill.getBigDecimal("bizamt1");
        String fxQuote = tradebill.getString("fxquote");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal spotRate = bill.getBigDecimal("execexrate");
        BigDecimal exchangeRate = tradebill.getBigDecimal("exchangerate");
        String left = fxQuote.split("/")[0];
        BigDecimal setAmt = left.equals(firstCurrency.getString("number")) ? (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? ForexOptionsHelper.calAmountForwardDirection(spotRate, exchangeRate, firstAmount, new ModelAgent((Object)tradebill)) : ForexOptionsHelper.calAmountForwardDirection(exchangeRate, spotRate, firstAmount, new ModelAgent((Object)tradebill))) : (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? ForexOptionsHelper.calAmountReverseDirection(spotRate, exchangeRate, firstAmount, new ModelAgent((Object)tradebill)) : ForexOptionsHelper.calAmountReverseDirection(exchangeRate, spotRate, firstAmount, new ModelAgent((Object)tradebill)));
        DynamicObject settleCurrency = tradebill.getDynamicObject("settlecurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCurrency)) {
            DynamicObject pricerule = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
            Long fqId = pricerule.getLong("forexquote");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, null);
            setAmt = forexQuoteInfo.getFxquote().startsWith(settleCurrency.getString("number")) ? setAmt.divide(forexQuoteInfo.getSellPrice(), 10, 4) : setAmt.multiply(forexQuoteInfo.getBuyPrice());
        }
        bill.set("settleamount", (Object)setAmt);
        bill.set("settlecurrency", bill.get("plcurrency"));
    }

    private static Date getDeyDateSrc_ForexFwd(DynamicObject bizRecord) {
        Date dm = bizRecord.getDate("bizdate");
        if (EmptyUtil.isEmpty((Object)dm)) {
            dm = bizRecord.getDate("enddate");
        }
        return dm;
    }

    private static void setExecExRate(DynamicObject bill) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        DynamicObject priceRule = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
        Date issueTime = priceRule.getDate("forexquote.issuetime");
        Date dm = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)tradebill.getDynamicObjectCollection("workcalendar"), (Date)issueTime, (int)tradebill.getInt("settledelay"));
        Date bizdate = bill.getDate("bizdate");
        BigDecimal execExrate = BusinessBillHelper.getExRate(tradebill, bizdate, dm, false);
        bill.set("execexrate", (Object)execExrate);
    }

    private static void setExecExRateByDeliveryDate(DynamicObject bill) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        Date bizdate = bill.getDate("bizdate");
        Date bedeydate = bill.getDate("deliverydate");
        BigDecimal execExrate = BusinessBillHelper.getExRate(tradebill, bizdate, null, false);
        bill.set("execexrate", (Object)execExrate);
    }

    private static void setAmt_PL(DynamicObject bill, DynamicObject bizRecord) {
        BigDecimal plAmt;
        String exrateCalMtd = bill.getString("exratecalmtd");
        if (EmptyUtil.isEmpty((String)exrateCalMtd)) {
            return;
        }
        if (ExRateCalMethodEnum.SrcPlusSwapPips.getValue().equals(exrateCalMtd)) {
            BigDecimal execExrate = bill.getBigDecimal("execexrate");
            BigDecimal deferExrate = bill.getBigDecimal("spotrate_dey");
            plAmt = BusinessBillHelper.calAmt_PL(execExrate, deferExrate, bill);
        } else {
            BigDecimal execExrate = bill.getBigDecimal("execexrate");
            BigDecimal fwdExrate = bizRecord.getBigDecimal("exrate");
            plAmt = BusinessBillHelper.calAmt_PL(execExrate, fwdExrate, bill);
        }
        plAmt = BusinessBillHelper.dealPlAmt_PlCurrencyNotSrc(plAmt, bill);
        bill.set("plamt", (Object)plAmt);
    }

    private static void setAmt_PL_bdelivery(DynamicObject bill, DynamicObject bizRecord) {
        BigDecimal amt_pl;
        BigDecimal exrate;
        String exrateCalMtd = bill.getString("exratecalmtd");
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        DynamicObject plCurrencySrc = tradebill.getDynamicObject("sellcurrency");
        if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
            BigDecimal beforeExrate = bill.getBigDecimal("spotrate_dey");
            exrate = bill.getBigDecimal("execexrate");
            amt_pl = BusinessBillHelper.calAmt_PL(exrate, beforeExrate, bill);
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, plCurrencySrc}) && plCurrency.getLong("id") != plCurrencySrc.getLong("id")) {
                amt_pl = plCurrencySrc.getString("number").equals(tradebill.getString("fxquote").split("/")[0]) ? amt_pl.multiply(exrate) : amt_pl.divide(exrate, 10, 4);
            }
            bill.set("plamt", (Object)amt_pl);
        }
        if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
            BigDecimal fwdExrate = bizRecord.getBigDecimal("exrate");
            exrate = bill.getBigDecimal("execexrate");
            amt_pl = BusinessBillHelper.calAmt_PL(exrate, fwdExrate, bill);
            if (plCurrency.getLong("id") != plCurrencySrc.getLong("id")) {
                Date bizdate = bill.getDate("bizdate");
                ForexQuoteInfo info = BusinessBillHelper.getForexQuoteInfo(tradebill, bizdate, null);
                amt_pl = info == null ? BigDecimal.ZERO : (plCurrencySrc.getString("number").equals(info.getFxquote().split("/")[0]) ? amt_pl.multiply(info.getBuyPrice()) : amt_pl.divide(info.getSellPrice(), 10, 4));
            }
            bill.set("plamt", (Object)amt_pl);
        }
    }

    protected static BigDecimal calAmt_PL(BigDecimal exrateA, BigDecimal exrateB, DynamicObject bill) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        BigDecimal amt = bill.getBigDecimal("bizamt1");
        BigDecimal amt_pl = BusinessBillHelper.isSameFx(tradebill) ? exrateA.subtract(exrateB).multiply(amt) : (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exrateA, exrateB}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(exrateA, 10, 4).subtract(BigDecimal.ONE.divide(exrateB, 10, 4)).multiply(amt));
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            amt_pl = amt_pl.negate();
        }
        return amt_pl;
    }

    protected static BigDecimal dealPlAmt_PlCurrencyNotSrc(BigDecimal plAmt, DynamicObject bill) {
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (plCurrency != null && plCurrency.getLong("id") != tradebill.getDynamicObject("sellcurrency").getLong("id")) {
            Date bizdate = bill.getDate("bizdate");
            ForexQuoteInfo info = BusinessBillHelper.getForexQuoteInfo(tradebill, bizdate, null);
            plAmt = info == null ? BigDecimal.ZERO : (tradebill.getDynamicObject("sellcurrency").getString("number").equals(info.getFxquote().split("/")[0]) ? plAmt.multiply(info.getBuyPrice()) : plAmt.divide(info.getSellPrice(), 10, 4));
        }
        return plAmt;
    }

    protected static BigDecimal calPlAmtWithPlCurrency(BigDecimal exrateA, BigDecimal exrateB, DynamicObject bill) {
        BigDecimal plAmt;
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (plCurrency == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal bizAmt1 = bill.getBigDecimal("bizamt1");
        if (BusinessBillHelper.isSameFx(tradebill)) {
            plAmt = exrateA.subtract(exrateB).multiply(bizAmt1);
            if (plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id")) {
                plAmt = exrateA.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : plAmt.divide(exrateA, 10, 4);
            }
        } else {
            plAmt = EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exrateA, exrateB}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(exrateA, 10, 4).subtract(BigDecimal.ONE.divide(exrateB, 10, 4)).multiply(bizAmt1);
            if (plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id")) {
                plAmt = plAmt.multiply(exrateA);
            }
        }
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            plAmt = plAmt.negate();
        }
        return plAmt;
    }

    public static boolean isSameFx(DynamicObject tradebill) {
        String pair = tradebill.getString("pair");
        String fxquote = tradebill.getString("fxquote");
        return !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxquote}) && pair.equals(fxquote);
    }

    private static void setBaseInfo_PL(DynamicObject bill) {
        boolean isShow;
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradebill.getDynamicObject("org").getLong("id"));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        boolean bl = isShow = plCurrency != null && plCurrency.getLong("id") != localCurrencyId.longValue();
        if (isShow) {
            BigDecimal baseAmt;
            BigDecimal baseExrate;
            DynamicObject localCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
            bill.set("basecurrency", (Object)localCurrency);
            String pair = localCurrency.getString("number") + "/" + plCurrency.getString("number");
            DynamicObject temp = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
            Long fqId = temp.getLong("forexquote.id");
            Date issueTime = temp.getDate("forexquote.issuetime");
            Date dm = null;
            Date bizdate = bill.getDate("bizdate");
            ProductTypeEnum protectTypeEnum = BusinessBillHelper.getProductType(bill);
            if (ProductTypeEnum.FOREXSPOT.equals((Object)protectTypeEnum)) {
                dm = EmptyUtil.isEmpty((Object)bizdate) ? issueTime : bizdate;
            }
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm);
            bill.set("basefq", (Object)fqInfo.getFxquote());
            BigDecimal amt_pl = bill.getBigDecimal("plamt");
            if (plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0])) {
                baseExrate = fqInfo.getBuyPrice();
                baseAmt = amt_pl.multiply(baseExrate);
            } else {
                baseExrate = fqInfo.getSellPrice();
                baseAmt = amt_pl.divide(baseExrate, 10, 4);
            }
            bill.set("baseexrate", (Object)baseExrate);
            bill.set("baseplamt", (Object)baseAmt);
            bill.set("plsettledate", bill.get("bizdate"));
        }
    }

    private static ProductTypeEnum getProductType(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        DynamicObject productType = tradeBill.getDynamicObject("protecttype");
        return ProductTypeEnum.getEnumByValue((String)productType.getString("number"));
    }

    public static BigDecimal getExRate(DynamicObject tradebill, Date issueTime, Date Dm, boolean isSameDirBuy) {
        ForexQuoteInfo info = BusinessBillHelper.getForexQuoteInfo(tradebill, issueTime, Dm);
        if (info == null) {
            return BigDecimal.ZERO;
        }
        String fxQuote = info.getFxquote();
        String tradeFxQuote = tradebill.getString("fxquote");
        String pair = tradebill.getString("pair");
        String dir = tradebill.getString("tradedirect");
        BigDecimal exRate = isSameDirBuy ? (dir.equals(TradeDirectionEnum.buy.getValue()) && pair.equals(fxQuote) || dir.equals(TradeDirectionEnum.sell.getValue()) && !pair.equals(fxQuote) ? info.getBuyPrice() : info.getSellPrice()) : (dir.equals(TradeDirectionEnum.buy.getValue()) && pair.equals(fxQuote) || dir.equals(TradeDirectionEnum.sell.getValue()) && !pair.equals(fxQuote) ? info.getSellPrice() : info.getBuyPrice());
        if (!fxQuote.equals(tradeFxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(exRate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)exRate, (Object)newExRate);
            return newExRate;
        }
        logger.info("\u53d6\u5230\u7684\u6c47\u7387{}", (Object)exRate);
        return exRate;
    }

    public static BigDecimal getExRateOption(DynamicObject tradebill, Date issueTime, Date Dm) {
        ForexQuoteInfo info = BusinessBillHelper.getForexQuoteInfo(tradebill, issueTime, Dm);
        if (EmptyUtil.isEmpty((Object)info)) {
            return BigDecimal.ZERO;
        }
        String fxQuote = info.getFxquote();
        String tradeFxQuote = tradebill.getString("fxquote");
        String pair = tradebill.getString("pair");
        String dir = tradebill.getString("tradedirect");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal sellPrice = BigDecimal.ZERO;
        BigDecimal buyPrice = BigDecimal.ZERO;
        if (info != null) {
            sellPrice = info.getSellPrice();
            buyPrice = info.getBuyPrice();
        }
        BigDecimal exRate = pair.equals(fxQuote) ? (ForexOptionsHelper.callAndBuyORPutAndsell(dir, tradeType) ? sellPrice : buyPrice) : (ForexOptionsHelper.callAndSellORPutAndBuy(dir, tradeType) ? sellPrice : buyPrice);
        if (!fxQuote.equals(tradeFxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(exRate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u5916\u6c47\u671f\u6743\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)exRate, (Object)newExRate);
            return newExRate;
        }
        logger.info("\u53d6\u5230\u7684\u5916\u6c47\u671f\u6743\u6c47\u7387{}", (Object)exRate);
        return exRate;
    }

    public static ForexQuoteInfo getForexQuoteInfo(DynamicObject tradebill, Date issueTime, Date Dm) {
        DynamicObject priceRule = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
        Long fqId = priceRule.getLong("forexquote");
        String fxQuote = tradebill.getString("fxquote");
        return MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, (Date)issueTime, (Date)Dm);
    }

    public static Boolean isSwapNear(String bizOp) {
        return BizOperateEnum.defer_n.getValue().equals(bizOp) || BizOperateEnum.maudate_n.getValue().equals(bizOp) || BizOperateEnum.flat_n.getValue().equals(bizOp) || BizOperateEnum.expiredey_n.getValue().equals(bizOp) || BizOperateEnum.bdelivery_n.getValue().equals(bizOp);
    }

    public static Boolean isSwapFar(String bizOp) {
        return BizOperateEnum.defer_f.getValue().equals(bizOp) || BizOperateEnum.maudate_f.getValue().equals(bizOp) || BizOperateEnum.flat_f.getValue().equals(bizOp) || BizOperateEnum.expiredey_f.getValue().equals(bizOp) || BizOperateEnum.bdelivery_f.getValue().equals(bizOp);
    }

    public static BigDecimal calSettleAmount_ForexOptionForBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        DynamicObject settleCurrency;
        DynamicObject firstCurrency = tradebill.getDynamicObject("currency");
        BigDecimal firstAmount = bill.getBigDecimal("bizamt1");
        String fxQuote = tradebill.getString("fxquote");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal spotRate = bill.getBigDecimal("execexrate");
        BigDecimal exchangeRate = tradebill.getBigDecimal("exchangerate");
        String left = fxQuote.split("/")[0];
        String tradedirect = tradebill.getString("tradedirect");
        BigDecimal setAmt = left.equals(firstCurrency.getString("number")) ? (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? spotRate.subtract(exchangeRate).multiply(firstAmount) : exchangeRate.subtract(spotRate).multiply(firstAmount)) : (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? BusinessBillHelper.calAmountReverseDirection(spotRate, exchangeRate, firstAmount) : BusinessBillHelper.calAmountReverseDirection(exchangeRate, spotRate, firstAmount));
        if (TradeDirectionEnum.sell.getValue().equals(tradedirect)) {
            setAmt = setAmt.negate();
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(settleCurrency = bill.getDynamicObject("settlecurrency"))) && firstCurrency.getLong("id") == settleCurrency.getLong("id")) {
            Date optDate;
            DynamicObject priceRule = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
            Long fqId = priceRule.getLong("forexquote");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, (Date)(optDate = bill.getDate("bizdate")), null);
            setAmt = forexQuoteInfo.getFxquote().startsWith(settleCurrency.getString("number")) ? setAmt.divide(forexQuoteInfo.getSellPrice(), 10, 4) : setAmt.multiply(forexQuoteInfo.getBuyPrice());
        }
        return setAmt;
    }

    public static BigDecimal calAmountReverseDirection(BigDecimal subtractor, BigDecimal minuend, BigDecimal principal) {
        BigDecimal calSubtractor = BigDecimal.ZERO;
        if (subtractor.compareTo(BigDecimal.ZERO) > 0) {
            calSubtractor = BigDecimal.ONE.divide(subtractor, 10, 4);
        }
        BigDecimal calMinuend = BigDecimal.ZERO;
        if (minuend.compareTo(BigDecimal.ZERO) > 0) {
            calMinuend = BigDecimal.ONE.divide(minuend, 10, 4);
        }
        return calSubtractor.subtract(calMinuend).multiply(principal);
    }

    public static Boolean cannotPlConfirm(DynamicObject bizbill) {
        String op = bizbill.getString("operate");
        ProductTypeEnum protectTypeEnum = BusinessBillHelper.getProductType(bizbill);
        String exrateCalMtd = bizbill.getString("exratecalmtd");
        Boolean cannot = BizOperateEnum.ratecfg.getValue().equals(op) || ProductTypeEnum.FOREXSPOT.equals((Object)protectTypeEnum) && BizOperateEnum.expiredey.getValue().equals(op) || ProductTypeEnum.FOREXFORWARD.equals((Object)protectTypeEnum) && BizOperateEnum.defer.getValue().equals(op) && ExRateCalMethodEnum.SrcPlusSwapPips.getValue().equals(exrateCalMtd) || ProductTypeEnum.FOREXFORWARD.equals((Object)protectTypeEnum) && BizOperateEnum.maudate.getValue().equals(op) && ExRateCalMethodEnum.SrcMinusSwapPips.getValue().equals(exrateCalMtd) || ProductTypeEnum.FOREXSWAPS.equals((Object)protectTypeEnum) && (BizOperateEnum.defer_n.getValue().equals(op) || BizOperateEnum.defer_f.getValue().equals(op)) && ExRateCalMethodEnum.SrcPlusSwapPips.getValue().equals(exrateCalMtd) || ProductTypeEnum.FOREXSWAPS.equals((Object)protectTypeEnum) && (BizOperateEnum.maudate_n.getValue().equals(op) || BizOperateEnum.maudate_f.getValue().equals(op)) && ExRateCalMethodEnum.SrcMinusSwapPips.getValue().equals(exrateCalMtd);
        if (ProductTypeEnum.FOREXSWAPS.equals((Object)protectTypeEnum) && (BizOperateEnum.expiredey_n.getValue().equals(op) || BizOperateEnum.expiredey_f.getValue().equals(op))) {
            DynamicObject tradeBill = bizbill.getDynamicObject("tradebill");
            cannot = PlHelper.isNeedPl_ForexSwapExpireDey(tradeBill.getLong("id"), op) == false;
        }
        return cannot;
    }

    public static BigDecimal calPremium_PL(DynamicObject bizbill) {
        DynamicObject plCurrency;
        BigDecimal exRate;
        String fxquote;
        BigDecimal premium;
        DynamicObject tradebill = (DynamicObject)bizbill.get("tradebill");
        DynamicObject premiumCur = tradebill.getDynamicObject("premiumcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{premiumCur, premium = tradebill.getBigDecimal("premium"), fxquote = (String)bizbill.get("premium_pl_fq"), exRate = (BigDecimal)bizbill.get("premium_pl_exrate"), plCurrency = (DynamicObject)bizbill.get("plcurrency")})) {
            return premium;
        }
        Long plId = plCurrency.getLong("id");
        if (!plId.equals(premiumCur.getLong("id"))) {
            premium = fxquote.startsWith(plCurrency.getString("number")) ? premium.divide(exRate, 10, 4) : premium.multiply(exRate);
        }
        return premium;
    }

    public static BigDecimal calPlAmt(DynamicObject tradeBill, DynamicObject plCurrency, BigDecimal bizAmt1, BigDecimal spotExRate, BigDecimal fwdExRate) {
        BigDecimal pl;
        if (BusinessBillHelper.isSameFx(tradeBill)) {
            pl = spotExRate.subtract(fwdExRate).multiply(bizAmt1);
            if (plCurrency.getLong("id") == tradeBill.getDynamicObject("currency").getLong("id")) {
                pl = spotExRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : pl.divide(spotExRate, 10, 4);
            }
        } else {
            pl = EmptyUtil.isAnyoneEmpty((Object[])new Object[]{spotExRate, fwdExRate}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(spotExRate, 10, 4).subtract(BigDecimal.ONE.divide(fwdExRate, 10, 4)).multiply(bizAmt1);
            if (plCurrency.getLong("id") == tradeBill.getDynamicObject("currency").getLong("id")) {
                pl = pl.multiply(spotExRate);
            }
        }
        if (TradeDirectionEnum.sell.getValue().equals(tradeBill.getString("tradedirect"))) {
            pl = pl.negate();
        }
        return pl;
    }

    private static void buildOther_flat_forex_options(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        Date expireDate = tradeBill.getDate("adjexpiredate");
        bill.set("expireddate", (Object)expireDate);
        bill.set("plsettledate", bill.get("bizdate"));
        DynamicObject premCurrency = tradeBill.getDynamicObject("premiumcurrency");
        bill.set("premcurrency_src", (Object)premCurrency);
        BigDecimal premium = tradeBill.getBigDecimal("premium");
        bill.set("premium_src", (Object)premium);
        bill.set("settlecurrency", (Object)premCurrency);
        bill.set("plcurrency", (Object)premCurrency);
        bill.set("reccurrency", (Object)premCurrency);
        bill.set("paycurrency", (Object)premCurrency);
        BusinessBillHelper.calPlAmtValue(bill);
        BusinessBillHelper.setBaseInfo_PL(bill);
    }

    public static void calPlAmtValue(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        DynamicObject premiumCur = tradeBill.getDynamicObject("premiumcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, premiumCur})) {
            return;
        }
        Long plId = plCurrency.getLong("id");
        String tradeDirect = tradeBill.getString("tradedirect");
        BigDecimal premium = tradeBill.getBigDecimal("premium");
        if (!plId.equals(premiumCur.getLong("id"))) {
            DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradeBill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            String quyfxQuote = plCurrency.getString("number").trim() + "/" + premiumCur.getString("number").trim();
            Date optDate = bill.getDate("bizdate");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)quyfxQuote, (Date)optDate, null);
            String fxquote = forexQuoteInfo.getFxquote();
            bill.set("premium_pl_fq", (Object)fxquote);
            if (quyfxQuote.equals(fxquote)) {
                bill.set("premium_pl_exrate", (Object)forexQuoteInfo.getSellPrice());
                premium = premium.divide(forexQuoteInfo.getSellPrice(), 10, 4);
            } else {
                bill.set("premium_pl_exrate", (Object)forexQuoteInfo.getBuyPrice());
                premium = premium.multiply(forexQuoteInfo.getBuyPrice());
            }
            DynamicObject premCurrency = bill.getDynamicObject("premcurrency_src");
            if (premCurrency != null) {
                int precision = premCurrency.getInt("amtprecision");
                premium = premium.setScale(precision, RoundingMode.HALF_UP);
            }
            bill.set("premium_pl", (Object)premium);
        } else {
            bill.set("premium_pl_fq", (Object)"");
            bill.set("premium_pl_exrate", (Object)BigDecimal.ZERO);
            bill.set("premium_pl", (Object)BigDecimal.ZERO);
        }
        BigDecimal settleAmount = bill.getBigDecimal("settleamount");
        BigDecimal firstAmount = bill.getBigDecimal("bizamt1");
        BigDecimal buyAmt = tradeBill.getBigDecimal("amount");
        BigDecimal pl = settleAmount.subtract(premium.multiply(firstAmount).divide(buyAmt, 10, 4));
        if (TradeDirectionEnum.sell.getValue().equals(tradeDirect)) {
            pl = pl.negate();
        }
        bill.set("plamt", (Object)pl);
    }
}

