/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class CashFlowDAOHelper {
    public static DynamicObject[] loadAsc(Long billid, String selectProps) {
        DynamicObject[] cashflows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)selectProps, (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)billid)});
        CashFlowDAOHelper.sortAsc(cashflows);
        return cashflows;
    }

    private static void sortAsc(DynamicObject[] cashflows) {
        Arrays.sort(cashflows, (a1, a2) -> {
            BigDecimal b1 = new BigDecimal(a1.getString("billno"));
            BigDecimal b2 = new BigDecimal(a2.getString("billno"));
            return b1.compareTo(b2);
        });
    }

    public static DynamicObject[] loadAsc(String selectProps, QFilter[] qFilters) {
        String[] props = selectProps.split(",");
        boolean hasBillno = false;
        for (String p : props) {
            if (!"billno".equalsIgnoreCase(p) && !"billno".equalsIgnoreCase(p.replaceAll(" ", ""))) continue;
            hasBillno = true;
            break;
        }
        String propStr = selectProps;
        if (!hasBillno) {
            propStr = "billno," + selectProps;
        }
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)propStr, (QFilter[])qFilters);
        CashFlowDAOHelper.sortAsc(cashFlows);
        return cashFlows;
    }

    public static DynamicObject loadAscTopOne(String selectProps, QFilter[] qFilters) {
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfpaydate,cfispay,cfishis", (QFilter[])qFilters);
        if (cashFlows == null || cashFlows.length == 0) {
            return null;
        }
        if (cashFlows.length == 1) {
            return cashFlows[0];
        }
        CashFlowDAOHelper.sortAsc(cashFlows);
        return cashFlows[0];
    }
}

