/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.BondBizTypeEnum;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.StubTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Pair;

public class CashFlowHelper {
    public static List<Date> getNeedAADateList(DynamicObject bondIssue) {
        List<Date> unPaydateList = CashFlowHelper.getUnAdjPayDateList(bondIssue);
        Date firstdate4aa = bondIssue.getDate("firstdate4aa");
        Date lastdate4aa = bondIssue.getDate("lastdate4aa");
        Date firstcoupon = bondIssue.getDate("firstcoupon");
        Date penucoupon = bondIssue.getDate("penucoupon");
        PayFrequeEnum freq4aa = PayFrequeEnum.valueOf((String)bondIssue.getString("freq4aa"));
        PayFrequeEnum payfreq = PayFrequeEnum.valueOf((String)bondIssue.getString("payfreq"));
        int n = freq4aa.getMonth() / payfreq.getMonth();
        boolean beginCount = false;
        ArrayList<Date> date4AA = new ArrayList<Date>(10);
        int count = 0;
        if (unPaydateList == null) {
            return date4AA;
        }
        if (unPaydateList.size() > 2 && unPaydateList.get(unPaydateList.size() - 1).compareTo(unPaydateList.get(unPaydateList.size() - 2)) == 0) {
            unPaydateList.remove(unPaydateList.size() - 1);
        }
        for (int i = 0; i < unPaydateList.size(); ++i) {
            Date curdate = unPaydateList.get(i);
            if (curdate.compareTo(firstdate4aa) == 0) {
                beginCount = true;
                date4AA.add(curdate);
                count = 1;
                continue;
            }
            if (!beginCount) continue;
            if (curdate.after(lastdate4aa)) break;
            if (count == n) {
                date4AA.add(curdate);
                count = 1;
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)firstcoupon) && curdate.compareTo(firstcoupon) == 0) {
                date4AA.add(curdate);
            }
            if (EmptyUtil.isNoEmpty((Object)penucoupon) && curdate.compareTo(penucoupon) == 0) {
                date4AA.add(curdate);
            }
            ++count;
        }
        return date4AA;
    }

    public static void fillWithBetweenDays_Forward(Date startdate, Date enddate, PayFrequeEnum payfreqEnum, List<Date> result) {
        if (startdate.compareTo(enddate) == 0) {
            return;
        }
        Date temp = PayFrequeEnum.getNextDateByPayfreq((Date)startdate, (PayFrequeEnum)payfreqEnum);
        while (temp.before(enddate)) {
            result.add(temp);
            temp = PayFrequeEnum.getNextDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        }
        result.add(enddate);
    }

    public static void fillWithBetweenDays_Backward(Date startdate, Date enddate, PayFrequeEnum payfreqEnum, List<Date> result) {
        Date temp = enddate;
        while (temp.after(startdate)) {
            result.add(temp);
            temp = PayFrequeEnum.getLastDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        }
    }

    public static List<Date> getDateList_Forward(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        result.add(bizdate);
        CashFlowHelper.fillWithBetweenDays_Forward(bizdate, maturitydate, payfreqEnum, result);
        result.add(maturitydate);
        return result;
    }

    public static List<Date> getDateList_Backward(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        result.add(maturitydate);
        CashFlowHelper.fillWithBetweenDays_Backward(bizdate, maturitydate, payfreqEnum, result);
        result.add(bizdate);
        Collections.reverse(result);
        return result;
    }

    public static List<Date> getDateList_ForwardInsertFirstcoupon(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum, Date firstcoupon) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum, firstcoupon})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        Date temp = bizdate;
        while (temp.before(firstcoupon)) {
            temp = PayFrequeEnum.getNextDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        }
        result.add(bizdate);
        result.add(firstcoupon);
        result.add(temp);
        CashFlowHelper.fillWithBetweenDays_Forward(temp, maturitydate, payfreqEnum, result);
        result.add(maturitydate);
        return result;
    }

    public static List<Date> getDateList_ForwardFromFirstcoupon(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum, Date firstcoupon) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum, firstcoupon})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        result.add(bizdate);
        result.add(firstcoupon);
        CashFlowHelper.fillWithBetweenDays_Forward(firstcoupon, maturitydate, payfreqEnum, result);
        result.add(maturitydate);
        return result;
    }

    public static List<Date> getDateList_BackwardInsertPenucoupon(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum, Date penultimatecoupon) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum, penultimatecoupon})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        Date temp = bizdate;
        while (temp.before(penultimatecoupon)) {
            temp = PayFrequeEnum.getNextDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        }
        temp = PayFrequeEnum.getLastDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        result.add(maturitydate);
        result.add(maturitydate);
        result.add(penultimatecoupon);
        CashFlowHelper.fillWithBetweenDays_Backward(bizdate, temp, payfreqEnum, result);
        result.add(bizdate);
        Collections.reverse(result);
        return result;
    }

    public static List<Date> getDateList_BackwardFromPenucoupon(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum, Date penultimatecoupon) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum, penultimatecoupon})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        result.add(maturitydate);
        result.add(maturitydate);
        CashFlowHelper.fillWithBetweenDays_Backward(bizdate, penultimatecoupon, payfreqEnum, result);
        result.add(bizdate);
        Collections.reverse(result);
        return result;
    }

    public static List<Date> getDateList_BackwardThenForward(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum, Date firstcoupon) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum, firstcoupon})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        Date temp = maturitydate;
        while (temp.after(firstcoupon)) {
            temp = PayFrequeEnum.getLastDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        }
        temp = PayFrequeEnum.getNextDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        result.add(bizdate);
        result.add(firstcoupon);
        result.add(temp);
        CashFlowHelper.fillWithBetweenDays_Forward(temp, maturitydate, payfreqEnum, result);
        result.add(maturitydate);
        return result;
    }

    public static List<Date> getDateList_ForwardThenBackward(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum, Date penultimatecoupon) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum, penultimatecoupon})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        Date temp = bizdate;
        while (temp.before(penultimatecoupon)) {
            temp = PayFrequeEnum.getNextDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        }
        temp = PayFrequeEnum.getLastDateByPayfreq((Date)temp, (PayFrequeEnum)payfreqEnum);
        result.add(maturitydate);
        result.add(maturitydate);
        result.add(penultimatecoupon);
        CashFlowHelper.fillWithBetweenDays_Backward(bizdate, temp, payfreqEnum, result);
        result.add(bizdate);
        Collections.reverse(result);
        return result;
    }

    public static List<Date> getDateList_ForwardWithFirstAndPenuCoupon(Date bizdate, Date maturitydate, PayFrequeEnum payfreqEnum, Date firstcoupon, Date penultimatecoupon) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate, payfreqEnum, firstcoupon, penultimatecoupon})) {
            return null;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        result.add(bizdate);
        result.add(firstcoupon);
        CashFlowHelper.fillWithBetweenDays_Forward(firstcoupon, penultimatecoupon, payfreqEnum, result);
        result.add(maturitydate);
        result.add(maturitydate);
        return result;
    }

    public static List<Date> getUnAdjPayDateList(DynamicObject bondIssue) {
        List<Date> result = new ArrayList<Date>(10);
        Date bizdate = bondIssue.getDate("bizdate");
        Date maturitydate = bondIssue.getDate("maturitydate");
        Date firstcoupon = bondIssue.getDate("firstcoupon");
        Date penultimatecoupon = bondIssue.getDate("penucoupon");
        String payfreq = bondIssue.getString("payfreq");
        String biztype = bondIssue.getString("biztype");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizdate, maturitydate})) {
            return result;
        }
        PayFrequeEnum payfreqEnum = PayFrequeEnum.valueOf((String)payfreq);
        BondBizTypeEnum biztypeEnum = BondBizTypeEnum.valueOf(biztype);
        boolean isstub = bondIssue.getBoolean("isstub");
        boolean sameMonthDay = TcDateUtils.isSameMonthAndDay((Date)bizdate, (Date)maturitydate);
        String flag1 = isstub ? "WithStub" : "WithoutStub";
        String flag2 = sameMonthDay ? "SameMonthDay" : "NotSameMonthDay";
        String flag = "";
        if (isstub) {
            String stubtype = bondIssue.getString("stubtype");
            StubTypeEnum stubtypeEnum = StubTypeEnum.valueOf(stubtype);
            flag = flag1 + stubtypeEnum.getValue() + "_" + flag2;
        } else {
            flag = flag1 + "_" + flag2;
        }
        switch (flag) {
            case "WithStubstart_SameMonthDay": {
                if (biztypeEnum == BondBizTypeEnum.fixBond) {
                    result = CashFlowHelper.getDateList_ForwardInsertFirstcoupon(bizdate, maturitydate, payfreqEnum, firstcoupon);
                    break;
                }
                if (biztypeEnum != BondBizTypeEnum.floatBond) break;
                result = CashFlowHelper.getDateList_ForwardFromFirstcoupon(bizdate, maturitydate, payfreqEnum, firstcoupon);
                break;
            }
            case "WithStubend_SameMonthDay": {
                if (biztypeEnum == BondBizTypeEnum.fixBond) {
                    result = CashFlowHelper.getDateList_BackwardFromPenucoupon(bizdate, maturitydate, payfreqEnum, penultimatecoupon);
                    break;
                }
                if (biztypeEnum != BondBizTypeEnum.floatBond) break;
                result = CashFlowHelper.getDateList_BackwardInsertPenucoupon(bizdate, maturitydate, payfreqEnum, penultimatecoupon);
                break;
            }
            case "WithStubstart2end_SameMonthDay": {
                if (biztypeEnum != BondBizTypeEnum.fixBond && biztypeEnum != BondBizTypeEnum.floatBond) break;
                result = CashFlowHelper.getDateList_ForwardWithFirstAndPenuCoupon(bizdate, maturitydate, payfreqEnum, firstcoupon, penultimatecoupon);
                break;
            }
            case "WithStubstart_NotSameMonthDay": {
                if (biztypeEnum == BondBizTypeEnum.fixBond) {
                    result = CashFlowHelper.getDateList_BackwardThenForward(bizdate, maturitydate, payfreqEnum, firstcoupon);
                    break;
                }
                if (biztypeEnum != BondBizTypeEnum.floatBond) break;
                result = CashFlowHelper.getDateList_ForwardFromFirstcoupon(bizdate, maturitydate, payfreqEnum, firstcoupon);
                break;
            }
            case "WithStubend_NotSameMonthDay": {
                if (biztypeEnum == BondBizTypeEnum.fixBond) {
                    result = CashFlowHelper.getDateList_BackwardFromPenucoupon(bizdate, maturitydate, payfreqEnum, penultimatecoupon);
                    break;
                }
                if (biztypeEnum != BondBizTypeEnum.floatBond) break;
                result = CashFlowHelper.getDateList_ForwardThenBackward(bizdate, maturitydate, payfreqEnum, penultimatecoupon);
                break;
            }
            case "WithStubstart2end_NotSameMonthDay": {
                if (biztypeEnum != BondBizTypeEnum.fixBond && biztypeEnum != BondBizTypeEnum.floatBond) break;
                result = CashFlowHelper.getDateList_ForwardWithFirstAndPenuCoupon(bizdate, maturitydate, payfreqEnum, firstcoupon, penultimatecoupon);
                break;
            }
            case "WithoutStub_SameMonthDay": {
                result = CashFlowHelper.getDateList_Forward(bizdate, maturitydate, payfreqEnum);
                break;
            }
            case "WithoutStub_NotSameMonthDay": {
                if (biztypeEnum == BondBizTypeEnum.fixBond) {
                    result = CashFlowHelper.getDateList_Backward(bizdate, maturitydate, payfreqEnum);
                    break;
                }
                if (biztypeEnum != BondBizTypeEnum.floatBond) break;
                result = CashFlowHelper.getDateList_Forward(bizdate, maturitydate, payfreqEnum);
            }
        }
        return result;
    }

    public static Date getAdjDate(Date date, DynamicObject bondIssue) {
        Date adjustDate = date;
        String adjustmethod = bondIssue.getString("adjustmethod");
        if (!adjustmethod.equals(AdjustMethodEnum.no_adjust.getValue())) {
            AdjustMethodEnum adjustmethodEnum = AdjustMethodEnum.valueOf((String)adjustmethod);
            DynamicObjectCollection calendars = bondIssue.getDynamicObjectCollection("calendars");
            adjustDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)calendars, (Date)date, (AdjustMethodEnum)adjustmethodEnum);
        }
        return adjustDate;
    }

    public static List<Date> getPaydateList(DynamicObject bondIssue) {
        List<Date> unAdjDateList = CashFlowHelper.getUnAdjPayDateList(bondIssue);
        ArrayList<Date> unPaydateList = new ArrayList<Date>(10);
        if (unAdjDateList == null) {
            return unPaydateList;
        }
        for (int i = 0; i < unAdjDateList.size(); ++i) {
            unPaydateList.add(CashFlowHelper.getAdjDate(unAdjDateList.get(i), bondIssue));
        }
        return unPaydateList;
    }

    public static Date getNearAfterDate(List<Date> dateList, Date temp) {
        Map<String, Date> result = CashFlowHelper.getPayPeriodDay(dateList, temp);
        if (EmptyUtil.isEmpty(result)) {
            return null;
        }
        if (EmptyUtil.isEmpty((Object)result.get("curPaydate"))) {
            return result.get("nextPaydate");
        }
        return result.get("curPaydate");
    }

    public static Map<String, Date> getPayPeriodDay(List<Date> dateList, Date temp) {
        HashMap<String, Date> result = new HashMap<String, Date>();
        for (int i = 0; i < dateList.size(); ++i) {
            Date cur = dateList.get(i);
            if (temp.after(cur)) continue;
            if (i - 1 >= 0) {
                result.put("lastPaydate", dateList.get(i - 1));
            } else {
                result.put("lastPaydate", null);
            }
            if (temp.compareTo(cur) == 0) {
                result.put("curPaydate", temp);
                if (i + 1 < dateList.size()) {
                    result.put("nextPaydate", dateList.get(i + 1));
                } else {
                    result.put("nextPaydate", null);
                }
            } else {
                result.put("curPaydate", null);
                result.put("nextPaydate", cur);
            }
            return result;
        }
        return result;
    }

    public static CashFlowTypeEnum getCashFlowTypeEnum(BondBizTypeEnum biztypeEnum) {
        CashFlowTypeEnum typeEnum = biztypeEnum == BondBizTypeEnum.fixBond ? CashFlowTypeEnum.fixedrate : CashFlowTypeEnum.floatrate;
        return typeEnum;
    }

    public static Pair<Date, DynamicObject> getParam_CalAccrual(DynamicObjectCollection cashFlowList, Date paydate, Date accrueFrom) {
        DynamicObject lastCashflowRow = (DynamicObject)cashFlowList.get(0);
        for (DynamicObject cashflowRow : cashFlowList) {
            if (!cashflowRow.getDynamicObjectType().getProperties().containsKey((Object)"cftype") || EmptyUtil.isEmpty((Object)cashflowRow.get("cftype"))) continue;
            CashFlowTypeEnum type = CashFlowTypeEnum.valueOf((String)cashflowRow.get("cftype"));
            Date payDate = cashflowRow.getDate("cfpaydate");
            if (CashFlowTypeEnum.fixedrate != type && CashFlowTypeEnum.floatrate != type) continue;
            if (!payDate.before(paydate)) {
                Date lastPayDate = lastCashflowRow.equals(cashFlowList.get(0)) ? accrueFrom : lastCashflowRow.getDate("cfpaydate");
                return Pair.create((Object)lastPayDate, (Object)cashflowRow);
            }
            lastCashflowRow = cashflowRow;
        }
        return null;
    }

    public static Pair<Date, Map<String, Object>> getParam_CalAccrual(List<Map<String, Object>> cashFlowList, Date paydate, Date accrueFrom) {
        Map<String, Object> lastCashflowRow = cashFlowList.get(0);
        for (Map<String, Object> cashflowRow : cashFlowList) {
            if (EmptyUtil.isEmpty((Object)cashflowRow.get("cftype"))) continue;
            CashFlowTypeEnum type = CashFlowTypeEnum.valueOf((String)cashflowRow.get("cftype"));
            Date payDate = (Date)cashflowRow.get("cfpaydate");
            if (CashFlowTypeEnum.fixedrate != type && CashFlowTypeEnum.floatrate != type) continue;
            if (!payDate.before(paydate)) {
                Date lastPayDate = lastCashflowRow.equals(cashFlowList.get(0)) ? accrueFrom : (Date)lastCashflowRow.get("cfpaydate");
                return Pair.create((Object)lastPayDate, cashflowRow);
            }
            lastCashflowRow = cashflowRow;
        }
        return null;
    }

    public static DynamicObjectCollection getAfterSettleNoRestCash(DynamicObjectCollection cashFlow, Date calDate) {
        DynamicObjectCollection resultList = new DynamicObjectCollection();
        for (DynamicObject cash : cashFlow) {
            String type = cash.getString("cftype");
            Date payDate = cash.getDate("cfpaydate");
            if (EmptyUtil.isEmpty((String)type) || !CashFlowTypeEnum.fixedrate.getValue().equals(type) && !CashFlowTypeEnum.floatrate.getValue().equals(type) && !CashFlowTypeEnum.capital.getValue().equals(type) || !payDate.after(calDate)) continue;
            resultList.add((Object)cash);
        }
        return resultList;
    }

    public static Map<Date, BigDecimal> resetRate(DynamicObject bondIssue, DynamicObjectCollection cashFlow) {
        HashMap<Date, BigDecimal> rateMap = new HashMap<Date, BigDecimal>();
        DynamicObjectCollection workCalendars = bondIssue.getDynamicObjectCollection("calendars");
        Object[] calendars = new DynamicObject[]{};
        workCalendars.toArray(calendars);
        String basis = bondIssue.getString("couponbasis");
        BasisEnum basisEnum = BasisEnum.valueOf((String)basis);
        BigDecimal M = bondIssue.getBigDecimal("ratemargin");
        for (int i = 0; i < cashFlow.size(); ++i) {
            DynamicObject cash = (DynamicObject)cashFlow.get(i);
            Long id = cash.getLong("id");
            BigDecimal rate = Constants.ONE;
            for (int j = i + 1; j < cashFlow.size(); ++j) {
                DynamicObject resetCash = (DynamicObject)cashFlow.get(j);
                Long pid = resetCash.getLong("pid");
                if (!id.equals(pid) || !EmptyUtil.isEmpty((String)resetCash.getString("cftype"))) {
                    i = j - 1;
                    break;
                }
                Date adjStartdate = resetCash.getDate("cfadjstartdate");
                Date adjEnddate = resetCash.getDate("cfadjenddate");
                BigDecimal basisValue = TradeBusinessHelper.getBaseBasis((Date)adjStartdate, (Date)adjEnddate, (BasisEnum)basisEnum, (DynamicObject[])calendars, null, null);
                rate = rate.multiply(Constants.ONE.add(resetCash.getBigDecimal("cfuserate").subtract(M).divide(Constants.ONE_HUNDRED).multiply(basisValue)));
            }
            if (CashFlowTypeEnum.capital.getValue().equals(cash.getString("cftype"))) continue;
            rate = rate.subtract(BigDecimal.ONE).multiply(Constants.ONE_HUNDRED);
            rateMap.put(cash.getDate("cfpaydate"), rate);
        }
        return rateMap;
    }

    public static boolean isCouponPaydate(DynamicObject bondIssue, Date basedate) {
        List<Date> paydateList = CashFlowHelper.getPaydateList(bondIssue);
        return paydateList.contains(basedate);
    }

    public static DynamicObjectCollection queryCashFlow(Long billid) {
        DynamicObject cashFlowModel = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
        DataEntityPropertyCollection modelProps = cashFlowModel.getDataEntityType().getProperties();
        DataEntityPropertyCollection entryProps = cashFlowModel.getDynamicObjectCollection("entrys").getDynamicObjectType().getProperties();
        ArrayList propList = new ArrayList(10);
        modelProps.forEach(prop -> propList.add(prop.getName()));
        entryProps.forEach(prop -> propList.add("entrys." + prop.getName()));
        String selProps = StringUtils.join(propList, (String)",");
        QFilter filter = new QFilter("billid", "=", (Object)billid);
        DynamicObject[] cashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)selProps, (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection cashFlowList = new DynamicObjectCollection();
        for (int i = 0; i < cashFlow.length; ++i) {
            DynamicObject tempParent = cashFlow[i];
            tempParent.getDynamicObjectType().setName("cashflow");
            tempParent.getDynamicObjectType().setExtendName("cashflow");
            cashFlowList.add((Object)tempParent);
            for (int j = 0; j < tempParent.getDynamicObjectCollection("entrys").size(); ++j) {
                DynamicObject tempChild = (DynamicObject)tempParent.getDynamicObjectCollection("entrys").get(j);
                tempChild.getDynamicObjectType().setName("cashflow");
                tempChild.getDynamicObjectType().setExtendName("cashflow");
                cashFlowList.add((Object)tempChild);
            }
        }
        return cashFlowList;
    }

    public static DynamicObject[] returnCashFlow(QFilter[] cashflowFilter) {
        DynamicObject cashFlowModel = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
        DataEntityPropertyCollection modelProps = cashFlowModel.getDataEntityType().getProperties();
        DataEntityPropertyCollection entryProps = cashFlowModel.getDynamicObjectCollection("entrys").getDynamicObjectType().getProperties();
        ArrayList<String> propList = new ArrayList<String>(10);
        modelProps.forEach(prop -> propList.add(prop.getName()));
        propList.add("usedId");
        entryProps.forEach(prop -> propList.add("entrys." + prop.getName()));
        propList.add("entrys.usedentryid");
        String selProps = StringUtils.join(propList, (String)",");
        DynamicObject[] cashFlow = TmcDataServiceHelper.load((String)"tm_cashflow_bak", (String)selProps, (QFilter[])cashflowFilter);
        DynamicObject[] result = new DynamicObject[cashFlow.length];
        for (int i = 0; i < cashFlow.length; ++i) {
            DynamicObject tempParent = cashFlow[i];
            DynamicObject bakParent = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
            modelProps.forEach(prop -> {
                if ("id".equals(prop.getName())) {
                    bakParent.set(prop.getName(), (Object)tempParent.getLong("usedId"));
                } else if (!"entrys".equals(prop.getName())) {
                    bakParent.set(prop.getName(), tempParent.get(prop.getName()));
                }
            });
            for (int j = 0; j < tempParent.getDynamicObjectCollection("entrys").size(); ++j) {
                DynamicObject tempChild = (DynamicObject)tempParent.getDynamicObjectCollection("entrys").get(j);
                DynamicObject bakChild = bakParent.getDynamicObjectCollection("entrys").addNew();
                entryProps.forEach(prop -> {
                    if ("id".equals(prop.getName())) {
                        bakChild.set(prop.getName(), tempChild.get("usedentryid"));
                    } else {
                        bakChild.set(prop.getName(), tempChild.get(prop.getName()));
                    }
                });
            }
            result[i] = bakParent;
        }
        return result;
    }

    public static DynamicObject[] copyCashFlow(QFilter[] cashflowFilter, Long bizBillId) {
        DynamicObject cashFlowModel = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
        DataEntityPropertyCollection modelProps = cashFlowModel.getDataEntityType().getProperties();
        DataEntityPropertyCollection entryProps = cashFlowModel.getDynamicObjectCollection("entrys").getDynamicObjectType().getProperties();
        ArrayList propList = new ArrayList(10);
        modelProps.forEach(prop -> propList.add(prop.getName()));
        entryProps.forEach(prop -> propList.add("entrys." + prop.getName()));
        String selProps = StringUtils.join(propList, (String)",");
        DynamicObject[] cashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)selProps, (QFilter[])cashflowFilter);
        DynamicObject[] result = new DynamicObject[cashFlow.length];
        for (int i = 0; i < cashFlow.length; ++i) {
            DynamicObject tempParent = cashFlow[i];
            DynamicObject bakParent = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow_bak");
            long parentId = DBServiceHelper.genGlobalLongId();
            modelProps.forEach(prop -> {
                if ("id".equals(prop.getName())) {
                    bakParent.set(prop.getName(), (Object)parentId);
                    bakParent.set("usedId", (Object)tempParent.getLong(prop.getName()));
                } else if (!"entrys".equals(prop.getName())) {
                    bakParent.set(prop.getName(), tempParent.get(prop.getName()));
                }
            });
            bakParent.set("cfbizbillid", (Object)bizBillId);
            int size = tempParent.getDynamicObjectCollection("entrys").size();
            for (int j = 0; j < size; ++j) {
                DynamicObject tempChild = (DynamicObject)tempParent.getDynamicObjectCollection("entrys").get(j);
                DynamicObject bakChild = bakParent.getDynamicObjectCollection("entrys").addNew();
                for (int index = 0; index < entryProps.size(); ++index) {
                    IDataEntityProperty prop2 = (IDataEntityProperty)entryProps.get(index);
                    if ("id".equals(prop2.getName())) {
                        bakChild.set("id", (Object)DBServiceHelper.genGlobalLongId());
                        bakChild.set("usedentryid", tempChild.get(prop2.getName()));
                        continue;
                    }
                    if ("usedentryid".equals(prop2.getName())) continue;
                    bakChild.set(prop2.getName(), tempChild.get(prop2.getName()));
                }
            }
            result[i] = bakParent;
        }
        return result;
    }
}

