/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.ForexOptionsHelper;

public class ForexCashFlowHelper {
    private static final Log logger = LogFactory.getLog(ForexCashFlowHelper.class);

    public static BigDecimal queryExRate_forexSwap(DynamicObject tradeBill, Date date, boolean isNear) {
        Long fqId = tradeBill.getDynamicObject("pricerule").getDynamicObject("forexquote").getLong("id");
        String tradeFxQuote = tradeBill.getString("fxquote");
        ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)tradeFxQuote, null, (Date)date);
        String pair = tradeBill.getString("pair");
        String tradeDir = tradeBill.getString("tradedirect");
        BigDecimal exRate = pair.equals(forexQuoteInfo.getFxquote()) && TradeDirectionEnum.buy.getValue().equals(tradeDir) || !pair.equals(forexQuoteInfo.getFxquote()) && TradeDirectionEnum.sell.getValue().equals(tradeDir) ? (isNear ? forexQuoteInfo.getSellPrice() : forexQuoteInfo.getBuyPrice()) : (isNear ? forexQuoteInfo.getBuyPrice() : forexQuoteInfo.getSellPrice());
        String fxQuote = forexQuoteInfo.getFxquote();
        if (!fxQuote.equals(tradeFxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(exRate, 10, RoundingMode.HALF_UP);
            logger.info("\u5916\u6c47\u6389\u671f\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)exRate, (Object)newExRate);
            return newExRate;
        }
        logger.info("\u5916\u6c47\u6389\u671f\u53d6\u5230\u7684\u6c47\u7387{}", (Object)exRate);
        return exRate;
    }

    public static BigDecimal queryExRate(DynamicObject tradeBill, Date date) {
        Long fqId = tradeBill.getDynamicObject("pricerule").getDynamicObject("forexquote").getLong("id");
        String tradeFxQuote = tradeBill.getString("fxquote");
        ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)tradeFxQuote, null, (Date)date);
        String pair = tradeBill.getString("pair");
        String tradeDir = tradeBill.getString("tradedirect");
        BigDecimal exRate = pair.equals(forexQuoteInfo.getFxquote()) && TradeDirectionEnum.buy.getValue().equals(tradeDir) || !pair.equals(forexQuoteInfo.getFxquote()) && TradeDirectionEnum.sell.getValue().equals(tradeDir) ? forexQuoteInfo.getSellPrice() : forexQuoteInfo.getBuyPrice();
        String fxQuote = forexQuoteInfo.getFxquote();
        if (!fxQuote.equals(tradeFxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(exRate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)exRate, (Object)newExRate);
            return newExRate;
        }
        logger.info("\u53d6\u5230\u7684\u6c47\u7387{}", (Object)exRate);
        return exRate;
    }

    public static BigDecimal calcPayAmount_fwd(DynamicObject tradeBill, BigDecimal principal, BigDecimal fixRate, BigDecimal useRate) {
        if (!DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.getString("deliveryway"))) {
            return BigDecimal.ZERO;
        }
        DynamicObject currency = tradeBill.getDynamicObject("currency");
        DynamicObject sellCurrency = tradeBill.getDynamicObject("sellcurrency");
        DynamicObject settleCurrency = tradeBill.getDynamicObject("settlecurrency");
        if (currency.getLong("id") == settleCurrency.getLong("id")) {
            return ForexCashFlowHelper.calcBuyPayAmount_fwd(tradeBill, principal, fixRate, useRate);
        }
        if (sellCurrency.getLong("id") == settleCurrency.getLong("id")) {
            return ForexCashFlowHelper.calcSellPayAmount_fwd(tradeBill, principal, fixRate, useRate);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal calcSellPayAmount_fwd(DynamicObject tradeBill, BigDecimal principal, BigDecimal fwdExRate, BigDecimal preExRate) {
        String tradeDir = tradeBill.getString("tradedirect");
        String fxQuote = tradeBill.getString("fxquote");
        String pair = tradeBill.getString("pair");
        BigDecimal payAmount = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxQuote}) && pair.equals(fxQuote) ? preExRate.subtract(fwdExRate).multiply(principal).setScale(10, 4) : BigDecimal.ONE.divide(preExRate, 10, 4).subtract(BigDecimal.ONE.divide(fwdExRate, 10, 4)).multiply(principal);
        return TradeDirectionEnum.sell.getValue().equals(tradeDir) ? payAmount.negate() : payAmount;
    }

    public static BigDecimal calcBuyPayAmount_fwd(DynamicObject tradeBill, BigDecimal principal, BigDecimal fwdExRate, BigDecimal preExRate) {
        BigDecimal payAmount;
        String tradeDir = tradeBill.getString("tradedirect");
        Long fqId = tradeBill.getDynamicObject("pricerule").getDynamicObject("forexquote").getLong("id");
        String fxQuote = tradeBill.getString("fxquote");
        ForexQuoteInfo spotRateInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, null);
        String pair = tradeBill.getString("pair");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxQuote}) && pair.equals(fxQuote)) {
            BigDecimal spotExRate = fxQuote.equals(spotRateInfo.getFxquote()) ? spotRateInfo.getSellPrice() : BigDecimal.ONE.divide(spotRateInfo.getSellPrice(), 10, 4);
            payAmount = preExRate.subtract(fwdExRate).multiply(principal).divide(spotExRate, 10, 4);
        } else {
            BigDecimal spotExRate = fxQuote.equals(spotRateInfo.getFxquote()) ? spotRateInfo.getBuyPrice() : BigDecimal.ONE.divide(spotRateInfo.getBuyPrice(), 10, 4);
            payAmount = BigDecimal.ONE.divide(preExRate, 10, 4).subtract(BigDecimal.ONE.divide(fwdExRate, 10, 4)).multiply(principal).multiply(spotExRate);
        }
        return TradeDirectionEnum.sell.getValue().equals(tradeDir) ? payAmount.negate() : payAmount;
    }

    public static BigDecimal calPayAmt_ForexOption(DynamicObject tradebill, BigDecimal principal) {
        BigDecimal marketRate = ForexCashFlowHelper.getMarketRate(tradebill);
        return ForexCashFlowHelper.calPayAmt_ForexOption(tradebill, principal, marketRate);
    }

    public static BigDecimal calPayAmt_ForexOption(DynamicObject tradebill, BigDecimal principal, BigDecimal marketRate) {
        BigDecimal contractRate = tradebill.getBigDecimal("exchangerate");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal payAmount = BusinessBillHelper.isSameFx(tradebill) ? (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? ForexOptionsHelper.calAmountForwardDirection(marketRate, contractRate, principal, new ModelAgent((Object)tradebill)) : ForexOptionsHelper.calAmountForwardDirection(contractRate, marketRate, principal, new ModelAgent((Object)tradebill))) : (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? ForexOptionsHelper.calAmountReverseDirection(marketRate, contractRate, principal, new ModelAgent((Object)tradebill)) : ForexOptionsHelper.calAmountReverseDirection(contractRate, marketRate, principal, new ModelAgent((Object)tradebill)));
        DynamicObject currency = tradebill.getDynamicObject("currency");
        DynamicObject settleCurrency = tradebill.getDynamicObject("settlecurrency");
        if (currency.getLong("id") == settleCurrency.getLong("id")) {
            Long fqId = tradebill.getDynamicObject("pricerule").getDynamicObject("forexquote").getLong("id");
            String fxQuote = tradebill.getString("fxquote");
            ForexQuoteInfo sportInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, null);
            payAmount = currency.getString("number").equals(sportInfo.getFxquote().split("/")[0]) ? payAmount.divide(sportInfo.getSellPrice(), 6, 4) : payAmount.multiply(sportInfo.getBuyPrice());
        }
        return payAmount;
    }

    public static BigDecimal getMarketRate(DynamicObject tradebill) {
        Long fqId = tradebill.getDynamicObject("pricerule").getDynamicObject("forexquote").getLong("id");
        String fxQuote = tradebill.getString("fxquote");
        Date dm = tradebill.getDate("adjustsettledate");
        ForexQuoteInfo fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)dm);
        String dir = tradebill.getString("tradedirect");
        String tradeType = tradebill.getString("tradetype");
        String fq = fxInfo.getFxquote();
        String pair = tradebill.getString("pair");
        BigDecimal marketRate = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fq}) && pair.equals(fq) ? (ForexOptionsHelper.callAndBuyORPutAndsell(dir, tradeType) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice()) : (ForexOptionsHelper.callAndSellORPutAndBuy(dir, tradeType) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice());
        if (!fq.equals(fxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(marketRate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)marketRate, (Object)newExRate);
            return newExRate;
        }
        logger.info("\u53d6\u5230\u7684\u6c47\u7387{}", (Object)marketRate);
        return marketRate;
    }
}

