/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.ExRateDirEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;

public class PlHelper {
    public static BigDecimal getReferExrate(String flag, DynamicObject tradeBill, ForexQuoteInfo fqInfo) {
        String dir = tradeBill.getString("tradedirect");
        String pair = tradeBill.getString("pair");
        String fxQuote = tradeBill.getString("fxquote");
        BigDecimal rate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(fxQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(fxQuote) ? ("spot".equals(flag) ? fqInfo.getSellPrice() : fqInfo.getBuyPrice()) : ("spot".equals(flag) ? fqInfo.getBuyPrice() : fqInfo.getSellPrice());
        return rate;
    }

    public static BigDecimal calFloatPlAmt(String flag, DynamicObject tradeBill, DynamicObject plInfo, DynamicObject bizRecord) {
        String dir = tradeBill.getString("tradedirect");
        String pair = tradeBill.getString("pair");
        String fxQuote = tradeBill.getString("fxquote");
        BigDecimal exrate = bizRecord.getBigDecimal("exrate");
        BigDecimal restamt = bizRecord.getBigDecimal("restamt");
        BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
        BigDecimal floatPlAmt = pair.equals(fxQuote) ? referExrate.subtract(exrate).multiply(restamt) : (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referExrate, exrate}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(referExrate, 10, 4).subtract(BigDecimal.ONE.divide(exrate, 10, 4)).multiply(restamt));
        if ("spot".equals(flag) && TradeDirectionEnum.sell.getValue().equals(dir) || "forw".equals(flag) && TradeDirectionEnum.buy.getValue().equals(dir)) {
            floatPlAmt = floatPlAmt.negate();
        }
        Long plcurrencyId = plInfo.getDynamicObject("plcurrency").getLong("id");
        Long plcurrencyIdS = plInfo.getDynamicObject("plcurrency_s").getLong("id");
        if (plcurrencyId.longValue() != plcurrencyIdS.longValue() && EmptyUtil.isNoEmpty((DynamicObject)plInfo.getDynamicObject("forexquote"))) {
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)plInfo.getDynamicObject("forexquote").getLong("id"), (String)pair, (Date)plInfo.getDate("updatedate"), null);
            String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
            floatPlAmt = plInfo.getDynamicObject("plcurrency_s").getString("number").equals(forexQuoteInfo.getFxquote().split("/")[0]) ? floatPlAmt.multiply(ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? forexQuoteInfo.getBuyPrice() : forexQuoteInfo.getMiddleprice()) : floatPlAmt.divide(ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? forexQuoteInfo.getSellPrice() : forexQuoteInfo.getMiddleprice(), 10, 4);
        }
        return floatPlAmt;
    }

    public static BigDecimal calFloatPlLocalAmt(DynamicObject plInfo, BigDecimal floatPlAmt) {
        Long localCurrencyId = plInfo.getDynamicObject("localcurrency").getLong("id");
        DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
        BigDecimal floatPlAmt_local = null;
        if (!localCurrencyId.equals(plCurrency.getLong("id"))) {
            String fxquote_local = plInfo.getString("fxquote_local");
            BigDecimal exrate_local = plInfo.getBigDecimal("exrate_local");
            floatPlAmt_local = plInfo.getDynamicObject("plcurrency").getString("number").equals(fxquote_local.split("/")[0]) ? floatPlAmt.multiply(exrate_local) : floatPlAmt.divide(exrate_local, 10, 4);
        }
        return floatPlAmt_local;
    }

    public static Map<String, Object> calcLocalInfo_PlInfo(DynamicObject plInfo, DynamicObject tradeBill, BigDecimal floatPlAmt) {
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        if (priceRule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613%s\u672a\u8bbe\u7f6e\u5b9a\u4ef7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizBillEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{tradeBill.getString("number")}));
        }
        Long fqId = priceRule.getLong("forexquote.id");
        DynamicObject localCurrency = plInfo.getDynamicObject("localcurrency");
        Long localCurrencyId = localCurrency.getLong("id");
        DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
        if (EmptyUtil.isNoEmpty((Long)fqId) && !localCurrencyId.equals(plCurrency.getLong("id"))) {
            String pl_local_fq = plInfo.getDynamicObject("plcurrency").getString("number").trim() + "/" + localCurrency.getString("number").trim();
            ForexQuoteInfo pl_local_fqInfo = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)fqId, (String)pl_local_fq, (Date)plInfo.getDate("updatedate"), null);
            if (pl_local_fqInfo != null) {
                BigDecimal pl_local_floatPl;
                BigDecimal pl_local_exRate;
                Long orgId = plInfo.get("org") instanceof DynamicObject ? Long.valueOf(plInfo.getDynamicObject("org").getLong("id")) : Long.valueOf(plInfo.getLong("org"));
                String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)orgId, (String)"exratedir");
                if (plInfo.getDynamicObject("plcurrency").getString("number").equals(pl_local_fqInfo.getFxquote().split("/")[0])) {
                    pl_local_exRate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? pl_local_fqInfo.getBuyPrice() : pl_local_fqInfo.getMiddleprice();
                    pl_local_floatPl = floatPlAmt.multiply(pl_local_exRate);
                } else {
                    pl_local_exRate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? pl_local_fqInfo.getSellPrice() : pl_local_fqInfo.getMiddleprice();
                    pl_local_floatPl = floatPlAmt.divide(pl_local_exRate, 10, RoundingMode.HALF_UP);
                }
                HashMap<String, Object> result = new HashMap<String, Object>(3);
                result.put("fxquote_local", pl_local_fqInfo.getFxquote());
                result.put("issuedate_local", pl_local_fqInfo.getIssuetime());
                result.put("exrate_local", pl_local_exRate);
                result.put("floatpllocalamt", pl_local_floatPl);
                return result;
            }
            return null;
        }
        return new HashMap<String, Object>();
    }

    public static void copyPlInfo(DynamicObject srcPlInfo, DynamicObject plInfo) {
        plInfo.set("tradebill", srcPlInfo.get("tradebill"));
        plInfo.set("org", srcPlInfo.get("org"));
        plInfo.set("tradetype", srcPlInfo.get("tradetype"));
        plInfo.set("type", srcPlInfo.get("type"));
        plInfo.set("localcurrency", srcPlInfo.get("localcurrency"));
        plInfo.set("plcurrency_s", srcPlInfo.get("plcurrency_s"));
        plInfo.set("plcurrency", srcPlInfo.get("plcurrency"));
        plInfo.set("fxquote_local", srcPlInfo.get("fxquote_local"));
        plInfo.set("buycurrency", srcPlInfo.get("buycurrency"));
        plInfo.set("sellcurrency", srcPlInfo.get("sellcurrency"));
        plInfo.set("standardcurrency", srcPlInfo.get("standardcurrency"));
        plInfo.set("optiontype", srcPlInfo.get("optiontype"));
        plInfo.set("premiumcurrency", srcPlInfo.get("premiumcurrency"));
        plInfo.set("premium", srcPlInfo.get("premium"));
        plInfo.set("forexswaptype", srcPlInfo.get("forexswaptype"));
    }

    public static BigDecimal calPlAmtWithPlCurrency(DynamicObject bill, DynamicObject tradebill, BigDecimal exrateA, BigDecimal exrateB) {
        BigDecimal plAmt;
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        BigDecimal bizAmt1 = bill.getBigDecimal("bizamt1");
        if (BusinessBillHelper.isSameFx(tradebill)) {
            plAmt = exrateA.subtract(exrateB).multiply(bizAmt1);
            if (plCurrency != null && plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id")) {
                plAmt = exrateA.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : plAmt.divide(exrateA, 10, 4);
            }
        } else {
            plAmt = EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exrateA, exrateB}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(exrateA, 10, 4).subtract(BigDecimal.ONE.divide(exrateB, 10, 4)).multiply(bizAmt1);
            if (plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id")) {
                plAmt = plAmt.multiply(exrateA);
            }
        }
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            plAmt = plAmt.negate();
        }
        return plAmt;
    }

    public static BigDecimal calAmt_PL(DynamicObject bill, DynamicObject tradebill, BigDecimal exrateA, BigDecimal exrateB) {
        BigDecimal amt = bill.getBigDecimal("bizamt1");
        BigDecimal amt_pl = BusinessBillHelper.isSameFx(tradebill) ? exrateA.subtract(exrateB).multiply(amt) : (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exrateA, exrateB}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(exrateA, 10, 4).subtract(BigDecimal.ONE.divide(exrateB, 10, 4)).multiply(amt));
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            amt_pl = amt_pl.negate();
        }
        return amt_pl;
    }

    public static BigDecimal dealPlAmt_PlCurrencyNotSrc(DynamicObject bill, DynamicObject tradebill, BigDecimal plAmt) {
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (plCurrency != null && plCurrency.getLong("id") != tradebill.getDynamicObject("sellcurrency").getLong("id")) {
            Date bizdate = bill.getDate("bizdate");
            ForexQuoteInfo info = BusinessBillHelper.getForexQuoteInfo(tradebill, bizdate, null);
            plAmt = EmptyUtil.isEmpty((Object)info) ? BigDecimal.ZERO : (tradebill.getDynamicObject("sellcurrency").getString("number").equals(info.getFxquote().split("/")[0]) ? plAmt.multiply(info.getBuyPrice()) : plAmt.divide(info.getSellPrice(), 10, 4));
        }
        return plAmt;
    }

    public static Map<String, Object> calPlAmt_Ex_ForexOptionForBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
            return result;
        }
        Long plId = plCurrency.getLong("id");
        DynamicObject premiumCur = tradebill.getDynamicObject("premiumcurrency");
        BigDecimal premium = tradebill.getBigDecimal("premium");
        if (!plId.equals(premiumCur.getLong("id"))) {
            DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradebill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            String quyfxQuote = plCurrency.getString("number").trim() + "/" + premiumCur.getString("number").trim();
            Date optDate = bill.getDate("bizdate");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)quyfxQuote, (Date)optDate, null);
            String fxquote = forexQuoteInfo.getFxquote();
            result.put("premium_pl_fq", fxquote);
            if (quyfxQuote.equals(fxquote)) {
                result.put("premium_pl_exrate", forexQuoteInfo.getSellPrice());
                premium = premium.divide(forexQuoteInfo.getSellPrice(), 10, 4);
            } else {
                result.put("premium_pl_exrate", forexQuoteInfo.getBuyPrice());
                premium = premium.multiply(forexQuoteInfo.getBuyPrice());
            }
            result.put("premium_pl", premium);
        } else {
            result.put("premium_pl_fq", "");
            result.put("premium_pl_exrate", BigDecimal.ZERO);
            result.put("premium_pl", BigDecimal.ZERO);
        }
        String tradeDirect = tradebill.getString("tradedirect");
        BigDecimal settleAmount = bill.getBigDecimal("settleamount");
        BigDecimal firstAmount = bill.getBigDecimal("bizamt1");
        BigDecimal buyAmt = tradebill.getBigDecimal("amount");
        premium = premium.multiply(firstAmount).divide(buyAmt, 10, 4);
        if (TradeDirectionEnum.buy.getValue().equals(tradeDirect)) {
            premium = premium.negate();
        }
        BigDecimal pl = settleAmount.add(premium);
        int amtPrecision = plCurrency.getInt("amtPrecision");
        pl = pl.setScale(amtPrecision, RoundingMode.HALF_UP);
        result.put("plamt", pl);
        return result;
    }

    public static Map<String, Object> calPlAmt_GiveUp_ForexOptionForBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
            return result;
        }
        Long plId = plCurrency.getLong("id");
        DynamicObject premiumCur = tradebill.getDynamicObject("premiumcurrency");
        String tradeDirect = tradebill.getString("tradedirect");
        BigDecimal premium = tradebill.getBigDecimal("premium");
        if (!plId.equals(premiumCur.getLong("id"))) {
            DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradebill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            String quyfxQuote = plCurrency.getString("number").trim() + "/" + premiumCur.getString("number").trim();
            Date optDate = bill.getDate("bizdate");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)quyfxQuote, (Date)optDate, null);
            String fxquote = forexQuoteInfo.getFxquote();
            result.put("premium_pl_fq", fxquote);
            if (quyfxQuote.equals(fxquote)) {
                result.put("premium_pl_exrate", forexQuoteInfo.getSellPrice());
                premium = premium.divide(forexQuoteInfo.getSellPrice(), 10, 4);
            } else {
                result.put("premium_pl_exrate", forexQuoteInfo.getBuyPrice());
                premium = premium.multiply(forexQuoteInfo.getBuyPrice());
            }
            result.put("premium_pl", premium);
        } else {
            result.put("premium_pl_fq", "");
            result.put("premium_pl_exrate", BigDecimal.ZERO);
            result.put("premium_pl", BigDecimal.ZERO);
        }
        BigDecimal firstAmount = bill.getBigDecimal("bizamt1");
        BigDecimal buyAmt = tradebill.getBigDecimal("amount");
        BigDecimal pl = premium.multiply(firstAmount).divide(buyAmt, 10, 4);
        if (TradeDirectionEnum.buy.getValue().equals(tradeDirect)) {
            pl = pl.negate();
        }
        result.put("plamt", pl);
        return result;
    }

    public static void setBaseInfo_PlForBizUpdate(DynamicObject bill, DynamicObject tradeBill) {
        DynamicObject localCurrency = bill.getDynamicObject("basecurrency");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)localCurrency) && EmptyUtil.isNoEmpty((DynamicObject)plCurrency) && plCurrency.getLong("id") != localCurrency.getLong("id")) {
            BigDecimal baseAmt;
            BigDecimal baseExrate;
            DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradeBill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
            Date bizdate = bill.getDate("bizdate");
            BigDecimal plAmt = bill.getBigDecimal("plamt");
            String pair = localCurrency.getString("number") + "/" + plCurrency.getString("number");
            DynamicObject forexQuote = priceRule.getDynamicObject("forexquote");
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfoWithIssueTime((Long)forexQuote.getLong("id"), (String)pair, (Date)bizdate, null);
            if (plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0])) {
                baseExrate = fqInfo.getBuyPrice();
                baseAmt = plAmt.multiply(baseExrate);
            } else {
                baseExrate = fqInfo.getSellPrice();
                baseAmt = plAmt.divide(baseExrate, 10, 4);
            }
            bill.set("baseexrate", (Object)baseExrate);
            bill.set("baseplamt", (Object)baseAmt);
        }
    }

    public static BigDecimal calPlAmt_Rate_RateSwapForBusinessBill(DynamicObject bill) {
        Long cashflow_pay = bill.getLong("cashflow_pay");
        Long cashflow_rec = bill.getLong("cashflow_rec");
        BigDecimal plAmt = BigDecimal.ZERO;
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec})) {
            plAmt = bill.getBigDecimal("settleamount");
        } else if (EmptyUtil.isNoEmpty((Long)cashflow_pay)) {
            plAmt = bill.getBigDecimal("bizamt1").negate();
        } else if (EmptyUtil.isNoEmpty((Long)cashflow_rec)) {
            plAmt = bill.getBigDecimal("bizamt2");
        }
        return plAmt;
    }

    public static BigDecimal calPlAmt_Currency_RateSwapForBusinessBill(DynamicObject bill) {
        BigDecimal plAmt = BigDecimal.ZERO;
        DynamicObject tradebill = bill.getDynamicObject("tradebill");
        Long cashflow_pay = bill.getLong("cashflow_pay");
        Long cashflow_rec = bill.getLong("cashflow_rec");
        boolean isPay = EmptyUtil.isNoEmpty((Long)cashflow_pay);
        boolean isRec = EmptyUtil.isNoEmpty((Long)cashflow_rec);
        BigDecimal amtPay = bill.getBigDecimal("bizamt1");
        BigDecimal amtRec = bill.getBigDecimal("bizamt2");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (plCurrency != null) {
            if (isPay && !isRec && plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id") || !isPay && isRec && plCurrency.getLong("id") != tradebill.getDynamicObject("currency").getLong("id")) {
                if (isPay) {
                    plAmt = amtPay.negate();
                }
                if (isRec) {
                    plAmt = amtRec;
                }
            } else {
                String fxquote = bill.getString("fxquotetype");
                BigDecimal rate = bill.getBigDecimal("execexrate");
                DynamicObject payCurrency = tradebill.getDynamicObject("currency");
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{payCurrency})) {
                    if (plCurrency.getLong("id") == payCurrency.getLong("id")) {
                        amtRec = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)rate) ? BigDecimal.ZERO : amtRec.divide(rate, 10, 4)) : amtRec.multiply(rate);
                    } else {
                        amtPay = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)rate) ? BigDecimal.ZERO : amtPay.divide(rate, 10, 4)) : amtPay.multiply(rate);
                    }
                }
            }
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec})) {
                plAmt = amtRec.subtract(amtPay);
            } else if (EmptyUtil.isNoEmpty((Long)cashflow_pay)) {
                plAmt = amtPay.negate();
            } else if (EmptyUtil.isNoEmpty((Long)cashflow_rec)) {
                plAmt = amtRec;
            }
        }
        return plAmt;
    }

    public static Boolean isEnableCommonForPlConfirm(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        Boolean isPlCfg = bill.getBoolean("isplconfirm");
        if ((TcBillStatusEnum.AUDIT.getValue().equals(billStatus) || TcBillStatusEnum.SETTLE_ING.getValue().equals(billStatus) || TcBillStatusEnum.SETTLE_DONE.getValue().equals(billStatus)) && !isPlCfg.booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static DynamicObject getPlInfoForPlConfirm(DynamicObject bill) {
        QFilter filter = new QFilter("entrys.bizbillid", "=", (Object)bill.getLong("id"));
        DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"plamt_sum,pllocalamt_sum,entrys.plamt,entrys.pllocalamt,entrys.bizbillid", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection entrys = plInfo.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entrys) {
            if (entry.getLong("bizbillid") != bill.getLong("id")) continue;
            entry.set("plamt", (Object)bill.getBigDecimal("plamt"));
            DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
            DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
            if (baseCurrency != null && plCurrency != null && baseCurrency.getString("number").equals(plCurrency.getString("number"))) {
                entry.set("pllocalamt", (Object)bill.getBigDecimal("plamt"));
                break;
            }
            entry.set("pllocalamt", (Object)bill.getBigDecimal("baseplamt"));
            break;
        }
        BigDecimal pllocalamt = entrys.stream().map(s -> s.getBigDecimal("pllocalamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        plInfo.set("pllocalamt_sum", (Object)pllocalamt);
        return plInfo;
    }

    public static Boolean isNeedPl_ForexSwapExpireDey(Long forexSwapId, String bizop) {
        DynamicObject forexSwap = TmcDataServiceHelper.loadSingle((Object)forexSwapId, (String)"tm_forex_swaps", (String)"swaptype");
        if (BizOperateEnum.expiredey_n.getValue().equals(bizop) && ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(forexSwap.getString("swaptype")) || ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(forexSwap.getString("swaptype"))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean isShowVoucherPlPanel(DynamicObject tradeBill, Long localCurrencyId) {
        DynamicObject sellCurrency;
        DynamicObject buyCurrency = tradeBill.getDynamicObject("currency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency = tradeBill.getDynamicObject("sellcurrency")})) {
            return false;
        }
        long buyCurrencyId = buyCurrency.getLong("id");
        long sellCurrencyId = sellCurrency.getLong("id");
        return buyCurrencyId != localCurrencyId && sellCurrencyId != localCurrencyId;
    }

    public static void calcPLBuySellAmount(DynamicObject tradebill, DynamicObject plInfo) {
        DynamicObject standardCurrency;
        DynamicObject buyCurrency;
        String fxQuote = tradebill.getString("fxquote");
        BigDecimal standardCurrencyAmt = plInfo.getBigDecimal("bizrestamt");
        BigDecimal exRate = plInfo.getBigDecimal("exrate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fxQuote, exRate, buyCurrency = plInfo.getDynamicObject("buycurrency"), standardCurrency = plInfo.getDynamicObject("standardcurrency")})) {
            BigDecimal priceCurrencyAmt = standardCurrency.getString("number").equals(fxQuote.split("/")[0]) ? standardCurrencyAmt.multiply(exRate) : standardCurrencyAmt.divide(exRate, 6, 4);
            if (standardCurrency.getString("number").equals(buyCurrency.getString("number"))) {
                plInfo.set("buyamount", (Object)standardCurrencyAmt);
                plInfo.set("sellamount", (Object)priceCurrencyAmt);
            } else {
                plInfo.set("buyamount", (Object)priceCurrencyAmt);
                plInfo.set("sellamount", (Object)standardCurrencyAmt);
            }
        }
    }

    public static void setValue(DynamicObject plInfo, Map<String, Object> result) {
        if (result != null) {
            for (Map.Entry<String, Object> entry : result.entrySet()) {
                plInfo.set(entry.getKey(), entry.getValue());
            }
        }
    }
}

