/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;

public class RateSwapCFCalHelper {
    private static Log logger = LogFactory.getLog(RateSwapCFCalHelper.class);

    public static void calCashFlows_swap(DynamicObject[] cashFlows, Date referDate, DynamicObject tradeBill, Map<Date, BigDecimal> dfs, Boolean isPay) {
        DynamicObject pricerule = tradeBill.getDynamicObject("pricerule");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referDate, pricerule})) {
            return;
        }
        FreqPeriodListBean freqPeriodResolver = RateSwapCFCalHelper.genFreqPeriodListBean(tradeBill, isPay);
        Date payDayBefore = null;
        for (DynamicObject cashFlow : cashFlows) {
            BigDecimal amount;
            BigDecimal dft_1;
            BigDecimal disCFactor;
            String type = cashFlow.getString("cftype");
            boolean cfispay = cashFlow.getBoolean("cfispay");
            BigDecimal orPricipal = cashFlow.getBigDecimal("cfosprincipal");
            Date payDay = cashFlow.getDate("cfpaydate");
            if ("fixedrate".equals(type) || "capital".equals(type)) {
                Date payDate = cashFlow.getDate("cfpaydate");
                BigDecimal amount2 = cashFlow.getBigDecimal("cfpayamount");
                disCFactor = dfs.get(payDate);
                dft_1 = dfs.get(TcDateUtils.getLastDay((Date)payDate, (int)1));
                if (dft_1 == null) {
                    dft_1 = BigDecimal.ZERO;
                }
                cashFlow.set("cftheta", (Object)RateSwapCFCalHelper.roundDecimal(disCFactor.subtract(dft_1).multiply(amount2)).negate());
                cashFlow.set("cfpv", (Object)RateSwapCFCalHelper.roundDecimal(amount2.multiply(disCFactor)));
                cashFlow.set("cfdiscfactor", (Object)disCFactor);
                logger.info(String.format("%7$s:date=%1$s,df=%2$s,df_1=%3$s,amount=%4$s,theta=%5$s,pv=%6$s", DateUtils.formatString((Date)payDate, (String)"yyyy-MM-dd"), disCFactor, dft_1, amount2, cashFlow.getBigDecimal("cftheta"), cashFlow.getBigDecimal("cfpv"), isPay != false ? "pay" : "rec"));
            }
            if (!"floatrate".equals(type)) continue;
            if (!cfispay) {
                Date indexDate;
                DynamicObjectCollection resetCashFlows = cashFlow.getDynamicObjectCollection("entrys");
                HashMap<Date, List<Date>> dateMap = new HashMap<Date, List<Date>>();
                HashMap<Long, Date> indexDateMap = new HashMap<Long, Date>();
                for (int i = 0; i < resetCashFlows.size(); ++i) {
                    DynamicObject resetCashFlow = (DynamicObject)resetCashFlows.get(i);
                    DynamicObject ratefixindex = resetCashFlow.getDynamicObject("cfratefixindex");
                    boolean isratecfg = resetCashFlow.getBoolean("cfisratecfg");
                    Date ratefixDate = resetCashFlow.getDate("cfratefixdate");
                    String term = RateSwapCFCalHelper.isRateQuoteDays(tradeBill, isPay) ? ratefixindex.getString("term") : RateTermEnum.getEnum((String)RateSwapCFCalHelper.getRateResetFreq(tradeBill, isPay)).getValue();
                    if (!ratefixDate.after(referDate) || isratecfg) continue;
                    indexDate = TermUtils.getDateByTerm((String)RateTermEnum.valueOf((String)term).getName(), (Date)ratefixDate);
                    dateMap.put(ratefixDate, Collections.singletonList(indexDate));
                    indexDateMap.put(resetCashFlow.getLong("id"), indexDate);
                }
                Map furRateByYieldCurveResult = null;
                if (!EmptyUtil.isEmpty(dateMap)) {
                    furRateByYieldCurveResult = MarketDataHelper.getFurRateByBatchYieldCurve(null, (YieldTypeEnum)YieldTypeEnum.ref, (DynamicObject)pricerule, (Long)RateSwapCFCalHelper.getMarket(tradeBill, isPay), (Date)referDate, dateMap);
                }
                BigDecimal useRate = BigDecimal.ONE;
                for (DynamicObject finalCash : resetCashFlows) {
                    boolean isratecfg = finalCash.getBoolean("cfisratecfg");
                    indexDate = (Date)indexDateMap.get(finalCash.getLong("id"));
                    if (!(isratecfg || cfispay || EmptyUtil.isEmpty((Object)furRateByYieldCurveResult))) {
                        if (!EmptyUtil.isEmpty((Object)indexDate)) {
                            finalCash.set("cfresetpredictrate", furRateByYieldCurveResult.get(indexDate));
                        }
                        BigDecimal resetPreRate = finalCash.get("cfresetpredictrate") == null ? BigDecimal.ZERO : (BigDecimal)finalCash.get("cfresetpredictrate");
                        BigDecimal muUseRate = resetPreRate.add(RateSwapCFCalHelper.getRateMargin(tradeBill, isPay));
                        finalCash.set("cfuserate", (Object)muUseRate);
                    }
                    BigDecimal baseBasis = RateSwapCFCalHelper.getBaseBasis(finalCash, tradeBill, isPay, freqPeriodResolver);
                    BigDecimal tempUseRate = (BigDecimal)finalCash.get("cfuserate");
                    useRate = useRate.multiply(BigDecimal.ONE.add(tempUseRate.divide(Constants.ONE_HUNDRED, 10, 4).multiply(baseBasis)));
                }
                useRate = useRate.subtract(BigDecimal.ONE);
                amount = orPricipal.multiply(useRate);
                if (RateSwapCFCalHelper.isPayDateFoward(tradeBill, isPay) && RateSwapCFCalHelper.isDiscount(tradeBill, isPay).booleanValue()) {
                    amount = payDayBefore == null ? amount.multiply(dfs.get(payDay)) : amount.multiply(dfs.get(payDay).divide(dfs.get(payDayBefore), 10, 4));
                }
                payDayBefore = payDay;
                amount = amount.multiply(RateSwapCFCalHelper.getAmtDir(isPay));
                amount = RateSwapCFCalHelper.roundDecimal(amount);
                cashFlow.set("cfamount", (Object)amount);
                cashFlow.set("cfpayamount", (Object)amount);
                cashFlow.set("cfinterest", (Object)amount);
            } else {
                amount = cashFlow.getBigDecimal("cfpayamount");
            }
            Date payDate = (Date)cashFlow.get("cfpaydate");
            disCFactor = dfs.get(payDate);
            dft_1 = dfs.get(TcDateUtils.getLastDay((Date)payDate, (int)1));
            if (dft_1 == null) {
                dft_1 = BigDecimal.ZERO;
            }
            cashFlow.set("cftheta", (Object)RateSwapCFCalHelper.roundDecimal(disCFactor.subtract(dft_1).multiply(amount)).negate());
            cashFlow.set("cfpv", (Object)RateSwapCFCalHelper.roundDecimal(amount.multiply(disCFactor)));
            cashFlow.set("cfdiscfactor", (Object)disCFactor);
            logger.info(String.format("%7$s:date=%1$s,df=%2$s,df_1=%3$s,amount=%4$s,theta=%5$s,pv=%6$s", DateUtils.formatString((Date)payDate, (String)"yyyy-MM-dd"), disCFactor, dft_1, amount, cashFlow.getBigDecimal("cftheta"), cashFlow.getBigDecimal("cfpv"), isPay != false ? "pay" : "rec"));
        }
    }

    private static Long getMarket(DynamicObject tradeBill, boolean ispay) {
        String market = ispay ? "market" : "recmarket";
        return tradeBill.getDynamicObject(market).getLong("id");
    }

    private static boolean isRateQuoteDays(DynamicObject tradeBill, boolean ispay) {
        String rateQuoteType = ispay ? "ratequotafreq" : "recratequotafreq";
        return "day".equals(tradeBill.getString(rateQuoteType));
    }

    private static String getRateResetFreq(DynamicObject tradeBill, boolean ispay) {
        String rateQuoteType = ispay ? "rateresetfreq" : "recrateresetfreq";
        return tradeBill.getBigDecimal(rateQuoteType).intValue() + "m";
    }

    private static BigDecimal getRateMargin(DynamicObject tradeBill, boolean ispay) {
        String ratemargin = ispay ? "ratemargin" : "recratemargin";
        return tradeBill.getBigDecimal(ratemargin);
    }

    private static String getBasis(DynamicObject tradeBill, boolean ispay) {
        String basis = ispay ? "basis" : "recbasis";
        return tradeBill.getString(basis);
    }

    private static String getPayFreq(DynamicObject tradeBill, boolean ispay) {
        String payfrequency = ispay ? "payfrequency" : "recpayfrequency";
        return tradeBill.getString(payfrequency);
    }

    private static boolean isPayStage(DynamicObject tradeBill, boolean ispay) {
        String payfrequency = tradeBill.getString(ispay ? "paytype" : "recpaytype");
        return "stages".equals(payfrequency);
    }

    private static Date getFirstCopDate(DynamicObject tradeBill, boolean ispay) {
        String firstpaycopdate = ispay ? "firstpaycopdate" : "recfirstpaycopdate";
        return tradeBill.getDate(firstpaycopdate);
    }

    private static Date getPenuCopDate(DynamicObject tradeBill, boolean ispay) {
        String penupaycopdate = ispay ? "penupaycopdate" : "recpenupaycopdate";
        return tradeBill.getDate(penupaycopdate);
    }

    private static Date getValueDate(DynamicObject tradeBill, boolean ispay) {
        String valuedate = ispay ? "valuedate" : "recvaluedate";
        return tradeBill.getDate(valuedate);
    }

    private static boolean isStub(DynamicObject tradeBill, boolean ispay) {
        String stub = ispay ? "stub" : "recstub";
        return tradeBill.getBoolean(stub);
    }

    private static boolean isStubFront(DynamicObject tradeBill, boolean ispay) {
        String stubtype = tradeBill.getString(ispay ? "stubtype" : "recstubtype");
        return "front".equals(stubtype);
    }

    private static DynamicObjectCollection getWorkCalendars(DynamicObject tradeBill, boolean ispay) {
        String payworkcalendar = ispay ? "payworkcalendar" : "recworkcalendar";
        return tradeBill.getDynamicObjectCollection(payworkcalendar);
    }

    private static String getAdjustMethod(DynamicObject tradeBill, boolean ispay) {
        String dateadjustmethod = ispay ? "dateadjustmethod" : "recdateadjustmethod";
        return tradeBill.getString(dateadjustmethod);
    }

    private static boolean isPayDateFoward(DynamicObject tradeBill, boolean ispay) {
        String paydatetype = tradeBill.getString(ispay ? "paydatetype" : "recpaydatetype");
        return "forward".equals(paydatetype);
    }

    private static Boolean isDiscount(DynamicObject tradeBill, boolean ispay) {
        String discount = ispay ? "discount" : "recdiscount";
        return tradeBill.getBoolean(discount);
    }

    private static BigDecimal getAmtDir(boolean ispay) {
        return ispay ? BigDecimal.ONE.negate() : BigDecimal.ONE;
    }

    private static BigDecimal getBaseBasis(DynamicObject resetRow, DynamicObject tradeBill, boolean ispay, FreqPeriodListBean freqPeriodResolver) {
        BasisEnum basis = BasisEnum.getEnum((String)RateSwapCFCalHelper.getBasis(tradeBill, ispay));
        return TradeBusinessHelper.getBaseBasis((Date)((Date)resetRow.get("cfadjstartdate")), (Date)((Date)resetRow.get("cfadjenddate")), (BasisEnum)basis, (DynamicObject[])((DynamicObject[])RateSwapCFCalHelper.getWorkCalendars(tradeBill, ispay).toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)(freqPeriodResolver != null ? freqPeriodResolver.getFreqEnum() : null), (FreqPeriodListBean)freqPeriodResolver);
    }

    private static FreqPeriodListBean genFreqPeriodListBean(DynamicObject tradeBill, boolean ispay) {
        BasisEnum basis = BasisEnum.getEnum((String)RateSwapCFCalHelper.getBasis(tradeBill, ispay));
        String payFreq = RateSwapCFCalHelper.getPayFreq(tradeBill, ispay);
        if (RateSwapCFCalHelper.isPayStage(tradeBill, ispay) && BasisEnum.ICMA_Actual_actual == basis) {
            PayFrequeEnum freq = PayFrequeEnum.valueOf((String)payFreq);
            Date firstCop = RateSwapCFCalHelper.getFirstCopDate(tradeBill, ispay);
            Date penuCopDate = RateSwapCFCalHelper.getPenuCopDate(tradeBill, ispay);
            Date valueDate = RateSwapCFCalHelper.getValueDate(tradeBill, ispay);
            boolean isStub = RateSwapCFCalHelper.isStub(tradeBill, ispay);
            boolean isStubFront = RateSwapCFCalHelper.isStubFront(tradeBill, ispay);
            DynamicObjectCollection wc = RateSwapCFCalHelper.getWorkCalendars(tradeBill, ispay);
            Date endDate = tradeBill.getDate("enddate");
            String adjMethod = RateSwapCFCalHelper.getAdjustMethod(tradeBill, ispay);
            return new FreqPeriodListBean(valueDate, endDate, isStub, isStubFront, firstCop, penuCopDate, freq, AdjustMethodEnum.getEnumByValue((String)adjMethod), wc, true);
        }
        return null;
    }

    private static BigDecimal roundDecimal(BigDecimal deci) {
        return deci.setScale(10, RoundingMode.HALF_UP);
    }
}

