/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;

public class ReqNoteHelper {
    public static void buildOtherForPush(DynamicObject tarbill, Long pricerule, List<DynamicObject> srcRows, AfterFieldMappingEventArgs e) {
        String name;
        switch (name = tarbill.getDataEntityType().getName()) {
            case "tm_forex": {
                Date bizDate = tarbill.getDate("bizdate");
                DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
                Date deliveryDate = tarbill.getDate("settledate");
                if (bizDate != null && deliveryDate != null) {
                    int settleDelay = TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizDate, (Date)deliveryDate);
                    tarbill.set("settledelay", (Object)(settleDelay >= 2 ? 2 : settleDelay));
                }
                ReqNoteHelper.dealSpotForexQuoteInfo(tarbill, pricerule);
                ReqNoteHelper.setSecondAmt(tarbill);
                break;
            }
            case "tm_forex_forward": {
                boolean isopdate = (Boolean)((DynamicProperty)e.getFldProperties().get("isoptionaltraction")).getValue((Object)srcRows.get(0));
                if (isopdate) {
                    ReqNoteHelper.setFoAdjSettleDate("settledate_start", "adjsettledate_start", tarbill);
                    ReqNoteHelper.setFoAdjSettleDate("settledate_end", "adjsettledate_end", tarbill);
                    ReqNoteHelper.setFoTerm("settledate_start", "term", tarbill);
                    ReqNoteHelper.setFoTerm("settledate_end", "term_end", tarbill);
                } else {
                    ReqNoteHelper.setFoAdjSettleDate("settledate", "adjustsettledate", tarbill);
                    ReqNoteHelper.setFoTerm("settledate", "term", tarbill);
                }
                ReqNoteHelper.dealFoForexQuoteInfo(tarbill, pricerule);
                ReqNoteHelper.setSecondAmt(tarbill);
                break;
            }
            case "tm_forex_swaps": {
                ReqNoteHelper.setSwAdjDate("settledate", "adjustsettledate", tarbill);
                ReqNoteHelper.setSwAdjDate("settledate_far", "adjustsettledate_far", tarbill);
                ReqNoteHelper.setSwapsTerm(tarbill);
                ReqNoteHelper.dealSwapsForexQuoteInfoAndAmt(tarbill);
                break;
            }
            case "tm_forex_options": {
                ReqNoteHelper.callAdjustSettleDate(tarbill, srcRows, e);
                ReqNoteHelper.callTerm(tarbill);
                ReqNoteHelper.calAdjustExpireDate(tarbill);
                ReqNoteHelper.setOptionSecondAmt(tarbill);
                Date bizDate = tarbill.getDate("bizdate");
                int settleDelay = tarbill.getInt("settledelay");
                DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
                Date premiumDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)settleDelay);
                tarbill.set("premiumdate", (Object)premiumDate);
            }
        }
    }

    private static void setSwapsTerm(DynamicObject tarbill) {
        Date settledate = tarbill.getDate("settledate");
        Date farSettledate = tarbill.getDate("settledate_far");
        Date bizdate = tarbill.getDate("bizdate");
        String adjMtd = tarbill.getString("dateadjustmethod");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{adjMtd, settledate, bizdate})) {
            AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)adjMtd);
            DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
            Date delayDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)wc, (Date)bizdate, (int)2, (AdjustMethodEnum)adjMtdEnum);
            if (settledate.compareTo(delayDate) > 0) {
                tarbill.set("swaptype", (Object)ForexSwapsTypeEnum.FWDTOFWD.getValue());
                tarbill.set("isovernight", (Object)false);
                tarbill.set("term", (Object)TcDateUtils.getDiffYMD((Date)delayDate, (Date)settledate));
                tarbill.set("term_far", (Object)TcDateUtils.getDiffYMD((Date)delayDate, (Date)farSettledate));
                tarbill.set("settledelay", (Object)2);
            } else if (farSettledate.compareTo(delayDate) > 0) {
                tarbill.set("swaptype", (Object)ForexSwapsTypeEnum.SPOTTOFWD.getValue());
                tarbill.set("isovernight", (Object)false);
                tarbill.set("term", (Object)"0d");
                tarbill.set("term_far", (Object)TcDateUtils.getDiffYMD((Date)delayDate, (Date)farSettledate));
                tarbill.set("settledelay", (Object)TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizdate, (Date)settledate));
            } else {
                tarbill.set("isovernight", (Object)true);
                tarbill.set("swaptype", (Object)ForexSwapsTypeEnum.SPOTTOSPOT.getValue());
                int offset = TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizdate, (Date)settledate);
                tarbill.set("offset", (Object)offset);
                tarbill.set("offset_far", (Object)"1");
                tarbill.set("settledelay", (Object)offset);
            }
        }
    }

    private static void callAdjustSettleDate(DynamicObject tarbill, List<DynamicObject> srcRows, AfterFieldMappingEventArgs e) {
        Date settleDate = (Date)((DynamicProperty)e.getFldProperties().get("opdeliverydate")).getValue((Object)srcRows.get(0));
        if (EmptyUtil.isNoEmpty((Object)settleDate)) {
            AdjustMethodEnum adjustmethod = AdjustMethodEnum.valueOf((String)((String)tarbill.get("dateadjustmethod")));
            DynamicObjectCollection wc = (DynamicObjectCollection)tarbill.get("workcalendar");
            Date ad_settleDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)TcDateUtils.truncateDate((Date)settleDate), (AdjustMethodEnum)adjustmethod);
            tarbill.set("adjustsettledate", (Object)ad_settleDate);
        }
    }

    private static void calAdjustExpireDate(DynamicObject tarbill) {
        Date ad_settleDate = tarbill.getDate("adjustsettledate");
        int settleDelay = tarbill.getInt("settledelay");
        if (EmptyUtil.isNoEmpty((Object)ad_settleDate)) {
            DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
            tarbill.set("adjexpiredate", (Object)TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)ad_settleDate, (int)(-settleDelay)));
        }
    }

    private static void callTerm(DynamicObject tarbill) {
        Date settleDate = tarbill.getDate("settledate");
        Date bizDate = tarbill.getDate("bizdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)settleDate)) {
            DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
            Date offsetDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)2);
            if (!settleDate.after(offsetDate)) {
                int offset_new = TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizDate, (Date)settleDate);
                tarbill.set("settledelay", (Object)offset_new);
            } else {
                tarbill.set("settledelay", (Object)2);
            }
            tarbill.set("term", (Object)TcDateUtils.getDiffYMD((Date)offsetDate, (Date)settleDate));
        }
    }

    private static void dealSpotForexQuoteInfo(DynamicObject tarbill, Long priceruleId) {
        Date dm;
        String pair = tarbill.getString("pair");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceruleId, pair, dm = tarbill.getDate("settledate")})) {
            Date bizdate = tarbill.getDate("bizdate");
            DynamicObject pricerule = TmcDataServiceHelper.loadSingle((Object)priceruleId, (String)"md_pricerule");
            Long fqId = pricerule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm);
            String forexQuote = info.getFxquote();
            String dir = tarbill.getString("tradedirect");
            BigDecimal exRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getSellPrice() : info.getBuyPrice();
            tarbill.set("spotrate", (Object)exRate);
            tarbill.set("fxquote", (Object)forexQuote);
        }
    }

    private static void dealFoForexQuoteInfo(DynamicObject tarbill, Long priceruleId) {
        boolean isDateRange;
        Date dm;
        String pair = tarbill.getString("pair");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceruleId, pair, dm = (isDateRange = tarbill.getBoolean("isdaterange")) ? tarbill.getDate("adjsettledate_end") : tarbill.getDate("adjustsettledate")})) {
            Date bizdate = tarbill.getDate("bizdate");
            DynamicObject pricerule = TmcDataServiceHelper.loadSingle((Object)priceruleId, (String)"md_pricerule");
            Long fqId = pricerule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm);
            String forexQuote = info.getFxquote();
            String dir = tarbill.getString("tradedirect");
            BigDecimal exRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getSellPrice() : info.getBuyPrice();
            tarbill.set("spotrate", (Object)exRate);
            tarbill.set("fxquote", (Object)forexQuote);
        } else {
            tarbill.set("spotrate", null);
        }
    }

    private static void dealSwapsForexQuoteInfoAndAmt(DynamicObject tarBill) {
        String forexQuote;
        ForexQuoteInfo info;
        Long fqId;
        DynamicObject priceRule = tarBill.getDynamicObject("pricerule");
        String pair = tarBill.getString("pair");
        Date dm = tarBill.getDate("adjustsettledate");
        Date dm_far = tarBill.getDate("adjustsettledate_far");
        BigDecimal spotRate = BigDecimal.ZERO;
        BigDecimal forwRate = BigDecimal.ZERO;
        Date bizdate = tarBill.getDate("bizdate");
        String dir = tarBill.getString("tradedirect");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair, dm})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                return;
            }
            fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm);
            forexQuote = info.getFxquote();
            spotRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getSellPrice() : info.getBuyPrice();
            tarBill.set("fxquote", (Object)forexQuote);
            tarBill.set("spotrate", (Object)spotRate);
            BigDecimal amount = tarBill.getBigDecimal("amount");
            if (!EmptyUtil.isEmpty((BigDecimal)amount)) {
                BigDecimal sellamount = BusinessBillHelper.isSameFx(tarBill) ? amount.multiply(spotRate) : amount.divide(spotRate, 6, RoundingMode.HALF_UP);
                tarBill.set("sellamount", (Object)sellamount);
            }
        } else {
            tarBill.set("spotrate", null);
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair, dm_far})) {
            fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm_far);
            forexQuote = info.getFxquote();
            forwRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getBuyPrice() : info.getSellPrice();
            tarBill.set("fxquote", (Object)forexQuote);
            tarBill.set("forwrate", (Object)forwRate);
            BigDecimal buyamount_far = tarBill.getBigDecimal("buyamount_far");
            if (!EmptyUtil.isEmpty((BigDecimal)buyamount_far)) {
                BigDecimal sellamount_far = BusinessBillHelper.isSameFx(tarBill) ? buyamount_far.multiply(forwRate) : buyamount_far.divide(forwRate, 6, RoundingMode.HALF_UP);
                tarBill.set("sellamount_far", (Object)sellamount_far);
            }
        } else {
            tarBill.set("forwrate", null);
        }
        BigDecimal pips = forwRate.subtract(spotRate).multiply(Constants.TEN_THOUSAND);
        tarBill.set("pips", (Object)pips);
    }

    private static void setSecondAmt(DynamicObject tradeBill) {
        BigDecimal spotRate = tradeBill.getBigDecimal("spotrate");
        BigDecimal amtFirstRow = tradeBill.getBigDecimal("amount");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amtFirstRow, spotRate})) {
            return;
        }
        BigDecimal amtSecondRow = BusinessBillHelper.isSameFx(tradeBill) ? amtFirstRow.multiply(spotRate) : amtFirstRow.divide(spotRate, 6, 4);
        tradeBill.set("sellamount", (Object)amtSecondRow);
    }

    private static void setOptionSecondAmt(DynamicObject tradeBill) {
        BigDecimal spotRate = tradeBill.getBigDecimal("exchangerate");
        BigDecimal amtFirstRow = tradeBill.getBigDecimal("amount");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amtFirstRow, spotRate})) {
            return;
        }
        BigDecimal amtSecondRow = BusinessBillHelper.isSameFx(tradeBill) ? amtFirstRow.multiply(spotRate) : amtFirstRow.divide(spotRate, 6, 4);
        tradeBill.set("sellamount", (Object)amtSecondRow);
    }

    private static void setFoAdjSettleDate(String dateProp, String adjDateProp, DynamicObject tarbill) {
        Date settleDate = tarbill.getDate(dateProp);
        DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
        String dateAdjMtd = tarbill.getString("dateadjustmethod");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dateAdjMtd, settleDate})) {
            tarbill.set(adjDateProp, null);
            return;
        }
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)dateAdjMtd);
        Date adjSettleDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)settleDate, (AdjustMethodEnum)adjMtdEnum);
        tarbill.set(adjDateProp, (Object)adjSettleDate);
    }

    private static void setFoTerm(String dateProp, String termProp, DynamicObject tarbill) {
        Date settleDate = tarbill.getDate(dateProp);
        Date bizDate = tarbill.getDate("bizdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{settleDate, bizDate})) {
            return;
        }
        DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
        Date offsetDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)2);
        String term = TcDateUtils.getDiffYMD((Date)offsetDate, (Date)settleDate);
        tarbill.set(termProp, (Object)term);
    }

    private static void setSwTerm(DynamicObject tarbill) {
        String adjMtd = tarbill.getString("dateadjustmethod");
        Date settledate = tarbill.getDate("settledate");
        Date bizdate = tarbill.getDate("bizdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{adjMtd, settledate, bizdate})) {
            return;
        }
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)adjMtd);
        DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
        int settledelay = tarbill.getInt("settledelay");
        Date temp = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)wc, (Date)bizdate, (int)settledelay, (AdjustMethodEnum)adjMtdEnum);
        String term = TcDateUtils.getDiffYMD((Date)temp, (Date)settledate);
        tarbill.set("term", (Object)term);
    }

    private static void setFarTerm(DynamicObject tarbill) {
        Date farDate = tarbill.getDate("settledate_far");
        Date date = tarbill.getDate("settledate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{date, farDate})) {
            String term = TcDateUtils.getDiffYMD((Date)date, (Date)farDate);
            tarbill.set("term_far", (Object)term);
        }
    }

    private static void setSwAdjDate(String dateProp, String adjDateProp, DynamicObject tarbill) {
        Date settledate = tarbill.getDate(dateProp);
        DynamicObjectCollection wc = tarbill.getDynamicObjectCollection("workcalendar");
        String adjMtd = tarbill.getString("dateadjustmethod");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{settledate, adjMtd})) {
            return;
        }
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)adjMtd);
        Date adjdate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)settledate, (AdjustMethodEnum)adjMtdEnum);
        tarbill.set(adjDateProp, (Object)adjdate);
    }

    public static void sumReqNoteCurrAndAmt(DynamicObjectCollection reqNoteEntries, CombReqNoteEnum combReqNoteEnum, Map<Long, BigDecimal> reqnoteCurrencyAmtMap, Map<Long, String> reqnoteCurrencyMap) {
        String currinName = combReqNoteEnum.getEntryBuyCurrName();
        String curroutName = combReqNoteEnum.getEntrySellCurrName();
        String amtinName = combReqNoteEnum.getEntryBuyAmtName();
        String amtoutName = combReqNoteEnum.getEntrySellAmtName();
        for (DynamicObject reqNoteEntry : reqNoteEntries) {
            DynamicObject currin = reqNoteEntry.getDynamicObject(currinName);
            DynamicObject currout = reqNoteEntry.getDynamicObject(curroutName);
            if (EmptyUtil.isEmpty((DynamicObject)currin) && EmptyUtil.isEmpty((DynamicObject)currout)) continue;
            BigDecimal amtin = reqNoteEntry.getBigDecimal(amtinName);
            BigDecimal amtout = reqNoteEntry.getBigDecimal(amtoutName);
            Long currinId = (Long)currin.getPkValue();
            Long curroutId = (Long)currout.getPkValue();
            if (!reqnoteCurrencyAmtMap.containsKey(currinId)) {
                reqnoteCurrencyAmtMap.put(currinId, amtin);
                if (!EmptyUtil.isEmpty(reqnoteCurrencyMap)) {
                    reqnoteCurrencyMap.put(currinId, currin.getString("number"));
                }
            } else {
                BigDecimal curramtin = reqnoteCurrencyAmtMap.get(currinId);
                curramtin = curramtin.add(amtin);
                reqnoteCurrencyAmtMap.put(currinId, curramtin);
            }
            if (!reqnoteCurrencyAmtMap.containsKey(curroutId)) {
                reqnoteCurrencyAmtMap.put(curroutId, amtout);
                if (EmptyUtil.isEmpty(reqnoteCurrencyMap)) continue;
                reqnoteCurrencyMap.put(curroutId, currout.getString("number"));
                continue;
            }
            BigDecimal curramtout = reqnoteCurrencyAmtMap.get(curroutId);
            curramtout = curramtout.add(amtout);
            reqnoteCurrencyAmtMap.put(curroutId, curramtout);
        }
    }
}

